/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.feature.Word2Vec;
import org.apache.spark.ml.feature.Word2VecModel;
import org.apache.spark.ml.feature.Word2VecSuite$;
import org.apache.spark.ml.feature.Word2VecSuite$$anonfun$2$;
import org.apache.spark.ml.feature.Word2VecSuite$$anonfun$4$;
import org.apache.spark.ml.feature.Word2VecSuite$$anonfun$5$;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.ParamsSuite$;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.DefaultReadWriteTest$class;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.IndexedSeq;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u00112A!\u0001\u0002\u0001\u001b\tiqk\u001c:eeY+7mU;ji\u0016T!a\u0001\u0003\u0002\u000f\u0019,\u0017\r^;sK*\u0011QAB\u0001\u0003[2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001aB\u0005\u000e\u0011\u0005=\u0001R\"\u0001\u0004\n\u0005E1!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u001415\tAC\u0003\u0002\u0016-\u0005!Q\u000f^5m\u0015\t9b!A\u0003nY2L'-\u0003\u0002\u001a)\t)R\n\u00147jER+7\u000f^*qCJ\\7i\u001c8uKb$\bCA\u000e\u001e\u001b\u0005a\"BA\u000b\u0005\u0013\tqBD\u0001\u000bEK\u001a\fW\u000f\u001c;SK\u0006$wK]5uKR+7\u000f\u001e\u0005\u0006A\u0001!\t!I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\t\u0002\"a\t\u0001\u000e\u0003\t\u0001")
public class Word2VecSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest$class.testDefaultReadWrite(this, instance, testParams);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, DataFrame dataset, Map<String, Object> testParams, Function2<M, M, BoxedUnit> checkModelData) {
        DefaultReadWriteTest$class.testEstimatorAndModelReadWrite(this, estimator, dataset, testParams, checkModelData);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest$class.testDefaultReadWrite$default$2(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    @Override
    public void beforeAll() {
        TempDirectory$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public Word2VecSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        TempDirectory$class.$init$(this);
        DefaultReadWriteTest$class.$init$(this);
        this.test("params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParamsSuite$.MODULE$.checkParams((Params)new Word2Vec());
                Word2VecModel model = new Word2VecModel("w2v", new org.apache.spark.mllib.feature.Word2VecModel((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)new float[]{0.0f})}))));
                ParamsSuite$.MODULE$.checkParams((Params)model);
            }
        });
        this.test("Word2Vec", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Word2VecSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SQLContext sqlContext = this.$outer.sqlContext();
                String sentence = new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("a b ")).$times(100)).append((Object)new StringOps(Predef$.MODULE$.augmentString("a c ")).$times(10)).toString();
                int numOfWords = Predef$.MODULE$.refArrayOps((Object[])sentence.split(" ")).size();
                SparkContext qual$1 = this.$outer.sc();
                Seq x$6 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sentence, sentence}));
                int x$7 = qual$1.parallelize$default$2();
                RDD doc = qual$1.parallelize(x$6, x$7, ClassTag$.MODULE$.apply(String.class)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String[] apply(String line) {
                        return line.split(" ");
                    }
                }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
                Map codes = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)new double[]{-0.2811822295188904, -0.6356269121170044, -0.3020961284637451}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)new double[]{1.0309048891067505, -1.29472815990448, 0.22276712954044342}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"c"), (Object)new double[]{-0.08456747233867645, 0.5137411952018738, 0.11731560528278351})}));
                RDD expected = doc.map((Function1)new Serializable(this, numOfWords, codes){
                    public static final long serialVersionUID = 0L;
                    public final int numOfWords$1;
                    public final Map codes$1;

                    public final Vector apply(String[] sentence) {
                        return Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])sentence).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$2$$anonfun$9 $outer;

                            public final double[] apply(String key) {
                                return (double[])this.$outer.codes$1.apply((Object)key);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))))).reduce((Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double[] apply(double[] word1, double[] word2) {
                                return (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(word1).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(word2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final double apply(Tuple2<Object, Object> x0$1) {
                                        Tuple2<Object, Object> tuple2 = x0$1;
                                        if (tuple2 != null) {
                                            double v1 = tuple2._1$mcD$sp();
                                            double v2 = tuple2._2$mcD$sp();
                                            double d = v1 + v2;
                                            return d;
                                        }
                                        throw new MatchError(tuple2);
                                    }
                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                            }
                        })).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$2$$anonfun$9 $outer;

                            public final double apply(double x$1) {
                                return this.apply$mcDD$sp(x$1);
                            }

                            public double apply$mcDD$sp(double x$1) {
                                return x$1 / (double)this.$outer.numOfWords$1;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
                    }
                    {
                        this.numOfWords$1 = numOfWords$1;
                        this.codes$1 = codes$1;
                    }
                }, ClassTag$.MODULE$.apply(Vector.class));
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecSuite.class.getClassLoader());
                DataFrame docDF = sqlContext.implicits().rddToDataFrameHolder(doc.zip(expected, ClassTag$.MODULE$.apply(Vector.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Array"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("java.lang.String")).asType()).toTypeConstructor()}))), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.linalg.Vector")).asType()).toTypeConstructor()})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"text", "expected"}));
                Word2VecModel model = new Word2Vec().setVectorSize(3).setInputCol("text").setOutputCol("result").setSeed(42L).fit(docDF);
                MLTestingUtils$.MODULE$.checkCopy((Model<?>)model);
                Vector magicExp = Vectors$.MODULE$.dense(0.30153007534417237, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.6833061711354689, 0.5116530778733167}));
                Predef$.MODULE$.refArrayOps((Object[])model.transform(docDF).select("result", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected"})).collect()).foreach((Function1)new Serializable(this, magicExp){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;
                    private final Vector magicExp$1;

                    public final void apply(Row x0$2) {
                        Row row = x0$2;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                            Object vector1 = ((SeqLike)some.get()).apply(0);
                            Object vector2 = ((SeqLike)some.get()).apply(1);
                            if (vector1 instanceof Vector) {
                                Vector vector = (Vector)vector1;
                                if (vector2 instanceof Vector) {
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(vector).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(this.magicExp$1).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(vector1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(magicExp).absTol(1.0E-5))");
                                    this.$outer.org$apache$spark$ml$feature$Word2VecSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Transformed vector is different with expected.");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.magicExp$1 = magicExp$1;
                    }
                });
            }

            public /* synthetic */ Word2VecSuite org$apache$spark$ml$feature$Word2VecSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("getVectors", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Word2VecSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SQLContext sqlContext = this.$outer.sqlContext();
                String sentence = new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("a b ")).$times(100)).append((Object)new StringOps(Predef$.MODULE$.augmentString("a c ")).$times(10)).toString();
                SparkContext qual$2 = this.$outer.sc();
                Seq x$8 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sentence, sentence}));
                int x$9 = qual$2.parallelize$default$2();
                RDD doc = qual$2.parallelize(x$8, x$9, ClassTag$.MODULE$.apply(String.class)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String[] apply(String line) {
                        return line.split(" ");
                    }
                }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
                Map codes = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)new double[]{-0.2811822295188904, -0.6356269121170044, -0.3020961284637451}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)new double[]{1.0309048891067505, -1.29472815990448, 0.22276712954044342}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"c"), (Object)new double[]{-0.08456747233867645, 0.5137411952018738, 0.11731560528278351})}));
                Seq expectedVectors = (Seq)((TraversableLike)codes.toSeq().sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<String, double[]> x$2) {
                        return (String)x$2._1();
                    }
                }, (Ordering)Ordering.String$.MODULE$)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(Tuple2<String, double[]> x0$3) {
                        Tuple2<String, double[]> tuple2 = x0$3;
                        if (tuple2 != null) {
                            double[] v = (double[])tuple2._2();
                            Vector vector = Vectors$.MODULE$.dense(v);
                            return vector;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecSuite.class.getClassLoader());
                DataFrame docDF = sqlContext.implicits().rddToDataFrameHolder(doc.zip(doc, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Array"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("java.lang.String")).asType()).toTypeConstructor()}))), $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Array"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("java.lang.String")).asType()).toTypeConstructor()})))})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"text", "alsotext"}));
                Word2VecModel model = new Word2Vec().setVectorSize(3).setInputCol("text").setOutputCol("result").setSeed(42L).fit(docDF);
                Vector[] realVectors = (Vector[])model.getVectors().sort("word", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).select("vector", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(Row x0$4) {
                        Object v;
                        Row row = x0$4;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (v = ((SeqLike)some.get()).apply(0)) instanceof Vector) {
                            Vector vector;
                            Vector vector2 = vector = (Vector)v;
                            return vector2;
                        }
                        throw new MatchError((Object)row);
                    }
                }, ClassTag$.MODULE$.apply(Vector.class)).collect();
                Seq magicExpected = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(0.3326166272163391, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.5603077411651611, -0.2309209555387497})), Vectors$.MODULE$.dense(0.32463887333869934, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.9306551218032837, 1.393115520477295})), Vectors$.MODULE$.dense(-0.27150997519493103, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.4372006058692932, -0.13465698063373566}))}));
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])realVectors).zip((GenIterable)magicExpected, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final void apply(Tuple2<Vector, Vector> x0$5) {
                        Tuple2<Vector, Vector> tuple2 = x0$5;
                        if (tuple2 != null) {
                            Vector real = (Vector)tuple2._1();
                            Vector expected = (Vector)tuple2._2();
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(real).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(expected).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(real).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(expected).absTol(1.0E-5))");
                            this.$outer.org$apache$spark$ml$feature$Word2VecSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Actual vector is different from expected.");
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ Word2VecSuite org$apache$spark$ml$feature$Word2VecSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("findSynonyms", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Word2VecSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SQLContext sqlContext = this.$outer.sqlContext();
                String sentence = new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("a b ")).$times(100)).append((Object)new StringOps(Predef$.MODULE$.augmentString("a c ")).$times(10)).toString();
                SparkContext qual$3 = this.$outer.sc();
                Seq x$10 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sentence, sentence}));
                int x$11 = qual$3.parallelize$default$2();
                RDD doc = qual$3.parallelize(x$10, x$11, ClassTag$.MODULE$.apply(String.class)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String[] apply(String line) {
                        return line.split(" ");
                    }
                }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecSuite.class.getClassLoader());
                DataFrame docDF = sqlContext.implicits().rddToDataFrameHolder(doc.zip(doc, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Array"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("java.lang.String")).asType()).toTypeConstructor()}))), $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Array"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("java.lang.String")).asType()).toTypeConstructor()})))})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"text", "alsotext"}));
                Word2VecModel model = new Word2Vec().setVectorSize(3).setInputCol("text").setOutputCol("result").setSeed(42L).fit(docDF);
                double[] expectedSimilarity = new double[]{0.18032623242822343, -0.5717976464798823};
                Tuple2 tuple2 = Predef$.MODULE$.wrapRefArray((Object[])model.findSynonyms("a", 2).map((Function1)new $anonfun$4$$anonfun$15(this), ClassTag$.MODULE$.apply(Tuple2.class)).collect()).unzip((Function1)Predef$.MODULE$.conforms());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    IndexedSeq synonyms = (IndexedSeq)tuple2._1();
                    IndexedSeq similarity = (IndexedSeq)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)synonyms, (Object)similarity);
                    IndexedSeq synonyms2 = (IndexedSeq)tuple23._1();
                    IndexedSeq similarity2 = (IndexedSeq)tuple23._2();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(synonyms2.toArray(ClassTag$.MODULE$.apply(String.class)));
                    String[] $org_scalatest_assert_macro_right = (String[])((Object[])new String[]{"b", "c"});
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(expectedSimilarity).zip((GenIterable)similarity2, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$4 $outer;

                        public final void apply(Tuple2<Object, Object> x0$7) {
                            Tuple2<Object, Object> tuple2 = x0$7;
                            if (tuple2 != null) {
                                double expected = tuple2._1$mcD$sp();
                                double actual = tuple2._2$mcD$sp();
                                double $org_scalatest_assert_macro_left = scala.math.package$.MODULE$.abs((expected - actual) / expected);
                                double $org_scalatest_assert_macro_right = 1.0E-5;
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
                                this.$outer.org$apache$spark$ml$feature$Word2VecSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Unit()));
                    return;
                }
                throw new MatchError((Object)tuple2);
            }

            public /* synthetic */ Word2VecSuite org$apache$spark$ml$feature$Word2VecSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("window size", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Word2VecSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SQLContext sqlContext = this.$outer.sqlContext();
                String sentence = new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("a q s t q s t b b b s t m s t m q ")).$times(100)).append((Object)new StringOps(Predef$.MODULE$.augmentString("a c ")).$times(10)).toString();
                SparkContext qual$4 = this.$outer.sc();
                Seq x$12 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sentence, sentence}));
                int x$13 = qual$4.parallelize$default$2();
                RDD doc = qual$4.parallelize(x$12, x$13, ClassTag$.MODULE$.apply(String.class)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String[] apply(String line) {
                        return line.split(" ");
                    }
                }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecSuite.class.getClassLoader());
                DataFrame docDF = sqlContext.implicits().rddToDataFrameHolder(doc.zip(doc, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Array"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("java.lang.String")).asType()).toTypeConstructor()}))), $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Array"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("java.lang.String")).asType()).toTypeConstructor()})))})));
                    }
                })).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"text", "alsotext"}));
                Word2VecModel model = new Word2Vec().setVectorSize(3).setWindowSize(2).setInputCol("text").setOutputCol("result").setSeed(42L).fit(docDF);
                Tuple2 tuple2 = Predef$.MODULE$.wrapRefArray((Object[])model.findSynonyms("a", 6).map((Function1)new $anonfun$5$$anonfun$17(this), ClassTag$.MODULE$.apply(Tuple2.class)).collect()).unzip((Function1)Predef$.MODULE$.conforms());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    IndexedSeq synonyms = (IndexedSeq)tuple2._1();
                    IndexedSeq similarity = (IndexedSeq)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)synonyms, (Object)similarity);
                    IndexedSeq synonyms2 = (IndexedSeq)tuple23._1();
                    IndexedSeq similarity2 = (IndexedSeq)tuple23._2();
                    Word2VecModel biggerModel = new Word2Vec().setVectorSize(3).setInputCol("text").setOutputCol("result").setSeed(42L).setWindowSize(10).fit(docDF);
                    Tuple2 tuple24 = Predef$.MODULE$.wrapRefArray((Object[])model.findSynonyms("a", 6).map((Function1)new $anonfun$5$$anonfun$18(this), ClassTag$.MODULE$.apply(Tuple2.class)).collect()).unzip((Function1)Predef$.MODULE$.conforms());
                    if (tuple24 != null) {
                        Tuple2 tuple25;
                        IndexedSeq synonymsLarger = (IndexedSeq)tuple24._1();
                        IndexedSeq similarityLarger = (IndexedSeq)tuple24._2();
                        Tuple2 tuple26 = tuple25 = new Tuple2((Object)synonymsLarger, (Object)similarityLarger);
                        IndexedSeq synonymsLarger2 = (IndexedSeq)tuple26._1();
                        IndexedSeq similarityLarger2 = (IndexedSeq)tuple26._2();
                        double $org_scalatest_assert_macro_left = scala.math.package$.MODULE$.abs(BoxesRunTime.unboxToDouble((Object)similarity2.apply(5)) - BoxesRunTime.unboxToDouble((Object)similarityLarger2.apply(5)) / BoxesRunTime.unboxToDouble((Object)similarity2.apply(5)));
                        double $org_scalatest_assert_macro_right = 1.0E-5;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right);
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        return;
                    }
                    throw new MatchError((Object)tuple24);
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Word2Vec read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Word2VecSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Word2Vec t = new Word2Vec().setInputCol("myInputCol").setOutputCol("myOutputCol").setMaxIter(2).setMinCount(8).setNumPartitions(1).setSeed(42L).setStepSize(0.01).setVectorSize(100);
                this.$outer.testDefaultReadWrite(t, this.$outer.testDefaultReadWrite$default$2());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Word2VecModel read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Word2VecSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map word2VecMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"china", (Object)new float[]{0.5f, 0.5f, 0.5f, 0.5f}), new Tuple2((Object)"japan", (Object)new float[]{0.4f, 0.5f, 0.5f, 0.5f}), new Tuple2((Object)"taiwan", (Object)new float[]{0.6f, 0.5f, 0.5f, 0.5f}), new Tuple2((Object)"korea", (Object)new float[]{0.45f, 0.6f, 0.6f, 0.6f})}));
                org.apache.spark.mllib.feature.Word2VecModel oldModel = new org.apache.spark.mllib.feature.Word2VecModel(word2VecMap);
                Word2VecModel instance = new Word2VecModel("myWord2VecModel", oldModel);
                Word2VecModel newInstance = this.$outer.testDefaultReadWrite(instance, this.$outer.testDefaultReadWrite$default$2());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(newInstance.getVectors().collect());
                Row[] $org_scalatest_assert_macro_right = instance.getVectors().collect();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

