/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.ParamsSuite$;
import org.apache.spark.ml.regression.AFTPoint;
import org.apache.spark.ml.regression.AFTSurvivalRegression;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel;
import org.apache.spark.ml.regression.AFTSurvivalRegressionSuite$;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.DefaultReadWriteTest$class;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.random.ExponentialGenerator;
import org.apache.spark.mllib.random.WeibullGenerator;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005}b\u0001B\u0001\u0003\u00015\u0011!$\u0011$U'V\u0014h/\u001b<bYJ+wM]3tg&|gnU;ji\u0016T!a\u0001\u0003\u0002\u0015I,wM]3tg&|gN\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u000f%i\u0001\"a\u0004\t\u000e\u0003\u0019I!!\u0005\u0004\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t\u0019\u0002$D\u0001\u0015\u0015\t)b#\u0001\u0003vi&d'BA\f\u0007\u0003\u0015iG\u000e\\5c\u0013\tIBCA\u000bN\u00192L'\rV3tiN\u0003\u0018M]6D_:$X\r\u001f;\u0011\u0005miR\"\u0001\u000f\u000b\u0005U!\u0011B\u0001\u0010\u001d\u0005Q!UMZ1vYR\u0014V-\u00193Xe&$X\rV3ti\")\u0001\u0005\u0001C\u0001C\u00051A(\u001b8jiz\"\u0012A\t\t\u0003G\u0001i\u0011A\u0001\u0005\nK\u0001\u0001\r\u00111A\u0005\u0002\u0019\n\u0011\u0003Z1uCN,G/\u00168jm\u0006\u0014\u0018.\u0019;f+\u00059\u0003C\u0001\u0015,\u001b\u0005I#B\u0001\u0016\u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0003Y%\u0012\u0011\u0002R1uC\u001a\u0013\u0018-\\3\t\u00139\u0002\u0001\u0019!a\u0001\n\u0003y\u0013!\u00063bi\u0006\u001cX\r^+oSZ\f'/[1uK~#S-\u001d\u000b\u0003aY\u0002\"!\r\u001b\u000e\u0003IR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\u0012A!\u00168ji\"9q'LA\u0001\u0002\u00049\u0013a\u0001=%c!1\u0011\b\u0001Q!\n\u001d\n!\u0003Z1uCN,G/\u00168jm\u0006\u0014\u0018.\u0019;fA!\u0012\u0001h\u000f\t\u0003cqJ!!\u0010\u001a\u0003\u0013Q\u0014\u0018M\\:jK:$\b\"C \u0001\u0001\u0004\u0005\r\u0011\"\u0001'\u0003M!\u0017\r^1tKRlU\u000f\u001c;jm\u0006\u0014\u0018.\u0019;f\u0011%\t\u0005\u00011AA\u0002\u0013\u0005!)A\feCR\f7/\u001a;Nk2$\u0018N^1sS\u0006$Xm\u0018\u0013fcR\u0011\u0001g\u0011\u0005\bo\u0001\u000b\t\u00111\u0001(\u0011\u0019)\u0005\u0001)Q\u0005O\u0005!B-\u0019;bg\u0016$X*\u001e7uSZ\f'/[1uK\u0002B#\u0001R\u001e\t\u000b!\u0003A\u0011I%\u0002\u0013\t,gm\u001c:f\u00032dG#\u0001\u0019\t\u000b-\u0003A\u0011\u0001'\u0002!\u001d,g.\u001a:bi\u0016\fe\tV%oaV$H#C']C&\\Wn\\9t!\rqe+\u0017\b\u0003\u001fRs!\u0001U*\u000e\u0003ES!A\u0015\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0014BA+3\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0016-\u0003\u0007M+\u0017O\u0003\u0002VeA\u00111EW\u0005\u00037\n\u0011\u0001\"\u0011$U!>Lg\u000e\u001e\u0005\u0006;*\u0003\rAX\u0001\f]Vlg)Z1ukJ,7\u000f\u0005\u00022?&\u0011\u0001M\r\u0002\u0004\u0013:$\b\"\u00022K\u0001\u0004\u0019\u0017!\u0002=NK\u0006t\u0007cA\u0019eM&\u0011QM\r\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003c\u001dL!\u0001\u001b\u001a\u0003\r\u0011{WO\u00197f\u0011\u0015Q'\n1\u0001d\u0003%Ah+\u0019:jC:\u001cW\rC\u0003m\u0015\u0002\u0007a,A\u0004o!>Lg\u000e^:\t\u000b9T\u0005\u0019\u00010\u0002\tM,W\r\u001a\u0005\u0006a*\u0003\rAZ\u0001\ro\u0016L'-\u001e7m'\"\f\u0007/\u001a\u0005\u0006e*\u0003\rAZ\u0001\ro\u0016L'-\u001e7m'\u000e\fG.\u001a\u0005\u0006i*\u0003\rAZ\u0001\u0010Kb\u0004xN\\3oi&\fG.T3b]\u001e)aO\u0001E\u0001o\u0006Q\u0012I\u0012+TkJ4\u0018N^1m%\u0016<'/Z:tS>t7+^5uKB\u00111\u0005\u001f\u0004\u0006\u0003\tA\t!_\n\u0004qjl\bCA\u0019|\u0013\ta(G\u0001\u0004B]f\u0014VM\u001a\t\u0003cyL!a \u001a\u0003\u0019M+'/[1mSj\f'\r\\3\t\r\u0001BH\u0011AA\u0002)\u00059\b\"CA\u0004q\n\u0007I\u0011AA\u0005\u0003A\tG\u000e\u001c)be\u0006l7+\u001a;uS:<7/\u0006\u0002\u0002\fAA\u0011QBA\n\u00033\tyBD\u00022\u0003\u001fI1!!\u00053\u0003\u0019\u0001&/\u001a3fM&!\u0011QCA\f\u0005\ri\u0015\r\u001d\u0006\u0004\u0003#\u0011\u0004\u0003BA\u0007\u00037IA!!\b\u0002\u0018\t11\u000b\u001e:j]\u001e\u00042!MA\u0011\u0013\r\t\u0019C\r\u0002\u0004\u0003:L\b\u0002CA\u0014q\u0002\u0006I!a\u0003\u0002#\u0005dG\u000eU1sC6\u001cV\r\u001e;j]\u001e\u001c\b\u0005C\u0005\u0002,a\f\t\u0011\"\u0003\u0002.\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ty\u0003\u0005\u0003\u00022\u0005mRBAA\u001a\u0015\u0011\t)$a\u000e\u0002\t1\fgn\u001a\u0006\u0003\u0003s\tAA[1wC&!\u0011QHA\u001a\u0005\u0019y%M[3di\u0002")
public class AFTSurvivalRegressionSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private transient DataFrame datasetUnivariate;
    private transient DataFrame datasetMultivariate;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public static Map<String, Object> allParamSettings() {
        return AFTSurvivalRegressionSuite$.MODULE$.allParamSettings();
    }

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest$class.testDefaultReadWrite(this, instance, testParams);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, DataFrame dataset, Map<String, Object> testParams, Function2<M, M, BoxedUnit> checkModelData) {
        DefaultReadWriteTest$class.testEstimatorAndModelReadWrite(this, estimator, dataset, testParams, checkModelData);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest$class.testDefaultReadWrite$default$2(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    @Override
    public void afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public DataFrame datasetUnivariate() {
        return this.datasetUnivariate;
    }

    public void datasetUnivariate_$eq(DataFrame x$1) {
        this.datasetUnivariate = x$1;
    }

    public DataFrame datasetMultivariate() {
        return this.datasetMultivariate;
    }

    public void datasetMultivariate_$eq(DataFrame x$1) {
        this.datasetMultivariate = x$1;
    }

    @Override
    public void beforeAll() {
        TempDirectory$class.beforeAll(this);
        SparkContext qual$1 = this.sc();
        Seq<AFTPoint> x$1 = this.generateAFTInput(1, new double[]{5.5}, new double[]{0.8}, 1000, 42, 1.0, 2.0, 2.0);
        int x$2 = qual$1.parallelize$default$2();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionSuite$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.regression.AFTPoint")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_AFTSurvivalRegressionSuite$$typecreator1$1(AFTSurvivalRegressionSuite $outer) {
            }
        }
        this.datasetUnivariate_$eq(this.sqlContext().createDataFrame(qual$1.parallelize(x$1, x$2, ClassTag$.MODULE$.apply(AFTPoint.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionSuite$$typecreator1$1(this))));
        SparkContext qual$2 = this.sc();
        Seq<AFTPoint> x$3 = this.generateAFTInput(2, new double[]{0.9, -1.3}, new double[]{0.7, 1.2}, 1000, 42, 1.5, 2.5, 2.0);
        int x$4 = qual$2.parallelize$default$2();
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionSuite$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.regression.AFTPoint")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_AFTSurvivalRegressionSuite$$typecreator2$1(AFTSurvivalRegressionSuite $outer) {
            }
        }
        this.datasetMultivariate_$eq(this.sqlContext().createDataFrame(qual$2.parallelize(x$3, x$4, ClassTag$.MODULE$.apply(AFTPoint.class)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionSuite$$typecreator2$1(this))));
    }

    public Seq<AFTPoint> generateAFTInput(int numFeatures, double[] xMean, double[] xVariance, int nPoints, int seed, double weibullShape, double weibullScale, double exponentialMean) {
        WeibullGenerator weibull = new WeibullGenerator(weibullShape, weibullScale);
        weibull.setSeed((long)seed);
        ExponentialGenerator exponential = new ExponentialGenerator(exponentialMean);
        exponential.setSeed((long)seed);
        Random rnd = new Random(seed);
        double[][] x = (double[][])Array$.MODULE$.fill(nPoints, (Function0)new Serializable(this, numFeatures, rnd){
            public static final long serialVersionUID = 0L;
            private final int numFeatures$1;
            public final Random rnd$1;

            public final double[] apply() {
                return (double[])Array$.MODULE$.fill(this.numFeatures$1, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return this.$outer.rnd$1.nextDouble();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.Double());
            }
            {
                this.numFeatures$1 = numFeatures$1;
                this.rnd$1 = rnd$1;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Predef$.MODULE$.refArrayOps((Object[])x).foreach((Function1)new Serializable(this, xMean, xVariance){
            public static final long serialVersionUID = 0L;
            private final double[] xMean$1;
            private final double[] xVariance$1;

            public final void apply(double[] v) {
                int len = v.length;
                for (int i = 0; i < len; ++i) {
                    v[i] = (v[i] - 0.5) * scala.math.package$.MODULE$.sqrt(12.0 * this.xVariance$1[i]) + this.xMean$1[i];
                }
            }
            {
                this.xMean$1 = xMean$1;
                this.xVariance$1 = xVariance$1;
            }
        });
        IndexedSeq y = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), nPoints).map((Function1)new Serializable(this, weibull, exponential){
            public static final long serialVersionUID = 0L;
            private final WeibullGenerator weibull$1;
            private final ExponentialGenerator exponential$1;

            public final Tuple2<Object, Object> apply(int i) {
                return new Tuple2.mcDD.sp(this.weibull$1.nextValue(), this.exponential$1.nextValue());
            }
            {
                this.weibull$1 = weibull$1;
                this.exponential$1 = exponential$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return (Seq)((TraversableLike)y.zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])x), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AFTSurvivalRegressionSuite $outer;

            public final AFTPoint apply(Tuple2<Tuple2<Object, Object>, double[]> p) {
                return new AFTPoint(Vectors$.MODULE$.dense((double[])p._2()), ((Tuple2)p._1())._1$mcD$sp(), this.$outer.org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$censor$1(((Tuple2)p._1())._1$mcD$sp(), ((Tuple2)p._1())._2$mcD$sp()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    public final double org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$censor$1(double x, double y) {
        return x <= y ? 1.0 : 0.0;
    }

    public AFTSurvivalRegressionSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        TempDirectory$class.$init$(this);
        DefaultReadWriteTest$class.$init$(this);
        this.test("params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParamsSuite$.MODULE$.checkParams((Params)new AFTSurvivalRegression());
                AFTSurvivalRegressionModel model = new AFTSurvivalRegressionModel("aftSurvReg", Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), 0.0, 0.0);
                ParamsSuite$.MODULE$.checkParams((Params)model);
            }
        });
        this.test("aft survival regression: default params", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AFTSurvivalRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AFTSurvivalRegression aftr = new AFTSurvivalRegression();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(aftr.getLabelCol());
                String $org_scalatest_assert_macro_right = "label";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(aftr.getFeaturesCol());
                String $org_scalatest_assert_macro_right2 = "features";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(aftr.getPredictionCol());
                String $org_scalatest_assert_macro_right3 = "prediction";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(aftr.getCensorCol());
                String $org_scalatest_assert_macro_right4 = "censor";
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(aftr.getFitIntercept(), "aftr.getFitIntercept");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)aftr.getMaxIter()));
                int $org_scalatest_assert_macro_right5 = 100;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)aftr.getTol()));
                double $org_scalatest_assert_macro_right6 = 1.0E-6;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                AFTSurvivalRegressionModel model = aftr.setQuantileProbabilities(new double[]{0.1, 0.8}).setQuantilesCol("quantiles").fit(this.$outer.datasetUnivariate());
                MLTestingUtils$.MODULE$.checkCopy((Model<?>)model);
                model.transform(this.$outer.datasetUnivariate()).select("label", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction", "quantiles"})).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(model.getFeaturesCol());
                String $org_scalatest_assert_macro_right7 = "features";
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(model.getPredictionCol());
                String $org_scalatest_assert_macro_right8 = "prediction";
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(model.getQuantileProbabilities());
                double[] $org_scalatest_assert_macro_right9 = new double[]{0.1, 0.8};
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(model.getQuantilesCol());
                String $org_scalatest_assert_macro_right10 = "quantiles";
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)model.intercept()));
                double $org_scalatest_assert_macro_right11 = 0.0;
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "!==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11.$bang$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(model.hasParent(), "model.hasParent");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("aft survival regression with univariate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AFTSurvivalRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double[] quantileProbabilities = new double[]{0.1, 0.5, 0.9};
                AFTSurvivalRegression trainer = new AFTSurvivalRegression().setQuantileProbabilities(quantileProbabilities).setQuantilesCol("quantiles");
                AFTSurvivalRegressionModel model = trainer.fit(this.$outer.datasetUnivariate());
                Vector coefficientsR = Vectors$.MODULE$.dense(-0.039, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
                double interceptR = 1.759;
                double scaleR = 1.41;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model.coefficients()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model.coefficients).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.scale()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(scaleR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.scale).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scaleR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Vector features = Vectors$.MODULE$.dense(6.559282795753792, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
                double responsePredictR = 4.494763;
                Vector quantilePredictR = Vectors$.MODULE$.dense(0.1879174, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.6801195, 14.5779394}));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.predict(features)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(responsePredictR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.predict(features)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(responsePredictR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model.predictQuantiles(features)).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(quantilePredictR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model.predictQuantiles(features)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(quantilePredictR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Predef$.MODULE$.refArrayOps((Object[])model.transform(this.$outer.datasetUnivariate()).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction", "quantiles"})).collect()).foreach((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    private final AFTSurvivalRegressionModel model$1;

                    public final void apply(Row x0$1) {
                        Row row = x0$1;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                            Object features = ((SeqLike)some.get()).apply(0);
                            Object prediction = ((SeqLike)some.get()).apply(1);
                            Object quantiles = ((SeqLike)some.get()).apply(2);
                            if (features instanceof Vector) {
                                Vector vector = (Vector)features;
                                if (prediction instanceof Double) {
                                    double d = BoxesRunTime.unboxToDouble((Object)prediction);
                                    if (quantiles instanceof Vector) {
                                        Vector vector2 = (Vector)quantiles;
                                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(d).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(this.model$1.predict(vector)).relTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(prediction).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.predict(features)).relTol(1.0E-5))");
                                        this.$outer.org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(vector2).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(this.model$1.predictQuantiles(vector)).relTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(quantiles).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model.predictQuantiles(features)).relTol(1.0E-5))");
                                        this.$outer.org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        return;
                                    }
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.model$1 = model$1;
                    }
                });
            }

            public /* synthetic */ AFTSurvivalRegressionSuite org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("aft survival regression with multivariate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AFTSurvivalRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double[] quantileProbabilities = new double[]{0.1, 0.5, 0.9};
                AFTSurvivalRegression trainer = new AFTSurvivalRegression().setQuantileProbabilities(quantileProbabilities).setQuantilesCol("quantiles");
                AFTSurvivalRegressionModel model = trainer.fit(this.$outer.datasetMultivariate());
                Vector coefficientsR = Vectors$.MODULE$.dense(-0.0844, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0677}));
                double interceptR = 1.9206;
                double scaleR = 0.977;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.intercept()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(interceptR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.intercept).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(interceptR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model.coefficients()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model.coefficients).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.scale()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(scaleR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.scale).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scaleR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Vector features = Vectors$.MODULE$.dense(2.233396950271428, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-2.5321374085997683}));
                double responsePredictR = 4.761219;
                Vector quantilePredictR = Vectors$.MODULE$.dense(0.5287044, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.3285858, 10.7517072}));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.predict(features)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(responsePredictR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.predict(features)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(responsePredictR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model.predictQuantiles(features)).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(quantilePredictR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model.predictQuantiles(features)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(quantilePredictR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Predef$.MODULE$.refArrayOps((Object[])model.transform(this.$outer.datasetMultivariate()).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction", "quantiles"})).collect()).foreach((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;
                    private final AFTSurvivalRegressionModel model$2;

                    public final void apply(Row x0$2) {
                        Row row = x0$2;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                            Object features = ((SeqLike)some.get()).apply(0);
                            Object prediction = ((SeqLike)some.get()).apply(1);
                            Object quantiles = ((SeqLike)some.get()).apply(2);
                            if (features instanceof Vector) {
                                Vector vector = (Vector)features;
                                if (prediction instanceof Double) {
                                    double d = BoxesRunTime.unboxToDouble((Object)prediction);
                                    if (quantiles instanceof Vector) {
                                        Vector vector2 = (Vector)quantiles;
                                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(d).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(this.model$2.predict(vector)).relTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(prediction).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.predict(features)).relTol(1.0E-5))");
                                        this.$outer.org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(vector2).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(this.model$2.predictQuantiles(vector)).relTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(quantiles).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model.predictQuantiles(features)).relTol(1.0E-5))");
                                        this.$outer.org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        return;
                                    }
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.model$2 = model$2;
                    }
                });
            }

            public /* synthetic */ AFTSurvivalRegressionSuite org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("aft survival regression w/o intercept", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AFTSurvivalRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double[] quantileProbabilities = new double[]{0.1, 0.5, 0.9};
                AFTSurvivalRegression trainer = new AFTSurvivalRegression().setQuantileProbabilities(quantileProbabilities).setQuantilesCol("quantiles").setFitIntercept(false);
                AFTSurvivalRegressionModel model = trainer.fit(this.$outer.datasetMultivariate());
                Vector coefficientsR = Vectors$.MODULE$.dense(0.896, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.709}));
                double interceptR = 0.0;
                double scaleR = 1.52;
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)model.intercept()));
                double $org_scalatest_assert_macro_right = interceptR;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model.coefficients()).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(coefficientsR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model.coefficients).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(coefficientsR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.scale()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(scaleR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.scale).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scaleR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Vector features = Vectors$.MODULE$.dense(2.233396950271428, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-2.5321374085997683}));
                double responsePredictR = 44.54465;
                Vector quantilePredictR = Vectors$.MODULE$.dense(1.452103, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{25.506077, 158.4286}));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(model.predict(features)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(responsePredictR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.predict(features)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(responsePredictR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model.predictQuantiles(features)).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(quantilePredictR).relTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model.predictQuantiles(features)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(quantilePredictR).relTol(0.001))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Predef$.MODULE$.refArrayOps((Object[])model.transform(this.$outer.datasetMultivariate()).select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction", "quantiles"})).collect()).foreach((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;
                    private final AFTSurvivalRegressionModel model$3;

                    public final void apply(Row x0$3) {
                        Row row = x0$3;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                            Object features = ((SeqLike)some.get()).apply(0);
                            Object prediction = ((SeqLike)some.get()).apply(1);
                            Object quantiles = ((SeqLike)some.get()).apply(2);
                            if (features instanceof Vector) {
                                Vector vector = (Vector)features;
                                if (prediction instanceof Double) {
                                    double d = BoxesRunTime.unboxToDouble((Object)prediction);
                                    if (quantiles instanceof Vector) {
                                        Vector vector2 = (Vector)quantiles;
                                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(d).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(this.model$3.predict(vector)).relTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(prediction).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.predict(features)).relTol(1.0E-5))");
                                        this.$outer.org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(vector2).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(this.model$3.predictQuantiles(vector)).relTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(quantiles).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model.predictQuantiles(features)).relTol(1.0E-5))");
                                        this.$outer.org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        return;
                                    }
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.model$3 = model$3;
                    }
                });
            }

            public /* synthetic */ AFTSurvivalRegressionSuite org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("aft survival regression w/o quantiles column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AFTSurvivalRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AFTSurvivalRegression trainer = new AFTSurvivalRegression();
                AFTSurvivalRegressionModel model = trainer.fit(this.$outer.datasetUnivariate());
                DataFrame outputDf = model.transform(this.$outer.datasetUnivariate());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)Predef$.MODULE$.refArrayOps((Object[])outputDf.schema().fieldNames()).contains((Object)"quantiles")));
                boolean $org_scalatest_assert_macro_right = false;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Predef$.MODULE$.refArrayOps((Object[])outputDf.select("features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prediction"})).collect()).foreach((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;
                    private final AFTSurvivalRegressionModel model$4;

                    public final void apply(Row x0$4) {
                        Row row = x0$4;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                            Object features = ((SeqLike)some.get()).apply(0);
                            Object prediction = ((SeqLike)some.get()).apply(1);
                            if (features instanceof Vector) {
                                Vector vector = (Vector)features;
                                if (prediction instanceof Double) {
                                    double d = BoxesRunTime.unboxToDouble((Object)prediction);
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(d).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(this.model$4.predict(vector)).relTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(prediction).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(model.predict(features)).relTol(1.0E-5))");
                                    this.$outer.org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                            }
                        }
                        throw new MatchError((Object)row);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.model$4 = model$4;
                    }
                });
            }

            public /* synthetic */ AFTSurvivalRegressionSuite org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read/write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AFTSurvivalRegressionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AFTSurvivalRegression aft = new AFTSurvivalRegression();
                this.$outer.testEstimatorAndModelReadWrite(aft, this.$outer.datasetMultivariate(), AFTSurvivalRegressionSuite$.MODULE$.allParamSettings(), new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final void apply(AFTSurvivalRegressionModel model, AFTSurvivalRegressionModel model2) {
                        this.$outer.org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$anonfun$$checkModelData$1(model, model2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public final void org$apache$spark$ml$regression$AFTSurvivalRegressionSuite$$anonfun$$checkModelData$1(AFTSurvivalRegressionModel model, AFTSurvivalRegressionModel model2) {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)model.intercept()));
                double $org_scalatest_assert_macro_right = model2.intercept();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(model.coefficients());
                Vector $org_scalatest_assert_macro_right2 = model2.coefficients();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)model.scale()));
                double $org_scalatest_assert_macro_right3 = model2.scale();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

