/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.impl.TreeTests$;
import org.apache.spark.ml.regression.RandomForestRegressionModel;
import org.apache.spark.ml.regression.RandomForestRegressor;
import org.apache.spark.ml.regression.RandomForestRegressorSuite$;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.EnsembleTestHelper$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLContext;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001%4A!\u0001\u0002\u0001\u001b\tQ\"+\u00198e_64uN]3tiJ+wM]3tg>\u00148+^5uK*\u00111\u0001B\u0001\u000be\u0016<'/Z:tS>t'BA\u0003\u0007\u0003\tiGN\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0013!\ty\u0001#D\u0001\u0007\u0013\t\tbAA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003'ai\u0011\u0001\u0006\u0006\u0003+Y\tA!\u001e;jY*\u0011qCB\u0001\u0006[2d\u0017NY\u0005\u00033Q\u0011Q#\u0014'mS\n$Vm\u001d;Ta\u0006\u00148nQ8oi\u0016DH\u000fC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0005!I\u0001\u0005\u0001a\u0001\u0002\u0004%I!I\u0001\u001c_J$WM]3e\u0019\u0006\u0014W\r\\3e!>Lg\u000e^:6a}\u000b\u0004\u0007\r\u0019\u0016\u0003\t\u00022a\t\u0014)\u001b\u0005!#BA\u0013\u0007\u0003\r\u0011H\rZ\u0005\u0003O\u0011\u00121A\u0015#E!\tI3&D\u0001+\u0015\t\u0019a#\u0003\u0002-U\taA*\u00192fY\u0016$\u0007k\\5oi\"Ia\u0006\u0001a\u0001\u0002\u0004%IaL\u0001 _J$WM]3e\u0019\u0006\u0014W\r\\3e!>Lg\u000e^:6a}\u000b\u0004\u0007\r\u0019`I\u0015\fHC\u0001\u00197!\t\tD'D\u00013\u0015\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b3\u0005\u0011)f.\u001b;\t\u000f]j\u0013\u0011!a\u0001E\u0005\u0019\u0001\u0010J\u0019\t\re\u0002\u0001\u0015)\u0003#\u0003qy'\u000fZ3sK\u0012d\u0015MY3mK\u0012\u0004v.\u001b8ugV\u0002t,\r\u00191a\u0001BQa\u000f\u0001\u0005Bq\n\u0011BY3g_J,\u0017\t\u001c7\u0015\u0003ABQA\u0010\u0001\u0005\u0002}\nAE]3he\u0016\u001c8/[8o)\u0016\u001cHoV5uQ\u000e{g\u000e^5ok>,8OR3biV\u0014Xm\u001d\u000b\u0003a\u0001CQ!Q\u001fA\u0002\t\u000b!A\u001d4\u0011\u0005y\u0019\u0015B\u0001#\u0003\u0005U\u0011\u0016M\u001c3p[\u001a{'/Z:u%\u0016<'/Z:t_J<QA\u0012\u0002\t\n\u001d\u000b!DU1oI>lgi\u001c:fgR\u0014Vm\u001a:fgN|'oU;ji\u0016\u0004\"A\b%\u0007\u000b\u0005\u0011\u0001\u0012B%\u0014\u0005!s\u0001\"B\u000eI\t\u0003YE#A$\t\u000b5CE\u0011\u0001(\u0002\u0017\r|W\u000e]1sK\u0006\u0003\u0016j\u001d\u000b\u0005a=\u000b&\u000bC\u0003Q\u0019\u0002\u0007!%\u0001\u0003eCR\f\u0007\"B!M\u0001\u0004\u0011\u0005\"B*M\u0001\u0004!\u0016aE2bi\u0016<wN]5dC24U-\u0019;ve\u0016\u001c\b\u0003B+Y7ns!!\r,\n\u0005]\u0013\u0014A\u0002)sK\u0012,g-\u0003\u0002Z5\n\u0019Q*\u00199\u000b\u0005]\u0013\u0004CA\u0019]\u0013\ti&GA\u0002J]RDqa\u0018%\u0002\u0002\u0013%\u0001-A\u0006sK\u0006$'+Z:pYZ,G#A1\u0011\u0005\t<W\"A2\u000b\u0005\u0011,\u0017\u0001\u00027b]\u001eT\u0011AZ\u0001\u0005U\u00064\u0018-\u0003\u0002iG\n1qJ\u00196fGR\u0004")
public class RandomForestRegressorSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private RDD<LabeledPoint> orderedLabeledPoints50_1000;
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public static void compareAPIs(RDD<LabeledPoint> rDD, RandomForestRegressor randomForestRegressor, Map<Object, Object> map) {
        RandomForestRegressorSuite$.MODULE$.compareAPIs(rDD, randomForestRegressor, map);
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    private RDD<LabeledPoint> orderedLabeledPoints50_1000() {
        return this.orderedLabeledPoints50_1000;
    }

    private void orderedLabeledPoints50_1000_$eq(RDD<LabeledPoint> x$1) {
        this.orderedLabeledPoints50_1000 = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
        SparkContext qual$1 = this.sc();
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])EnsembleTestHelper$.MODULE$.generateOrderedLabeledPoints(50, 1000));
        int x$2 = qual$1.parallelize$default$2();
        this.orderedLabeledPoints50_1000_$eq((RDD<LabeledPoint>)qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.apply(LabeledPoint.class)));
    }

    public void regressionTestWithContinuousFeatures(RandomForestRegressor rf) {
        Map categoricalFeaturesInfo = Predef$.MODULE$.Map().empty();
        RandomForestRegressor newRF = rf.setImpurity("variance").setMaxDepth(2).setMaxBins(10).setNumTrees(1).setFeatureSubsetStrategy("auto").setSeed(123L);
        RandomForestRegressorSuite$.MODULE$.compareAPIs(this.orderedLabeledPoints50_1000(), newRF, (Map<Object, Object>)categoricalFeaturesInfo);
    }

    public RandomForestRegressorSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("Regression with continuous features: comparing DecisionTree vs. RandomForest(numTrees = 1)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestRegressorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RandomForestRegressor rf = new RandomForestRegressor();
                this.$outer.regressionTestWithContinuousFeatures(rf);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Regression with continuous features and node Id cache : comparing DecisionTree vs. RandomForest(numTrees = 1)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestRegressorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RandomForestRegressor rf = new RandomForestRegressor().setCacheNodeIds(true);
                this.$outer.regressionTestWithContinuousFeatures(rf);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Feature importance with toy data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestRegressorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RandomForestRegressor rf = new RandomForestRegressor().setImpurity("variance").setMaxDepth(3).setNumTrees(3).setFeatureSubsetStrategy("all").setSubsamplingRate(1.0).setSeed(123L);
                SparkContext qual$2 = this.$outer.sc();
                Seq x$3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 0.0, 1.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 0.0, 1.0, 0.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 0.0, 0.0, 0.0}))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 0.0, 0.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 0.0, 0.0, 0.0})))}));
                int x$4 = qual$2.parallelize$default$2();
                RDD data = qual$2.parallelize(x$3, x$4, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Map categoricalFeatures = Predef$.MODULE$.Map().empty();
                DataFrame df = TreeTests$.MODULE$.setMetadata((RDD<LabeledPoint>)data, (Map<Object, Object>)categoricalFeatures, 0);
                RandomForestRegressionModel model = (RandomForestRegressionModel)rf.fit(df);
                MLTestingUtils$.MODULE$.checkCopy((Model<?>)model);
                Vector importances = model.featureImportances();
                int mostImportantFeature = importances.argmax();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)mostImportantFeature));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

