/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.source.libsvm;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.util.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JavaLibSVMRelationSuite {
    private transient JavaSparkContext jsc;
    private transient SQLContext sqlContext;
    private File tempDir;
    private String path;

    @Before
    public void setUp() throws IOException {
        this.jsc = new JavaSparkContext("local", "JavaLibSVMRelationSuite");
        this.sqlContext = new SQLContext(this.jsc);
        this.tempDir = Utils.createTempDir((String)System.getProperty("java.io.tmpdir"), (String)"datasource");
        File file = new File(this.tempDir, "part-00000");
        String s = "1 1:1.0 3:2.0 5:3.0\n0\n0 2:4.0 4:5.0 6:6.0";
        Files.write((CharSequence)s, (File)file, (Charset)Charsets.US_ASCII);
        this.path = this.tempDir.toURI().toString();
    }

    @After
    public void tearDown() {
        this.jsc.stop();
        this.jsc = null;
        Utils.deleteRecursively((File)this.tempDir);
    }

    @Test
    public void verifyLibSVMDF() {
        DataFrame dataset = this.sqlContext.read().format("libsvm").option("vectorType", "dense").load(this.path);
        Assert.assertEquals((Object)"label", (Object)dataset.columns()[0]);
        Assert.assertEquals((Object)"features", (Object)dataset.columns()[1]);
        Row r = dataset.first();
        Assert.assertEquals((double)1.0, (double)r.getDouble(0), (double)1.0E-15);
        DenseVector v = (DenseVector)r.getAs(1);
        Assert.assertEquals((Object)Vectors.dense((double)1.0, (double[])new double[]{0.0, 2.0, 0.0, 3.0, 0.0}), (Object)v);
    }
}

