/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.source.libsvm;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000193A!\u0001\u0002\u0001\u001f\t\u0019B*\u001b2T-6\u0013V\r\\1uS>t7+^5uK*\u00111\u0001B\u0001\u0007Y&\u00147O^7\u000b\u0005\u00151\u0011AB:pkJ\u001cWM\u0003\u0002\b\u0011\u0005\u0011Q\u000e\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011c\u0001\u0001\u0011)A\u0011\u0011CE\u0007\u0002\u0011%\u00111\u0003\u0003\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005UQR\"\u0001\f\u000b\u0005]A\u0012\u0001B;uS2T!!\u0007\u0005\u0002\u000b5dG.\u001b2\n\u0005m1\"!F'MY&\u0014G+Z:u'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\u0006;\u0001!\tAH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0001\"\u0001\t\u0001\u000e\u0003\tA\u0011B\t\u0001A\u0002\u0003\u0007I\u0011A\u0012\u0002\u000fQ,W\u000e\u001d#jeV\tA\u0005\u0005\u0002&U5\taE\u0003\u0002(Q\u0005\u0011\u0011n\u001c\u0006\u0002S\u0005!!.\u0019<b\u0013\tYcE\u0001\u0003GS2,\u0007\"C\u0017\u0001\u0001\u0004\u0005\r\u0011\"\u0001/\u0003-!X-\u001c9ESJ|F%Z9\u0015\u0005=*\u0004C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$\u0001B+oSRDqA\u000e\u0017\u0002\u0002\u0003\u0007A%A\u0002yIEBa\u0001\u000f\u0001!B\u0013!\u0013\u0001\u0003;f[B$\u0015N\u001d\u0011\t\u0013i\u0002\u0001\u0019!a\u0001\n\u0003Y\u0014\u0001\u00029bi\",\u0012\u0001\u0010\t\u0003{\u0001s!\u0001\r \n\u0005}\n\u0014A\u0002)sK\u0012,g-\u0003\u0002B\u0005\n11\u000b\u001e:j]\u001eT!aP\u0019\t\u0013\u0011\u0003\u0001\u0019!a\u0001\n\u0003)\u0015\u0001\u00039bi\"|F%Z9\u0015\u0005=2\u0005b\u0002\u001cD\u0003\u0003\u0005\r\u0001\u0010\u0005\u0007\u0011\u0002\u0001\u000b\u0015\u0002\u001f\u0002\u000bA\fG\u000f\u001b\u0011\t\u000b)\u0003A\u0011I&\u0002\u0013\t,gm\u001c:f\u00032dG#A\u0018\t\u000b5\u0003A\u0011I&\u0002\u0011\u00054G/\u001a:BY2\u0004")
public class LibSVMRelationSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private File tempDir;
    private String path;
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public File tempDir() {
        return this.tempDir;
    }

    public void tempDir_$eq(File x$1) {
        this.tempDir = x$1;
    }

    public String path() {
        return this.path;
    }

    public void path_$eq(String x$1) {
        this.path = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
        String lines = new StringOps(Predef$.MODULE$.augmentString("\n        |1 1:1.0 3:2.0 5:3.0\n        |0\n        |0 2:4.0 4:5.0 6:6.0\n      ")).stripMargin();
        this.tempDir_$eq(Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()));
        File file = new File(this.tempDir(), "part-00000");
        Files.write((CharSequence)lines, (File)file, (Charset)Charsets.US_ASCII);
        this.path_$eq(this.tempDir().toURI().toString());
    }

    @Override
    public void afterAll() {
        Utils$.MODULE$.deleteRecursively(this.tempDir());
        MLlibTestSparkContext$class.afterAll(this);
    }

    public LibSVMRelationSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("select as sparse vector", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LibSVMRelationSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparseVector v;
                DataFrame df = this.$outer.sqlContext().read().format("libsvm").load(this.$outer.path());
                String $org_scalatest_assert_macro_left = df.columns()[0];
                String $org_scalatest_assert_macro_right = "label";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                String $org_scalatest_assert_macro_left2 = df.columns()[1];
                String $org_scalatest_assert_macro_right2 = "features";
                String string3 = $org_scalatest_assert_macro_left2;
                String string4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Row row1 = df.first();
                double $org_scalatest_assert_macro_left3 = row1.getDouble(0);
                double $org_scalatest_assert_macro_right3 = 1.0;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                SparseVector $org_scalatest_assert_macro_left4 = v = (SparseVector)row1.getAs(1);
                Vector $org_scalatest_assert_macro_right4 = Vectors$.MODULE$.sparse(6, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0), new Tuple2.mcID.sp(2, 2.0), new Tuple2.mcID.sp(4, 3.0)})));
                SparseVector sparseVector = $org_scalatest_assert_macro_left4;
                Vector vector = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(sparseVector != null ? !sparseVector.equals(vector) : vector != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("select as dense vector", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LibSVMRelationSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DenseVector v;
                DataFrame df = this.$outer.sqlContext().read().format("libsvm").options((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"vectorType"), (Object)"dense")}))).load(this.$outer.path());
                String $org_scalatest_assert_macro_left = df.columns()[0];
                String $org_scalatest_assert_macro_right = "label";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                String $org_scalatest_assert_macro_left2 = df.columns()[1];
                String $org_scalatest_assert_macro_right2 = "features";
                String string3 = $org_scalatest_assert_macro_left2;
                String string4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                long $org_scalatest_assert_macro_left3 = df.count();
                int $org_scalatest_assert_macro_right3 = 3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == (long)$org_scalatest_assert_macro_right3);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Row row1 = df.first();
                double $org_scalatest_assert_macro_left4 = row1.getDouble(0);
                double $org_scalatest_assert_macro_right4 = 1.0;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                DenseVector $org_scalatest_assert_macro_left5 = v = (DenseVector)row1.getAs(1);
                Vector $org_scalatest_assert_macro_right5 = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 2.0, 0.0, 3.0, 0.0}));
                DenseVector denseVector = $org_scalatest_assert_macro_left5;
                Vector vector = $org_scalatest_assert_macro_right5;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(denseVector != null ? !denseVector.equals(vector) : vector != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("select a vector with specifying the longer dimension", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LibSVMRelationSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparseVector v;
                DataFrame df = this.$outer.sqlContext().read().option("numFeatures", "100").format("libsvm").load(this.$outer.path());
                Row row1 = df.first();
                SparseVector $org_scalatest_assert_macro_left = v = (SparseVector)row1.getAs(1);
                Vector $org_scalatest_assert_macro_right = Vectors$.MODULE$.sparse(100, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0), new Tuple2.mcID.sp(2, 2.0), new Tuple2.mcID.sp(4, 3.0)})));
                SparseVector sparseVector = $org_scalatest_assert_macro_left;
                Vector vector = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(sparseVector != null ? !sparseVector.equals(vector) : vector != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

