/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tuning;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.classification.LogisticRegression;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.evaluation.BinaryClassificationEvaluator;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.evaluation.RegressionEvaluator;
import org.apache.spark.ml.feature.HashingTF;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamMap$;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.shared.HasInputCol;
import org.apache.spark.ml.regression.LinearRegression;
import org.apache.spark.ml.tuning.CrossValidator;
import org.apache.spark.ml.tuning.CrossValidatorModel;
import org.apache.spark.ml.tuning.CrossValidatorSuite$;
import org.apache.spark.ml.tuning.CrossValidatorSuite$$anonfun$6$;
import org.apache.spark.ml.tuning.ParamGridBuilder;
import org.apache.spark.ml.util.DefaultReadWriteTest;
import org.apache.spark.ml.util.DefaultReadWriteTest$class;
import org.apache.spark.ml.util.MLTestingUtils$;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.TempDirectory$class;
import org.apache.spark.mllib.classification.LogisticRegressionSuite$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.LinearDataGenerator$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\u0001\u0003\u00015\u00111c\u0011:pgN4\u0016\r\\5eCR|'oU;ji\u0016T!a\u0001\u0003\u0002\rQ,h.\u001b8h\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001q!C\u0007\t\u0003\u001fAi\u0011AB\u0005\u0003#\u0019\u0011Qb\u00159be.4UO\\*vSR,\u0007CA\n\u0019\u001b\u0005!\"BA\u000b\u0017\u0003\u0011)H/\u001b7\u000b\u0005]1\u0011!B7mY&\u0014\u0017BA\r\u0015\u0005UiE\n\\5c)\u0016\u001cHo\u00159be.\u001cuN\u001c;fqR\u0004\"aG\u000f\u000e\u0003qQ!!\u0006\u0003\n\u0005ya\"\u0001\u0006#fM\u0006,H\u000e\u001e*fC\u0012<&/\u001b;f)\u0016\u001cH\u000fC\u0003!\u0001\u0011\u0005\u0011%\u0001\u0004=S:LGO\u0010\u000b\u0002EA\u00111\u0005A\u0007\u0002\u0005!IQ\u0005\u0001a\u0001\u0002\u0004%\tAJ\u0001\bI\u0006$\u0018m]3u+\u00059\u0003C\u0001\u0015,\u001b\u0005I#B\u0001\u0016\u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0003Y%\u0012\u0011\u0002R1uC\u001a\u0013\u0018-\\3\t\u00139\u0002\u0001\u0019!a\u0001\n\u0003y\u0013a\u00033bi\u0006\u001cX\r^0%KF$\"\u0001\r\u001c\u0011\u0005E\"T\"\u0001\u001a\u000b\u0003M\nQa]2bY\u0006L!!\u000e\u001a\u0003\tUs\u0017\u000e\u001e\u0005\bo5\n\t\u00111\u0001(\u0003\rAH%\r\u0005\u0007s\u0001\u0001\u000b\u0015B\u0014\u0002\u0011\u0011\fG/Y:fi\u0002B#\u0001O\u001e\u0011\u0005Eb\u0014BA\u001f3\u0005%!(/\u00198tS\u0016tG\u000fC\u0003@\u0001\u0011\u0005\u0003)A\u0005cK\u001a|'/Z!mYR\t\u0001gB\u0003C\u0005!\u00051)A\nDe>\u001c8OV1mS\u0012\fGo\u001c:Tk&$X\r\u0005\u0002$\t\u001a)\u0011A\u0001E\u0001\u000bN\u0011AI\u0004\u0005\u0006A\u0011#\ta\u0012\u000b\u0002\u0007\")\u0011\n\u0012C\u0001\u0015\u0006\u00012m\\7qCJ,\u0007+\u0019:b[6\u000b\u0007o\u001d\u000b\u0004a-3\u0006\"\u0002'I\u0001\u0004i\u0015!\u00029NCB\u001c\bcA\u0019O!&\u0011qJ\r\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003#Rk\u0011A\u0015\u0006\u0003'\u0012\tQ\u0001]1sC6L!!\u0016*\u0003\u0011A\u000b'/Y7NCBDQa\u0016%A\u00025\u000ba\u0001]'baN\u0014d!B-E\u0003\u0003Q&aB'z\u001b>$W\r\\\n\u00031n\u00032\u0001X/`\u001b\u0005!\u0011B\u00010\u0005\u0005\u0015iu\u000eZ3m!\t\u0001\u0007,D\u0001E\u0011\u0015\u0001\u0003\f\"\u0001c)\u0005yf\u0001\u00023E\u0001\u0015\u00141\"T=FgRLW.\u0019;peN\u00191MZ5\u0011\u0007q;w,\u0003\u0002i\t\tIQi\u001d;j[\u0006$xN\u001d\t\u0003U6l\u0011a\u001b\u0006\u0003YJ\u000baa\u001d5be\u0016$\u0017B\u00018l\u0005-A\u0015m]%oaV$8i\u001c7\t\u0011A\u001c'Q1A\u0005BE\f1!^5e+\u0005\u0011\bCA:w\u001d\t\tD/\u0003\u0002ve\u00051\u0001K]3eK\u001aL!a\u001e=\u0003\rM#(/\u001b8h\u0015\t)(\u0007\u0003\u0005{G\n\u0005\t\u0015!\u0003s\u0003\u0011)\u0018\u000e\u001a\u0011\t\u000b\u0001\u001aG\u0011\u0001?\u0015\u0005ut\bC\u00011d\u0011\u0015\u00018\u00101\u0001s\u0011\u0019\t\ta\u0019C!\u0001\u0006qa/\u00197jI\u0006$X\rU1sC6\u001c\bbBA\u0003G\u0012\u0005\u0013qA\u0001\u0004M&$HcA0\u0002\n!1Q%a\u0001A\u0002\u001dBq!!\u0004d\t\u0003\ny!A\bue\u0006t7OZ8s[N\u001b\u0007.Z7b)\u0011\t\t\"!\b\u0011\t\u0005M\u0011\u0011D\u0007\u0003\u0003+Q1!a\u0006*\u0003\u0015!\u0018\u0010]3t\u0013\u0011\tY\"!\u0006\u0003\u0015M#(/^2u)f\u0004X\r\u0003\u0005\u0002 \u0005-\u0001\u0019AA\t\u0003\u0019\u00198\r[3nC\"9\u00111E2\u0005B\u0005\u0015\u0012\u0001B2paf$2!`A\u0014\u0011\u001d\tI#!\tA\u0002A\u000bQ!\u001a=ue\u00064a!!\fE\u0001\u0005=\"aC'z\u000bZ\fG.^1u_J\u001cB!a\u000b\u00022A!\u00111GA\u001d\u001b\t\t)DC\u0002\u00028\u0011\t!\"\u001a<bYV\fG/[8o\u0013\u0011\tY$!\u000e\u0003\u0013\u00153\u0018\r\\;bi>\u0014\bb\u0002\u0011\u0002,\u0011\u0005\u0011q\b\u000b\u0003\u0003\u0003\u00022\u0001YA\u0016\u0011!\t)%a\u000b\u0005B\u0005\u001d\u0013\u0001C3wC2,\u0018\r^3\u0015\t\u0005%\u0013q\n\t\u0004c\u0005-\u0013bAA'e\t1Ai\\;cY\u0016Da!JA\"\u0001\u00049\u0003\u0002CA*\u0003W!\t%!\u0016\u0002\u001d%\u001cH*\u0019:hKJ\u0014U\r\u001e;feV\u0011\u0011q\u000b\t\u0004c\u0005e\u0013bAA.e\t9!i\\8mK\u0006t\u0007\u0002\u00039\u0002,\t\u0007I\u0011I9\t\u000fi\fY\u0003)A\u0005e\"A\u00111EA\u0016\t\u0003\n\u0019\u0007\u0006\u0003\u0002B\u0005\u0015\u0004bBA\u0015\u0003C\u0002\r\u0001\u0015\u0005\n\u0003S\"\u0015\u0011!C\u0005\u0003W\n1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u000e\t\u0005\u0003_\nI(\u0004\u0002\u0002r)!\u00111OA;\u0003\u0011a\u0017M\\4\u000b\u0005\u0005]\u0014\u0001\u00026bm\u0006LA!a\u001f\u0002r\t1qJ\u00196fGR\u0004")
public class CrossValidatorSuite
extends SparkFunSuite
implements MLlibTestSparkContext,
DefaultReadWriteTest {
    private transient DataFrame dataset;
    private File org$apache$spark$ml$util$TempDirectory$$_tempDir;
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public static void compareParamMaps(ParamMap[] paramMapArray, ParamMap[] paramMapArray2) {
        CrossValidatorSuite$.MODULE$.compareParamMaps(paramMapArray, paramMapArray2);
    }

    @Override
    public <T extends Params & MLWritable> T testDefaultReadWrite(T instance, boolean testParams) {
        return (T)DefaultReadWriteTest$class.testDefaultReadWrite(this, instance, testParams);
    }

    @Override
    public <E extends Estimator<M>, M extends Model<M>> void testEstimatorAndModelReadWrite(E estimator, DataFrame dataset, Map<String, Object> testParams, Function2<M, M, BoxedUnit> checkModelData) {
        DefaultReadWriteTest$class.testEstimatorAndModelReadWrite(this, estimator, dataset, testParams, checkModelData);
    }

    @Override
    public <T extends Params & MLWritable> boolean testDefaultReadWrite$default$2() {
        return DefaultReadWriteTest$class.testDefaultReadWrite$default$2(this);
    }

    @Override
    public File org$apache$spark$ml$util$TempDirectory$$_tempDir() {
        return this.org$apache$spark$ml$util$TempDirectory$$_tempDir;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$_tempDir_$eq(File x$1) {
        this.org$apache$spark$ml$util$TempDirectory$$_tempDir = x$1;
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void org$apache$spark$ml$util$TempDirectory$$super$afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    @Override
    public File tempDir() {
        return TempDirectory$class.tempDir(this);
    }

    @Override
    public void afterAll() {
        TempDirectory$class.afterAll(this);
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public DataFrame dataset() {
        return this.dataset;
    }

    public void dataset_$eq(DataFrame x$1) {
        this.dataset = x$1;
    }

    @Override
    public void beforeAll() {
        TempDirectory$class.beforeAll(this);
        SQLContext sqlContext = new SQLContext(this.sc());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CrossValidatorSuite.class.getClassLoader());
        public final class Org_apache_spark_ml_tuning_CrossValidatorSuite$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.regression.LabeledPoint")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_tuning_CrossValidatorSuite$$typecreator1$1(CrossValidatorSuite $outer) {
            }
        }
        this.dataset_$eq(sqlContext.createDataFrame(this.sc().parallelize(LogisticRegressionSuite$.MODULE$.generateLogisticInput(1.0, 1.0, 100, 42), 2, ClassTag$.MODULE$.apply(LabeledPoint.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_tuning_CrossValidatorSuite$$typecreator1$1(this))));
    }

    public CrossValidatorSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        TempDirectory$class.$init$(this);
        DefaultReadWriteTest$class.$init$(this);
        this.test("cross validation with logistic regression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossValidatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegression lr = new LogisticRegression();
                ParamMap[] lrParamMaps = new ParamGridBuilder().addGrid(lr.regParam(), new double[]{0.001, 1000.0}).addGrid(lr.maxIter(), new int[]{0, 10}).build();
                BinaryClassificationEvaluator eval = new BinaryClassificationEvaluator();
                CrossValidator cv = new CrossValidator().setEstimator((Estimator)lr).setEstimatorParamMaps(lrParamMaps).setEvaluator((Evaluator)eval).setNumFolds(3);
                CrossValidatorModel cvModel = cv.fit(this.$outer.dataset());
                MLTestingUtils$.MODULE$.checkCopy((Model<?>)cvModel);
                LogisticRegression parent = (LogisticRegression)cvModel.bestModel().parent();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)parent.getRegParam()));
                double $org_scalatest_assert_macro_right = 0.001;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parent.getMaxIter()));
                int $org_scalatest_assert_macro_right2 = 10;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)cvModel.avgMetrics().length));
                int $org_scalatest_assert_macro_right3 = lrParamMaps.length;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("cross validation with linear regression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossValidatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CrossValidatorSuite.class.getClassLoader());
                DataFrame dataset = this.$outer.sqlContext().createDataFrame(this.$outer.sc().parallelize(LinearDataGenerator$.MODULE$.generateLinearInput(6.3, new double[]{4.7, 7.2}, new double[]{0.9, -1.3}, new double[]{0.7, 1.2}, 100, 42, 0.1), 2, ClassTag$.MODULE$.apply(LabeledPoint.class)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, new TypeCreator(this){

                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.regression.LabeledPoint")).asType()).toTypeConstructor();
                    }
                }));
                LinearRegression trainer = new LinearRegression().setSolver("l-bfgs");
                ParamMap[] lrParamMaps = new ParamGridBuilder().addGrid(trainer.regParam(), new double[]{1000.0, 0.001}).addGrid(trainer.maxIter(), new int[]{0, 10}).build();
                RegressionEvaluator eval = new RegressionEvaluator();
                CrossValidator cv = new CrossValidator().setEstimator((Estimator)trainer).setEstimatorParamMaps(lrParamMaps).setEvaluator((Evaluator)eval).setNumFolds(3);
                CrossValidatorModel cvModel = cv.fit(dataset);
                LinearRegression parent = (LinearRegression)cvModel.bestModel().parent();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)parent.getRegParam()));
                double $org_scalatest_assert_macro_right = 0.001;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parent.getMaxIter()));
                int $org_scalatest_assert_macro_right2 = 10;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)cvModel.avgMetrics().length));
                int $org_scalatest_assert_macro_right3 = lrParamMaps.length;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                eval.setMetricName("r2");
                CrossValidatorModel cvModel2 = cv.fit(dataset);
                LinearRegression parent2 = (LinearRegression)cvModel2.bestModel().parent();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)parent2.getRegParam()));
                double $org_scalatest_assert_macro_right4 = 0.001;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parent2.getMaxIter()));
                int $org_scalatest_assert_macro_right5 = 10;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)cvModel2.avgMetrics().length));
                int $org_scalatest_assert_macro_right6 = lrParamMaps.length;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("validateParams should check estimatorParamMaps", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossValidatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MyEstimator est = new MyEstimator("est");
                MyEvaluator eval = new MyEvaluator();
                ParamMap[] paramMaps = new ParamGridBuilder().addGrid(est.inputCol(), (Iterable)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"input1", "input2"})).build();
                CrossValidator cv = new CrossValidator().setEstimator((Estimator)est).setEstimatorParamMaps(paramMaps).setEvaluator((Evaluator)eval);
                cv.validateParams();
                ParamMap[] invalidParamMaps = (ParamMap[])Predef$.MODULE$.refArrayOps((Object[])paramMaps).$colon$plus((Object)ParamMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{est.inputCol().$minus$greater((Object)"")})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ParamMap.class)));
                cv.setEstimatorParamMaps(invalidParamMaps);
                this.$outer.intercept((Function0)new Serializable(this, cv){
                    public static final long serialVersionUID = 0L;
                    private final CrossValidator cv$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.cv$1.validateParams();
                    }
                    {
                        this.cv$1 = cv$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read/write: CrossValidator with simple estimator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossValidatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegression lr = new LogisticRegression().setMaxIter(3);
                BinaryClassificationEvaluator evaluator = new BinaryClassificationEvaluator().setMetricName("areaUnderPR");
                ParamMap[] paramMaps = new ParamGridBuilder().addGrid(lr.regParam(), new double[]{0.1, 0.2}).build();
                CrossValidator cv = new CrossValidator().setEstimator((Estimator)lr).setEvaluator((Evaluator)evaluator).setNumFolds(20).setEstimatorParamMaps(paramMaps);
                CrossValidator cv2 = this.$outer.testDefaultReadWrite(cv, false);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(cv.uid());
                String $org_scalatest_assert_macro_right = cv2.uid();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)cv.getNumFolds()));
                int $org_scalatest_assert_macro_right2 = cv2.getNumFolds();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Evaluator $org_scalatest_assert_macro_left3 = cv2.getEvaluator();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.ml.evaluation.BinaryClassificationEvaluator", $org_scalatest_assert_macro_left3 instanceof BinaryClassificationEvaluator);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                BinaryClassificationEvaluator evaluator2 = (BinaryClassificationEvaluator)cv2.getEvaluator();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(evaluator.uid());
                String $org_scalatest_assert_macro_right3 = evaluator2.uid();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(evaluator.getMetricName());
                String $org_scalatest_assert_macro_right4 = evaluator2.getMetricName();
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Estimator estimator = cv2.getEstimator();
                if (estimator instanceof LogisticRegression) {
                    LogisticRegression logisticRegression = (LogisticRegression)estimator;
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(lr.uid());
                    String $org_scalatest_assert_macro_right5 = logisticRegression.uid();
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)lr.getMaxIter()));
                    int $org_scalatest_assert_macro_right6 = logisticRegression.getMaxIter();
                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    CrossValidatorSuite$.MODULE$.compareParamMaps(cv.getEstimatorParamMaps(), cv2.getEstimatorParamMaps());
                    return;
                }
                throw new AssertionError((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded CrossValidator expected estimator of type"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" LogisticRegression but found ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{estimator.getClass().getName()}))).toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read/write: CrossValidator with complex estimator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossValidatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                BinaryClassificationEvaluator lrEvaluator = new BinaryClassificationEvaluator().setMetricName("areaUnderPR");
                LogisticRegression lr = new LogisticRegression().setMaxIter(3);
                ParamMap[] lrParamMaps = new ParamGridBuilder().addGrid(lr.regParam(), new double[]{0.1, 0.2}).build();
                CrossValidator lrcv = new CrossValidator().setEstimator((Estimator)lr).setEvaluator((Evaluator)lrEvaluator).setEstimatorParamMaps(lrParamMaps);
                HashingTF hashingTF = new HashingTF();
                Pipeline pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{hashingTF, lrcv}));
                ParamMap[] paramMaps = new ParamGridBuilder().addGrid(hashingTF.numFeatures(), new int[]{10, 20}).addGrid(lr.elasticNetParam(), new double[]{0.0, 1.0}).build();
                BinaryClassificationEvaluator evaluator = new BinaryClassificationEvaluator();
                CrossValidator cv = new CrossValidator().setEstimator((Estimator)pipeline).setEvaluator((Evaluator)evaluator).setNumFolds(20).setEstimatorParamMaps(paramMaps);
                CrossValidator cv2 = this.$outer.testDefaultReadWrite(cv, false);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(cv.uid());
                String $org_scalatest_assert_macro_right = cv2.uid();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)cv.getNumFolds()));
                int $org_scalatest_assert_macro_right2 = cv2.getNumFolds();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Evaluator $org_scalatest_assert_macro_left3 = cv2.getEvaluator();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.ml.evaluation.BinaryClassificationEvaluator", $org_scalatest_assert_macro_left3 instanceof BinaryClassificationEvaluator);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(cv.getEvaluator().uid());
                String $org_scalatest_assert_macro_right3 = cv2.getEvaluator().uid();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                CrossValidatorSuite$.MODULE$.compareParamMaps(cv.getEstimatorParamMaps(), cv2.getEstimatorParamMaps());
                Estimator estimator = cv2.getEstimator();
                if (estimator instanceof Pipeline) {
                    Pipeline pipeline2 = (Pipeline)estimator;
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(pipeline.uid());
                    String $org_scalatest_assert_macro_right4 = pipeline2.uid();
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                    PipelineStage[] pipelineStageArray = pipeline2.getStages();
                    Option option = Array$.MODULE$.unapplySeq((Object)pipelineStageArray);
                    if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                        PipelineStage hashingTF2 = (PipelineStage)((SeqLike)option.get()).apply(0);
                        PipelineStage lrcv2 = (PipelineStage)((SeqLike)option.get()).apply(1);
                        if (hashingTF2 instanceof HashingTF) {
                            HashingTF hashingTF3 = (HashingTF)hashingTF2;
                            if (lrcv2 instanceof CrossValidator) {
                                CrossValidator crossValidator = (CrossValidator)lrcv2;
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(hashingTF.uid());
                                String $org_scalatest_assert_macro_right5 = hashingTF3.uid();
                                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                                Estimator estimator2 = crossValidator.getEstimator();
                                if (estimator2 instanceof LogisticRegression) {
                                    LogisticRegression logisticRegression = (LogisticRegression)estimator2;
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(lr.uid());
                                    String $org_scalatest_assert_macro_right6 = logisticRegression.uid();
                                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()));
                                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)lr.getMaxIter()));
                                    int $org_scalatest_assert_macro_right7 = logisticRegression.getMaxIter();
                                    Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(lrcv.uid());
                                    String $org_scalatest_assert_macro_right8 = crossValidator.uid();
                                    Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()));
                                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                                    Evaluator $org_scalatest_assert_macro_left10 = crossValidator.getEvaluator();
                                    Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left10, "isInstanceOf", "org.apache.spark.ml.evaluation.BinaryClassificationEvaluator", $org_scalatest_assert_macro_left10 instanceof BinaryClassificationEvaluator);
                                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.$outer.convertToEqualizer(lrEvaluator.uid());
                                    String $org_scalatest_assert_macro_right9 = crossValidator.getEvaluator().uid();
                                    Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()));
                                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                                    CrossValidatorSuite$.MODULE$.compareParamMaps(lrParamMaps, crossValidator.getEstimatorParamMaps());
                                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                                    BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new AssertionError((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded internal CrossValidator expected to be"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" LogisticRegression but found type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{estimator2.getClass().getName()}))).toString());
                            }
                        }
                    }
                    throw new AssertionError((Object)new StringBuilder().append((Object)"Loaded Pipeline expected stages (HashingTF, CrossValidator) but found: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])pipelineStageArray).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(PipelineStage x$1) {
                            return x$1.getClass().getName();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(", ")).toString());
                }
                throw new AssertionError((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded CrossValidator expected estimator of type"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" CrossValidator but found ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{estimator.getClass().getName()}))).toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read/write: CrossValidator fails for extraneous Param", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossValidatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegression lr = new LogisticRegression();
                LogisticRegression lr2 = new LogisticRegression();
                BinaryClassificationEvaluator evaluator = new BinaryClassificationEvaluator();
                ParamMap[] paramMaps = new ParamGridBuilder().addGrid(lr.regParam(), new double[]{0.1, 0.2}).addGrid(lr2.regParam(), new double[]{0.1, 0.2}).build();
                CrossValidator cv = new CrossValidator().setEstimator((Estimator)lr).setEvaluator((Evaluator)evaluator).setEstimatorParamMaps(paramMaps);
                this.$outer.withClue("CrossValidator.write failed to catch extraneous Param error", (Function0)new Serializable(this, cv){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;
                    public final CrossValidator cv$2;

                    public final IllegalArgumentException apply() {
                        return (IllegalArgumentException)this.$outer.org$apache$spark$ml$tuning$CrossValidatorSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$6$$anonfun$apply$mcV$sp$3 $outer;

                            public final MLWriter apply() {
                                return this.$outer.cv$2.write();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.cv$2 = cv$2;
                    }
                });
            }

            public /* synthetic */ CrossValidatorSuite org$apache$spark$ml$tuning$CrossValidatorSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read/write: CrossValidatorModel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossValidatorSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogisticRegression lr = new LogisticRegression().setThreshold(0.6);
                LogisticRegressionModel lrModel = new LogisticRegressionModel(lr.uid(), Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0})), 1.2).setThreshold(0.6);
                BinaryClassificationEvaluator evaluator = new BinaryClassificationEvaluator().setMetricName("areaUnderPR");
                ParamMap[] paramMaps = new ParamGridBuilder().addGrid(lr.regParam(), new double[]{0.1, 0.2}).build();
                CrossValidatorModel cv = new CrossValidatorModel("cvUid", (Model)lrModel, new double[]{0.3, 0.6});
                cv.set(cv.estimator(), (Object)lr).set(cv.evaluator(), (Object)evaluator).set((Param)cv.numFolds(), (Object)BoxesRunTime.boxToInteger((int)20)).set(cv.estimatorParamMaps(), (Object)paramMaps);
                CrossValidatorModel cv2 = this.$outer.testDefaultReadWrite(cv, false);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(cv.uid());
                String $org_scalatest_assert_macro_right = cv2.uid();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)cv.getNumFolds()));
                int $org_scalatest_assert_macro_right2 = cv2.getNumFolds();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Evaluator $org_scalatest_assert_macro_left3 = cv2.getEvaluator();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.ml.evaluation.BinaryClassificationEvaluator", $org_scalatest_assert_macro_left3 instanceof BinaryClassificationEvaluator);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                BinaryClassificationEvaluator evaluator2 = (BinaryClassificationEvaluator)cv2.getEvaluator();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(evaluator.uid());
                String $org_scalatest_assert_macro_right3 = evaluator2.uid();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(evaluator.getMetricName());
                String $org_scalatest_assert_macro_right4 = evaluator2.getMetricName();
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Estimator estimator = cv2.getEstimator();
                if (estimator instanceof LogisticRegression) {
                    LogisticRegression logisticRegression = (LogisticRegression)estimator;
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(lr.uid());
                    String $org_scalatest_assert_macro_right5 = logisticRegression.uid();
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)lr.getThreshold()));
                    double $org_scalatest_assert_macro_right6 = logisticRegression.getThreshold();
                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    CrossValidatorSuite$.MODULE$.compareParamMaps(cv.getEstimatorParamMaps(), cv2.getEstimatorParamMaps());
                    Model model = cv2.bestModel();
                    if (model instanceof LogisticRegressionModel) {
                        LogisticRegressionModel logisticRegressionModel = (LogisticRegressionModel)model;
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(lrModel.uid());
                        String $org_scalatest_assert_macro_right7 = logisticRegressionModel.uid();
                        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()));
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)lrModel.getThreshold()));
                        double $org_scalatest_assert_macro_right8 = logisticRegressionModel.getThreshold();
                        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()));
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(lrModel.coefficients());
                        Vector $org_scalatest_assert_macro_right9 = logisticRegressionModel.coefficients();
                        Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()));
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)lrModel.intercept()));
                        double $org_scalatest_assert_macro_right10 = logisticRegressionModel.intercept();
                        Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()));
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.$outer.convertToEqualizer(cv.avgMetrics());
                        double[] $org_scalatest_assert_macro_right11 = cv2.avgMetrics();
                        Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()));
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                        return;
                    }
                    throw new AssertionError((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded CrossValidator expected bestModel of type"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" LogisticRegressionModel but found ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{model.getClass().getName()}))).toString());
                }
                throw new AssertionError((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loaded CrossValidator expected estimator of type"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" LogisticRegression but found ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{estimator.getClass().getName()}))).toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static abstract class MyModel
    extends Model<MyModel> {
    }

    public static class MyEstimator
    extends Estimator<MyModel>
    implements HasInputCol {
        private final String uid;
        private final Param<String> inputCol;

        public final Param<String> inputCol() {
            return this.inputCol;
        }

        public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param x$1) {
            this.inputCol = x$1;
        }

        public final String getInputCol() {
            return HasInputCol.class.getInputCol((HasInputCol)this);
        }

        public String uid() {
            return this.uid;
        }

        public void validateParams() {
            Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString((String)this.$(this.inputCol()))).nonEmpty());
        }

        public MyModel fit(DataFrame dataset) {
            throw new UnsupportedOperationException();
        }

        public StructType transformSchema(StructType schema) {
            throw new UnsupportedOperationException();
        }

        public MyEstimator copy(ParamMap extra) {
            return (MyEstimator)this.defaultCopy(extra);
        }

        public MyEstimator(String uid) {
            this.uid = uid;
            HasInputCol.class.$init$((HasInputCol)this);
        }
    }

    public static class MyEvaluator
    extends Evaluator {
        private final String uid;

        public double evaluate(DataFrame dataset) {
            throw new UnsupportedOperationException();
        }

        public boolean isLargerBetter() {
            return true;
        }

        public String uid() {
            return this.uid;
        }

        public MyEvaluator copy(ParamMap extra) {
            return (MyEvaluator)this.defaultCopy(extra);
        }

        public MyEvaluator() {
            this.uid = "eval";
        }
    }
}

