/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.util;

import java.io.File;
import java.io.IOException;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.ml.util.MyParams;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.util.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JavaDefaultReadWriteSuite {
    JavaSparkContext jsc = null;
    SQLContext sqlContext = null;
    File tempDir = null;

    @Before
    public void setUp() {
        this.jsc = new JavaSparkContext("local[2]", "JavaDefaultReadWriteSuite");
        SQLContext.clearActive();
        this.sqlContext = new SQLContext(this.jsc);
        SQLContext.setActive((SQLContext)this.sqlContext);
        this.tempDir = Utils.createTempDir((String)System.getProperty("java.io.tmpdir"), (String)"JavaDefaultReadWriteSuite");
    }

    @After
    public void tearDown() {
        this.sqlContext = null;
        SQLContext.clearActive();
        if (this.jsc != null) {
            this.jsc.stop();
            this.jsc = null;
        }
        Utils.deleteRecursively((File)this.tempDir);
    }

    @Test
    public void testDefaultReadWrite() throws IOException {
        String uid = "my_params";
        MyParams instance = new MyParams(uid);
        instance.set(instance.intParam(), 2);
        String outputPath = new File(this.tempDir, uid).getPath();
        instance.save(outputPath);
        try {
            instance.save(outputPath);
            Assert.fail((String)"Write without overwrite enabled should fail if the output directory already exists.");
        }
        catch (IOException e) {
            // empty catch block
        }
        instance.write().context(this.sqlContext).overwrite().save(outputPath);
        MyParams newInstance = MyParams.load(outputPath);
        Assert.assertEquals((String)"UID should match.", (Object)instance.uid(), (Object)newInstance.uid());
        Assert.assertEquals((String)"Params should be preserved.", (Object)2, newInstance.getOrDefault(newInstance.intParam()));
    }
}

