/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.mllib.clustering.GaussianMixture;
import org.apache.spark.mllib.clustering.GaussianMixtureModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JavaGaussianMixtureSuite
implements Serializable {
    private transient JavaSparkContext sc;

    @Before
    public void setUp() {
        this.sc = new JavaSparkContext("local", "JavaGaussianMixture");
    }

    @After
    public void tearDown() {
        this.sc.stop();
        this.sc = null;
    }

    @Test
    public void runGaussianMixture() {
        List<Vector> points = Arrays.asList(Vectors.dense((double)1.0, (double[])new double[]{2.0, 6.0}), Vectors.dense((double)1.0, (double[])new double[]{3.0, 0.0}), Vectors.dense((double)1.0, (double[])new double[]{4.0, 6.0}));
        JavaRDD data = this.sc.parallelize(points, 2);
        GaussianMixtureModel model = new GaussianMixture().setK(2).setMaxIterations(1).setSeed(1234L).run(data);
        Assert.assertEquals((long)model.gaussians().length, (long)2L);
        JavaRDD predictions = model.predict(data);
        predictions.first();
    }
}

