/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.clustering.PowerIterationClustering;
import org.apache.spark.mllib.clustering.PowerIterationClusteringModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random$;

public final class PowerIterationClusteringSuite$
extends SparkFunSuite {
    public static final PowerIterationClusteringSuite$ MODULE$;

    static {
        new PowerIterationClusteringSuite$();
    }

    public PowerIterationClusteringModel createModel(SparkContext sc, int k, int nPoints) {
        RDD assignments = sc.parallelize((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPoints).map((Function1)new Serializable(k){
            public static final long serialVersionUID = 0L;
            private final int k$1;

            public final PowerIterationClustering.Assignment apply(int p) {
                return new PowerIterationClustering.Assignment((long)p, Random$.MODULE$.nextInt(this.k$1));
            }
            {
                this.k$1 = k$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom()), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(PowerIterationClustering.Assignment.class));
        return new PowerIterationClusteringModel(k, assignments);
    }

    public void checkEqual(PowerIterationClusteringModel a, PowerIterationClusteringModel b) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)a.k()));
        int $org_scalatest_assert_macro_right = b.k();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
        RDD aAssignments = a.assignments().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(PowerIterationClustering.Assignment x) {
                return new Tuple2.mcJI.sp(x.id(), x.cluster());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD bAssignments = b.assignments().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(PowerIterationClustering.Assignment x) {
                return new Tuple2.mcJI.sp(x.id(), x.cluster());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        long unequalElements = RDD$.MODULE$.rddToPairRDDFunctions(aAssignments, ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Long$.MODULE$).join(bAssignments).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Tuple2<Object, Object>> x0$4) {
                Tuple2 tuple2;
                Tuple2<Object, Tuple2<Object, Object>> tuple22 = x0$4;
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                    int c2;
                    int c1 = tuple2._1$mcI$sp();
                    boolean bl = c1 != (c2 = tuple2._2$mcI$sp());
                    return bl;
                }
                throw new MatchError(tuple22);
            }
        }).count();
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)unequalElements));
        long $org_scalatest_assert_macro_right2 = 0L;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
    }

    private Object readResolve() {
        return MODULE$;
    }

    private PowerIterationClusteringSuite$() {
        MODULE$ = this;
    }
}

