/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.mllib.clustering.PowerIterationClustering;
import org.apache.spark.mllib.clustering.PowerIterationClustering$;
import org.apache.spark.mllib.clustering.PowerIterationClusteringModel;
import org.apache.spark.mllib.clustering.PowerIterationClusteringModel$;
import org.apache.spark.mllib.clustering.PowerIterationClusteringSuite$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u000193A!\u0001\u0002\u0001\u001b\ti\u0002k\\<fe&#XM]1uS>t7\t\\;ti\u0016\u0014\u0018N\\4Tk&$XM\u0003\u0002\u0004\t\u0005Q1\r\\;ti\u0016\u0014\u0018N\\4\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\n\u0011\u0005=\u0001R\"\u0001\u0004\n\u0005E1!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u0005!Q\u000f^5m\u0013\t9BCA\u000bN\u00192L'\rV3tiN\u0003\u0018M]6D_:$X\r\u001f;\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011q!\u0002\u0010\u0003\u0011\u0003y\u0012!\b)po\u0016\u0014\u0018\n^3sCRLwN\\\"mkN$XM]5oON+\u0018\u000e^3\u0011\u0005q\u0001c!B\u0001\u0003\u0011\u0003\t3C\u0001\u0011\u000f\u0011\u0015I\u0002\u0005\"\u0001$)\u0005y\u0002\"B\u0013!\t\u00031\u0013aC2sK\u0006$X-T8eK2$Ba\n\u00160oA\u0011A\u0004K\u0005\u0003S\t\u0011Q\u0004U8xKJLE/\u001a:bi&|gn\u00117vgR,'/\u001b8h\u001b>$W\r\u001c\u0005\u0006W\u0011\u0002\r\u0001L\u0001\u0003g\u000e\u0004\"aD\u0017\n\u000592!\u0001D*qCJ\\7i\u001c8uKb$\b\"\u0002\u0019%\u0001\u0004\t\u0014!A6\u0011\u0005I*T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\u0007%sG\u000fC\u00039I\u0001\u0007\u0011'A\u0004o!>Lg\u000e^:\t\u000bi\u0002C\u0011A\u001e\u0002\u0015\rDWmY6FcV\fG\u000eF\u0002=\u007f\u0005\u0003\"AM\u001f\n\u0005y\u001a$\u0001B+oSRDQ\u0001Q\u001dA\u0002\u001d\n\u0011!\u0019\u0005\u0006\u0005f\u0002\raJ\u0001\u0002E\"9A\tIA\u0001\n\u0013)\u0015a\u0003:fC\u0012\u0014Vm]8mm\u0016$\u0012A\u0012\t\u0003\u000f2k\u0011\u0001\u0013\u0006\u0003\u0013*\u000bA\u0001\\1oO*\t1*\u0001\u0003kCZ\f\u0017BA'I\u0005\u0019y%M[3di\u0002")
public class PowerIterationClusteringSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public static void checkEqual(PowerIterationClusteringModel powerIterationClusteringModel, PowerIterationClusteringModel powerIterationClusteringModel2) {
        PowerIterationClusteringSuite$.MODULE$.checkEqual(powerIterationClusteringModel, powerIterationClusteringModel2);
    }

    public static PowerIterationClusteringModel createModel(SparkContext sparkContext, int n, int n2) {
        return PowerIterationClusteringSuite$.MODULE$.createModel(sparkContext, n, n2);
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public PowerIterationClusteringSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("power iteration clustering", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PowerIterationClusteringSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq similarities = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)3L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToLong((long)3L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToLong((long)3L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)3L), (Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToDouble((double)0.1)), new Tuple3((Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToLong((long)5L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToLong((long)15L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)5L), (Object)BoxesRunTime.boxToLong((long)6L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)6L), (Object)BoxesRunTime.boxToLong((long)7L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)7L), (Object)BoxesRunTime.boxToLong((long)8L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)8L), (Object)BoxesRunTime.boxToLong((long)9L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)9L), (Object)BoxesRunTime.boxToLong((long)10L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)10L), (Object)BoxesRunTime.boxToLong((long)11L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)11L), (Object)BoxesRunTime.boxToLong((long)12L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)12L), (Object)BoxesRunTime.boxToLong((long)13L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)13L), (Object)BoxesRunTime.boxToLong((long)14L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)14L), (Object)BoxesRunTime.boxToLong((long)15L), (Object)BoxesRunTime.boxToDouble((double)1.0))}));
                PowerIterationClusteringModel model = new PowerIterationClustering().setK(2).run(this.$outer.sc().parallelize(similarities, 2, ClassTag$.MODULE$.apply(Tuple3.class)));
                Set[] predictions = (Set[])Array$.MODULE$.fill(2, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Set<Object> apply() {
                        return Set$.MODULE$.empty();
                    }
                }, ClassTag$.MODULE$.apply(Set.class));
                Predef$.MODULE$.refArrayOps((Object[])model.assignments().collect()).foreach((Function1)new Serializable(this, predictions){
                    public static final long serialVersionUID = 0L;
                    private final Set[] predictions$1;

                    public final Set<Object> apply(PowerIterationClustering.Assignment a) {
                        return (Set)this.predictions$1[a.cluster()].$plus$eq((Object)BoxesRunTime.boxToLong((long)a.id()));
                    }
                    {
                        this.predictions$1 = predictions$1;
                    }
                });
                scala.collection.immutable.Set $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])predictions).toSet();
                scala.collection.immutable.Set $org_scalatest_assert_macro_right = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Set[]{RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3).toSet(), RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(4), 15).toSet()}));
                scala.collection.immutable.Set set = $org_scalatest_assert_macro_left;
                scala.collection.immutable.Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                PowerIterationClusteringModel model2 = new PowerIterationClustering().setK(2).setInitializationMode("degree").run(this.$outer.sc().parallelize(similarities, 2, ClassTag$.MODULE$.apply(Tuple3.class)));
                Set[] predictions2 = (Set[])Array$.MODULE$.fill(2, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Set<Object> apply() {
                        return Set$.MODULE$.empty();
                    }
                }, ClassTag$.MODULE$.apply(Set.class));
                Predef$.MODULE$.refArrayOps((Object[])model2.assignments().collect()).foreach((Function1)new Serializable(this, predictions2){
                    public static final long serialVersionUID = 0L;
                    private final Set[] predictions2$1;

                    public final Set<Object> apply(PowerIterationClustering.Assignment a) {
                        return (Set)this.predictions2$1[a.cluster()].$plus$eq((Object)BoxesRunTime.boxToLong((long)a.id()));
                    }
                    {
                        this.predictions2$1 = predictions2$1;
                    }
                });
                scala.collection.immutable.Set $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])predictions2).toSet();
                scala.collection.immutable.Set $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Set[]{RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3).toSet(), RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(4), 15).toSet()}));
                scala.collection.immutable.Set set3 = $org_scalatest_assert_macro_left2;
                scala.collection.immutable.Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("power iteration clustering on graph", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PowerIterationClusteringSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq similarities = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)3L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToLong((long)3L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToLong((long)3L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)3L), (Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToDouble((double)0.1)), new Tuple3((Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToLong((long)5L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)4L), (Object)BoxesRunTime.boxToLong((long)15L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)5L), (Object)BoxesRunTime.boxToLong((long)6L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)6L), (Object)BoxesRunTime.boxToLong((long)7L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)7L), (Object)BoxesRunTime.boxToLong((long)8L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)8L), (Object)BoxesRunTime.boxToLong((long)9L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)9L), (Object)BoxesRunTime.boxToLong((long)10L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)10L), (Object)BoxesRunTime.boxToLong((long)11L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)11L), (Object)BoxesRunTime.boxToLong((long)12L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)12L), (Object)BoxesRunTime.boxToLong((long)13L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)13L), (Object)BoxesRunTime.boxToLong((long)14L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)14L), (Object)BoxesRunTime.boxToLong((long)15L), (Object)BoxesRunTime.boxToDouble((double)1.0))}));
                Seq edges = (Seq)similarities.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<Edge<Object>> apply(Tuple3<Object, Object, Object> x0$1) {
                        Tuple3<Object, Object, Object> tuple3 = x0$1;
                        if (tuple3 != null) {
                            long i = BoxesRunTime.unboxToLong((Object)tuple3._1());
                            long j = BoxesRunTime.unboxToLong((Object)tuple3._2());
                            double s = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                            Iterable iterable = i != j ? (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Edge[]{new Edge.mcD.sp(i, j, s), new Edge.mcD.sp(j, i, s)})) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                            return iterable;
                        }
                        throw new MatchError(tuple3);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Graph graph = Graph$.MODULE$.fromEdges(this.$outer.sc().parallelize(edges, 2, ClassTag$.MODULE$.apply(Edge.class)), (Object)BoxesRunTime.boxToDouble((double)0.0), Graph$.MODULE$.fromEdges$default$3(), Graph$.MODULE$.fromEdges$default$4(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double());
                PowerIterationClusteringModel model = new PowerIterationClustering().setK(2).run(graph);
                Set[] predictions = (Set[])Array$.MODULE$.fill(2, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Set<Object> apply() {
                        return Set$.MODULE$.empty();
                    }
                }, ClassTag$.MODULE$.apply(Set.class));
                Predef$.MODULE$.refArrayOps((Object[])model.assignments().collect()).foreach((Function1)new Serializable(this, predictions){
                    public static final long serialVersionUID = 0L;
                    private final Set[] predictions$2;

                    public final Set<Object> apply(PowerIterationClustering.Assignment a) {
                        return (Set)this.predictions$2[a.cluster()].$plus$eq((Object)BoxesRunTime.boxToLong((long)a.id()));
                    }
                    {
                        this.predictions$2 = predictions$2;
                    }
                });
                scala.collection.immutable.Set $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])predictions).toSet();
                scala.collection.immutable.Set $org_scalatest_assert_macro_right = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Set[]{RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3).toSet(), RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(4), 15).toSet()}));
                scala.collection.immutable.Set set = $org_scalatest_assert_macro_left;
                scala.collection.immutable.Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                PowerIterationClusteringModel model2 = new PowerIterationClustering().setK(2).setInitializationMode("degree").run(this.$outer.sc().parallelize(similarities, 2, ClassTag$.MODULE$.apply(Tuple3.class)));
                Set[] predictions2 = (Set[])Array$.MODULE$.fill(2, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Set<Object> apply() {
                        return Set$.MODULE$.empty();
                    }
                }, ClassTag$.MODULE$.apply(Set.class));
                Predef$.MODULE$.refArrayOps((Object[])model2.assignments().collect()).foreach((Function1)new Serializable(this, predictions2){
                    public static final long serialVersionUID = 0L;
                    private final Set[] predictions2$2;

                    public final Set<Object> apply(PowerIterationClustering.Assignment a) {
                        return (Set)this.predictions2$2[a.cluster()].$plus$eq((Object)BoxesRunTime.boxToLong((long)a.id()));
                    }
                    {
                        this.predictions2$2 = predictions2$2;
                    }
                });
                scala.collection.immutable.Set $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])predictions2).toSet();
                scala.collection.immutable.Set $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Set[]{RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3).toSet(), RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(4), 15).toSet()}));
                scala.collection.immutable.Set set3 = $org_scalatest_assert_macro_left2;
                scala.collection.immutable.Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("normalize and powerIter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PowerIterationClusteringSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq similarities = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)3L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)1L), (Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToLong((long)2L), (Object)BoxesRunTime.boxToLong((long)3L), (Object)BoxesRunTime.boxToDouble((double)1.0))}));
                double[][] expected = (double[][])((Object[])new double[][]{{0.0, 0.3333333333333333, 0.3333333333333333, 0.3333333333333333}, {0.5, 0.0, 0.5, 0.0}, {0.3333333333333333, 0.3333333333333333, 0.0, 0.3333333333333333}, {0.5, 0.0, 0.5, 0.0}});
                Graph w = PowerIterationClustering$.MODULE$.normalize(this.$outer.sc().parallelize(similarities, 2, ClassTag$.MODULE$.apply(Tuple3.class)));
                Predef$.MODULE$.refArrayOps((Object[])w.edges().collect()).foreach((Function1)new Serializable(this, expected){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    private final double[][] expected$1;

                    public final void apply(Edge<Object> x0$2) {
                        Edge<Object> edge = x0$2;
                        if (edge != null) {
                            long i = edge.srcId();
                            long j = edge.dstId();
                            double x = edge.attr$mcD$sp();
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(this.expected$1[(int)i][(int)j]).absTol(1.0E-14)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(x).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(expected.apply(i.toInt).apply(j.toInt)).absTol(1.0E-14))");
                            this.$outer.org$apache$spark$mllib$clustering$PowerIterationClusteringSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(edge);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.expected$1 = expected$1;
                    }
                });
                RDD v0 = this.$outer.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJD.sp(0L, 0.1), new Tuple2.mcJD.sp(1L, 0.2), new Tuple2.mcJD.sp(2L, 0.3), new Tuple2.mcJD.sp(3L, 0.4)})), 2, ClassTag$.MODULE$.apply(Tuple2.class));
                Graph w0 = Graph$.MODULE$.apply(v0, (RDD)w.edges(), Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double());
                Tuple2[] v1 = (Tuple2[])PowerIterationClustering$.MODULE$.powerIter(w0, 1).collect();
                double[] u = new double[]{0.3, 0.2, 0.2333333333333333, 0.2};
                double norm = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(u).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                double[] u1 = (double[])Predef$.MODULE$.doubleArrayOps(u).map((Function1)new Serializable(this, norm){
                    public static final long serialVersionUID = 0L;
                    private final double norm$1;

                    public final double apply(double x) {
                        return this.apply$mcDD$sp(x);
                    }

                    public double apply$mcDD$sp(double x) {
                        return x / this.norm$1;
                    }
                    {
                        this.norm$1 = norm$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                Predef$.MODULE$.refArrayOps((Object[])v1).foreach((Function1)new Serializable(this, u1){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    private final double[] u1$1;

                    public final void apply(Tuple2<Object, Object> x0$3) {
                        Tuple2<Object, Object> tuple2 = x0$3;
                        if (tuple2 != null) {
                            long i = tuple2._1$mcJ$sp();
                            double x = tuple2._2$mcD$sp();
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(this.u1$1[(int)i]).absTol(1.0E-14)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(x).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(u1.apply(i.toInt)).absTol(1.0E-14))");
                            this.$outer.org$apache$spark$mllib$clustering$PowerIterationClusteringSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.u1$1 = u1$1;
                    }
                });
            }

            public /* synthetic */ PowerIterationClusteringSuite org$apache$spark$mllib$clustering$PowerIterationClusteringSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("model save/load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PowerIterationClusteringSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                String path = tempDir.toURI().toString();
                PowerIterationClusteringModel model = PowerIterationClusteringSuite$.MODULE$.createModel(this.$outer.sc(), 3, 10);
                try {
                    model.save(this.$outer.sc(), path);
                    PowerIterationClusteringModel sameModel = PowerIterationClusteringModel$.MODULE$.load(this.$outer.sc(), path);
                    PowerIterationClusteringSuite$.MODULE$.checkEqual(model, sameModel);
                    return;
                }
                finally {
                    Utils$.MODULE$.deleteRecursively(tempDir);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

