/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.generic.UFunc;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Vector$;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.clustering.StreamingKMeans;
import org.apache.spark.mllib.clustering.StreamingKMeansModel;
import org.apache.spark.mllib.clustering.StreamingKMeansSuite$;
import org.apache.spark.mllib.clustering.StreamingKMeansSuite$$anonfun$8$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.TestServer;
import org.apache.spark.streaming.TestSuiteBase;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.util.random.XORShiftRandom;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.concurrent.PatienceConfiguration;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001M4A!\u0001\u0002\u0001\u001b\t!2\u000b\u001e:fC6LgnZ&NK\u0006t7oU;ji\u0016T!a\u0001\u0003\u0002\u0015\rdWo\u001d;fe&twM\u0003\u0002\u0006\r\u0005)Q\u000e\u001c7jE*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001q!\u0003\u0005\u0002\u0010!5\ta!\u0003\u0002\u0012\r\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0004\u0002\u0013M$(/Z1nS:<\u0017BA\f\u0015\u00055!Vm\u001d;Tk&$XMQ1tK\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011A\u0001\u0005\u0006=\u0001!\teH\u0001\u0012[\u0006Dx+Y5u)&lW-T5mY&\u001cX#\u0001\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\u0007%sG\u000fC\u0005(\u0001\u0001\u0007\t\u0019!C\u0001Q\u0005\u00191o]2\u0016\u0003%\u0002\"a\u0005\u0016\n\u0005-\"\"\u0001E*ue\u0016\fW.\u001b8h\u0007>tG/\u001a=u\u0011%i\u0003\u00011AA\u0002\u0013\u0005a&A\u0004tg\u000e|F%Z9\u0015\u0005=\u0012\u0004CA\u00111\u0013\t\t$E\u0001\u0003V]&$\bbB\u001a-\u0003\u0003\u0005\r!K\u0001\u0004q\u0012\n\u0004BB\u001b\u0001A\u0003&\u0011&\u0001\u0003tg\u000e\u0004\u0003\"B\u001c\u0001\t\u0003B\u0014!D1gi\u0016\u0014h)\u001e8di&|g\u000eF\u00010\u0011\u0015Q\u0004\u0001\"\u0001<\u0003q\u0019FO]3b[&twmS'fC:\u001cH)\u0019;b\u000f\u0016tWM]1u_J$\u0002\u0002P+X3nk&\r\u001a\t\u0005Cuz$+\u0003\u0002?E\t1A+\u001e9mKJ\u00022\u0001\u0011%L\u001d\t\teI\u0004\u0002C\u000b6\t1I\u0003\u0002E\u0019\u00051AH]8pizJ\u0011aI\u0005\u0003\u000f\n\nq\u0001]1dW\u0006<W-\u0003\u0002J\u0015\nQ\u0011J\u001c3fq\u0016$7+Z9\u000b\u0005\u001d\u0013\u0003c\u0001!I\u0019B\u0011Q\nU\u0007\u0002\u001d*\u0011q\nB\u0001\u0007Y&t\u0017\r\\4\n\u0005Es%A\u0002,fGR|'\u000fE\u0002\"'2K!\u0001\u0016\u0012\u0003\u000b\u0005\u0013(/Y=\t\u000bYK\u0004\u0019\u0001\u0011\u0002\u00139,X\u000eU8j]R\u001c\b\"\u0002-:\u0001\u0004\u0001\u0013A\u00038v[\n\u000bGo\u00195fg\")!,\u000fa\u0001A\u0005\t1\u000eC\u0003]s\u0001\u0007\u0001%A\u0001e\u0011\u0015q\u0016\b1\u0001`\u0003\u0005\u0011\bCA\u0011a\u0013\t\t'E\u0001\u0004E_V\u0014G.\u001a\u0005\u0006Gf\u0002\r\u0001I\u0001\u0005g\u0016,G\rC\u0004fsA\u0005\t\u0019\u0001*\u0002\u0017%t\u0017\u000e^\"f]R,'o\u001d\u0005\bO\u0002\t\n\u0011\"\u0001i\u0003\u0019\u001aFO]3b[&twmS'fC:\u001cH)\u0019;b\u000f\u0016tWM]1u_J$C-\u001a4bk2$HeN\u000b\u0002S*\u0012!K[\u0016\u0002WB\u0011A.]\u0007\u0002[*\u0011an\\\u0001\nk:\u001c\u0007.Z2lK\u0012T!\u0001\u001d\u0012\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002s[\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class StreamingKMeansSuite
extends SparkFunSuite
implements TestSuiteBase {
    private StreamingContext ssc;
    private final String checkpointDir;
    private final SparkConf conf;
    private final PatienceConfiguration.Timeout eventuallyTimeout;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    private volatile boolean bitmap$0;

    private String checkpointDir$lzycompute() {
        StreamingKMeansSuite streamingKMeansSuite = this;
        synchronized (streamingKMeansSuite) {
            if (!this.bitmap$0) {
                this.checkpointDir = TestSuiteBase.class.checkpointDir((TestSuiteBase)this);
                this.bitmap$0 = true;
            }
            return this.checkpointDir;
        }
    }

    public String checkpointDir() {
        return this.bitmap$0 ? this.checkpointDir : this.checkpointDir$lzycompute();
    }

    public SparkConf conf() {
        return this.conf;
    }

    public PatienceConfiguration.Timeout eventuallyTimeout() {
        return this.eventuallyTimeout;
    }

    public void org$apache$spark$streaming$TestSuiteBase$_setter_$conf_$eq(SparkConf x$1) {
        this.conf = x$1;
    }

    public void org$apache$spark$streaming$TestSuiteBase$_setter_$eventuallyTimeout_$eq(PatienceConfiguration.Timeout x$1) {
        this.eventuallyTimeout = x$1;
    }

    public String framework() {
        return TestSuiteBase.class.framework((TestSuiteBase)this);
    }

    public String master() {
        return TestSuiteBase.class.master((TestSuiteBase)this);
    }

    public Duration batchDuration() {
        return TestSuiteBase.class.batchDuration((TestSuiteBase)this);
    }

    public int numInputPartitions() {
        return TestSuiteBase.class.numInputPartitions((TestSuiteBase)this);
    }

    public boolean useManualClock() {
        return TestSuiteBase.class.useManualClock((TestSuiteBase)this);
    }

    public boolean actuallyWait() {
        return TestSuiteBase.class.actuallyWait((TestSuiteBase)this);
    }

    public void beforeFunction() {
        TestSuiteBase.class.beforeFunction((TestSuiteBase)this);
    }

    public <R> R withStreamingContext(StreamingContext ssc, Function1<StreamingContext, R> block) {
        return (R)TestSuiteBase.class.withStreamingContext((TestSuiteBase)this, (StreamingContext)ssc, block);
    }

    public <R> R withTestServer(TestServer testServer, Function1<TestServer, R> block) {
        return (R)TestSuiteBase.class.withTestServer((TestSuiteBase)this, (TestServer)testServer, block);
    }

    public <U, V> StreamingContext setupStreams(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, int numPartitions, ClassTag<U> evidence$4, ClassTag<V> evidence$5) {
        return TestSuiteBase.class.setupStreams((TestSuiteBase)this, input, operation, (int)numPartitions, evidence$4, evidence$5);
    }

    public <U, V, W> StreamingContext setupStreams(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, ClassTag<U> evidence$6, ClassTag<V> evidence$7, ClassTag<W> evidence$8) {
        return TestSuiteBase.class.setupStreams((TestSuiteBase)this, input1, input2, operation, evidence$6, evidence$7, evidence$8);
    }

    public <V> Seq<Seq<V>> runStreams(StreamingContext ssc, int numBatches, int numExpectedOutput, ClassTag<V> evidence$9) {
        return TestSuiteBase.class.runStreams((TestSuiteBase)this, (StreamingContext)ssc, (int)numBatches, (int)numExpectedOutput, evidence$9);
    }

    public <V> Seq<Seq<Seq<V>>> runStreamsWithPartitions(StreamingContext ssc, int numBatches, int numExpectedOutput, ClassTag<V> evidence$10) {
        return TestSuiteBase.class.runStreamsWithPartitions((TestSuiteBase)this, (StreamingContext)ssc, (int)numBatches, (int)numExpectedOutput, evidence$10);
    }

    public <V> void verifyOutput(Seq<Seq<V>> output, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<V> evidence$11) {
        TestSuiteBase.class.verifyOutput((TestSuiteBase)this, output, expectedOutput, (boolean)useSet, evidence$11);
    }

    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<U> evidence$12, ClassTag<V> evidence$13) {
        TestSuiteBase.class.testOperation((TestSuiteBase)this, input, operation, expectedOutput, (boolean)useSet, evidence$12, evidence$13);
    }

    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$14, ClassTag<V> evidence$15) {
        TestSuiteBase.class.testOperation((TestSuiteBase)this, input, operation, expectedOutput, (int)numBatches, (boolean)useSet, evidence$14, evidence$15);
    }

    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, boolean useSet, ClassTag<U> evidence$16, ClassTag<V> evidence$17, ClassTag<W> evidence$18) {
        TestSuiteBase.class.testOperation((TestSuiteBase)this, input1, input2, operation, expectedOutput, (boolean)useSet, evidence$16, evidence$17, evidence$18);
    }

    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$19, ClassTag<V> evidence$20, ClassTag<W> evidence$21) {
        TestSuiteBase.class.testOperation((TestSuiteBase)this, input1, input2, operation, expectedOutput, (int)numBatches, (boolean)useSet, evidence$19, evidence$20, evidence$21);
    }

    public <U, V> boolean testOperation$default$4() {
        return TestSuiteBase.class.testOperation$default$4((TestSuiteBase)this);
    }

    public <U, V> int setupStreams$default$3() {
        return TestSuiteBase.class.setupStreams$default$3((TestSuiteBase)this);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public int maxWaitTimeMillis() {
        return 30000;
    }

    public StreamingContext ssc() {
        return this.ssc;
    }

    public void ssc_$eq(StreamingContext x$1) {
        this.ssc = x$1;
    }

    public void afterFunction() {
        TestSuiteBase.class.afterFunction((TestSuiteBase)this);
        if (this.ssc() != null) {
            StreamingContext qual$1 = this.ssc();
            boolean x$6 = qual$1.stop$default$1();
            qual$1.stop(x$6);
        }
    }

    public Tuple2<IndexedSeq<IndexedSeq<Vector>>, Vector[]> StreamingKMeansDataGenerator(int numPoints, int numBatches, int k, int d, double r, int seed, Vector[] initCenters) {
        XORShiftRandom rand = new XORShiftRandom((long)seed);
        Vector[] vectorArray = initCenters;
        Vector[] vectorArray2 = vectorArray == null ? (Vector[])Array$.MODULE$.fill(k, (Function0)new Serializable(this, d, rand){
            public static final long serialVersionUID = 0L;
            private final int d$1;
            public final XORShiftRandom rand$1;

            public final Vector apply() {
                return Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(this.d$1, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return this.$outer.rand$1.nextGaussian();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.Double()));
            }
            {
                this.d$1 = d$1;
                this.rand$1 = rand$1;
            }
        }, ClassTag$.MODULE$.apply(Vector.class)) : initCenters;
        Vector[] centers = vectorArray2;
        scala.collection.immutable.IndexedSeq data = (scala.collection.immutable.IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numBatches).map((Function1)new Serializable(this, numPoints, k, d, r, rand, centers){
            public static final long serialVersionUID = 0L;
            private final int numPoints$1;
            public final int k$1;
            public final int d$1;
            public final double r$1;
            public final XORShiftRandom rand$1;
            public final Vector[] centers$1;

            public final scala.collection.immutable.IndexedSeq<Vector> apply(int i) {
                return (scala.collection.immutable.IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPoints$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final Vector apply(int idx) {
                        Vector center = this.$outer.centers$1[idx % this.$outer.k$1];
                        return Vectors$.MODULE$.dense((double[])Array$.MODULE$.tabulate(this.$outer.d$1, (Function1)new Serializable(this, center){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$8$$anonfun$apply$3 $outer;
                            private final Vector center$1;

                            public final double apply(int x) {
                                return this.apply$mcDI$sp(x);
                            }

                            public double apply$mcDI$sp(int x) {
                                return this.center$1.apply(x) + this.$outer.org$apache$spark$mllib$clustering$StreamingKMeansSuite$$anonfun$$anonfun$$$outer().rand$1.nextGaussian() * this.$outer.org$apache$spark$mllib$clustering$StreamingKMeansSuite$$anonfun$$anonfun$$$outer().r$1;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.center$1 = center$1;
                            }
                        }, ClassTag$.MODULE$.Double()));
                    }

                    public /* synthetic */ $anonfun$8 org$apache$spark$mllib$clustering$StreamingKMeansSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.numPoints$1 = numPoints$1;
                this.k$1 = k$1;
                this.d$1 = d$1;
                this.r$1 = r$1;
                this.rand$1 = rand$1;
                this.centers$1 = centers$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return new Tuple2((Object)data, (Object)centers);
    }

    public Vector[] StreamingKMeansDataGenerator$default$7() {
        return null;
    }

    public StreamingKMeansSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        TestSuiteBase.class.$init$((TestSuiteBase)this);
        this.test("accuracy for single center and equivalence to grand average", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingKMeansSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int numBatches = 10;
                int numPoints = 50;
                int k = 1;
                int d = 5;
                double r = 0.1;
                StreamingKMeans model = new StreamingKMeans().setK(1).setDecayFactor(1.0).setInitialCenters((Vector[])((Object[])new Vector[]{Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 0.0, 0.0}))}), new double[]{0.0});
                Tuple2<IndexedSeq<IndexedSeq<Vector>>, Vector[]> tuple2 = this.$outer.StreamingKMeansDataGenerator(numPoints, numBatches, k, d, r, 42, this.$outer.StreamingKMeansDataGenerator$default$7());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    IndexedSeq input = (IndexedSeq)tuple2._1();
                    Vector[] centers = (Vector[])tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)input, (Object)centers);
                    IndexedSeq input2 = (IndexedSeq)tuple23._1();
                    Vector[] centers2 = (Vector[])tuple23._2();
                    this.$outer.ssc_$eq(this.$outer.setupStreams(input2, new Serializable(this, model){
                        public static final long serialVersionUID = 0L;
                        private final StreamingKMeans model$1;

                        public final DStream<Object> apply(DStream<Vector> inputDStream) {
                            this.model$1.trainOn(inputDStream);
                            return inputDStream.count();
                        }
                        {
                            this.model$1 = model$1;
                        }
                    }, this.$outer.setupStreams$default$3(), ClassTag$.MODULE$.apply(Vector.class), ClassTag$.MODULE$.Long()));
                    this.$outer.runStreams(this.$outer.ssc(), numBatches, numBatches, ClassTag$.MODULE$.Nothing());
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(centers2[0]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(model.latestModel().clusterCenters()[0]).absTol(0.1)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(centers.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model.latestModel().clusterCenters.apply(0)).absTol(0.1))");
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    breeze.linalg.Vector grandMean = (breeze.linalg.Vector)((ImmutableNumericOps)((TraversableOnce)((TraversableLike)input2.flatten((Function1)Predef$.MODULE$.conforms())).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final breeze.linalg.Vector<Object> apply(Vector x) {
                            return x.toBreeze();
                        }
                    }, scala.collection.IndexedSeq$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final breeze.linalg.Vector<Object> apply(breeze.linalg.Vector<Object> x$2, breeze.linalg.Vector<Object> x$3) {
                            return (breeze.linalg.Vector)x$2.$plus(x$3, (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpAdd());
                        }
                    })).$div((Object)BoxesRunTime.boxToDouble((double)(numBatches * numPoints)), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpDiv());
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(model.latestModel().clusterCenters()[0]).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(Vectors$.MODULE$.dense(grandMean.toArray$mcD$sp(ClassTag$.MODULE$.Double()))).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(model.latestModel().clusterCenters.apply(0)).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(org.apache.spark.mllib.linalg.Vectors.dense(grandMean.toArray(ClassTag.Double))).absTol(1.0E-5))");
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("accuracy for two centers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingKMeansSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int numBatches = 10;
                int numPoints = 5;
                int k = 2;
                int d = 5;
                double r = 0.1;
                StreamingKMeans kMeans = new StreamingKMeans().setK(2).setHalfLife(2.0, "batches").setInitialCenters((Vector[])((Object[])new Vector[]{Vectors$.MODULE$.dense(-0.1, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.1, -0.2, -0.3, -0.1})), Vectors$.MODULE$.dense(0.1, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{-0.2, 0.0, 0.2, 0.1}))}), new double[]{5.0, 5.0});
                Tuple2<IndexedSeq<IndexedSeq<Vector>>, Vector[]> tuple2 = this.$outer.StreamingKMeansDataGenerator(numPoints, numBatches, k, d, r, 42, this.$outer.StreamingKMeansDataGenerator$default$7());
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    Tuple2 tuple23;
                    IndexedSeq input = (IndexedSeq)tuple2._1();
                    Vector[] centers = (Vector[])tuple2._2();
                    Tuple2 tuple24 = tuple23 = new Tuple2((Object)input, (Object)centers);
                    IndexedSeq input2 = (IndexedSeq)tuple24._1();
                    Vector[] centers2 = (Vector[])tuple24._2();
                    this.$outer.ssc_$eq(this.$outer.setupStreams(input2, new Serializable(this, kMeans){
                        public static final long serialVersionUID = 0L;
                        private final StreamingKMeans kMeans$1;

                        public final DStream<Object> apply(DStream<Vector> inputDStream) {
                            this.kMeans$1.trainOn(inputDStream);
                            return inputDStream.count();
                        }
                        {
                            this.kMeans$1 = kMeans$1;
                        }
                    }, this.$outer.setupStreams$default$3(), ClassTag$.MODULE$.apply(Vector.class), ClassTag$.MODULE$.Long()));
                    this.$outer.runStreams(this.$outer.ssc(), numBatches, numBatches, ClassTag$.MODULE$.Nothing());
                    double d0 = Vectors$.MODULE$.sqdist(kMeans.latestModel().clusterCenters()[0], centers2[0]);
                    double d1 = Vectors$.MODULE$.sqdist(kMeans.latestModel().clusterCenters()[0], centers2[1]);
                    Tuple2 tuple25 = tuple22 = d0 < d1 ? new Tuple2((Object)centers2[0], (Object)centers2[1]) : new Tuple2((Object)centers2[1], (Object)centers2[0]);
                    if (tuple22 != null) {
                        Tuple2 tuple26;
                        Vector c0 = (Vector)tuple22._1();
                        Vector c1 = (Vector)tuple22._2();
                        Tuple2 tuple27 = tuple26 = new Tuple2((Object)c0, (Object)c1);
                        Vector c02 = (Vector)tuple27._1();
                        Vector c12 = (Vector)tuple27._2();
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(c02).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(kMeans.latestModel().clusterCenters()[0]).absTol(0.1)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(c0).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(kMeans.latestModel().clusterCenters.apply(0)).absTol(0.1))");
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.VectorWithAlmostEquals(c12).$tilde$eq$eq(TestingUtils$.MODULE$.VectorWithAlmostEquals(kMeans.latestModel().clusterCenters()[1]).absTol(0.1)), "org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(c1).~==(org.apache.spark.mllib.util.TestingUtils.VectorWithAlmostEquals(kMeans.latestModel().clusterCenters.apply(1)).absTol(0.1))");
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        return;
                    }
                    throw new MatchError((Object)tuple22);
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("detecting dying clusters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingKMeansSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int numBatches = 10;
                int numPoints = 5;
                int k = 1;
                int d = 1;
                double r = 1.0;
                StreamingKMeans kMeans = new StreamingKMeans().setK(2).setHalfLife(0.5, "points").setInitialCenters((Vector[])((Object[])new Vector[]{Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), Vectors$.MODULE$.dense(1000.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))}), new double[]{1.0, 1.0});
                Tuple2<IndexedSeq<IndexedSeq<Vector>>, Vector[]> tuple2 = this.$outer.StreamingKMeansDataGenerator(numPoints, numBatches, k, d, r, 42, (Vector[])((Object[])new Vector[]{Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))}));
                if (tuple2 != null) {
                    IndexedSeq input;
                    IndexedSeq indexedSeq;
                    IndexedSeq input2 = indexedSeq = (input = (IndexedSeq)tuple2._1());
                    this.$outer.ssc_$eq(this.$outer.setupStreams(input2, new Serializable(this, kMeans){
                        public static final long serialVersionUID = 0L;
                        private final StreamingKMeans kMeans$2;

                        public final DStream<Object> apply(DStream<Vector> inputDStream) {
                            this.kMeans$2.trainOn(inputDStream);
                            return inputDStream.count();
                        }
                        {
                            this.kMeans$2 = kMeans$2;
                        }
                    }, this.$outer.setupStreams$default$3(), ClassTag$.MODULE$.apply(Vector.class), ClassTag$.MODULE$.Long()));
                    this.$outer.runStreams(this.$outer.ssc(), numBatches, numBatches, ClassTag$.MODULE$.Nothing());
                    StreamingKMeansModel model = kMeans.latestModel();
                    double c0 = model.clusterCenters()[0].apply(0);
                    double c1 = model.clusterCenters()[1].apply(0);
                    double $org_scalatest_assert_macro_left = c0 * c1;
                    double $org_scalatest_assert_macro_right = 0.0;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"should have one positive center and one negative center");
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(package$.MODULE$.abs(c0)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.8).absTol(0.6)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.math.`package`.abs(c0)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.8).absTol(0.6))");
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(package$.MODULE$.abs(c1)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.8).absTol(0.6)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(scala.math.`package`.abs(c1)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.8).absTol(0.6))");
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SPARK-7946 setDecayFactor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingKMeansSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                StreamingKMeans kMeans = new StreamingKMeans();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)kMeans.decayFactor()));
                double $org_scalatest_assert_macro_right = 1.0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                kMeans.setDecayFactor(2.0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)kMeans.decayFactor()));
                double $org_scalatest_assert_macro_right2 = 2.0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

