/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.evaluation;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.evaluation.AreaUnderCurve$;
import org.apache.spark.mllib.evaluation.BinaryClassificationMetrics;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SQLContext;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00154A!\u0001\u0002\u0001\u001b\t\u0001#)\u001b8bef\u001cE.Y:tS\u001aL7-\u0019;j_:lU\r\u001e:jGN\u001cV/\u001b;f\u0015\t\u0019A!\u0001\u0006fm\u0006dW/\u0019;j_:T!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dI\u0001\"a\u0004\t\u000e\u0003\u0019I!!\u0005\u0004\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t\u0019b#D\u0001\u0015\u0015\t)B!\u0001\u0003vi&d\u0017BA\f\u0015\u0005UiE\n\\5c)\u0016\u001cHo\u00159be.\u001cuN\u001c;fqRDQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtD#A\u000e\u0011\u0005q\u0001Q\"\u0001\u0002\t\u000by\u0001A\u0011B\u0010\u0002!\u0005\u0014XmV5uQ&tW\t]:jY>tGC\u0001\u0011'!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\u001d\u0011un\u001c7fC:DQaJ\u000fA\u0002!\n\u0011\u0001\u001f\t\u0005C%Z3&\u0003\u0002+E\t1A+\u001e9mKJ\u0002\"!\t\u0017\n\u00055\u0012#A\u0002#pk\ndW\rC\u00030\u0001\u0011%\u0001'\u0001\nqC&\u00148oV5uQ&tW\t]:jY>tGC\u0001\u00112\u0011\u00159c\u00061\u00013!\u0011\t\u0013\u0006\u000b\u0015\t\u000bQ\u0002A\u0011B\u001b\u0002)\u0005\u001c8/\u001a:u'\u0016\fX/\u001a8dKNl\u0015\r^2i)\r1\u0014h\u0012\t\u0003C]J!\u0001\u000f\u0012\u0003\tUs\u0017\u000e\u001e\u0005\u0006uM\u0002\raO\u0001\u0005Y\u00164G\u000fE\u0002=\t.r!!\u0010\"\u000f\u0005y\nU\"A \u000b\u0005\u0001c\u0011A\u0002\u001fs_>$h(C\u0001$\u0013\t\u0019%%A\u0004qC\u000e\\\u0017mZ3\n\u0005\u00153%aA*fc*\u00111I\t\u0005\u0006\u0011N\u0002\raO\u0001\u0006e&<\u0007\u000e\u001e\u0005\u0006\u0015\u0002!IaS\u0001\u001aCN\u001cXM\u001d;UkBdWmU3rk\u0016t7-Z:NCR\u001c\u0007\u000eF\u00027\u0019:CQAO%A\u00025\u00032\u0001\u0010#)\u0011\u0015A\u0015\n1\u0001N\u0011\u0015\u0001\u0006\u0001\"\u0003R\u0003=1\u0018\r\\5eCR,W*\u001a;sS\u000e\u001cH#\u0003\u001cS/f[VlX1d\u0011\u0015\u0019v\n1\u0001U\u0003\u001diW\r\u001e:jGN\u0004\"\u0001H+\n\u0005Y\u0013!a\u0007\"j]\u0006\u0014\u0018p\u00117bgNLg-[2bi&|g.T3ue&\u001c7\u000fC\u0003Y\u001f\u0002\u00071(\u0001\nfqB,7\r^3e)\"\u0014Xm\u001d5pY\u0012\u001c\b\"\u0002.P\u0001\u0004i\u0015\u0001E3ya\u0016\u001cG/\u001a3S\u001f\u000e\u001bUO\u001d<f\u0011\u0015av\n1\u0001N\u0003=)\u0007\u0010]3di\u0016$\u0007KU\"veZ,\u0007\"\u00020P\u0001\u0004Y\u0014AE3ya\u0016\u001cG/\u001a3G\u001b\u0016\f7/\u001e:fgFBQ\u0001Y(A\u0002m\n!#\u001a=qK\u000e$X\r\u001a$nK\u0006\u001cXO]3te!)!m\u0014a\u0001w\u0005\u0011R\r\u001f9fGR,G\r\u0015:fG&\u001c\u0018n\u001c8t\u0011\u0015!w\n1\u0001<\u0003=)\u0007\u0010]3di\u0016$'+Z2bY2\u001c\b")
public class BinaryClassificationMetricsSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public boolean org$apache$spark$mllib$evaluation$BinaryClassificationMetricsSuite$$areWithinEpsilon(Tuple2<Object, Object> x) {
        return TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._1$mcD$sp()).$tilde$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(x._2$mcD$sp()).absTol(1.0E-5));
    }

    public boolean org$apache$spark$mllib$evaluation$BinaryClassificationMetricsSuite$$pairsWithinEpsilon(Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>> x) {
        return TestingUtils$.MODULE$.DoubleWithAlmostEquals(((Tuple2)x._1())._1$mcD$sp()).$tilde$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(((Tuple2)x._2())._1$mcD$sp()).absTol(1.0E-5)) && TestingUtils$.MODULE$.DoubleWithAlmostEquals(((Tuple2)x._1())._2$mcD$sp()).$tilde$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(((Tuple2)x._2())._2$mcD$sp()).absTol(1.0E-5));
    }

    private void assertSequencesMatch(Seq<Object> left, Seq<Object> right) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((IterableLike)left.zip(right, Seq$.MODULE$.canBuildFrom())).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BinaryClassificationMetricsSuite $outer;

            public final boolean apply(Tuple2<Object, Object> x) {
                return this.$outer.org$apache$spark$mllib$evaluation$BinaryClassificationMetricsSuite$$areWithinEpsilon(x);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }), "left.zip[Double, Double, Seq[(Double, Double)]](right)(collection.this.Seq.canBuildFrom[(Double, Double)]).forall({\n  ((x: (Double, Double)) => BinaryClassificationMetricsSuite.this.areWithinEpsilon(x))\n})");
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
    }

    private void assertTupleSequencesMatch(Seq<Tuple2<Object, Object>> left, Seq<Tuple2<Object, Object>> right) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((IterableLike)left.zip(right, Seq$.MODULE$.canBuildFrom())).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BinaryClassificationMetricsSuite $outer;

            public final boolean apply(Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>> x) {
                return this.$outer.org$apache$spark$mllib$evaluation$BinaryClassificationMetricsSuite$$pairsWithinEpsilon(x);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }), "left.zip[(Double, Double), (Double, Double), Seq[((Double, Double), (Double, Double))]](right)(collection.this.Seq.canBuildFrom[((Double, Double), (Double, Double))]).forall({\n  ((x: ((Double, Double), (Double, Double))) => BinaryClassificationMetricsSuite.this.pairsWithinEpsilon(x))\n})");
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
    }

    public void org$apache$spark$mllib$evaluation$BinaryClassificationMetricsSuite$$validateMetrics(BinaryClassificationMetrics metrics, Seq<Object> expectedThresholds, Seq<Tuple2<Object, Object>> expectedROCCurve, Seq<Tuple2<Object, Object>> expectedPRCurve, Seq<Object> expectedFMeasures1, Seq<Object> expectedFmeasures2, Seq<Object> expectedPrecisions, Seq<Object> expectedRecalls) {
        this.assertSequencesMatch((Seq<Object>)Predef$.MODULE$.wrapDoubleArray((double[])metrics.thresholds().collect()), expectedThresholds);
        this.assertTupleSequencesMatch((Seq<Tuple2<Object, Object>>)Predef$.MODULE$.wrapRefArray((Object[])metrics.roc().collect()), expectedROCCurve);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.areaUnderROC()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(AreaUnderCurve$.MODULE$.of(expectedROCCurve)).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.areaUnderROC()).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(AreaUnderCurve.of(expectedROCCurve)).absTol(1.0E-5))");
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
        this.assertTupleSequencesMatch((Seq<Tuple2<Object, Object>>)Predef$.MODULE$.wrapRefArray((Object[])metrics.pr().collect()), expectedPRCurve);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.areaUnderPR()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(AreaUnderCurve$.MODULE$.of(expectedPRCurve)).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.areaUnderPR()).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(AreaUnderCurve.of(expectedPRCurve)).absTol(1.0E-5))");
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
        this.assertTupleSequencesMatch((Seq<Tuple2<Object, Object>>)Predef$.MODULE$.wrapRefArray((Object[])metrics.fMeasureByThreshold().collect()), (Seq<Tuple2<Object, Object>>)((Seq)expectedThresholds.zip(expectedFMeasures1, Seq$.MODULE$.canBuildFrom())));
        this.assertTupleSequencesMatch((Seq<Tuple2<Object, Object>>)Predef$.MODULE$.wrapRefArray((Object[])metrics.fMeasureByThreshold(2.0).collect()), (Seq<Tuple2<Object, Object>>)((Seq)expectedThresholds.zip(expectedFmeasures2, Seq$.MODULE$.canBuildFrom())));
        this.assertTupleSequencesMatch((Seq<Tuple2<Object, Object>>)Predef$.MODULE$.wrapRefArray((Object[])metrics.precisionByThreshold().collect()), (Seq<Tuple2<Object, Object>>)((Seq)expectedThresholds.zip(expectedPrecisions, Seq$.MODULE$.canBuildFrom())));
        this.assertTupleSequencesMatch((Seq<Tuple2<Object, Object>>)Predef$.MODULE$.wrapRefArray((Object[])metrics.recallByThreshold().collect()), (Seq<Tuple2<Object, Object>>)((Seq)expectedThresholds.zip(expectedRecalls, Seq$.MODULE$.canBuildFrom())));
    }

    public BinaryClassificationMetricsSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("binary evaluation metrics", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BinaryClassificationMetricsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD scoreAndLabels = this.$outer.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.1, 0.0), new Tuple2.mcDD.sp(0.1, 1.0), new Tuple2.mcDD.sp(0.4, 0.0), new Tuple2.mcDD.sp(0.6, 0.0), new Tuple2.mcDD.sp(0.6, 1.0), new Tuple2.mcDD.sp(0.6, 1.0), new Tuple2.mcDD.sp(0.8, 1.0)})), 2, ClassTag$.MODULE$.apply(Tuple2.class));
                BinaryClassificationMetrics metrics = new BinaryClassificationMetrics(scoreAndLabels);
                Seq thresholds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.8, 0.6, 0.4, 0.1}));
                Seq numTruePositives = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 3, 4}));
                Seq numFalsePositives = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
                int numPositives = 4;
                int numNegatives = 3;
                Seq precisions = (Seq)((TraversableLike)numTruePositives.zip((GenIterable)numFalsePositives, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Tuple2<Object, Object> x0$1) {
                        Tuple2<Object, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            int t = tuple2._1$mcI$sp();
                            int f = tuple2._2$mcI$sp();
                            double d = (double)t / (double)(t + f);
                            return d;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq recalls = (Seq)numTruePositives.map((Function1)new Serializable(this, numPositives){
                    public static final long serialVersionUID = 0L;
                    private final int numPositives$1;

                    public final double apply(int t) {
                        return this.apply$mcDI$sp(t);
                    }

                    public double apply$mcDI$sp(int t) {
                        return (double)t / (double)this.numPositives$1;
                    }
                    {
                        this.numPositives$1 = numPositives$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq fpr = (Seq)numFalsePositives.map((Function1)new Serializable(this, numNegatives){
                    public static final long serialVersionUID = 0L;
                    private final int numNegatives$1;

                    public final double apply(int f) {
                        return this.apply$mcDI$sp(f);
                    }

                    public double apply$mcDI$sp(int f) {
                        return (double)f / (double)this.numNegatives$1;
                    }
                    {
                        this.numNegatives$1 = numNegatives$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq rocCurve = (Seq)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.0, 0.0)}))).$plus$plus((GenTraversableOnce)fpr.zip((GenIterable)recalls, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(1.0, 1.0)})), Seq$.MODULE$.canBuildFrom());
                Seq pr = (Seq)recalls.zip((GenIterable)precisions, Seq$.MODULE$.canBuildFrom());
                Seq prCurve = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.0, 1.0)}))).$plus$plus((GenTraversableOnce)pr, Seq$.MODULE$.canBuildFrom());
                Seq f1 = (Seq)pr.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Tuple2<Object, Object> x0$2) {
                        Tuple2<Object, Object> tuple2 = x0$2;
                        if (tuple2 != null) {
                            double r = tuple2._1$mcD$sp();
                            double p = tuple2._2$mcD$sp();
                            double d = 2.0 * (p * r) / (p + r);
                            return d;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq f2 = (Seq)pr.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Tuple2<Object, Object> x0$3) {
                        Tuple2<Object, Object> tuple2 = x0$3;
                        if (tuple2 != null) {
                            double r = tuple2._1$mcD$sp();
                            double p = tuple2._2$mcD$sp();
                            double d = 5.0 * (p * r) / (4.0 * p + r);
                            return d;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                this.$outer.org$apache$spark$mllib$evaluation$BinaryClassificationMetricsSuite$$validateMetrics(metrics, (Seq<Object>)thresholds, (Seq<Tuple2<Object, Object>>)rocCurve, (Seq<Tuple2<Object, Object>>)prCurve, (Seq<Object>)f1, (Seq<Object>)f2, (Seq<Object>)precisions, (Seq<Object>)recalls);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("binary evaluation metrics for RDD where all examples have positive label", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BinaryClassificationMetricsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD scoreAndLabels = this.$outer.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.5, 1.0), new Tuple2.mcDD.sp(0.5, 1.0)})), 2, ClassTag$.MODULE$.apply(Tuple2.class));
                BinaryClassificationMetrics metrics = new BinaryClassificationMetrics(scoreAndLabels);
                Seq thresholds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5}));
                Seq precisions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}));
                Seq recalls = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}));
                Seq fpr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}));
                Seq rocCurve = (Seq)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.0, 0.0)}))).$plus$plus((GenTraversableOnce)fpr.zip((GenIterable)recalls, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(1.0, 1.0)})), Seq$.MODULE$.canBuildFrom());
                Seq pr = (Seq)recalls.zip((GenIterable)precisions, Seq$.MODULE$.canBuildFrom());
                Seq prCurve = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.0, 1.0)}))).$plus$plus((GenTraversableOnce)pr, Seq$.MODULE$.canBuildFrom());
                Seq f1 = (Seq)pr.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Tuple2<Object, Object> x0$4) {
                        Tuple2<Object, Object> tuple2 = x0$4;
                        if (tuple2 != null) {
                            double r = tuple2._1$mcD$sp();
                            double p = tuple2._2$mcD$sp();
                            double d = 2.0 * (p * r) / (p + r);
                            return d;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq f2 = (Seq)pr.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Tuple2<Object, Object> x0$5) {
                        Tuple2<Object, Object> tuple2 = x0$5;
                        if (tuple2 != null) {
                            double r = tuple2._1$mcD$sp();
                            double p = tuple2._2$mcD$sp();
                            double d = 5.0 * (p * r) / (4.0 * p + r);
                            return d;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                this.$outer.org$apache$spark$mllib$evaluation$BinaryClassificationMetricsSuite$$validateMetrics(metrics, (Seq<Object>)thresholds, (Seq<Tuple2<Object, Object>>)rocCurve, (Seq<Tuple2<Object, Object>>)prCurve, (Seq<Object>)f1, (Seq<Object>)f2, (Seq<Object>)precisions, (Seq<Object>)recalls);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("binary evaluation metrics for RDD where all examples have negative label", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BinaryClassificationMetricsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD scoreAndLabels = this.$outer.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.5, 0.0), new Tuple2.mcDD.sp(0.5, 0.0)})), 2, ClassTag$.MODULE$.apply(Tuple2.class));
                BinaryClassificationMetrics metrics = new BinaryClassificationMetrics(scoreAndLabels);
                Seq thresholds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.5}));
                Seq precisions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}));
                Seq recalls = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}));
                Seq fpr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}));
                Seq rocCurve = (Seq)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.0, 0.0)}))).$plus$plus((GenTraversableOnce)fpr.zip((GenIterable)recalls, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(1.0, 1.0)})), Seq$.MODULE$.canBuildFrom());
                Seq pr = (Seq)recalls.zip((GenIterable)precisions, Seq$.MODULE$.canBuildFrom());
                Seq prCurve = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.0, 1.0)}))).$plus$plus((GenTraversableOnce)pr, Seq$.MODULE$.canBuildFrom());
                Seq f1 = (Seq)pr.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Tuple2<Object, Object> x0$6) {
                        Tuple2<Object, Object> tuple2;
                        block4: {
                            double d;
                            block3: {
                                block2: {
                                    tuple2 = x0$6;
                                    if (tuple2 == null) break block2;
                                    double d2 = tuple2._1$mcD$sp();
                                    double d3 = tuple2._2$mcD$sp();
                                    if (0.0 != d2 || 0.0 != d3) break block2;
                                    d = 0.0;
                                    break block3;
                                }
                                if (tuple2 == null) break block4;
                                double r = tuple2._1$mcD$sp();
                                double p = tuple2._2$mcD$sp();
                                d = 2.0 * (p * r) / (p + r);
                            }
                            return d;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq f2 = (Seq)pr.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Tuple2<Object, Object> x0$7) {
                        Tuple2<Object, Object> tuple2;
                        block4: {
                            double d;
                            block3: {
                                block2: {
                                    tuple2 = x0$7;
                                    if (tuple2 == null) break block2;
                                    double d2 = tuple2._1$mcD$sp();
                                    double d3 = tuple2._2$mcD$sp();
                                    if (0.0 != d2 || 0.0 != d3) break block2;
                                    d = 0.0;
                                    break block3;
                                }
                                if (tuple2 == null) break block4;
                                double r = tuple2._1$mcD$sp();
                                double p = tuple2._2$mcD$sp();
                                d = 5.0 * (p * r) / (4.0 * p + r);
                            }
                            return d;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                this.$outer.org$apache$spark$mllib$evaluation$BinaryClassificationMetricsSuite$$validateMetrics(metrics, (Seq<Object>)thresholds, (Seq<Tuple2<Object, Object>>)rocCurve, (Seq<Tuple2<Object, Object>>)prCurve, (Seq<Object>)f1, (Seq<Object>)f2, (Seq<Object>)precisions, (Seq<Object>)recalls);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("binary evaluation metrics with downsampling", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BinaryClassificationMetricsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq scoreAndLabels = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.1, 0.0), new Tuple2.mcDD.sp(0.2, 0.0), new Tuple2.mcDD.sp(0.3, 1.0), new Tuple2.mcDD.sp(0.4, 0.0), new Tuple2.mcDD.sp(0.5, 0.0), new Tuple2.mcDD.sp(0.6, 1.0), new Tuple2.mcDD.sp(0.7, 1.0), new Tuple2.mcDD.sp(0.8, 0.0), new Tuple2.mcDD.sp(0.9, 1.0)}));
                RDD scoreAndLabelsRDD = this.$outer.sc().parallelize(scoreAndLabels, 1, ClassTag$.MODULE$.apply(Tuple2.class));
                BinaryClassificationMetrics original = new BinaryClassificationMetrics(scoreAndLabelsRDD);
                List originalROC = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])original.roc().collect()).sorted(Ordering$.MODULE$.Tuple2((Ordering)Ordering.Double$.MODULE$, (Ordering)Ordering.Double$.MODULE$))).toList();
                int $org_scalatest_assert_macro_left = 2 + scoreAndLabels.size();
                int $org_scalatest_assert_macro_right = originalROC.size();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                List $org_scalatest_assert_macro_left2 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.0, 0.0), new Tuple2.mcDD.sp(0.0, 0.25), new Tuple2.mcDD.sp(0.2, 0.25), new Tuple2.mcDD.sp(0.2, 0.5), new Tuple2.mcDD.sp(0.2, 0.75), new Tuple2.mcDD.sp(0.4, 0.75), new Tuple2.mcDD.sp(0.6, 0.75), new Tuple2.mcDD.sp(0.6, 1.0), new Tuple2.mcDD.sp(0.8, 1.0), new Tuple2.mcDD.sp(1.0, 1.0), new Tuple2.mcDD.sp(1.0, 1.0)}));
                List $org_scalatest_assert_macro_right2 = originalROC;
                List list = $org_scalatest_assert_macro_left2;
                List list2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(list != null ? !list.equals(list2) : list2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                int numBins = 4;
                BinaryClassificationMetrics downsampled = new BinaryClassificationMetrics(scoreAndLabelsRDD, numBins);
                List downsampledROC = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])downsampled.roc().collect()).sorted(Ordering$.MODULE$.Tuple2((Ordering)Ordering.Double$.MODULE$, (Ordering)Ordering.Double$.MODULE$))).toList();
                int $org_scalatest_assert_macro_left3 = 2 + (numBins + (scoreAndLabels.size() % numBins == 0 ? 0 : 1));
                int $org_scalatest_assert_macro_right3 = downsampledROC.size();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                List $org_scalatest_assert_macro_left4 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(0.0, 0.0), new Tuple2.mcDD.sp(0.2, 0.25), new Tuple2.mcDD.sp(0.2, 0.75), new Tuple2.mcDD.sp(0.6, 0.75), new Tuple2.mcDD.sp(0.8, 1.0), new Tuple2.mcDD.sp(1.0, 1.0), new Tuple2.mcDD.sp(1.0, 1.0)}));
                List $org_scalatest_assert_macro_right4 = downsampledROC;
                List list3 = $org_scalatest_assert_macro_left4;
                List list4 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(list3 != null ? !list3.equals(list4) : list4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

