/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.evaluation;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.evaluation.RegressionMetrics;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SQLContext;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001u1A!\u0001\u0002\u0001\u001b\t1\"+Z4sKN\u001c\u0018n\u001c8NKR\u0014\u0018nY:Tk&$XM\u0003\u0002\u0004\t\u0005QQM^1mk\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\n\u0011\u0005=\u0001R\"\u0001\u0004\n\u0005E1!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u0005!Q\u000f^5m\u0013\t9BCA\u000bN\u00192L'\rV3tiN\u0003\u0018M]6D_:$X\r\u001f;\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001")
public class RegressionMetricsSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public RegressionMetricsSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("regression metrics for unbiased (includes intercept term) predictor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RegressionMetricsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD predictionAndObservations = this.$outer.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(2.25, 3.0), new Tuple2.mcDD.sp(-0.25, -0.5), new Tuple2.mcDD.sp(1.75, 2.0), new Tuple2.mcDD.sp(7.75, 7.0)})), 2, ClassTag$.MODULE$.apply(Tuple2.class));
                RegressionMetrics metrics = new RegressionMetrics(predictionAndObservations);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.explainedVariance()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(8.79687).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.explainedVariance).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(8.79687).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"explained variance regression score mismatch");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.meanAbsoluteError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.5).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.meanAbsoluteError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.5).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"mean absolute error mismatch");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.meanSquaredError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.3125).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.meanSquaredError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.3125).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"mean squared error mismatch");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.rootMeanSquaredError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.55901).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.rootMeanSquaredError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.55901).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"root mean squared error mismatch");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.r2()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.95717).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.r2).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.95717).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"r2 score mismatch");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("regression metrics for biased (no intercept term) predictor", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RegressionMetricsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD predictionAndObservations = this.$outer.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(2.5, 3.0), new Tuple2.mcDD.sp(0.0, -0.5), new Tuple2.mcDD.sp(2.0, 2.0), new Tuple2.mcDD.sp(8.0, 7.0)})), 2, ClassTag$.MODULE$.apply(Tuple2.class));
                RegressionMetrics metrics = new RegressionMetrics(predictionAndObservations);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.explainedVariance()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(8.85937).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.explainedVariance).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(8.85937).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"explained variance regression score mismatch");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.meanAbsoluteError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.5).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.meanAbsoluteError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.5).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"mean absolute error mismatch");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.meanSquaredError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.375).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.meanSquaredError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.375).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"mean squared error mismatch");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.rootMeanSquaredError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.61237).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.rootMeanSquaredError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.61237).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"root mean squared error mismatch");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.r2()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.9486).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.r2).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.9486).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"r2 score mismatch");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("regression metrics with complete fitting", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RegressionMetricsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD predictionAndObservations = this.$outer.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(3.0, 3.0), new Tuple2.mcDD.sp(0.0, 0.0), new Tuple2.mcDD.sp(2.0, 2.0), new Tuple2.mcDD.sp(8.0, 8.0)})), 2, ClassTag$.MODULE$.apply(Tuple2.class));
                RegressionMetrics metrics = new RegressionMetrics(predictionAndObservations);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.explainedVariance()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(8.6875).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.explainedVariance).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(8.6875).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"explained variance regression score mismatch");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.meanAbsoluteError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.meanAbsoluteError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.0).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"mean absolute error mismatch");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.meanSquaredError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.meanSquaredError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.0).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"mean squared error mismatch");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.rootMeanSquaredError()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.rootMeanSquaredError).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(0.0).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"root mean squared error mismatch");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(metrics.r2()).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(1.0).absTol(1.0E-5)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(metrics.r2).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(1.0).absTol(1.0E-5))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"r2 score mismatch");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

