/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.feature.Word2Vec;
import org.apache.spark.mllib.feature.Word2VecModel;
import org.apache.spark.mllib.feature.Word2VecModel$;
import org.apache.spark.mllib.feature.Word2VecSuite$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001u1A!\u0001\u0002\u0001\u001b\tiqk\u001c:eeY+7mU;ji\u0016T!a\u0001\u0003\u0002\u000f\u0019,\u0017\r^;sK*\u0011QAB\u0001\u0006[2d\u0017N\u0019\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f%A\u0011q\u0002E\u0007\u0002\r%\u0011\u0011C\u0002\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U!\u0011\u0001B;uS2L!a\u0006\u000b\u0003+5cE.\u001b2UKN$8\u000b]1sW\u000e{g\u000e^3yi\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011A\u0001")
public class Word2VecSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public Word2VecSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("Word2Vec", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Word2VecSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2[] syms;
                String sentence = new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("a b ")).$times(100)).append((Object)new StringOps(Predef$.MODULE$.augmentString("a c ")).$times(10)).toString();
                Seq localDoc = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sentence, sentence}));
                SparkContext qual$1 = this.$outer.sc();
                Seq x$5 = localDoc;
                int x$6 = qual$1.parallelize$default$2();
                RDD doc = qual$1.parallelize(x$5, x$6, ClassTag$.MODULE$.apply(String.class)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<String> apply(String line) {
                        return Predef$.MODULE$.refArrayOps((Object[])line.split(" ")).toSeq();
                    }
                }, ClassTag$.MODULE$.apply(Seq.class));
                Word2VecModel model = new Word2Vec().setVectorSize(10).setSeed(42L).fit(doc);
                Tuple2[] $org_scalatest_assert_macro_left = syms = model.findSynonyms("a", 2);
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (long)$org_scalatest_assert_macro_left.length, (long)$org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                String $org_scalatest_assert_macro_left2 = (String)syms[0]._1();
                String $org_scalatest_assert_macro_right2 = "b";
                String string = $org_scalatest_assert_macro_left2;
                String string2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                String $org_scalatest_assert_macro_left3 = (String)syms[1]._1();
                String $org_scalatest_assert_macro_right3 = "c";
                String string3 = $org_scalatest_assert_macro_left3;
                String string4 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Map word2VecMap = model.getVectors();
                Word2VecModel newModel = new Word2VecModel(word2VecMap);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(newModel.getVectors().mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Object> apply(float[] x$1) {
                        return Predef$.MODULE$.floatArrayOps(x$1).toSeq();
                    }
                }));
                Map $org_scalatest_assert_macro_right4 = word2VecMap.mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Object> apply(float[] x$2) {
                        return Predef$.MODULE$.floatArrayOps(x$2).toSeq();
                    }
                });
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Word2Vec throws exception when vocabulary is empty", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Word2VecSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final Word2VecModel apply() {
                        String sentence = "a b c";
                        Seq localDoc = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sentence, sentence}));
                        SparkContext qual$2 = this.$outer.org$apache$spark$mllib$feature$Word2VecSuite$$anonfun$$$outer().sc();
                        Seq x$7 = localDoc;
                        int x$8 = qual$2.parallelize$default$2();
                        RDD doc = qual$2.parallelize(x$7, x$8, ClassTag$.MODULE$.apply(String.class)).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Seq<String> apply(String line) {
                                return Predef$.MODULE$.refArrayOps((Object[])line.split(" ")).toSeq();
                            }
                        }, ClassTag$.MODULE$.apply(Seq.class));
                        return new Word2Vec().setMinCount(10).fit(doc);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }

            public /* synthetic */ Word2VecSuite org$apache$spark$mllib$feature$Word2VecSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Word2VecModel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Word2VecSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2[] syms;
                int num = 2;
                Map word2VecMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"china", (Object)new float[]{0.5f, 0.5f, 0.5f, 0.5f}), new Tuple2((Object)"japan", (Object)new float[]{0.4f, 0.5f, 0.5f, 0.5f}), new Tuple2((Object)"taiwan", (Object)new float[]{0.6f, 0.5f, 0.5f, 0.5f}), new Tuple2((Object)"korea", (Object)new float[]{0.45f, 0.6f, 0.6f, 0.6f})}));
                Word2VecModel model = new Word2VecModel(word2VecMap);
                Tuple2[] $org_scalatest_assert_macro_left = syms = model.findSynonyms("china", num);
                int $org_scalatest_assert_macro_right = num;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (long)$org_scalatest_assert_macro_left.length, (long)$org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                String $org_scalatest_assert_macro_left2 = (String)syms[0]._1();
                String $org_scalatest_assert_macro_right2 = "taiwan";
                String string = $org_scalatest_assert_macro_left2;
                String string2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                String $org_scalatest_assert_macro_left3 = (String)syms[1]._1();
                String $org_scalatest_assert_macro_right3 = "japan";
                String string3 = $org_scalatest_assert_macro_left3;
                String string4 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("model load / save", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Word2VecSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map word2VecMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"china", (Object)new float[]{0.5f, 0.5f, 0.5f, 0.5f}), new Tuple2((Object)"japan", (Object)new float[]{0.4f, 0.5f, 0.5f, 0.5f}), new Tuple2((Object)"taiwan", (Object)new float[]{0.6f, 0.5f, 0.5f, 0.5f}), new Tuple2((Object)"korea", (Object)new float[]{0.45f, 0.6f, 0.6f, 0.6f})}));
                Word2VecModel model = new Word2VecModel(word2VecMap);
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                String path = tempDir.toURI().toString();
                try {
                    model.save(this.$outer.sc(), path);
                    Word2VecModel sameModel = Word2VecModel$.MODULE$.load(this.$outer.sc(), path);
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(sameModel.getVectors().mapValues((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Seq<Object> apply(float[] x$3) {
                            return Predef$.MODULE$.floatArrayOps(x$3).toSeq();
                        }
                    }));
                    Map $org_scalatest_assert_macro_right = model.getVectors().mapValues((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Seq<Object> apply(float[] x$4) {
                            return Predef$.MODULE$.floatArrayOps(x$4).toSeq();
                        }
                    });
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    return;
                }
                finally {
                    Utils$.MODULE$.deleteRecursively(tempDir);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

