/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.impl;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.mllib.impl.PeriodicGraphCheckpointerSuite;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class PeriodicGraphCheckpointerSuite$
implements Serializable {
    public static final PeriodicGraphCheckpointerSuite$ MODULE$;
    private final Seq<Edge<Object>> edges;

    static {
        new PeriodicGraphCheckpointerSuite$();
    }

    public Seq<Edge<Object>> edges() {
        return this.edges;
    }

    public Graph<Object, Object> createGraph(SparkContext sc) {
        return Graph$.MODULE$.fromEdges(sc.parallelize(this.edges(), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Edge.class)), (Object)BoxesRunTime.boxToDouble((double)0.0), Graph$.MODULE$.fromEdges$default$3(), Graph$.MODULE$.fromEdges$default$4(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double());
    }

    public void checkPersistence(Seq<PeriodicGraphCheckpointerSuite.GraphToCheck> graphs, int iteration) {
        graphs.foreach((Function1)new Serializable(iteration){
            public static final long serialVersionUID = 0L;
            private final int iteration$1;

            public final void apply(PeriodicGraphCheckpointerSuite.GraphToCheck g) {
                PeriodicGraphCheckpointerSuite$.MODULE$.checkPersistence(g.graph(), g.gIndex(), this.iteration$1);
            }
            {
                this.iteration$1 = iteration$1;
            }
        });
    }

    public void checkPersistence(Graph<?, ?> graph, int gIndex, int iteration) {
        try {
            if (gIndex + 2 < iteration) {
                StorageLevel storageLevel = graph.vertices().getStorageLevel();
                StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
                Predef$.MODULE$.assert(!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null));
                StorageLevel storageLevel3 = graph.edges().getStorageLevel();
                StorageLevel storageLevel4 = StorageLevel$.MODULE$.NONE();
                Predef$.MODULE$.assert(!(storageLevel3 != null ? !storageLevel3.equals(storageLevel4) : storageLevel4 != null));
            } else {
                StorageLevel storageLevel = graph.vertices().getStorageLevel();
                StorageLevel storageLevel5 = StorageLevel$.MODULE$.NONE();
                Predef$.MODULE$.assert(storageLevel != null ? !storageLevel.equals(storageLevel5) : storageLevel5 != null);
                StorageLevel storageLevel6 = graph.edges().getStorageLevel();
                StorageLevel storageLevel7 = StorageLevel$.MODULE$.NONE();
                Predef$.MODULE$.assert(storageLevel6 != null ? !storageLevel6.equals(storageLevel7) : storageLevel7 != null);
            }
            return;
        }
        catch (AssertionError assertionError) {
            throw new Exception(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PeriodicGraphCheckpointerSuite.checkPersistence failed with:\\n"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t gIndex = ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)gIndex)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t iteration = ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)iteration)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t graph.vertices.getStorageLevel = ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{graph.vertices().getStorageLevel()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t graph.edges.getStorageLevel = ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{graph.edges().getStorageLevel()}))).toString());
        }
    }

    public void checkCheckpoint(Seq<PeriodicGraphCheckpointerSuite.GraphToCheck> graphs, int iteration, int checkpointInterval) {
        ((IterableLike)graphs.reverse()).foreach((Function1)new Serializable(iteration, checkpointInterval){
            public static final long serialVersionUID = 0L;
            private final int iteration$2;
            private final int checkpointInterval$1;

            public final void apply(PeriodicGraphCheckpointerSuite.GraphToCheck g) {
                PeriodicGraphCheckpointerSuite$.MODULE$.checkCheckpoint(g.graph(), g.gIndex(), this.iteration$2, this.checkpointInterval$1);
            }
            {
                this.iteration$2 = iteration$2;
                this.checkpointInterval$1 = checkpointInterval$1;
            }
        });
    }

    public void confirmCheckpointRemoved(Graph<?, ?> graph) {
        FileSystem fs = FileSystem.get((Configuration)graph.vertices().sparkContext().hadoopConfiguration());
        graph.getCheckpointFiles().foreach((Function1)new Serializable(fs){
            public static final long serialVersionUID = 0L;
            private final FileSystem fs$1;

            public final void apply(String checkpointFile) {
                Predef$.MODULE$.assert(!this.fs$1.exists(new Path(checkpointFile)), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Graph checkpoint file should have been removed";
                    }
                });
            }
            {
                this.fs$1 = fs$1;
            }
        });
    }

    public void checkCheckpoint(Graph<?, ?> graph, int gIndex, int iteration, int checkpointInterval) {
        try {
            if (gIndex % checkpointInterval == 0) {
                if (iteration - 2 * checkpointInterval < gIndex && gIndex <= iteration) {
                    Predef$.MODULE$.assert(graph.isCheckpointed(), (Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Graph should be checkpointed";
                        }
                    });
                    Predef$.MODULE$.assert(graph.getCheckpointFiles().length() == 2, (Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Graph should have 2 checkpoint files";
                        }
                    });
                } else {
                    this.confirmCheckpointRemoved(graph);
                }
            } else {
                Predef$.MODULE$.assert(!graph.isCheckpointed(), (Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Graph should never have been checkpointed";
                    }
                });
                Predef$.MODULE$.assert(graph.getCheckpointFiles().isEmpty(), (Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Graph should not have any checkpoint files";
                    }
                });
            }
            return;
        }
        catch (AssertionError assertionError) {
            throw new Exception(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PeriodicGraphCheckpointerSuite.checkCheckpoint failed with:\\n"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t gIndex = ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)gIndex)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t iteration = ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)iteration)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t checkpointInterval = ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)checkpointInterval)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t graph.isCheckpointed = ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)graph.isCheckpointed())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t graph.getCheckpointFiles = ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{graph.getCheckpointFiles().mkString(", ")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  AssertionError message: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Throwable)((Object)assertionError)).getMessage()}))).toString());
        }
    }

    private Object readResolve() {
        return MODULE$;
    }

    private PeriodicGraphCheckpointerSuite$() {
        MODULE$ = this;
        this.edges = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Edge[]{new Edge.mcD.sp(0L, 1L, 0.0), new Edge.mcD.sp(1L, 2L, 0.0), new Edge.mcD.sp(2L, 3L, 0.0), new Edge.mcD.sp(3L, 4L, 0.0)}));
    }
}

