/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.impl;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.impl.PeriodicRDDCheckpointerSuite;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class PeriodicRDDCheckpointerSuite$
implements Serializable {
    public static final PeriodicRDDCheckpointerSuite$ MODULE$;

    static {
        new PeriodicRDDCheckpointerSuite$();
    }

    public RDD<Object> createRDD(SparkContext sc) {
        return sc.parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.0, 2.0, 3.0})), sc.parallelize$default$2(), ClassTag$.MODULE$.Double());
    }

    public void checkPersistence(Seq<PeriodicRDDCheckpointerSuite.RDDToCheck> rdds, int iteration) {
        rdds.foreach((Function1)new Serializable(iteration){
            public static final long serialVersionUID = 0L;
            private final int iteration$1;

            public final void apply(PeriodicRDDCheckpointerSuite.RDDToCheck g) {
                PeriodicRDDCheckpointerSuite$.MODULE$.checkPersistence(g.rdd(), g.gIndex(), this.iteration$1);
            }
            {
                this.iteration$1 = iteration$1;
            }
        });
    }

    public void checkPersistence(RDD<?> rdd, int gIndex, int iteration) {
        try {
            if (gIndex + 2 < iteration) {
                StorageLevel storageLevel = rdd.getStorageLevel();
                StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
                Predef$.MODULE$.assert(!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null));
            } else {
                StorageLevel storageLevel = rdd.getStorageLevel();
                StorageLevel storageLevel3 = StorageLevel$.MODULE$.NONE();
                Predef$.MODULE$.assert(storageLevel != null ? !storageLevel.equals(storageLevel3) : storageLevel3 != null);
            }
            return;
        }
        catch (AssertionError assertionError) {
            throw new Exception(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PeriodicRDDCheckpointerSuite.checkPersistence failed with:\\n"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t gIndex = ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)gIndex)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t iteration = ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)iteration)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t rdd.getStorageLevel = ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rdd.getStorageLevel()}))).toString());
        }
    }

    public void checkCheckpoint(Seq<PeriodicRDDCheckpointerSuite.RDDToCheck> rdds, int iteration, int checkpointInterval) {
        ((IterableLike)rdds.reverse()).foreach((Function1)new Serializable(iteration, checkpointInterval){
            public static final long serialVersionUID = 0L;
            private final int iteration$2;
            private final int checkpointInterval$1;

            public final void apply(PeriodicRDDCheckpointerSuite.RDDToCheck g) {
                PeriodicRDDCheckpointerSuite$.MODULE$.checkCheckpoint(g.rdd(), g.gIndex(), this.iteration$2, this.checkpointInterval$1);
            }
            {
                this.iteration$2 = iteration$2;
                this.checkpointInterval$1 = checkpointInterval$1;
            }
        });
    }

    public void confirmCheckpointRemoved(RDD<?> rdd) {
        FileSystem fs = FileSystem.get((Configuration)rdd.sparkContext().hadoopConfiguration());
        rdd.getCheckpointFile().foreach((Function1)new Serializable(fs){
            public static final long serialVersionUID = 0L;
            private final FileSystem fs$1;

            public final void apply(String checkpointFile) {
                Predef$.MODULE$.assert(!this.fs$1.exists(new Path(checkpointFile)), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "RDD checkpoint file should have been removed";
                    }
                });
            }
            {
                this.fs$1 = fs$1;
            }
        });
    }

    public void checkCheckpoint(RDD<?> rdd, int gIndex, int iteration, int checkpointInterval) {
        try {
            if (gIndex % checkpointInterval == 0) {
                if (iteration - 2 * checkpointInterval < gIndex && gIndex <= iteration) {
                    Predef$.MODULE$.assert(rdd.isCheckpointed(), (Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "RDD should be checkpointed";
                        }
                    });
                    Predef$.MODULE$.assert(rdd.getCheckpointFile().nonEmpty(), (Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "RDD should have 2 checkpoint files";
                        }
                    });
                } else {
                    this.confirmCheckpointRemoved(rdd);
                }
            } else {
                Predef$.MODULE$.assert(!rdd.isCheckpointed(), (Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "RDD should never have been checkpointed";
                    }
                });
                Predef$.MODULE$.assert(rdd.getCheckpointFile().isEmpty(), (Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "RDD should not have any checkpoint files";
                    }
                });
            }
            return;
        }
        catch (AssertionError assertionError) {
            throw new Exception(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PeriodicRDDCheckpointerSuite.checkCheckpoint failed with:\\n"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t gIndex = ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)gIndex)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t iteration = ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)iteration)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t checkpointInterval = ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)checkpointInterval)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t rdd.isCheckpointed = ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)rdd.isCheckpointed())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t rdd.getCheckpointFile = ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Option$.MODULE$.option2Iterable(rdd.getCheckpointFile()).mkString(", ")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  AssertionError message: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((Throwable)((Object)assertionError)).getMessage()}))).toString());
        }
    }

    private Object readResolve() {
        return MODULE$;
    }

    private PeriodicRDDCheckpointerSuite$() {
        MODULE$ = this;
    }
}

