/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import java.io.Serializable;
import java.util.Random;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.Matrices;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SparseMatrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors;
import org.junit.Assert;
import org.junit.Test;

public class JavaMatricesSuite
implements Serializable {
    @Test
    public void randMatrixConstruction() {
        Random rng = new Random(24L);
        Matrix r = Matrices.rand((int)3, (int)4, (Random)rng);
        rng.setSeed(24L);
        DenseMatrix dr = DenseMatrix.rand((int)3, (int)4, (Random)rng);
        Assert.assertArrayEquals((double[])r.toArray(), (double[])dr.toArray(), (double)0.0);
        rng.setSeed(24L);
        Matrix rn = Matrices.randn((int)3, (int)4, (Random)rng);
        rng.setSeed(24L);
        DenseMatrix drn = DenseMatrix.randn((int)3, (int)4, (Random)rng);
        Assert.assertArrayEquals((double[])rn.toArray(), (double[])drn.toArray(), (double)0.0);
        rng.setSeed(24L);
        Matrix s = Matrices.sprand((int)3, (int)4, (double)0.5, (Random)rng);
        rng.setSeed(24L);
        SparseMatrix sr = SparseMatrix.sprand((int)3, (int)4, (double)0.5, (Random)rng);
        Assert.assertArrayEquals((double[])s.toArray(), (double[])sr.toArray(), (double)0.0);
        rng.setSeed(24L);
        Matrix sn = Matrices.sprandn((int)3, (int)4, (double)0.5, (Random)rng);
        rng.setSeed(24L);
        SparseMatrix srn = SparseMatrix.sprandn((int)3, (int)4, (double)0.5, (Random)rng);
        Assert.assertArrayEquals((double[])sn.toArray(), (double[])srn.toArray(), (double)0.0);
    }

    @Test
    public void identityMatrixConstruction() {
        Matrix r = Matrices.eye((int)2);
        DenseMatrix dr = DenseMatrix.eye((int)2);
        SparseMatrix sr = SparseMatrix.speye((int)2);
        Assert.assertArrayEquals((double[])r.toArray(), (double[])dr.toArray(), (double)0.0);
        Assert.assertArrayEquals((double[])sr.toArray(), (double[])dr.toArray(), (double)0.0);
        Assert.assertArrayEquals((double[])r.toArray(), (double[])new double[]{1.0, 0.0, 0.0, 1.0}, (double)0.0);
    }

    @Test
    public void diagonalMatrixConstruction() {
        Vector v = Vectors.dense((double)1.0, (double[])new double[]{0.0, 2.0});
        Vector sv = Vectors.sparse((int)3, (int[])new int[]{0, 2}, (double[])new double[]{1.0, 2.0});
        Matrix m = Matrices.diag((Vector)v);
        Matrix sm = Matrices.diag((Vector)sv);
        DenseMatrix d = DenseMatrix.diag((Vector)v);
        DenseMatrix sd = DenseMatrix.diag((Vector)sv);
        SparseMatrix s = SparseMatrix.spdiag((Vector)v);
        SparseMatrix ss = SparseMatrix.spdiag((Vector)sv);
        Assert.assertArrayEquals((double[])m.toArray(), (double[])sm.toArray(), (double)0.0);
        Assert.assertArrayEquals((double[])d.toArray(), (double[])sm.toArray(), (double)0.0);
        Assert.assertArrayEquals((double[])d.toArray(), (double[])sd.toArray(), (double)0.0);
        Assert.assertArrayEquals((double[])sd.toArray(), (double[])s.toArray(), (double)0.0);
        Assert.assertArrayEquals((double[])s.toArray(), (double[])ss.toArray(), (double)0.0);
        Assert.assertArrayEquals((double[])s.values(), (double[])ss.values(), (double)0.0);
        Assert.assertEquals((long)2L, (long)s.values().length);
        Assert.assertEquals((long)2L, (long)ss.values().length);
        Assert.assertEquals((long)4L, (long)s.colPtrs().length);
        Assert.assertEquals((long)4L, (long)ss.colPtrs().length);
    }

    @Test
    public void zerosMatrixConstruction() {
        Matrix z = Matrices.zeros((int)2, (int)2);
        Matrix one = Matrices.ones((int)2, (int)2);
        DenseMatrix dz = DenseMatrix.zeros((int)2, (int)2);
        DenseMatrix done = DenseMatrix.ones((int)2, (int)2);
        Assert.assertArrayEquals((double[])z.toArray(), (double[])new double[]{0.0, 0.0, 0.0, 0.0}, (double)0.0);
        Assert.assertArrayEquals((double[])dz.toArray(), (double[])new double[]{0.0, 0.0, 0.0, 0.0}, (double)0.0);
        Assert.assertArrayEquals((double[])one.toArray(), (double[])new double[]{1.0, 1.0, 1.0, 1.0}, (double)0.0);
        Assert.assertArrayEquals((double[])done.toArray(), (double[])new double[]{1.0, 1.0, 1.0, 1.0}, (double)0.0);
    }

    @Test
    public void sparseDenseConversion() {
        int m = 3;
        int n = 2;
        double[] values = new double[]{1.0, 2.0, 4.0, 5.0};
        double[] allValues = new double[]{1.0, 2.0, 0.0, 0.0, 4.0, 5.0};
        int[] colPtrs = new int[]{0, 2, 4};
        int[] rowIndices = new int[]{0, 1, 1, 2};
        SparseMatrix spMat1 = new SparseMatrix(m, n, colPtrs, rowIndices, values);
        DenseMatrix deMat1 = new DenseMatrix(m, n, allValues);
        SparseMatrix spMat2 = deMat1.toSparse();
        DenseMatrix deMat2 = spMat1.toDense();
        Assert.assertArrayEquals((double[])spMat1.toArray(), (double[])spMat2.toArray(), (double)0.0);
        Assert.assertArrayEquals((double[])deMat1.toArray(), (double[])deMat2.toArray(), (double)0.0);
    }

    @Test
    public void concatenateMatrices() {
        int m = 3;
        int n = 2;
        Random rng = new Random(42L);
        SparseMatrix spMat1 = SparseMatrix.sprand((int)m, (int)n, (double)0.5, (Random)rng);
        rng.setSeed(42L);
        DenseMatrix deMat1 = DenseMatrix.rand((int)m, (int)n, (Random)rng);
        Matrix deMat2 = Matrices.eye((int)3);
        Matrix spMat2 = Matrices.speye((int)3);
        Matrix deMat3 = Matrices.eye((int)2);
        Matrix spMat3 = Matrices.speye((int)2);
        Matrix spHorz = Matrices.horzcat((Matrix[])new Matrix[]{spMat1, spMat2});
        Matrix deHorz1 = Matrices.horzcat((Matrix[])new Matrix[]{deMat1, deMat2});
        Matrix deHorz2 = Matrices.horzcat((Matrix[])new Matrix[]{spMat1, deMat2});
        Matrix deHorz3 = Matrices.horzcat((Matrix[])new Matrix[]{deMat1, spMat2});
        Assert.assertEquals((long)3L, (long)deHorz1.numRows());
        Assert.assertEquals((long)3L, (long)deHorz2.numRows());
        Assert.assertEquals((long)3L, (long)deHorz3.numRows());
        Assert.assertEquals((long)3L, (long)spHorz.numRows());
        Assert.assertEquals((long)5L, (long)deHorz1.numCols());
        Assert.assertEquals((long)5L, (long)deHorz2.numCols());
        Assert.assertEquals((long)5L, (long)deHorz3.numCols());
        Assert.assertEquals((long)5L, (long)spHorz.numCols());
        Matrix spVert = Matrices.vertcat((Matrix[])new Matrix[]{spMat1, spMat3});
        Matrix deVert1 = Matrices.vertcat((Matrix[])new Matrix[]{deMat1, deMat3});
        Matrix deVert2 = Matrices.vertcat((Matrix[])new Matrix[]{spMat1, deMat3});
        Matrix deVert3 = Matrices.vertcat((Matrix[])new Matrix[]{deMat1, spMat3});
        Assert.assertEquals((long)5L, (long)deVert1.numRows());
        Assert.assertEquals((long)5L, (long)deVert2.numRows());
        Assert.assertEquals((long)5L, (long)deVert3.numRows());
        Assert.assertEquals((long)5L, (long)spVert.numRows());
        Assert.assertEquals((long)2L, (long)deVert1.numCols());
        Assert.assertEquals((long)2L, (long)deVert2.numCols());
        Assert.assertEquals((long)2L, (long)deVert3.numCols());
        Assert.assertEquals((long)2L, (long)spVert.numCols());
    }
}

