/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import java.util.NoSuchElementException;
import java.util.Random;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.MatricesSuite$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.MatrixUDT;
import org.apache.spark.mllib.linalg.SparseMatrix;
import org.apache.spark.mllib.linalg.SparseMatrix$;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.mockito.Mockito;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import org.scalatest.mock.MockitoSugar$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001]1A!\u0001\u0002\u0001\u001b\tiQ*\u0019;sS\u000e,7oU;ji\u0016T!a\u0001\u0003\u0002\r1Lg.\u00197h\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0001R\"\u0001\u0004\n\u0005E1!!D*qCJ\\g)\u001e8Tk&$X\rC\u0003\u0014\u0001\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002+A\u0011a\u0003A\u0007\u0002\u0005\u0001")
public class MatricesSuite
extends SparkFunSuite {
    public MatricesSuite() {
        this.test("dense matrix construction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatricesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int m = 3;
                int n = 2;
                double[] values = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
                DenseMatrix mat = (DenseMatrix)Matrices$.MODULE$.dense(m, n, values);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numRows()));
                int $org_scalatest_assert_macro_right = m;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numCols()));
                int $org_scalatest_assert_macro_right2 = n;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                double[] $org_scalatest_assert_macro_left3 = mat.values();
                double[] $org_scalatest_assert_macro_right3 = values;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "eq", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"should not copy data");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("dense matrix construction with wrong dimension", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatricesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Matrix apply() {
                        return Matrices$.MODULE$.dense(3, 2, new double[]{0.0, 1.0, 2.0});
                    }
                }, ManifestFactory$.MODULE$.classType(RuntimeException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("sparse matrix construction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatricesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int m = 3;
                int n = 4;
                double[] values = new double[]{1.0, 2.0, 4.0, 5.0};
                int[] colPtrs = new int[]{0, 2, 2, 4, 4};
                int[] rowIndices = new int[]{1, 2, 1, 2};
                SparseMatrix mat = (SparseMatrix)Matrices$.MODULE$.sparse(m, n, colPtrs, rowIndices, values);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numRows()));
                int $org_scalatest_assert_macro_right = m;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numCols()));
                int $org_scalatest_assert_macro_right2 = n;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                double[] $org_scalatest_assert_macro_left3 = mat.values();
                double[] $org_scalatest_assert_macro_right3 = values;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "eq", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"should not copy data");
                int[] $org_scalatest_assert_macro_left4 = mat.colPtrs();
                int[] $org_scalatest_assert_macro_right4 = colPtrs;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "eq", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"should not copy data");
                int[] $org_scalatest_assert_macro_left5 = mat.rowIndices();
                int[] $org_scalatest_assert_macro_right5 = rowIndices;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "eq", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"should not copy data");
                Tuple3[] entries = (Tuple3[])((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToDouble((double)3.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToDouble((double)2.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToDouble((double)2.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToDouble((double)2.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToDouble((double)2.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToDouble((double)0.0))});
                SparseMatrix mat2 = SparseMatrix$.MODULE$.fromCOO(m, n, (Iterable)Predef$.MODULE$.wrapRefArray((Object[])entries));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(mat.toBreeze());
                breeze.linalg.Matrix $org_scalatest_assert_macro_right6 = mat2.toBreeze();
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                double[] $org_scalatest_assert_macro_left7 = mat2.values();
                int $org_scalatest_assert_macro_right7 = 4;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "length", (long)$org_scalatest_assert_macro_left7.length, (long)$org_scalatest_assert_macro_right7);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("sparse matrix construction with wrong number of elements", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatricesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Matrix apply() {
                        return Matrices$.MODULE$.sparse(3, 2, new int[]{0, 1}, new int[]{1, 2, 1}, new double[]{0.0, 1.0, 2.0});
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Matrix apply() {
                        return Matrices$.MODULE$.sparse(3, 2, new int[]{0, 1, 2}, new int[]{1, 2}, new double[]{0.0, 1.0, 2.0});
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("index in matrices incorrect input", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatricesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Matrix sm = Matrices$.MODULE$.sparse(3, 2, new int[]{0, 2, 3}, new int[]{1, 2, 1}, new double[]{0.0, 1.0, 2.0});
                Matrix dm = Matrices$.MODULE$.dense(3, 2, new double[]{0.0, 2.3, 1.4, 3.2, 1.0, 9.1});
                Predef$.MODULE$.refArrayOps((Object[])new Matrix[]{sm, dm}).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final IllegalArgumentException apply(Matrix mat) {
                        this.$outer.org$apache$spark$mllib$linalg$MatricesSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this, mat){
                            public static final long serialVersionUID = 0L;
                            private final Matrix mat$1;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return this.mat$1.index(4, 1);
                            }
                            {
                                this.mat$1 = mat$1;
                            }
                        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                        this.$outer.org$apache$spark$mllib$linalg$MatricesSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this, mat){
                            public static final long serialVersionUID = 0L;
                            private final Matrix mat$1;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return this.mat$1.index(1, 4);
                            }
                            {
                                this.mat$1 = mat$1;
                            }
                        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                        this.$outer.org$apache$spark$mllib$linalg$MatricesSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this, mat){
                            public static final long serialVersionUID = 0L;
                            private final Matrix mat$1;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return this.mat$1.index(-1, 2);
                            }
                            {
                                this.mat$1 = mat$1;
                            }
                        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                        return (IllegalArgumentException)this.$outer.org$apache$spark$mllib$linalg$MatricesSuite$$anonfun$$$outer().intercept((Function0)new Serializable(this, mat){
                            public static final long serialVersionUID = 0L;
                            private final Matrix mat$1;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return this.mat$1.index(1, -2);
                            }
                            {
                                this.mat$1 = mat$1;
                            }
                        }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ MatricesSuite org$apache$spark$mllib$linalg$MatricesSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("equals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatricesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Matrix dm1 = Matrices$.MODULE$.dense(2, 2, new double[]{0.0, 1.0, 2.0, 3.0});
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(dm1);
                Matrix $org_scalatest_assert_macro_right = dm1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(dm1);
                Matrix $org_scalatest_assert_macro_right2 = dm1.transpose();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "!==", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$bang$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Matrix dm2 = Matrices$.MODULE$.dense(2, 2, new double[]{0.0, 2.0, 1.0, 3.0});
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(dm1);
                Matrix $org_scalatest_assert_macro_right3 = dm2.transpose();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                SparseMatrix sm1 = ((DenseMatrix)dm1).toSparse();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(sm1);
                SparseMatrix $org_scalatest_assert_macro_right4 = sm1;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(sm1);
                Matrix $org_scalatest_assert_macro_right5 = dm1;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(sm1);
                SparseMatrix $org_scalatest_assert_macro_right6 = sm1.transpose();
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "!==", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$bang$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                SparseMatrix sm2 = ((DenseMatrix)dm2).toSparse();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(sm1);
                SparseMatrix $org_scalatest_assert_macro_right7 = sm2.transpose();
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(sm1);
                Matrix $org_scalatest_assert_macro_right8 = dm2.transpose();
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("matrix copies are deep copies", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatricesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double[] $org_scalatest_assert_macro_right;
                double[] $org_scalatest_assert_macro_left;
                int m = 3;
                int n = 2;
                Matrix denseMat = Matrices$.MODULE$.dense(m, n, new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0});
                Matrix denseCopy = denseMat.copy();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "eq", (Object)$org_scalatest_assert_macro_right, ($org_scalatest_assert_macro_left = denseMat.toArray()) == ($org_scalatest_assert_macro_right = denseCopy.toArray())));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                double[] values = new double[]{1.0, 2.0, 4.0, 5.0};
                int[] colPtrs = new int[]{0, 2, 4};
                int[] rowIndices = new int[]{1, 2, 1, 2};
                Matrix sparseMat = Matrices$.MODULE$.sparse(m, n, colPtrs, rowIndices, values);
                Matrix sparseCopy = sparseMat.copy();
                double[] $org_scalatest_assert_macro_left2 = sparseMat.toArray();
                double[] $org_scalatest_assert_macro_right2 = sparseCopy.toArray();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "eq", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("matrix indexing and updating", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatricesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int m = 3;
                int n = 2;
                double[] allValues = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 0.0};
                DenseMatrix denseMat = new DenseMatrix(m, n, allValues);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)denseMat.apply(0, 1)));
                double $org_scalatest_assert_macro_right = 3.0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)denseMat.apply(0, 1)));
                double $org_scalatest_assert_macro_right2 = denseMat.values()[3];
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)denseMat.apply(0, 1)));
                double $org_scalatest_assert_macro_right3 = denseMat.apply(3);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)denseMat.apply(0, 0)));
                double $org_scalatest_assert_macro_right4 = 0.0;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                denseMat.update(0, 0, 10.0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)denseMat.apply(0, 0)));
                double $org_scalatest_assert_macro_right5 = 10.0;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)denseMat.values()[0]));
                double $org_scalatest_assert_macro_right6 = 10.0;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                double[] sparseValues = new double[]{1.0, 2.0, 3.0, 4.0};
                int[] colPtrs = new int[]{0, 2, 4};
                int[] rowIndices = new int[]{1, 2, 0, 1};
                SparseMatrix sparseMat = new SparseMatrix(m, n, colPtrs, rowIndices, sparseValues);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)sparseMat.apply(0, 1)));
                double $org_scalatest_assert_macro_right7 = 3.0;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)sparseMat.apply(0, 1)));
                double $org_scalatest_assert_macro_right8 = sparseMat.values()[2];
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)sparseMat.apply(0, 0)));
                double $org_scalatest_assert_macro_right9 = 0.0;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, sparseMat){
                    public static final long serialVersionUID = 0L;
                    private final SparseMatrix sparseMat$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.sparseMat$1.update(0, 0, 10.0);
                    }
                    {
                        this.sparseMat$1 = sparseMat$1;
                    }
                }, ManifestFactory$.MODULE$.classType(NoSuchElementException.class));
                sparseMat.update(0, 1, 10.0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)sparseMat.apply(0, 1)));
                double $org_scalatest_assert_macro_right10 = 10.0;
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)sparseMat.values()[2]));
                double $org_scalatest_assert_macro_right11 = 10.0;
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("toSparse, toDense", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatricesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int m = 3;
                int n = 2;
                double[] values = new double[]{1.0, 2.0, 4.0, 5.0};
                double[] allValues = new double[]{1.0, 2.0, 0.0, 0.0, 4.0, 5.0};
                int[] colPtrs = new int[]{0, 2, 4};
                int[] rowIndices = new int[]{0, 1, 1, 2};
                SparseMatrix spMat1 = new SparseMatrix(m, n, colPtrs, rowIndices, values);
                DenseMatrix deMat1 = new DenseMatrix(m, n, allValues);
                SparseMatrix spMat2 = deMat1.toSparse();
                DenseMatrix deMat2 = spMat1.toDense();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(spMat1.toBreeze());
                breeze.linalg.Matrix $org_scalatest_assert_macro_right = spMat2.toBreeze();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(deMat1.toBreeze());
                breeze.linalg.Matrix $org_scalatest_assert_macro_right2 = deMat2.toBreeze();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("map, update", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatricesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int m = 3;
                int n = 2;
                double[] values = new double[]{1.0, 2.0, 4.0, 5.0};
                double[] allValues = new double[]{1.0, 2.0, 0.0, 0.0, 4.0, 5.0};
                int[] colPtrs = new int[]{0, 2, 4};
                int[] rowIndices = new int[]{0, 1, 1, 2};
                SparseMatrix spMat1 = new SparseMatrix(m, n, colPtrs, rowIndices, values);
                DenseMatrix deMat1 = new DenseMatrix(m, n, allValues);
                DenseMatrix deMat2 = deMat1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x$1) {
                        return this.apply$mcDD$sp(x$1);
                    }

                    public double apply$mcDD$sp(double x$1) {
                        return x$1 * (double)2;
                    }
                });
                SparseMatrix spMat2 = spMat1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x$2) {
                        return this.apply$mcDD$sp(x$2);
                    }

                    public double apply$mcDD$sp(double x$2) {
                        return x$2 * (double)2;
                    }
                });
                deMat1.update((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x$3) {
                        return this.apply$mcDD$sp(x$3);
                    }

                    public double apply$mcDD$sp(double x$3) {
                        return x$3 * (double)2;
                    }
                });
                spMat1.update((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x$4) {
                        return this.apply$mcDD$sp(x$4);
                    }

                    public double apply$mcDD$sp(double x$4) {
                        return x$4 * (double)2;
                    }
                });
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(spMat1.toArray());
                double[] $org_scalatest_assert_macro_right = spMat2.toArray();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(deMat1.toArray());
                double[] $org_scalatest_assert_macro_right2 = deMat2.toArray();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("transpose", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatricesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DenseMatrix dA = new DenseMatrix(4, 3, new double[]{0.0, 1.0, 0.0, 0.0, 2.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 3.0});
                SparseMatrix sA = new SparseMatrix(4, 3, new int[]{0, 1, 3, 4}, new int[]{1, 0, 2, 3}, new double[]{1.0, 2.0, 1.0, 3.0});
                DenseMatrix dAT = dA.transpose();
                SparseMatrix sAT = sA.transpose();
                DenseMatrix dATexpected = new DenseMatrix(3, 4, new double[]{0.0, 2.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 3.0});
                SparseMatrix sATexpected = new SparseMatrix(3, 4, new int[]{0, 1, 2, 3, 4}, new int[]{1, 0, 1, 2}, new double[]{2.0, 1.0, 1.0, 3.0});
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(dAT.toBreeze());
                breeze.linalg.Matrix $org_scalatest_assert_macro_right = dATexpected.toBreeze();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(sAT.toBreeze());
                breeze.linalg.Matrix $org_scalatest_assert_macro_right2 = sATexpected.toBreeze();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)dA.apply(1, 0)));
                double $org_scalatest_assert_macro_right3 = dAT.apply(0, 1);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)dA.apply(2, 1)));
                double $org_scalatest_assert_macro_right4 = dAT.apply(1, 2);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)sA.apply(1, 0)));
                double $org_scalatest_assert_macro_right5 = sAT.apply(0, 1);
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)sA.apply(2, 1)));
                double $org_scalatest_assert_macro_right6 = sAT.apply(1, 2);
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                double[] $org_scalatest_assert_macro_left7 = dA.toArray();
                double[] $org_scalatest_assert_macro_right7 = dAT.toArray();
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "eq", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"has to have a new array");
                double[] $org_scalatest_assert_macro_left8 = dA.values();
                double[] $org_scalatest_assert_macro_right8 = dAT.transpose().values();
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "eq", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8 == $org_scalatest_assert_macro_right8);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"should not copy array");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(dAT.toSparse().toBreeze());
                breeze.linalg.Matrix $org_scalatest_assert_macro_right9 = sATexpected.toBreeze();
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(sAT.toDense().toBreeze());
                breeze.linalg.Matrix $org_scalatest_assert_macro_right10 = dATexpected.toBreeze();
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("foreachActive", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatricesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int m = 3;
                int n = 2;
                double[] values = new double[]{1.0, 2.0, 4.0, 5.0};
                double[] allValues = new double[]{1.0, 2.0, 0.0, 0.0, 4.0, 5.0};
                int[] colPtrs = new int[]{0, 2, 4};
                int[] rowIndices = new int[]{0, 1, 1, 2};
                SparseMatrix sp2 = new SparseMatrix(m, n, colPtrs, rowIndices, values);
                DenseMatrix dn = new DenseMatrix(m, n, allValues);
                Map dnMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                dn.foreachActive((Function3)new Serializable(this, dnMap){
                    public static final long serialVersionUID = 0L;
                    private final Map dnMap$1;

                    public final void apply(int i, int j, double value) {
                        this.dnMap$1.put((Object)new Tuple2.mcII.sp(i, j), (Object)BoxesRunTime.boxToDouble((double)value));
                    }
                    {
                        this.dnMap$1 = dnMap$1;
                    }
                });
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)dnMap.size()));
                int $org_scalatest_assert_macro_right = 6;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(dnMap.apply((Object)new Tuple2.mcII.sp(0, 0)));
                double $org_scalatest_assert_macro_right2 = 1.0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(dnMap.apply((Object)new Tuple2.mcII.sp(1, 0)));
                double $org_scalatest_assert_macro_right3 = 2.0;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(dnMap.apply((Object)new Tuple2.mcII.sp(2, 0)));
                double $org_scalatest_assert_macro_right4 = 0.0;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(dnMap.apply((Object)new Tuple2.mcII.sp(0, 1)));
                double $org_scalatest_assert_macro_right5 = 0.0;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(dnMap.apply((Object)new Tuple2.mcII.sp(1, 1)));
                double $org_scalatest_assert_macro_right6 = 4.0;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(dnMap.apply((Object)new Tuple2.mcII.sp(2, 1)));
                double $org_scalatest_assert_macro_right7 = 5.0;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Map spMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
                sp2.foreachActive((Function3)new Serializable(this, spMap){
                    public static final long serialVersionUID = 0L;
                    private final Map spMap$1;

                    public final void apply(int i, int j, double value) {
                        this.spMap$1.put((Object)new Tuple2.mcII.sp(i, j), (Object)BoxesRunTime.boxToDouble((double)value));
                    }
                    {
                        this.spMap$1 = spMap$1;
                    }
                });
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)spMap.size()));
                int $org_scalatest_assert_macro_right8 = 4;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(spMap.apply((Object)new Tuple2.mcII.sp(0, 0)));
                double $org_scalatest_assert_macro_right9 = 1.0;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(spMap.apply((Object)new Tuple2.mcII.sp(1, 0)));
                double $org_scalatest_assert_macro_right10 = 2.0;
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.$outer.convertToEqualizer(spMap.apply((Object)new Tuple2.mcII.sp(1, 1)));
                double $org_scalatest_assert_macro_right11 = 4.0;
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.$outer.convertToEqualizer(spMap.apply((Object)new Tuple2.mcII.sp(2, 1)));
                double $org_scalatest_assert_macro_right12 = 5.0;
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right12), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("horzcat, vertcat, eye, speye", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatricesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int m = 3;
                int n = 2;
                double[] values = new double[]{1.0, 2.0, 4.0, 5.0};
                double[] allValues = new double[]{1.0, 2.0, 0.0, 0.0, 4.0, 5.0};
                int[] colPtrs = new int[]{0, 2, 4};
                int[] rowIndices = new int[]{0, 1, 1, 2};
                double[] allValuesT = new double[]{1.0, 0.0, 2.0, 4.0, 0.0, 5.0};
                int[] colPtrsT = new int[]{0, 1, 3, 4};
                int[] rowIndicesT = new int[]{0, 0, 1, 1};
                SparseMatrix spMat1 = new SparseMatrix(m, n, colPtrs, rowIndices, values);
                DenseMatrix deMat1 = new DenseMatrix(m, n, allValues);
                SparseMatrix spMat1T = new SparseMatrix(n, m, colPtrsT, rowIndicesT, values);
                DenseMatrix deMat1T = new DenseMatrix(n, m, allValuesT);
                SparseMatrix spMat1TT = spMat1T.transpose();
                DenseMatrix deMat1TT = deMat1T.transpose();
                Matrix deMat2 = Matrices$.MODULE$.eye(3);
                Matrix spMat2 = Matrices$.MODULE$.speye(3);
                Matrix deMat3 = Matrices$.MODULE$.eye(2);
                Matrix spMat3 = Matrices$.MODULE$.speye(2);
                Matrix spHorz = Matrices$.MODULE$.horzcat((Matrix[])((Object[])new Matrix[]{spMat1, spMat2}));
                Matrix spHorz2 = Matrices$.MODULE$.horzcat((Matrix[])((Object[])new Matrix[]{spMat1, deMat2}));
                Matrix spHorz3 = Matrices$.MODULE$.horzcat((Matrix[])((Object[])new Matrix[]{deMat1, spMat2}));
                Matrix deHorz1 = Matrices$.MODULE$.horzcat((Matrix[])((Object[])new Matrix[]{deMat1, deMat2}));
                Matrix deHorz2 = Matrices$.MODULE$.horzcat((Matrix[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Matrix.class)));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)deHorz1.numRows()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)spHorz2.numRows()));
                int $org_scalatest_assert_macro_right2 = 3;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)spHorz3.numRows()));
                int $org_scalatest_assert_macro_right3 = 3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)spHorz.numRows()));
                int $org_scalatest_assert_macro_right4 = 3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)deHorz1.numCols()));
                int $org_scalatest_assert_macro_right5 = 5;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)spHorz2.numCols()));
                int $org_scalatest_assert_macro_right6 = 5;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)spHorz3.numCols()));
                int $org_scalatest_assert_macro_right7 = 5;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)spHorz.numCols()));
                int $org_scalatest_assert_macro_right8 = 5;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)deHorz2.numRows()));
                int $org_scalatest_assert_macro_right9 = 0;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)deHorz2.numCols()));
                int $org_scalatest_assert_macro_right10 = 0;
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)deHorz2.toArray().length));
                int $org_scalatest_assert_macro_right11 = 0;
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(deHorz1).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)((SparseMatrix)spHorz2).toDense()).absTol(1.0E-15)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(deHorz1).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spHorz2.asInstanceOf[org.apache.spark.mllib.linalg.SparseMatrix].toDense).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spHorz2).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spHorz3).absTol(1.0E-15)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spHorz2).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spHorz3).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)spHorz.apply(0, 0)));
                double $org_scalatest_assert_macro_right12 = 1.0;
                Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right12), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)spHorz.apply(2, 1)));
                double $org_scalatest_assert_macro_right13 = 5.0;
                Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right13), $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right13), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left14 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)spHorz.apply(0, 2)));
                double $org_scalatest_assert_macro_right14 = 1.0;
                Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right14), $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right14), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left15 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)spHorz.apply(1, 2)));
                double $org_scalatest_assert_macro_right15 = 0.0;
                Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right15), $org_scalatest_assert_macro_left15.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right15), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left16 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)spHorz.apply(1, 3)));
                double $org_scalatest_assert_macro_right16 = 1.0;
                Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right16), $org_scalatest_assert_macro_left16.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right16), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left17 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)spHorz.apply(2, 4)));
                double $org_scalatest_assert_macro_right17 = 1.0;
                Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left17, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right17), $org_scalatest_assert_macro_left17.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right17), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left18 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)spHorz.apply(1, 4)));
                double $org_scalatest_assert_macro_right18 = 0.0;
                Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left18, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right18), $org_scalatest_assert_macro_left18.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right18), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left19 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)deHorz1.apply(0, 0)));
                double $org_scalatest_assert_macro_right19 = 1.0;
                Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left19, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right19), $org_scalatest_assert_macro_left19.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right19), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left20 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)deHorz1.apply(2, 1)));
                double $org_scalatest_assert_macro_right20 = 5.0;
                Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left20, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right20), $org_scalatest_assert_macro_left20.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right20), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left21 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)deHorz1.apply(0, 2)));
                double $org_scalatest_assert_macro_right21 = 1.0;
                Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left21, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right21), $org_scalatest_assert_macro_left21.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right21), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)"");
                double $org_scalatest_assert_macro_left22 = deHorz1.apply(1, 2);
                double $org_scalatest_assert_macro_right22 = 0.0;
                Bool $org_scalatest_assert_macro_expr24 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left22), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right22), $org_scalatest_assert_macro_left22 == $org_scalatest_assert_macro_right22);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr24, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left23 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)deHorz1.apply(1, 3)));
                double $org_scalatest_assert_macro_right23 = 1.0;
                Bool $org_scalatest_assert_macro_expr25 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left23, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right23), $org_scalatest_assert_macro_left23.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right23), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr25, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left24 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)deHorz1.apply(2, 4)));
                double $org_scalatest_assert_macro_right24 = 1.0;
                Bool $org_scalatest_assert_macro_expr26 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left24, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right24), $org_scalatest_assert_macro_left24.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right24), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr26, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left25 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)deHorz1.apply(1, 4)));
                double $org_scalatest_assert_macro_right25 = 0.0;
                Bool $org_scalatest_assert_macro_expr27 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left25, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right25), $org_scalatest_assert_macro_left25.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right25), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr27, (Object)"");
                Matrix spHorzT = Matrices$.MODULE$.horzcat((Matrix[])((Object[])new Matrix[]{spMat1TT, spMat2}));
                Matrix spHorz2T = Matrices$.MODULE$.horzcat((Matrix[])((Object[])new Matrix[]{spMat1TT, deMat2}));
                Matrix spHorz3T = Matrices$.MODULE$.horzcat((Matrix[])((Object[])new Matrix[]{deMat1TT, spMat2}));
                Matrix deHorz1T = Matrices$.MODULE$.horzcat((Matrix[])((Object[])new Matrix[]{deMat1TT, deMat2}));
                Bool $org_scalatest_assert_macro_expr28 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(deHorz1T).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(deHorz1).absTol(1.0E-15)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(deHorz1T).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(deHorz1).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr28, (Object)"");
                Bool $org_scalatest_assert_macro_expr29 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spHorzT).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spHorz).absTol(1.0E-15)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spHorzT).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spHorz).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr29, (Object)"");
                Bool $org_scalatest_assert_macro_expr30 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spHorz2T).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spHorz2).absTol(1.0E-15)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spHorz2T).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spHorz2).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr30, (Object)"");
                Bool $org_scalatest_assert_macro_expr31 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spHorz3T).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spHorz3).absTol(1.0E-15)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spHorz3T).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spHorz3).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr31, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, spMat1, spMat3){
                    public static final long serialVersionUID = 0L;
                    private final SparseMatrix spMat1$1;
                    private final Matrix spMat3$1;

                    public final Matrix apply() {
                        return Matrices$.MODULE$.horzcat((Matrix[])((Object[])new Matrix[]{this.spMat1$1, this.spMat3$1}));
                    }
                    {
                        this.spMat1$1 = spMat1$1;
                        this.spMat3$1 = spMat3$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this, deMat1, spMat3){
                    public static final long serialVersionUID = 0L;
                    private final DenseMatrix deMat1$1;
                    private final Matrix spMat3$1;

                    public final Matrix apply() {
                        return Matrices$.MODULE$.horzcat((Matrix[])((Object[])new Matrix[]{this.deMat1$1, this.spMat3$1}));
                    }
                    {
                        this.deMat1$1 = deMat1$1;
                        this.spMat3$1 = spMat3$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                Matrix spVert = Matrices$.MODULE$.vertcat((Matrix[])((Object[])new Matrix[]{spMat1, spMat3}));
                Matrix deVert1 = Matrices$.MODULE$.vertcat((Matrix[])((Object[])new Matrix[]{deMat1, deMat3}));
                Matrix spVert2 = Matrices$.MODULE$.vertcat((Matrix[])((Object[])new Matrix[]{spMat1, deMat3}));
                Matrix spVert3 = Matrices$.MODULE$.vertcat((Matrix[])((Object[])new Matrix[]{deMat1, spMat3}));
                Matrix deVert2 = Matrices$.MODULE$.vertcat((Matrix[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Matrix.class)));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left26 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)deVert1.numRows()));
                int $org_scalatest_assert_macro_right26 = 5;
                Bool $org_scalatest_assert_macro_expr32 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left26, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right26), $org_scalatest_assert_macro_left26.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right26), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr32, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left27 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)spVert2.numRows()));
                int $org_scalatest_assert_macro_right27 = 5;
                Bool $org_scalatest_assert_macro_expr33 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left27, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right27), $org_scalatest_assert_macro_left27.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right27), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr33, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left28 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)spVert3.numRows()));
                int $org_scalatest_assert_macro_right28 = 5;
                Bool $org_scalatest_assert_macro_expr34 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left28, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right28), $org_scalatest_assert_macro_left28.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right28), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr34, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left29 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)spVert.numRows()));
                int $org_scalatest_assert_macro_right29 = 5;
                Bool $org_scalatest_assert_macro_expr35 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left29, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right29), $org_scalatest_assert_macro_left29.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right29), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr35, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left30 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)deVert1.numCols()));
                int $org_scalatest_assert_macro_right30 = 2;
                Bool $org_scalatest_assert_macro_expr36 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left30, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right30), $org_scalatest_assert_macro_left30.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right30), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr36, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left31 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)spVert2.numCols()));
                int $org_scalatest_assert_macro_right31 = 2;
                Bool $org_scalatest_assert_macro_expr37 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left31, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right31), $org_scalatest_assert_macro_left31.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right31), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr37, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left32 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)spVert3.numCols()));
                int $org_scalatest_assert_macro_right32 = 2;
                Bool $org_scalatest_assert_macro_expr38 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left32, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right32), $org_scalatest_assert_macro_left32.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right32), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr38, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left33 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)spVert.numCols()));
                int $org_scalatest_assert_macro_right33 = 2;
                Bool $org_scalatest_assert_macro_expr39 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left33, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right33), $org_scalatest_assert_macro_left33.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right33), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr39, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left34 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)deVert2.numRows()));
                int $org_scalatest_assert_macro_right34 = 0;
                Bool $org_scalatest_assert_macro_expr40 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left34, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right34), $org_scalatest_assert_macro_left34.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right34), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr40, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left35 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)deVert2.numCols()));
                int $org_scalatest_assert_macro_right35 = 0;
                Bool $org_scalatest_assert_macro_expr41 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left35, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right35), $org_scalatest_assert_macro_left35.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right35), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr41, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left36 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)deVert2.toArray().length));
                int $org_scalatest_assert_macro_right36 = 0;
                Bool $org_scalatest_assert_macro_expr42 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left36, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right36), $org_scalatest_assert_macro_left36.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right36), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr42, (Object)"");
                Bool $org_scalatest_assert_macro_expr43 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(deVert1).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)((SparseMatrix)spVert2).toDense()).absTol(1.0E-15)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(deVert1).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spVert2.asInstanceOf[org.apache.spark.mllib.linalg.SparseMatrix].toDense).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr43, (Object)"");
                Bool $org_scalatest_assert_macro_expr44 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spVert2).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spVert3).absTol(1.0E-15)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spVert2).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spVert3).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr44, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left37 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)spVert.apply(0, 0)));
                double $org_scalatest_assert_macro_right37 = 1.0;
                Bool $org_scalatest_assert_macro_expr45 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left37, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right37), $org_scalatest_assert_macro_left37.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right37), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr45, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left38 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)spVert.apply(2, 1)));
                double $org_scalatest_assert_macro_right38 = 5.0;
                Bool $org_scalatest_assert_macro_expr46 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left38, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right38), $org_scalatest_assert_macro_left38.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right38), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr46, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left39 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)spVert.apply(3, 0)));
                double $org_scalatest_assert_macro_right39 = 1.0;
                Bool $org_scalatest_assert_macro_expr47 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left39, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right39), $org_scalatest_assert_macro_left39.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right39), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr47, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left40 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)spVert.apply(3, 1)));
                double $org_scalatest_assert_macro_right40 = 0.0;
                Bool $org_scalatest_assert_macro_expr48 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left40, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right40), $org_scalatest_assert_macro_left40.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right40), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr48, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left41 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)spVert.apply(4, 1)));
                double $org_scalatest_assert_macro_right41 = 1.0;
                Bool $org_scalatest_assert_macro_expr49 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left41, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right41), $org_scalatest_assert_macro_left41.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right41), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr49, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left42 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)deVert1.apply(0, 0)));
                double $org_scalatest_assert_macro_right42 = 1.0;
                Bool $org_scalatest_assert_macro_expr50 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left42, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right42), $org_scalatest_assert_macro_left42.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right42), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr50, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left43 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)deVert1.apply(2, 1)));
                double $org_scalatest_assert_macro_right43 = 5.0;
                Bool $org_scalatest_assert_macro_expr51 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left43, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right43), $org_scalatest_assert_macro_left43.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right43), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr51, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left44 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)deVert1.apply(3, 0)));
                double $org_scalatest_assert_macro_right44 = 1.0;
                Bool $org_scalatest_assert_macro_expr52 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left44, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right44), $org_scalatest_assert_macro_left44.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right44), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr52, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left45 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)deVert1.apply(3, 1)));
                double $org_scalatest_assert_macro_right45 = 0.0;
                Bool $org_scalatest_assert_macro_expr53 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left45, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right45), $org_scalatest_assert_macro_left45.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right45), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr53, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left46 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)deVert1.apply(4, 1)));
                double $org_scalatest_assert_macro_right46 = 1.0;
                Bool $org_scalatest_assert_macro_expr54 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left46, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right46), $org_scalatest_assert_macro_left46.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right46), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr54, (Object)"");
                Matrix spVertT = Matrices$.MODULE$.vertcat((Matrix[])((Object[])new Matrix[]{spMat1TT, spMat3}));
                Matrix deVert1T = Matrices$.MODULE$.vertcat((Matrix[])((Object[])new Matrix[]{deMat1TT, deMat3}));
                Matrix spVert2T = Matrices$.MODULE$.vertcat((Matrix[])((Object[])new Matrix[]{spMat1TT, deMat3}));
                Matrix spVert3T = Matrices$.MODULE$.vertcat((Matrix[])((Object[])new Matrix[]{deMat1TT, spMat3}));
                Bool $org_scalatest_assert_macro_expr55 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(deVert1T).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(deVert1).absTol(1.0E-15)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(deVert1T).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(deVert1).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr55, (Object)"");
                Bool $org_scalatest_assert_macro_expr56 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spVertT).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spVert).absTol(1.0E-15)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spVertT).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spVert).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr56, (Object)"");
                Bool $org_scalatest_assert_macro_expr57 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spVert2T).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spVert2).absTol(1.0E-15)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spVert2T).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spVert2).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr57, (Object)"");
                Bool $org_scalatest_assert_macro_expr58 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spVert3T).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spVert3).absTol(1.0E-15)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spVert3T).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(spVert3).absTol(1.0E-15))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr58, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, spMat1, spMat2){
                    public static final long serialVersionUID = 0L;
                    private final SparseMatrix spMat1$1;
                    private final Matrix spMat2$1;

                    public final Matrix apply() {
                        return Matrices$.MODULE$.vertcat((Matrix[])((Object[])new Matrix[]{this.spMat1$1, this.spMat2$1}));
                    }
                    {
                        this.spMat1$1 = spMat1$1;
                        this.spMat2$1 = spMat2$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this, deMat1, spMat2){
                    public static final long serialVersionUID = 0L;
                    private final DenseMatrix deMat1$1;
                    private final Matrix spMat2$1;

                    public final Matrix apply() {
                        return Matrices$.MODULE$.vertcat((Matrix[])((Object[])new Matrix[]{this.deMat1$1, this.spMat2$1}));
                    }
                    {
                        this.deMat1$1 = deMat1$1;
                        this.spMat2$1 = spMat2$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("zeros", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatricesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DenseMatrix mat = (DenseMatrix)Matrices$.MODULE$.zeros(2, 3);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numRows()));
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numCols()));
                int $org_scalatest_assert_macro_right2 = 3;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.doubleArrayOps(mat.values()).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(double x$5) {
                        return this.apply$mcZD$sp(x$5);
                    }

                    public boolean apply$mcZD$sp(double x$5) {
                        return x$5 == 0.0;
                    }
                }), "scala.this.Predef.doubleArrayOps(mat.values).forall(((x$5: Double) => x$5.==(0.0)))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("ones", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatricesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DenseMatrix mat = (DenseMatrix)Matrices$.MODULE$.ones(2, 3);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numRows()));
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numCols()));
                int $org_scalatest_assert_macro_right2 = 3;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.doubleArrayOps(mat.values()).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(double x$6) {
                        return this.apply$mcZD$sp(x$6);
                    }

                    public boolean apply$mcZD$sp(double x$6) {
                        return x$6 == 1.0;
                    }
                }), "scala.this.Predef.doubleArrayOps(mat.values).forall(((x$6: Double) => x$6.==(1.0)))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("eye", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatricesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DenseMatrix mat = (DenseMatrix)Matrices$.MODULE$.eye(2);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numCols()));
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numCols()));
                int $org_scalatest_assert_macro_right2 = 2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(Predef$.MODULE$.doubleArrayOps(mat.values()).toSeq());
                Seq $org_scalatest_assert_macro_right3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 0.0, 0.0, 1.0}));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rand", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatricesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Random rng = (Random)MockitoSugar$.MODULE$.mock(ManifestFactory$.MODULE$.classType(Random.class));
                Mockito.when((Object)BoxesRunTime.boxToDouble((double)rng.nextDouble())).thenReturn((Object)BoxesRunTime.boxToDouble((double)1.0), ScalaRunTime$.MODULE$.toObjectArray((Object)new double[]{2.0, 3.0, 4.0}));
                DenseMatrix mat = (DenseMatrix)Matrices$.MODULE$.rand(2, 2, rng);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numRows()));
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numCols()));
                int $org_scalatest_assert_macro_right2 = 2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(Predef$.MODULE$.doubleArrayOps(mat.values()).toSeq());
                Seq $org_scalatest_assert_macro_right3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0, 3.0, 4.0}));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("randn", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatricesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Random rng = (Random)MockitoSugar$.MODULE$.mock(ManifestFactory$.MODULE$.classType(Random.class));
                Mockito.when((Object)BoxesRunTime.boxToDouble((double)rng.nextGaussian())).thenReturn((Object)BoxesRunTime.boxToDouble((double)1.0), ScalaRunTime$.MODULE$.toObjectArray((Object)new double[]{2.0, 3.0, 4.0}));
                DenseMatrix mat = (DenseMatrix)Matrices$.MODULE$.randn(2, 2, rng);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numRows()));
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numCols()));
                int $org_scalatest_assert_macro_right2 = 2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(Predef$.MODULE$.doubleArrayOps(mat.values()).toSeq());
                Seq $org_scalatest_assert_macro_right3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0, 3.0, 4.0}));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("diag", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatricesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DenseMatrix mat = (DenseMatrix)Matrices$.MODULE$.diag(Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0})));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numRows()));
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numCols()));
                int $org_scalatest_assert_macro_right2 = 2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(Predef$.MODULE$.doubleArrayOps(mat.values()).toSeq());
                Seq $org_scalatest_assert_macro_right3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 0.0, 0.0, 2.0}));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("sprand", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatricesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Random rng = (Random)MockitoSugar$.MODULE$.mock(ManifestFactory$.MODULE$.classType(Random.class));
                Mockito.when((Object)BoxesRunTime.boxToInteger((int)rng.nextInt(4))).thenReturn((Object)BoxesRunTime.boxToInteger((int)0), ScalaRunTime$.MODULE$.toObjectArray((Object)new int[]{1, 1, 3, 2, 2, 0, 1, 3, 0}));
                Mockito.when((Object)BoxesRunTime.boxToDouble((double)rng.nextDouble())).thenReturn((Object)BoxesRunTime.boxToDouble((double)1.0), ScalaRunTime$.MODULE$.toObjectArray((Object)new double[]{2.0, 3.0, 4.0, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0}));
                SparseMatrix mat = SparseMatrix$.MODULE$.sprand(4, 4, 0.25, rng);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numRows()));
                int $org_scalatest_assert_macro_right = 4;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numCols()));
                int $org_scalatest_assert_macro_right2 = 4;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(Predef$.MODULE$.intArrayOps(mat.rowIndices()).toSeq());
                Seq $org_scalatest_assert_macro_right3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 2, 1}));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(Predef$.MODULE$.doubleArrayOps(mat.values()).toSeq());
                Seq $org_scalatest_assert_macro_right4 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0, 3.0, 4.0}));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                SparseMatrix mat2 = SparseMatrix$.MODULE$.sprand(2, 3, 1.0, rng);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(Predef$.MODULE$.intArrayOps(mat2.rowIndices()).toSeq());
                Seq $org_scalatest_assert_macro_right5 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 0, 1, 0, 1}));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(Predef$.MODULE$.intArrayOps(mat2.colPtrs()).toSeq());
                Seq $org_scalatest_assert_macro_right6 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 4, 6}));
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("sprandn", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatricesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Random rng = (Random)MockitoSugar$.MODULE$.mock(ManifestFactory$.MODULE$.classType(Random.class));
                Mockito.when((Object)BoxesRunTime.boxToInteger((int)rng.nextInt(4))).thenReturn((Object)BoxesRunTime.boxToInteger((int)0), ScalaRunTime$.MODULE$.toObjectArray((Object)new int[]{1, 1, 3, 2, 2, 0, 1, 3, 0}));
                Mockito.when((Object)BoxesRunTime.boxToDouble((double)rng.nextGaussian())).thenReturn((Object)BoxesRunTime.boxToDouble((double)1.0), ScalaRunTime$.MODULE$.toObjectArray((Object)new double[]{2.0, 3.0, 4.0}));
                SparseMatrix mat = SparseMatrix$.MODULE$.sprandn(4, 4, 0.25, rng);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numRows()));
                int $org_scalatest_assert_macro_right = 4;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numCols()));
                int $org_scalatest_assert_macro_right2 = 4;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(Predef$.MODULE$.intArrayOps(mat.rowIndices()).toSeq());
                Seq $org_scalatest_assert_macro_right3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 2, 1}));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(Predef$.MODULE$.doubleArrayOps(mat.values()).toSeq());
                Seq $org_scalatest_assert_macro_right4 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0, 3.0, 4.0}));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("MatrixUDT", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatricesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DenseMatrix dm1 = new DenseMatrix(2, 2, new double[]{0.9, 1.2, 2.3, 9.8});
                DenseMatrix dm2 = new DenseMatrix(3, 2, new double[]{0.0, 1.21, 2.3, 9.8, 9.0, 0.0});
                DenseMatrix dm3 = new DenseMatrix(0, 0, (double[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Double()));
                SparseMatrix sm1 = dm1.toSparse();
                SparseMatrix sm2 = dm2.toSparse();
                SparseMatrix sm3 = dm3.toSparse();
                MatrixUDT mUDT = new MatrixUDT();
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Matrix[]{dm1, dm2, dm3, sm1, sm2, sm3}))).foreach((Function1)new Serializable(this, mUDT){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$26 $outer;
                    private final MatrixUDT mUDT$1;

                    public final void apply(Matrix mat) {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$linalg$MatricesSuite$$anonfun$$$outer().convertToEqualizer(mat.toArray());
                        double[] $org_scalatest_assert_macro_right = this.mUDT$1.deserialize((Object)this.mUDT$1.serialize((Object)mat)).toArray();
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$linalg$MatricesSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.mUDT$1 = mUDT$1;
                    }
                });
                String $org_scalatest_assert_macro_left = mUDT.typeName();
                String $org_scalatest_assert_macro_right = "matrix";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                String $org_scalatest_assert_macro_left2 = mUDT.simpleString();
                String $org_scalatest_assert_macro_right2 = "matrix";
                String string3 = $org_scalatest_assert_macro_left2;
                String string4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }

            public /* synthetic */ MatricesSuite org$apache$spark$mllib$linalg$MatricesSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("toString", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatricesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Matrix empty = Matrices$.MODULE$.ones(0, 0);
                empty.toString(0, 0);
                Matrix mat = Matrices$.MODULE$.rand(5, 10, new Random());
                mat.toString(-1, -5);
                mat.toString(0, 0);
                mat.toString(Integer.MIN_VALUE, Integer.MIN_VALUE);
                mat.toString(Integer.MAX_VALUE, Integer.MAX_VALUE);
                String[] lines = (String[])new StringOps(Predef$.MODULE$.augmentString(mat.toString(6, 50))).lines().toArray(ClassTag$.MODULE$.apply(String.class));
                ArrayOps $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])lines);
                int $org_scalatest_assert_macro_right = 5;
                Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (long)$org_scalatest_assert_macro_left.size(), (long)$org_scalatest_assert_macro_right);
                Bool $org_scalatest_assert_macro_right2 = $org_scalatest_assert_macro_left2.value() ? Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])lines).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x$7) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$7)).size() <= 50;
                    }
                }), "scala.this.Predef.refArrayOps[String](lines).forall(((x$7: String) => scala.this.Predef.augmentString(x$7).size.<=(50)))") : Bool$.MODULE$.simpleMacroBool(false, "");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$amp$amp($org_scalatest_assert_macro_right2));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                lines = (String[])new StringOps(Predef$.MODULE$.augmentString(mat.toString(5, 100))).lines().toArray(ClassTag$.MODULE$.apply(String.class));
                ArrayOps $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])lines);
                int $org_scalatest_assert_macro_right3 = 5;
                Bool $org_scalatest_assert_macro_left4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (long)$org_scalatest_assert_macro_left3.size(), (long)$org_scalatest_assert_macro_right3);
                Bool $org_scalatest_assert_macro_right4 = $org_scalatest_assert_macro_left4.value() ? Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])lines).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x$8) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$8)).size() <= 100;
                    }
                }), "scala.this.Predef.refArrayOps[String](lines).forall(((x$8: String) => scala.this.Predef.augmentString(x$8).size.<=(100)))") : Bool$.MODULE$.simpleMacroBool(false, "");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "&&", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$amp$amp($org_scalatest_assert_macro_right4));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("numNonzeros and numActives", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatricesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Matrix dm1 = Matrices$.MODULE$.dense(3, 2, new double[]{0.0, 0.0, -1.0, 1.0, 0.0, 1.0});
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)dm1.numNonzeros()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)dm1.numActives()));
                int $org_scalatest_assert_macro_right2 = 6;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Matrix sm1 = Matrices$.MODULE$.sparse(3, 2, new int[]{0, 2, 3}, new int[]{0, 2, 1}, new double[]{0.0, -1.2, 0.0});
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)sm1.numNonzeros()));
                int $org_scalatest_assert_macro_right3 = 1;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)sm1.numActives()));
                int $org_scalatest_assert_macro_right4 = 3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

