/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg.distributed;

import breeze.linalg.support.LiteralRow$;
import breeze.storage.Zero;
import java.util.Random;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.DenseMatrix$;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SparseMatrix;
import org.apache.spark.mllib.linalg.SparseMatrix$;
import org.apache.spark.mllib.linalg.distributed.BlockMatrix;
import org.apache.spark.mllib.linalg.distributed.BlockMatrixSuite$;
import org.apache.spark.mllib.linalg.distributed.BlockMatrixSuite$$anonfun$2$;
import org.apache.spark.mllib.linalg.distributed.CoordinateMatrix;
import org.apache.spark.mllib.linalg.distributed.GridPartitioner;
import org.apache.spark.mllib.linalg.distributed.GridPartitioner$;
import org.apache.spark.mllib.linalg.distributed.IndexedRowMatrix;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.mllib.util.TestingUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SQLContext;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u000153A!\u0001\u0002\u0001\u001f\t\u0001\"\t\\8dW6\u000bGO]5y'VLG/\u001a\u0006\u0003\u0007\u0011\t1\u0002Z5tiJL'-\u001e;fI*\u0011QAB\u0001\u0007Y&t\u0017\r\\4\u000b\u0005\u001dA\u0011!B7mY&\u0014'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0005\u000b\u0011\u0005E\u0011R\"\u0001\u0005\n\u0005MA!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u001615\taC\u0003\u0002\u0018\r\u0005!Q\u000f^5m\u0013\tIbCA\u000bN\u00192L'\rV3tiN\u0003\u0018M]6D_:$X\r\u001f;\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001b\u0002\u0011\u0001\u0005\u0004%\t!I\u0001\u0002[V\t!\u0005\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CEA\u0002J]RDa!\u000b\u0001!\u0002\u0013\u0011\u0013AA7!\u0011\u001dY\u0003A1A\u0005\u0002\u0005\n\u0011A\u001c\u0005\u0007[\u0001\u0001\u000b\u0011\u0002\u0012\u0002\u00059\u0004\u0003bB\u0018\u0001\u0005\u0004%\t!I\u0001\u000be><\b+\u001a:QCJ$\bBB\u0019\u0001A\u0003%!%A\u0006s_^\u0004VM\u001d)beR\u0004\u0003bB\u001a\u0001\u0005\u0004%\t!I\u0001\u000bG>d\u0007+\u001a:QCJ$\bBB\u001b\u0001A\u0003%!%A\u0006d_2\u0004VM\u001d)beR\u0004\u0003bB\u001c\u0001\u0005\u0004%\t!I\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\t\re\u0002\u0001\u0015!\u0003#\u00039qW/\u001c)beRLG/[8og\u0002B\u0011b\u000f\u0001A\u0002\u0003\u0007I\u0011\u0001\u001f\u0002\u0019\u001d\u0014\u0018\u000e\u001a\"bg\u0016$W*\u0019;\u0016\u0003u\u0002\"A\b \n\u0005}\u0012!a\u0003\"m_\u000e\\W*\u0019;sSbD\u0011\"\u0011\u0001A\u0002\u0003\u0007I\u0011\u0001\"\u0002!\u001d\u0014\u0018\u000e\u001a\"bg\u0016$W*\u0019;`I\u0015\fHCA\"G!\t\u0019C)\u0003\u0002FI\t!QK\\5u\u0011\u001d9\u0005)!AA\u0002u\n1\u0001\u001f\u00132\u0011\u0019I\u0005\u0001)Q\u0005{\u0005iqM]5e\u0005\u0006\u001cX\rZ'bi\u0002BQa\u0013\u0001\u0005B1\u000b\u0011BY3g_J,\u0017\t\u001c7\u0015\u0003\r\u0003")
public class BlockMatrixSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private final int m;
    private final int n;
    private final int rowPerPart;
    private final int colPerPart;
    private final int numPartitions;
    private BlockMatrix gridBasedMat;
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public int m() {
        return this.m;
    }

    public int n() {
        return this.n;
    }

    public int rowPerPart() {
        return this.rowPerPart;
    }

    public int colPerPart() {
        return this.colPerPart;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public BlockMatrix gridBasedMat() {
        return this.gridBasedMat;
    }

    public void gridBasedMat_$eq(BlockMatrix x$1) {
        this.gridBasedMat = x$1;
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
        Seq blocks = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Tuple2.mcII.sp(0, 0), (Object)new DenseMatrix(2, 2, new double[]{1.0, 0.0, 0.0, 2.0})), new Tuple2((Object)new Tuple2.mcII.sp(0, 1), (Object)new DenseMatrix(2, 2, new double[]{0.0, 1.0, 0.0, 0.0})), new Tuple2((Object)new Tuple2.mcII.sp(1, 0), (Object)new DenseMatrix(2, 2, new double[]{3.0, 0.0, 1.0, 1.0})), new Tuple2((Object)new Tuple2.mcII.sp(1, 1), (Object)new DenseMatrix(2, 2, new double[]{1.0, 2.0, 0.0, 1.0})), new Tuple2((Object)new Tuple2.mcII.sp(2, 1), (Object)new DenseMatrix(1, 2, new double[]{1.0, 5.0}))}));
        this.gridBasedMat_$eq(new BlockMatrix(this.sc().parallelize(blocks, this.numPartitions(), ClassTag$.MODULE$.apply(Tuple2.class)), this.rowPerPart(), this.colPerPart()));
    }

    public BlockMatrixSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        this.m = 5;
        this.n = 4;
        this.rowPerPart = 2;
        this.colPerPart = 2;
        this.numPartitions = 3;
        this.test("size", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)this.$outer.gridBasedMat().numRows()));
                int $org_scalatest_assert_macro_right = this.$outer.m();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)this.$outer.gridBasedMat().numCols()));
                int $org_scalatest_assert_macro_right2 = this.$outer.n();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("grid partitioner", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Random random = new Random();
                GridPartitioner part0 = GridPartitioner$.MODULE$.apply(4, 7, 12);
                int[][] expected0 = (int[][])((Object[])new int[][]{{0, 0, 4, 4, 8, 8, 12}, {1, 1, 5, 5, 9, 9, 13}, {2, 2, 6, 6, 10, 10, 14}, {3, 3, 7, 7, 11, 11, 15}});
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).foreach$mVc$sp((Function1)new Serializable(this, random, part0, expected0){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;
                    public final Random random$1;
                    public final GridPartitioner part0$1;
                    public final int[][] expected0$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 7).foreach$mVc$sp((Function1)new Serializable(this, i){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$2$$anonfun$apply$mcV$sp$1 $outer;
                            private final int i$1;

                            public final void apply(int j) {
                                this.apply$mcVI$sp(j);
                            }

                            public void apply$mcVI$sp(int j) {
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)this.$outer.part0$1.getPartition((Object)new Tuple2.mcII.sp(this.i$1, j))));
                                int $org_scalatest_assert_macro_right = this.$outer.expected0$1[this.i$1][j];
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)this.$outer.part0$1.getPartition((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)this.i$1), (Object)BoxesRunTime.boxToInteger((int)j), (Object)BoxesRunTime.boxToInteger((int)this.$outer.random$1.nextInt())))));
                                int $org_scalatest_assert_macro_right2 = this.$outer.expected0$1[this.i$1][j];
                                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.i$1 = i$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$2 org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.random$1 = random$1;
                        this.part0$1 = part0$1;
                        this.expected0$1 = expected0$1;
                    }
                });
                this.$outer.intercept((Function0)new Serializable(this, part0){
                    public static final long serialVersionUID = 0L;
                    private final GridPartitioner part0$1;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return this.part0$1.getPartition((Object)new Tuple2.mcII.sp(-1, 0));
                    }
                    {
                        this.part0$1 = part0$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this, part0){
                    public static final long serialVersionUID = 0L;
                    private final GridPartitioner part0$1;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return this.part0$1.getPartition((Object)new Tuple2.mcII.sp(4, 0));
                    }
                    {
                        this.part0$1 = part0$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this, part0){
                    public static final long serialVersionUID = 0L;
                    private final GridPartitioner part0$1;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return this.part0$1.getPartition((Object)new Tuple2.mcII.sp(0, -1));
                    }
                    {
                        this.part0$1 = part0$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this, part0){
                    public static final long serialVersionUID = 0L;
                    private final GridPartitioner part0$1;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return this.part0$1.getPartition((Object)new Tuple2.mcII.sp(0, 7));
                    }
                    {
                        this.part0$1 = part0$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                GridPartitioner part1 = GridPartitioner$.MODULE$.apply(2, 2, 5);
                int[][] expected1 = (int[][])((Object[])new int[][]{{0, 2}, {1, 3}});
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)new Serializable(this, random, part1, expected1){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;
                    public final Random random$1;
                    public final GridPartitioner part1$1;
                    public final int[][] expected1$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)new Serializable(this, i){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$2$$anonfun$apply$mcV$sp$6 $outer;
                            private final int i$2;

                            public final void apply(int j) {
                                this.apply$mcVI$sp(j);
                            }

                            public void apply$mcVI$sp(int j) {
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)this.$outer.part1$1.getPartition((Object)new Tuple2.mcII.sp(this.i$2, j))));
                                int $org_scalatest_assert_macro_right = this.$outer.expected1$1[this.i$2][j];
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)this.$outer.part1$1.getPartition((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)this.i$2), (Object)BoxesRunTime.boxToInteger((int)j), (Object)BoxesRunTime.boxToInteger((int)this.$outer.random$1.nextInt())))));
                                int $org_scalatest_assert_macro_right2 = this.$outer.expected1$1[this.i$2][j];
                                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.i$2 = i$2;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$2 org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.random$1 = random$1;
                        this.part1$1 = part1$1;
                        this.expected1$1 = expected1$1;
                    }
                });
                GridPartitioner part2 = GridPartitioner$.MODULE$.apply(2, 2, 5);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(part0);
                GridPartitioner $org_scalatest_assert_macro_right = part2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!==", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$bang$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(part1);
                GridPartitioner $org_scalatest_assert_macro_right2 = part2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                GridPartitioner part3 = new GridPartitioner(2, 3, 1, 2);
                int[][] expected3 = (int[][])((Object[])new int[][]{{0, 0, 2}, {1, 1, 3}});
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)new Serializable(this, random, part3, expected3){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;
                    public final Random random$1;
                    public final GridPartitioner part3$1;
                    public final int[][] expected3$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)new Serializable(this, i){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$2$$anonfun$apply$mcV$sp$7 $outer;
                            private final int i$3;

                            public final void apply(int j) {
                                this.apply$mcVI$sp(j);
                            }

                            public void apply$mcVI$sp(int j) {
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)this.$outer.part3$1.getPartition((Object)new Tuple2.mcII.sp(this.i$3, j))));
                                int $org_scalatest_assert_macro_right = this.$outer.expected3$1[this.i$3][j];
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)this.$outer.part3$1.getPartition((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)this.i$3), (Object)BoxesRunTime.boxToInteger((int)j), (Object)BoxesRunTime.boxToInteger((int)this.$outer.random$1.nextInt())))));
                                int $org_scalatest_assert_macro_right2 = this.$outer.expected3$1[this.i$3][j];
                                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.i$3 = i$3;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$2 org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.random$1 = random$1;
                        this.part3$1 = part3$1;
                        this.expected3$1 = expected3$1;
                    }
                });
                GridPartitioner part4 = GridPartitioner$.MODULE$.apply(2, 3, 1, 2);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(part3);
                GridPartitioner $org_scalatest_assert_macro_right3 = part4;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final GridPartitioner apply() {
                        return new GridPartitioner(2, 2, 0, 1);
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final GridPartitioner apply() {
                        return GridPartitioner$.MODULE$.apply(2, 2, 1, 0);
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final GridPartitioner apply() {
                        return GridPartitioner$.MODULE$.apply(2, 2, 0);
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }

            public /* synthetic */ BlockMatrixSuite org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("toCoordinateMatrix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                CoordinateMatrix coordMat = this.$outer.gridBasedMat().toCoordinateMatrix();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)coordMat.numRows()));
                int $org_scalatest_assert_macro_right = this.$outer.m();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)coordMat.numCols()));
                int $org_scalatest_assert_macro_right2 = this.$outer.n();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(coordMat.toBreeze());
                breeze.linalg.DenseMatrix $org_scalatest_assert_macro_right3 = this.$outer.gridBasedMat().toBreeze();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("toIndexedRowMatrix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IndexedRowMatrix rowMat = this.$outer.gridBasedMat().toIndexedRowMatrix();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rowMat.numRows()));
                int $org_scalatest_assert_macro_right = this.$outer.m();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rowMat.numCols()));
                int $org_scalatest_assert_macro_right2 = this.$outer.n();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(rowMat.toBreeze());
                breeze.linalg.DenseMatrix $org_scalatest_assert_macro_right3 = this.$outer.gridBasedMat().toBreeze();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("toBreeze and toLocalMatrix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                breeze.linalg.DenseMatrix expected = (breeze.linalg.DenseMatrix)breeze.linalg.DenseMatrix$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)3.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)5.0))}), LiteralRow$.MODULE$.tuple4(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                DenseMatrix dense = (DenseMatrix)Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix)expected);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.gridBasedMat().toLocalMatrix());
                DenseMatrix $org_scalatest_assert_macro_right = dense;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(this.$outer.gridBasedMat().toBreeze());
                breeze.linalg.DenseMatrix $org_scalatest_assert_macro_right2 = expected;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("add", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq blocks = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Tuple2.mcII.sp(0, 0), (Object)new DenseMatrix(2, 2, new double[]{1.0, 0.0, 0.0, 2.0})), new Tuple2((Object)new Tuple2.mcII.sp(0, 1), (Object)new DenseMatrix(2, 2, new double[]{0.0, 1.0, 0.0, 0.0})), new Tuple2((Object)new Tuple2.mcII.sp(1, 0), (Object)new DenseMatrix(2, 2, new double[]{3.0, 0.0, 1.0, 1.0})), new Tuple2((Object)new Tuple2.mcII.sp(1, 1), (Object)new DenseMatrix(2, 2, new double[]{1.0, 2.0, 0.0, 1.0})), new Tuple2((Object)new Tuple2.mcII.sp(2, 0), (Object)new DenseMatrix(1, 2, new double[]{1.0, 0.0})), new Tuple2((Object)new Tuple2.mcII.sp(2, 1), (Object)new DenseMatrix(1, 2, new double[]{1.0, 5.0}))}));
                RDD rdd = this.$outer.sc().parallelize(blocks, this.$outer.numPartitions(), ClassTag$.MODULE$.apply(Tuple2.class));
                BlockMatrix B = new BlockMatrix(rdd, this.$outer.rowPerPart(), this.$outer.colPerPart());
                breeze.linalg.DenseMatrix expected = (breeze.linalg.DenseMatrix)breeze.linalg.DenseMatrix$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToDouble((double)2.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)4.0), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)6.0), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)BoxesRunTime.boxToDouble((double)4.0), (Object)BoxesRunTime.boxToDouble((double)2.0)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)BoxesRunTime.boxToDouble((double)10.0))}), LiteralRow$.MODULE$.tuple4(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                BlockMatrix AplusB = this.$outer.gridBasedMat().add(B);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)AplusB.numRows()));
                int $org_scalatest_assert_macro_right = this.$outer.m();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)AplusB.numCols()));
                long $org_scalatest_assert_macro_right2 = B.numCols();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(AplusB.toBreeze());
                breeze.linalg.DenseMatrix $org_scalatest_assert_macro_right3 = expected;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                BlockMatrix C = new BlockMatrix(rdd, this.$outer.rowPerPart(), this.$outer.colPerPart(), (long)this.$outer.m(), (long)(this.$outer.n() + 1));
                this.$outer.intercept((Function0)new Serializable(this, C){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;
                    private final BlockMatrix C$1;

                    public final BlockMatrix apply() {
                        return this.$outer.org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$$outer().gridBasedMat().add(this.C$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.C$1 = C$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                Seq largerBlocks = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Tuple2.mcII.sp(0, 0), (Object)new DenseMatrix(4, 4, new double[16])), new Tuple2((Object)new Tuple2.mcII.sp(1, 0), (Object)new DenseMatrix(1, 4, new double[]{1.0, 0.0, 1.0, 5.0}))}));
                BlockMatrix C2 = new BlockMatrix(this.$outer.sc().parallelize(largerBlocks, this.$outer.numPartitions(), ClassTag$.MODULE$.apply(Tuple2.class)), 4, 4, (long)this.$outer.m(), (long)this.$outer.n());
                this.$outer.intercept((Function0)new Serializable(this, C2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;
                    private final BlockMatrix C2$1;

                    public final BlockMatrix apply() {
                        return this.$outer.org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$$outer().gridBasedMat().add(this.C2$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.C2$1 = C2$1;
                    }
                }, ManifestFactory$.MODULE$.classType(SparkException.class));
                IndexedSeq sparseBlocks = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Tuple2<Object, Object>, SparseMatrix> apply(int i) {
                        return new Tuple2((Object)new Tuple2.mcII.sp(i / 2, i % 2), (Object)SparseMatrix$.MODULE$.speye(4));
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                IndexedSeq denseBlocks = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Tuple2<Object, Object>, DenseMatrix> apply(int i) {
                        return new Tuple2((Object)new Tuple2.mcII.sp(i / 2, i % 2), (Object)DenseMatrix$.MODULE$.eye(4));
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                BlockMatrix sparseBM = new BlockMatrix(this.$outer.sc().makeRDD((Seq)sparseBlocks, 4, ClassTag$.MODULE$.apply(Tuple2.class)), 4, 4, 8L, 8L);
                BlockMatrix denseBM = new BlockMatrix(this.$outer.sc().makeRDD((Seq)denseBlocks, 4, ClassTag$.MODULE$.apply(Tuple2.class)), 4, 4, 8L, 8L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(sparseBM.add(sparseBM).toBreeze());
                breeze.linalg.DenseMatrix $org_scalatest_assert_macro_right4 = sparseBM.add(denseBM).toBreeze();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }

            public /* synthetic */ BlockMatrixSuite org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("multiply", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq blocks = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Tuple2.mcII.sp(0, 0), (Object)new DenseMatrix(2, 2, new double[]{1.0, 0.0, 0.0, 1.0})), new Tuple2((Object)new Tuple2.mcII.sp(1, 1), (Object)new DenseMatrix(2, 2, new double[]{1.0, 0.0, 0.0, 1.0}))}));
                RDD rdd = this.$outer.sc().parallelize(blocks, 2, ClassTag$.MODULE$.apply(Tuple2.class));
                BlockMatrix B = new BlockMatrix(rdd, this.$outer.colPerPart(), this.$outer.rowPerPart());
                breeze.linalg.DenseMatrix expected = (breeze.linalg.DenseMatrix)breeze.linalg.DenseMatrix$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)3.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)5.0))}), LiteralRow$.MODULE$.tuple4(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                BlockMatrix AtimesB = this.$outer.gridBasedMat().multiply(B);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)AtimesB.numRows()));
                int $org_scalatest_assert_macro_right = this.$outer.m();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)AtimesB.numCols()));
                int $org_scalatest_assert_macro_right2 = this.$outer.n();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(AtimesB.toBreeze());
                breeze.linalg.DenseMatrix $org_scalatest_assert_macro_right3 = expected;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                BlockMatrix C = new BlockMatrix(rdd, this.$outer.rowPerPart(), this.$outer.colPerPart(), (long)(this.$outer.m() + 1), (long)this.$outer.n());
                this.$outer.intercept((Function0)new Serializable(this, C){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;
                    private final BlockMatrix C$2;

                    public final BlockMatrix apply() {
                        return this.$outer.org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$$outer().gridBasedMat().multiply(this.C$2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.C$2 = C$2;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                Seq largerBlocks = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Tuple2.mcII.sp(0, 0), (Object)DenseMatrix$.MODULE$.eye(4))}));
                BlockMatrix C2 = new BlockMatrix(this.$outer.sc().parallelize(largerBlocks, this.$outer.numPartitions(), ClassTag$.MODULE$.apply(Tuple2.class)), 4, 4);
                this.$outer.intercept((Function0)new Serializable(this, C2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;
                    private final BlockMatrix C2$2;

                    public final BlockMatrix apply() {
                        return this.$outer.org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$$outer().gridBasedMat().multiply(this.C2$2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.C2$2 = C2$2;
                    }
                }, ManifestFactory$.MODULE$.classType(SparkException.class));
                Random rand = new Random(42L);
                IndexedSeq largerAblocks = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 20).map((Function1)new Serializable(this, rand){
                    public static final long serialVersionUID = 0L;
                    private final Random rand$1;

                    public final Tuple2<Tuple2<Object, Object>, DenseMatrix> apply(int i) {
                        return new Tuple2((Object)new Tuple2.mcII.sp(i % 5, i / 5), (Object)DenseMatrix$.MODULE$.rand(6, 4, this.rand$1));
                    }
                    {
                        this.rand$1 = rand$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                IndexedSeq largerBblocks = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 16).map((Function1)new Serializable(this, rand){
                    public static final long serialVersionUID = 0L;
                    private final Random rand$1;

                    public final Tuple2<Tuple2<Object, Object>, DenseMatrix> apply(int i) {
                        return new Tuple2((Object)new Tuple2.mcII.sp(i % 4, i / 4), (Object)DenseMatrix$.MODULE$.rand(4, 4, this.rand$1));
                    }
                    {
                        this.rand$1 = rand$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                BlockMatrix largeA = new BlockMatrix(this.$outer.sc().parallelize((Seq)largerAblocks, 10, ClassTag$.MODULE$.apply(Tuple2.class)), 6, 4);
                BlockMatrix largeB = new BlockMatrix(this.$outer.sc().parallelize((Seq)largerBblocks, 8, ClassTag$.MODULE$.apply(Tuple2.class)), 4, 4);
                BlockMatrix largeC = largeA.multiply(largeB);
                Matrix localC = largeC.toLocalMatrix();
                DenseMatrix result = largeA.toLocalMatrix().multiply((DenseMatrix)largeB.toLocalMatrix());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)largeC.numRows()));
                long $org_scalatest_assert_macro_right4 = largeA.numRows();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)largeC.numCols()));
                long $org_scalatest_assert_macro_right5 = largeB.numCols();
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(localC).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)result).absTol(1.0E-8)), "org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(localC).~==(org.apache.spark.mllib.util.TestingUtils.MatrixWithAlmostEquals(result).absTol(1.0E-8))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }

            public /* synthetic */ BlockMatrixSuite org$apache$spark$mllib$linalg$distributed$BlockMatrixSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("simulate multiply", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq blocks = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Tuple2.mcII.sp(0, 0), (Object)new DenseMatrix(2, 2, new double[]{1.0, 0.0, 0.0, 1.0})), new Tuple2((Object)new Tuple2.mcII.sp(1, 1), (Object)new DenseMatrix(2, 2, new double[]{1.0, 0.0, 0.0, 1.0}))}));
                RDD rdd = this.$outer.sc().parallelize(blocks, 2, ClassTag$.MODULE$.apply(Tuple2.class));
                BlockMatrix B = new BlockMatrix(rdd, this.$outer.colPerPart(), this.$outer.rowPerPart());
                GridPartitioner resultPartitioner = GridPartitioner$.MODULE$.apply(this.$outer.gridBasedMat().numRowBlocks(), B.numColBlocks(), package$.MODULE$.max(this.$outer.numPartitions(), 2));
                Tuple2 tuple2 = this.$outer.gridBasedMat().simulateMultiply(B, resultPartitioner);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    Map destinationsA = (Map)tuple2._1();
                    Map destinationsB = (Map)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)destinationsA, (Object)destinationsB);
                    Map destinationsA2 = (Map)tuple23._1();
                    Map destinationsB2 = (Map)tuple23._2();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(destinationsA2.apply((Object)new Tuple2.mcII.sp(0, 0)));
                    Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(destinationsA2.apply((Object)new Tuple2.mcII.sp(0, 1)));
                    Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(destinationsA2.apply((Object)new Tuple2.mcII.sp(1, 0)));
                    Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(destinationsA2.apply((Object)new Tuple2.mcII.sp(1, 1)));
                    Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}));
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(destinationsA2.apply((Object)new Tuple2.mcII.sp(2, 1)));
                    Set $org_scalatest_assert_macro_right5 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3}));
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(destinationsB2.apply((Object)new Tuple2.mcII.sp(0, 0)));
                    Set $org_scalatest_assert_macro_right6 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}));
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(destinationsB2.apply((Object)new Tuple2.mcII.sp(1, 1)));
                    Set $org_scalatest_assert_macro_right7 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}));
                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                    return;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("validate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.gridBasedMat().validate();
                Seq blocks = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Tuple2.mcII.sp(0, 0), (Object)new DenseMatrix(2, 2, new double[]{1.0, 0.0, 0.0, 2.0})), new Tuple2((Object)new Tuple2.mcII.sp(0, 1), (Object)new DenseMatrix(2, 2, new double[]{0.0, 1.0, 0.0, 0.0})), new Tuple2((Object)new Tuple2.mcII.sp(1, 0), (Object)new DenseMatrix(2, 2, new double[]{3.0, 0.0, 1.0, 1.0})), new Tuple2((Object)new Tuple2.mcII.sp(1, 1), (Object)new DenseMatrix(2, 2, new double[]{1.0, 2.0, 0.0, 1.0})), new Tuple2((Object)new Tuple2.mcII.sp(2, 1), (Object)new DenseMatrix(1, 2, new double[]{1.0, 5.0}))}));
                RDD rdd = this.$outer.sc().parallelize(blocks, this.$outer.numPartitions(), ClassTag$.MODULE$.apply(Tuple2.class));
                BlockMatrix wrongRowPerParts = new BlockMatrix(rdd, this.$outer.rowPerPart() + 1, this.$outer.colPerPart());
                BlockMatrix wrongColPerParts = new BlockMatrix(rdd, this.$outer.rowPerPart(), this.$outer.colPerPart() + 1);
                this.$outer.intercept((Function0)new Serializable(this, wrongRowPerParts){
                    public static final long serialVersionUID = 0L;
                    private final BlockMatrix wrongRowPerParts$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.wrongRowPerParts$1.validate();
                    }
                    {
                        this.wrongRowPerParts$1 = wrongRowPerParts$1;
                    }
                }, ManifestFactory$.MODULE$.classType(SparkException.class));
                this.$outer.intercept((Function0)new Serializable(this, wrongColPerParts){
                    public static final long serialVersionUID = 0L;
                    private final BlockMatrix wrongColPerParts$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.wrongColPerParts$1.validate();
                    }
                    {
                        this.wrongColPerParts$1 = wrongColPerParts$1;
                    }
                }, ManifestFactory$.MODULE$.classType(SparkException.class));
                BlockMatrix wrongRowSize = new BlockMatrix(rdd, this.$outer.rowPerPart(), this.$outer.colPerPart(), 4L, 4L);
                this.$outer.intercept((Function0)new Serializable(this, wrongRowSize){
                    public static final long serialVersionUID = 0L;
                    private final BlockMatrix wrongRowSize$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.wrongRowSize$1.validate();
                    }
                    {
                        this.wrongRowSize$1 = wrongRowSize$1;
                    }
                }, ManifestFactory$.MODULE$.classType(AssertionError.class));
                BlockMatrix wrongColSize = new BlockMatrix(rdd, this.$outer.rowPerPart(), this.$outer.colPerPart(), 5L, 2L);
                this.$outer.intercept((Function0)new Serializable(this, wrongColSize){
                    public static final long serialVersionUID = 0L;
                    private final BlockMatrix wrongColSize$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.wrongColSize$1.validate();
                    }
                    {
                        this.wrongColSize$1 = wrongColSize$1;
                    }
                }, ManifestFactory$.MODULE$.classType(AssertionError.class));
                Seq duplicateBlocks = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Tuple2.mcII.sp(0, 0), (Object)new DenseMatrix(2, 2, new double[]{1.0, 0.0, 0.0, 2.0})), new Tuple2((Object)new Tuple2.mcII.sp(0, 0), (Object)new DenseMatrix(2, 2, new double[]{0.0, 1.0, 0.0, 0.0})), new Tuple2((Object)new Tuple2.mcII.sp(1, 1), (Object)new DenseMatrix(2, 2, new double[]{3.0, 0.0, 1.0, 1.0})), new Tuple2((Object)new Tuple2.mcII.sp(1, 1), (Object)new DenseMatrix(2, 2, new double[]{1.0, 2.0, 0.0, 1.0})), new Tuple2((Object)new Tuple2.mcII.sp(2, 1), (Object)new DenseMatrix(1, 2, new double[]{1.0, 5.0}))}));
                BlockMatrix dupMatrix = new BlockMatrix(this.$outer.sc().parallelize(duplicateBlocks, this.$outer.numPartitions(), ClassTag$.MODULE$.apply(Tuple2.class)), 2, 2);
                this.$outer.intercept((Function0)new Serializable(this, dupMatrix){
                    public static final long serialVersionUID = 0L;
                    private final BlockMatrix dupMatrix$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.dupMatrix$1.validate();
                    }
                    {
                        this.dupMatrix$1 = dupMatrix$1;
                    }
                }, ManifestFactory$.MODULE$.classType(SparkException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("transpose", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockMatrixSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                breeze.linalg.DenseMatrix expected = (breeze.linalg.DenseMatrix)breeze.linalg.DenseMatrix$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{new Tuple5((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)3.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple5((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)0.0)), new Tuple5((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)2.0), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple5((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)5.0))}), LiteralRow$.MODULE$.tuple5(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                BlockMatrix AT = this.$outer.gridBasedMat().transpose();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)AT.numRows()));
                long $org_scalatest_assert_macro_right = this.$outer.gridBasedMat().numCols();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)AT.numCols()));
                long $org_scalatest_assert_macro_right2 = this.$outer.gridBasedMat().numRows();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(AT.toBreeze());
                breeze.linalg.DenseMatrix $org_scalatest_assert_macro_right3 = expected;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                this.$outer.gridBasedMat().cache();
                BlockMatrix AT2 = this.$outer.gridBasedMat().transpose();
                AT2.cache();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(AT2.toBreeze());
                breeze.linalg.DenseMatrix $org_scalatest_assert_macro_right4 = AT.toBreeze();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                BlockMatrix A = AT2.transpose();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(A.toBreeze());
                breeze.linalg.DenseMatrix $org_scalatest_assert_macro_right5 = this.$outer.gridBasedMat().toBreeze();
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

