/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.optimization;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.optimization.NNLS;
import org.apache.spark.mllib.optimization.NNLS$;
import org.apache.spark.mllib.optimization.NNLSSuite$;
import org.apache.spark.mllib.util.TestingUtils$;
import org.jblas.DoubleMatrix;
import org.jblas.SimpleBlas;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001}2A!\u0001\u0002\u0001\u001b\tIaJ\u0014'T'VLG/\u001a\u0006\u0003\u0007\u0011\tAb\u001c9uS6L'0\u0019;j_:T!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002E\u0007\u0002\r%\u0011\u0011C\u0002\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001\"\u0002\r\u0001\t\u0003I\u0012aC4f]>sWm\u001d#bi\u0006$2A\u0007\u0014,!\u0011Yb\u0004\t\u0011\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011a\u0001V;qY\u0016\u0014\u0004CA\u0011%\u001b\u0005\u0011#BA\u0012\u000b\u0003\u0015Q'\r\\1t\u0013\t)#E\u0001\u0007E_V\u0014G.Z'biJL\u0007\u0010C\u0003(/\u0001\u0007\u0001&A\u0001o!\tY\u0012&\u0003\u0002+9\t\u0019\u0011J\u001c;\t\u000b1:\u0002\u0019A\u0017\u0002\tI\fg\u000e\u001a\t\u0003]Ej\u0011a\f\u0006\u0003aq\tA!\u001e;jY&\u0011!g\f\u0002\u0007%\u0006tGm\\7\t\u000bQ\u0002A\u0011A\u001b\u0002+\r|W\u000e];uK>\u0013'.Z2uSZ,g+\u00197vKR!a'O\u001e>!\tYr'\u0003\u000299\t1Ai\\;cY\u0016DQAO\u001aA\u0002\u0001\n1!\u0019;b\u0011\u0015a4\u00071\u0001!\u0003\r\tGO\u0019\u0005\u0006}M\u0002\r\u0001I\u0001\u0002q\u0002")
public class NNLSSuite
extends SparkFunSuite {
    public Tuple2<DoubleMatrix, DoubleMatrix> genOnesData(int n, Random rand) {
        DoubleMatrix A = new DoubleMatrix(n, n, (double[])Array$.MODULE$.fill(n * n, (Function0)new Serializable(this, rand){
            public static final long serialVersionUID = 0L;
            private final Random rand$1;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return this.rand$1.nextDouble();
            }
            {
                this.rand$1 = rand$1;
            }
        }, ClassTag$.MODULE$.Double()));
        DoubleMatrix b = A.mmul(DoubleMatrix.ones((int)n, (int)1));
        DoubleMatrix ata = A.transpose().mmul(A);
        DoubleMatrix atb = A.transpose().mmul(b);
        return new Tuple2((Object)ata, (Object)atb);
    }

    public double computeObjectiveValue(DoubleMatrix ata, DoubleMatrix atb, DoubleMatrix x) {
        DoubleMatrix res = x.transpose().mmul(ata).mmul(x).mul(0.5).sub(atb.dot(x));
        return res.get(0);
    }

    public NNLSSuite() {
        this.test("NNLS: exact solution cases", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NNLSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int n = 20;
                Random rand = new Random(12346);
                NNLS.Workspace ws = NNLS$.MODULE$.createWorkspace(n);
                IntRef numSolved = new IntRef(0);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)new Serializable(this, n, rand, ws, numSolved){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;
                    private final int n$1;
                    private final Random rand$2;
                    private final NNLS.Workspace ws$1;
                    private final IntRef numSolved$1;

                    public final void apply(int k) {
                        this.apply$mcVI$sp(k);
                    }

                    public void apply$mcVI$sp(int k) {
                        Tuple2<DoubleMatrix, DoubleMatrix> tuple2 = this.$outer.org$apache$spark$mllib$optimization$NNLSSuite$$anonfun$$$outer().genOnesData(this.n$1, this.rand$2);
                        if (tuple2 != null) {
                            boolean solved;
                            Tuple2 tuple22;
                            DoubleMatrix ata = (DoubleMatrix)tuple2._1();
                            DoubleMatrix atb = (DoubleMatrix)tuple2._2();
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)ata, (Object)atb);
                            DoubleMatrix ata2 = (DoubleMatrix)tuple23._1();
                            DoubleMatrix atb2 = (DoubleMatrix)tuple23._2();
                            DoubleMatrix x = new DoubleMatrix(NNLS$.MODULE$.solve(ata2.data, atb2.data, this.ws$1));
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$optimization$NNLSSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)x.length));
                            int $org_scalatest_assert_macro_right = this.n$1;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$mllib$optimization$NNLSSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            DoubleMatrix answer = DoubleMatrix.ones((int)this.n$1, (int)1);
                            SimpleBlas.axpy((double)-1.0, (DoubleMatrix)answer, (DoubleMatrix)x);
                            boolean bl = solved = x.norm2() < 0.01 && x.normmax() < 0.001;
                            if (solved) {
                                ++this.numSolved$1.elem;
                            }
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.n$1 = n$1;
                        this.rand$2 = rand$2;
                        this.ws$1 = ws$1;
                        this.numSolved$1 = numSolved$1;
                    }
                });
                int $org_scalatest_assert_macro_left = numSolved.elem;
                int $org_scalatest_assert_macro_right = 50;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left > $org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }

            public /* synthetic */ NNLSSuite org$apache$spark$mllib$optimization$NNLSSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("NNLS: nonnegativity constraint active", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NNLSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int n = 5;
                DoubleMatrix ata = new DoubleMatrix((double[][])((Object[])new double[][]{{4.377, -3.531, -1.306, -0.139, 3.418}, {-3.531, 4.344, 0.934, 0.305, -2.14}, {-1.306, 0.934, 2.644, -0.203, -0.17}, {-0.139, 0.305, -0.203, 5.883, 1.428}, {3.418, -2.14, -0.17, 1.428, 4.684}}));
                DoubleMatrix atb = new DoubleMatrix(new double[]{-1.632, 2.115, 1.094, -1.025, -0.636});
                double[] goodx = new double[]{0.13025, 0.54506, 0.2874, 0.0, 0.028628};
                NNLS.Workspace ws = NNLS$.MODULE$.createWorkspace(n);
                double[] x = NNLS$.MODULE$.solve(ata.data, atb.data, ws);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).foreach$mVc$sp((Function1)new Serializable(this, goodx, x){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    private final double[] goodx$1;
                    private final double[] x$2;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(this.x$2[i]).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(this.goodx$1[i]).absTol(0.001)), "org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(x.apply(i)).~==(org.apache.spark.mllib.util.TestingUtils.DoubleWithAlmostEquals(goodx.apply(i)).absTol(0.001))");
                        this.$outer.org$apache$spark$mllib$optimization$NNLSSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        double $org_scalatest_assert_macro_left = this.x$2[i];
                        int $org_scalatest_assert_macro_right = 0;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left >= (double)$org_scalatest_assert_macro_right);
                        this.$outer.org$apache$spark$mllib$optimization$NNLSSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.goodx$1 = goodx$1;
                        this.x$2 = x$2;
                    }
                });
            }

            public /* synthetic */ NNLSSuite org$apache$spark$mllib$optimization$NNLSSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("NNLS: objective value test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NNLSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double obj;
                int n = 5;
                DoubleMatrix ata = new DoubleMatrix(5, 5, new double[]{517399.13534, 242529.67289, -153644.98976, 130802.84503, -798452.29283, 242529.67289, 126017.69765, -75944.21743, 81785.36128, -405290.60884, -153644.98976, -75944.21743, 46986.44577, -45401.12659, 247059.51049, 130802.84503, 81785.36128, -45401.12659, 67457.3131, -253747.03819, -798452.29283, -405290.60884, 247059.51049, -253747.03819, 1310939.40814});
                DoubleMatrix atb = new DoubleMatrix(5, 1, new double[]{-31755.0571, 13047.14813, -20191.24443, 25993.7758, 11963.55017});
                DoubleMatrix refx = new DoubleMatrix(new double[]{34.90751, 103.96254, 0.0, 27.82094, 58.79627});
                double refObj = this.$outer.computeObjectiveValue(ata, atb, refx);
                NNLS.Workspace ws = NNLS$.MODULE$.createWorkspace(n);
                DoubleMatrix x = new DoubleMatrix(NNLS$.MODULE$.solve(ata.data, atb.data, ws));
                double $org_scalatest_assert_macro_left = obj = this.$outer.computeObjectiveValue(ata, atb, x);
                double $org_scalatest_assert_macro_right = refObj + 1.0E-5;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

