/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.recommendation;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.recommendation.ALS;
import org.apache.spark.mllib.recommendation.ALS$;
import org.apache.spark.mllib.recommendation.ALSSuite$;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.jblas.DoubleMatrix;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005}s!B\u0001\u0003\u0011\u0003i\u0011\u0001C!M'N+\u0018\u000e^3\u000b\u0005\r!\u0011A\u0004:fG>lW.\u001a8eCRLwN\u001c\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001!\tqq\"D\u0001\u0003\r\u0015\u0001\"\u0001#\u0001\u0012\u0005!\tEjU*vSR,7cA\b\u00131A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001a\u0004\"aE\r\n\u0005i!\"\u0001D*fe&\fG.\u001b>bE2,\u0007\"\u0002\u000f\u0010\t\u0003i\u0012A\u0002\u001fj]&$h\bF\u0001\u000e\u0011\u0015yr\u0002\"\u0001!\u0003e9WM\\3sCR,'+\u0019;j]\u001e\u001c\u0018i\u001d&bm\u0006d\u0015n\u001d;\u0015\u000f\u0005*$\b\u0010 D\u0011B)1C\t\u00130_%\u00111\u0005\u0006\u0002\u0007)V\u0004H.Z\u001a\u0011\u0007\u0015RC&D\u0001'\u0015\t9\u0003&\u0001\u0003vi&d'\"A\u0015\u0002\t)\fg/Y\u0005\u0003W\u0019\u0012A\u0001T5tiB\u0011a\"L\u0005\u0003]\t\u0011aAU1uS:<\u0007C\u0001\u00194\u001b\u0005\t$B\u0001\u001a\u000b\u0003\u0015Q'\r\\1t\u0013\t!\u0014G\u0001\u0007E_V\u0014G.Z'biJL\u0007\u0010C\u00037=\u0001\u0007q'A\u0003vg\u0016\u00148\u000f\u0005\u0002\u0014q%\u0011\u0011\b\u0006\u0002\u0004\u0013:$\b\"B\u001e\u001f\u0001\u00049\u0014\u0001\u00039s_\u0012,8\r^:\t\u000bur\u0002\u0019A\u001c\u0002\u0011\u0019,\u0017\r^;sKNDQa\u0010\u0010A\u0002\u0001\u000bAb]1na2Lgn\u001a*bi\u0016\u0004\"aE!\n\u0005\t#\"A\u0002#pk\ndW\rC\u0003E=\u0001\u0007Q)A\u0007j[Bd\u0017nY5u!J,gm\u001d\t\u0003'\u0019K!a\u0012\u000b\u0003\u000f\t{w\u000e\\3b]\")\u0011J\ba\u0001\u000b\u0006ya.Z4bi&4XmV3jO\"$8\u000fC\u0003L\u001f\u0011\u0005A*A\bhK:,'/\u0019;f%\u0006$\u0018N\\4t)!i%l\u0017/^=~\u0003\u0007#B\n#\u001d>z\u0003cA(XY9\u0011\u0001+\u0016\b\u0003#Rk\u0011A\u0015\u0006\u0003'2\ta\u0001\u0010:p_Rt\u0014\"A\u000b\n\u0005Y#\u0012a\u00029bG.\fw-Z\u0005\u00031f\u00131aU3r\u0015\t1F\u0003C\u00037\u0015\u0002\u0007q\u0007C\u0003<\u0015\u0002\u0007q\u0007C\u0003>\u0015\u0002\u0007q\u0007C\u0003@\u0015\u0002\u0007\u0001\tC\u0004E\u0015B\u0005\t\u0019A#\t\u000f%S\u0005\u0013!a\u0001\u000b\"9\u0011M\u0013I\u0001\u0002\u0004)\u0015a\u00048fO\u0006$\u0018N^3GC\u000e$xN]:\t\u000f\r|\u0011\u0013!C\u0001I\u0006Ir-\u001a8fe\u0006$XMU1uS:<7\u000f\n3fM\u0006,H\u000e\u001e\u00136+\u0005)'FA#gW\u00059\u0007C\u00015n\u001b\u0005I'B\u00016l\u0003%)hn\u00195fG.,GM\u0003\u0002m)\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u00059L'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"9\u0001oDI\u0001\n\u0003!\u0017!G4f]\u0016\u0014\u0018\r^3SCRLgnZ:%I\u00164\u0017-\u001e7uIYBqA]\b\u0012\u0002\u0013\u0005A-A\rhK:,'/\u0019;f%\u0006$\u0018N\\4tI\u0011,g-Y;mi\u0012:\u0004b\u0002;\u0010\u0003\u0003%I!^\u0001\fe\u0016\fGMU3t_24X\rF\u0001w!\t9(0D\u0001y\u0015\tI\b&\u0001\u0003mC:<\u0017BA>y\u0005\u0019y%M[3di\u001a!\u0001C\u0001\u0001~'\u0011ah0!\u0002\u0011\u0007}\f\t!D\u0001\u0007\u0013\r\t\u0019A\u0002\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\t\u0005\u001d\u00111B\u0007\u0003\u0003\u0013Q!a\n\u0003\n\t\u00055\u0011\u0011\u0002\u0002\u0016\u001b2c\u0017N\u0019+fgR\u001c\u0006/\u0019:l\u0007>tG/\u001a=u\u0011\u0019aB\u0010\"\u0001\u0002\u0012Q\u0011\u00111\u0003\t\u0003\u001dqDq!a\u0006}\t\u0003\tI\"A\u0004uKN$\u0018\tT*\u00155\u0005m\u0011\u0011EA\u0012\u0003K\t9#a\u000b\u0002.\u0005E\u00121GA\u001c\u0003s\ti$!\u0011\u0011\u0007M\ti\"C\u0002\u0002 Q\u0011A!\u00168ji\"1a'!\u0006A\u0002]BaaOA\u000b\u0001\u00049\u0004BB\u001f\u0002\u0016\u0001\u0007q\u0007C\u0004\u0002*\u0005U\u0001\u0019A\u001c\u0002\u0015%$XM]1uS>t7\u000f\u0003\u0004@\u0003+\u0001\r\u0001\u0011\u0005\b\u0003_\t)\u00021\u0001A\u00039i\u0017\r^2i)\"\u0014Xm\u001d5pY\u0012D\u0001\u0002RA\u000b!\u0003\u0005\r!\u0012\u0005\n\u0003k\t)\u0002%AA\u0002\u0015\u000b1BY;mWB\u0013X\rZ5di\"A\u0011*!\u0006\u0011\u0002\u0003\u0007Q\tC\u0005\u0002<\u0005U\u0001\u0013!a\u0001o\u0005ia.^7Vg\u0016\u0014(\t\\8dWND\u0011\"a\u0010\u0002\u0016A\u0005\t\u0019A\u001c\u0002!9,X\u000e\u0015:pIV\u001cGO\u00117pG.\u001c\b\u0002C1\u0002\u0016A\u0005\t\u0019A#\t\u0011\u0005\u0015C0%A\u0005\u0002\u0011\f\u0011\u0003^3ti\u0006c5\u000b\n3fM\u0006,H\u000e\u001e\u00138\u0011!\tI\u0005`I\u0001\n\u0003!\u0017!\u0005;fgR\fEj\u0015\u0013eK\u001a\fW\u000f\u001c;%q!A\u0011Q\n?\u0012\u0002\u0013\u0005A-A\tuKN$\u0018\tT*%I\u00164\u0017-\u001e7uIeB\u0011\"!\u0015}#\u0003%\t!a\u0015\u0002%Q,7\u000f^!M'\u0012\"WMZ1vYR$\u0013\u0007M\u000b\u0003\u0003+R#a\u000e4\t\u0013\u0005eC0%A\u0005\u0002\u0005M\u0013A\u0005;fgR\fEj\u0015\u0013eK\u001a\fW\u000f\u001c;%cEB\u0001\"!\u0018}#\u0003%\t\u0001Z\u0001\u0013i\u0016\u001cH/\u0011'TI\u0011,g-Y;mi\u0012\n$\u0007")
public class ALSSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public static boolean generateRatings$default$7() {
        return ALSSuite$.MODULE$.generateRatings$default$7();
    }

    public static boolean generateRatings$default$6() {
        return ALSSuite$.MODULE$.generateRatings$default$6();
    }

    public static boolean generateRatings$default$5() {
        return ALSSuite$.MODULE$.generateRatings$default$5();
    }

    public static Tuple3<Seq<Rating>, DoubleMatrix, DoubleMatrix> generateRatings(int n, int n2, int n3, double d, boolean bl, boolean bl2, boolean bl3) {
        return ALSSuite$.MODULE$.generateRatings(n, n2, n3, d, bl, bl2, bl3);
    }

    public static Tuple3<java.util.List<Rating>, DoubleMatrix, DoubleMatrix> generateRatingsAsJavaList(int n, int n2, int n3, double d, boolean bl, boolean bl2) {
        return ALSSuite$.MODULE$.generateRatingsAsJavaList(n, n2, n3, d, bl, bl2);
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public void testALS(int users, int products, int features, int iterations, double samplingRate, double matchThreshold, boolean implicitPrefs, boolean bulkPredict, boolean negativeWeights, int numUserBlocks, int numProductBlocks, boolean negativeFactors) {
        Tuple3<Seq<Rating>, DoubleMatrix, DoubleMatrix> tuple3;
        block6: {
            boolean bl;
            block9: {
                DoubleMatrix doubleMatrix;
                DoubleMatrix predictedP;
                DoubleMatrix predictedU;
                DoubleMatrix truePrefs;
                DoubleMatrix trueRatings;
                block8: {
                    MatrixFactorizationModel model;
                    block7: {
                        Tuple3 tuple32;
                        tuple3 = ALSSuite$.MODULE$.generateRatings(users, products, features, samplingRate, implicitPrefs, negativeWeights, negativeFactors);
                        if (tuple3 == null) break block6;
                        Seq sampledRatings = (Seq)tuple3._1();
                        DoubleMatrix trueRatings2 = (DoubleMatrix)tuple3._2();
                        DoubleMatrix truePrefs2 = (DoubleMatrix)tuple3._3();
                        Tuple3 tuple33 = tuple32 = new Tuple3((Object)sampledRatings, (Object)trueRatings2, (Object)truePrefs2);
                        Seq sampledRatings2 = (Seq)tuple33._1();
                        trueRatings = (DoubleMatrix)tuple33._2();
                        truePrefs = (DoubleMatrix)tuple33._3();
                        SparkContext qual$3 = this.sc();
                        Seq x$25 = sampledRatings2;
                        int x$26 = qual$3.parallelize$default$2();
                        model = new ALS().setUserBlocks(numUserBlocks).setProductBlocks(numProductBlocks).setRank(features).setIterations(iterations).setAlpha(1.0).setImplicitPrefs(implicitPrefs).setLambda(0.01).setSeed(0L).setNonnegative(!negativeFactors).run(qual$3.parallelize(x$25, x$26, ClassTag$.MODULE$.apply(Rating.class)));
                        predictedU = new DoubleMatrix(users, features);
                        Predef$.MODULE$.refArrayOps((Object[])model.userFeatures().collect()).withFilter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Tuple2<Object, double[]> check$ifrefutable$1) {
                                Tuple2<Object, double[]> tuple2 = check$ifrefutable$1;
                                boolean bl = tuple2 != null;
                                return bl;
                            }
                        }).foreach((Function1)new Serializable(this, features, predictedU){
                            public static final long serialVersionUID = 0L;
                            private final int features$1;
                            public final DoubleMatrix predictedU$1;

                            public final void apply(Tuple2<Object, double[]> x$7) {
                                Tuple2<Object, double[]> tuple2 = x$7;
                                if (tuple2 != null) {
                                    int u = tuple2._1$mcI$sp();
                                    double[] vec = (double[])tuple2._2();
                                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.features$1).foreach((Function1)new Serializable(this, u, vec){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$testALS$4 $outer;
                                        private final int u$2;
                                        private final double[] vec$1;

                                        public final DoubleMatrix apply(int i) {
                                            return this.$outer.predictedU$1.put(this.u$2, i, this.vec$1[i]);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                            this.u$2 = u$2;
                                            this.vec$1 = vec$1;
                                        }
                                    });
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.features$1 = features$1;
                                this.predictedU$1 = predictedU$1;
                            }
                        });
                        predictedP = new DoubleMatrix(products, features);
                        Predef$.MODULE$.refArrayOps((Object[])model.productFeatures().collect()).withFilter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Tuple2<Object, double[]> check$ifrefutable$2) {
                                Tuple2<Object, double[]> tuple2 = check$ifrefutable$2;
                                boolean bl = tuple2 != null;
                                return bl;
                            }
                        }).foreach((Function1)new Serializable(this, features, predictedP){
                            public static final long serialVersionUID = 0L;
                            private final int features$1;
                            public final DoubleMatrix predictedP$1;

                            public final void apply(Tuple2<Object, double[]> x$8) {
                                Tuple2<Object, double[]> tuple2 = x$8;
                                if (tuple2 != null) {
                                    int p = tuple2._1$mcI$sp();
                                    double[] vec = (double[])tuple2._2();
                                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.features$1).foreach((Function1)new Serializable(this, p, vec){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$testALS$6 $outer;
                                        private final int p$1;
                                        private final double[] vec$2;

                                        public final DoubleMatrix apply(int i) {
                                            return this.$outer.predictedP$1.put(this.p$1, i, this.vec$2[i]);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                            this.p$1 = p$1;
                                            this.vec$2 = vec$2;
                                        }
                                    });
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.features$1 = features$1;
                                this.predictedP$1 = predictedP$1;
                            }
                        });
                        bl = bulkPredict;
                        if (bl) break block7;
                        doubleMatrix = predictedU.mmul(predictedP.transpose());
                        break block8;
                    }
                    if (!bl) break block9;
                    DoubleMatrix allRatings = new DoubleMatrix(users, products);
                    IndexedSeq usersProducts = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), users).flatMap((Function1)new Serializable(this, products){
                        public static final long serialVersionUID = 0L;
                        private final int products$2;

                        public final IndexedSeq<Tuple2<Object, Object>> apply(int u) {
                            return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.products$2).map((Function1)new Serializable(this, u){
                                public static final long serialVersionUID = 0L;
                                private final int u$3;

                                public final Tuple2<Object, Object> apply(int p) {
                                    return new Tuple2.mcII.sp(this.u$3, p);
                                }
                                {
                                    this.u$3 = u$3;
                                }
                            }, IndexedSeq$.MODULE$.canBuildFrom());
                        }
                        {
                            this.products$2 = products$2;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom());
                    SparkContext qual$4 = this.sc();
                    IndexedSeq x$27 = usersProducts;
                    int x$28 = qual$4.parallelize$default$2();
                    RDD userProductsRDD = qual$4.parallelize((Seq)x$27, x$28, ClassTag$.MODULE$.apply(Tuple2.class));
                    Predef$.MODULE$.refArrayOps((Object[])model.predict(userProductsRDD).collect()).foreach((Function1)new Serializable(this, allRatings){
                        public static final long serialVersionUID = 0L;
                        private final DoubleMatrix allRatings$1;

                        public final DoubleMatrix apply(Rating elem) {
                            return this.allRatings$1.put(elem.user(), elem.product(), elem.rating());
                        }
                        {
                            this.allRatings$1 = allRatings$1;
                        }
                    });
                    doubleMatrix = allRatings;
                }
                DoubleMatrix predictedRatings = doubleMatrix;
                if (implicitPrefs) {
                    DoubleRef sqErr = new DoubleRef(0.0);
                    DoubleRef denom = new DoubleRef(0.0);
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), users).foreach$mVc$sp((Function1)new Serializable(this, products, trueRatings, truePrefs, predictedRatings, sqErr, denom){
                        public static final long serialVersionUID = 0L;
                        private final int products$2;
                        public final DoubleMatrix trueRatings$2;
                        public final DoubleMatrix truePrefs$1;
                        public final DoubleMatrix predictedRatings$1;
                        public final DoubleRef sqErr$1;
                        public final DoubleRef denom$1;

                        public final void apply(int u) {
                            this.apply$mcVI$sp(u);
                        }

                        public void apply$mcVI$sp(int u) {
                            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.products$2).foreach$mVc$sp((Function1)new Serializable(this, u){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$testALS$2 $outer;
                                private final int u$5;

                                public final void apply(int p) {
                                    this.apply$mcVI$sp(p);
                                }

                                public void apply$mcVI$sp(int p) {
                                    double prediction = this.$outer.predictedRatings$1.get(this.u$5, p);
                                    double truePref = this.$outer.truePrefs$1.get(this.u$5, p);
                                    double confidence = 1.0 + 1.0 * package$.MODULE$.abs(this.$outer.trueRatings$2.get(this.u$5, p));
                                    double err = confidence * (truePref - prediction) * (truePref - prediction);
                                    this.$outer.sqErr$1.elem += err;
                                    this.$outer.denom$1.elem += confidence;
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.u$5 = u$5;
                                }
                            });
                        }
                        {
                            this.products$2 = products$2;
                            this.trueRatings$2 = trueRatings$2;
                            this.truePrefs$1 = truePrefs$1;
                            this.predictedRatings$1 = predictedRatings$1;
                            this.sqErr$1 = sqErr$1;
                            this.denom$1 = denom$1;
                        }
                    });
                    double rmse = package$.MODULE$.sqrt(sqErr.elem / denom.elem);
                    if (rmse > matchThreshold) {
                        throw this.fail(new StringOps(Predef$.MODULE$.augmentString("Model failed to predict RMSE: %f\ncorr: %s\npred: %s\nU: %s\n P: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)rmse), truePrefs, predictedRatings, predictedU, predictedP})));
                    }
                } else {
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), users).foreach$mVc$sp((Function1)new Serializable(this, products, matchThreshold, trueRatings, predictedU, predictedP, predictedRatings){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ALSSuite $outer;
                        private final int products$2;
                        public final double matchThreshold$1;
                        public final DoubleMatrix trueRatings$2;
                        public final DoubleMatrix predictedU$1;
                        public final DoubleMatrix predictedP$1;
                        public final DoubleMatrix predictedRatings$1;

                        public final void apply(int u) {
                            this.apply$mcVI$sp(u);
                        }

                        public void apply$mcVI$sp(int u) {
                            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.products$2).foreach$mVc$sp((Function1)new Serializable(this, u){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$testALS$1 $outer;
                                private final int u$4;

                                public final void apply(int p) {
                                    this.apply$mcVI$sp(p);
                                }

                                public void apply$mcVI$sp(int p) {
                                    double correct;
                                    double prediction = this.$outer.predictedRatings$1.get(this.u$4, p);
                                    if (package$.MODULE$.abs(prediction - (correct = this.$outer.trueRatings$2.get(this.u$4, p))) > this.$outer.matchThreshold$1) {
                                        throw this.$outer.org$apache$spark$mllib$recommendation$ALSSuite$$anonfun$$$outer().fail(new StringOps(Predef$.MODULE$.augmentString("Model failed to predict (%d, %d): %f vs %f\ncorr: %s\npred: %s\nU: %s\n P: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.u$4), BoxesRunTime.boxToInteger((int)p), BoxesRunTime.boxToDouble((double)correct), BoxesRunTime.boxToDouble((double)prediction), this.$outer.trueRatings$2, this.$outer.predictedRatings$1, this.$outer.predictedU$1, this.$outer.predictedP$1})));
                                    }
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.u$4 = u$4;
                                }
                            });
                        }

                        public /* synthetic */ ALSSuite org$apache$spark$mllib$recommendation$ALSSuite$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.products$2 = products$2;
                            this.matchThreshold$1 = matchThreshold$1;
                            this.trueRatings$2 = trueRatings$2;
                            this.predictedU$1 = predictedU$1;
                            this.predictedP$1 = predictedP$1;
                            this.predictedRatings$1 = predictedRatings$1;
                        }
                    });
                }
                return;
            }
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        throw new MatchError(tuple3);
    }

    public boolean testALS$default$7() {
        return false;
    }

    public boolean testALS$default$8() {
        return false;
    }

    public boolean testALS$default$9() {
        return false;
    }

    public int testALS$default$10() {
        return -1;
    }

    public int testALS$default$11() {
        return -1;
    }

    public boolean testALS$default$12() {
        return true;
    }

    public ALSSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("rank-1 matrices", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.testALS(50, 100, 1, 15, 0.7, 0.3, this.$outer.testALS$default$7(), this.$outer.testALS$default$8(), this.$outer.testALS$default$9(), this.$outer.testALS$default$10(), this.$outer.testALS$default$11(), this.$outer.testALS$default$12());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rank-1 matrices bulk", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.testALS(50, 100, 1, 15, 0.7, 0.3, false, true, this.$outer.testALS$default$9(), this.$outer.testALS$default$10(), this.$outer.testALS$default$11(), this.$outer.testALS$default$12());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rank-2 matrices", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.testALS(100, 200, 2, 15, 0.7, 0.3, this.$outer.testALS$default$7(), this.$outer.testALS$default$8(), this.$outer.testALS$default$9(), this.$outer.testALS$default$10(), this.$outer.testALS$default$11(), this.$outer.testALS$default$12());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rank-2 matrices bulk", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.testALS(100, 200, 2, 15, 0.7, 0.3, false, true, this.$outer.testALS$default$9(), this.$outer.testALS$default$10(), this.$outer.testALS$default$11(), this.$outer.testALS$default$12());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rank-1 matrices implicit", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.testALS(80, 160, 1, 15, 0.7, 0.4, true, this.$outer.testALS$default$8(), this.$outer.testALS$default$9(), this.$outer.testALS$default$10(), this.$outer.testALS$default$11(), this.$outer.testALS$default$12());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rank-1 matrices implicit bulk", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.testALS(80, 160, 1, 15, 0.7, 0.4, true, true, this.$outer.testALS$default$9(), this.$outer.testALS$default$10(), this.$outer.testALS$default$11(), this.$outer.testALS$default$12());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rank-2 matrices implicit", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.testALS(100, 200, 2, 15, 0.7, 0.4, true, this.$outer.testALS$default$8(), this.$outer.testALS$default$9(), this.$outer.testALS$default$10(), this.$outer.testALS$default$11(), this.$outer.testALS$default$12());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rank-2 matrices implicit bulk", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.testALS(100, 200, 2, 15, 0.7, 0.4, true, true, this.$outer.testALS$default$9(), this.$outer.testALS$default$10(), this.$outer.testALS$default$11(), this.$outer.testALS$default$12());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rank-2 matrices implicit negative", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.testALS(100, 200, 2, 15, 0.7, 0.4, true, false, true, this.$outer.testALS$default$10(), this.$outer.testALS$default$11(), this.$outer.testALS$default$12());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rank-2 matrices with different user and product blocks", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int x$9 = 100;
                int x$10 = 200;
                int x$11 = 2;
                int x$12 = 15;
                double x$13 = 0.7;
                double x$14 = 0.4;
                int x$15 = 4;
                int x$16 = 2;
                boolean x$17 = this.$outer.testALS$default$7();
                boolean x$18 = this.$outer.testALS$default$8();
                boolean x$19 = this.$outer.testALS$default$9();
                boolean x$20 = this.$outer.testALS$default$12();
                this.$outer.testALS(x$9, x$10, x$11, x$12, x$13, x$14, x$17, x$18, x$19, x$15, x$16, x$20);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("pseudorandomness", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD ratings = this.$outer.sc().parallelize((Seq)ALSSuite$.MODULE$.generateRatings(10, 20, 5, 0.5, false, false, ALSSuite$.MODULE$.generateRatings$default$7())._1(), 2, ClassTag$.MODULE$.apply(Rating.class));
                MatrixFactorizationModel model11 = ALS$.MODULE$.train(ratings, 5, 1, 1.0, 2, 1L);
                MatrixFactorizationModel model12 = ALS$.MODULE$.train(ratings, 5, 1, 1.0, 2, 1L);
                List u11 = Predef$.MODULE$.doubleArrayOps((double[])RDD$.MODULE$.rddToPairRDDFunctions(model11.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).values().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final List<Object> apply(double[] x$3) {
                        return Predef$.MODULE$.doubleArrayOps(x$3).toList();
                    }
                }, ClassTag$.MODULE$.Double()).collect()).toList();
                List u12 = Predef$.MODULE$.doubleArrayOps((double[])RDD$.MODULE$.rddToPairRDDFunctions(model12.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).values().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final List<Object> apply(double[] x$4) {
                        return Predef$.MODULE$.doubleArrayOps(x$4).toList();
                    }
                }, ClassTag$.MODULE$.Double()).collect()).toList();
                MatrixFactorizationModel model2 = ALS$.MODULE$.train(ratings, 5, 1, 1.0, 2, 2L);
                List u2 = Predef$.MODULE$.doubleArrayOps((double[])RDD$.MODULE$.rddToPairRDDFunctions(model2.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).values().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final List<Object> apply(double[] x$5) {
                        return Predef$.MODULE$.doubleArrayOps(x$5).toList();
                    }
                }, ClassTag$.MODULE$.Double()).collect()).toList();
                List $org_scalatest_assert_macro_left = u11;
                List $org_scalatest_assert_macro_right = u12;
                List list = $org_scalatest_assert_macro_left;
                List list2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(list != null ? !list.equals(list2) : list2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                List $org_scalatest_assert_macro_left2 = u11;
                List $org_scalatest_assert_macro_right2 = u2;
                List list3 = $org_scalatest_assert_macro_left2;
                List list4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "!=", (Object)$org_scalatest_assert_macro_right2, list3 != null ? !list3.equals(list4) : list4 != null);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Storage Level for RDDs in model", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RDD ratings = this.$outer.sc().parallelize((Seq)ALSSuite$.MODULE$.generateRatings(10, 20, 5, 0.5, false, false, ALSSuite$.MODULE$.generateRatings$default$7())._1(), 2, ClassTag$.MODULE$.apply(Rating.class));
                StorageLevel storageLevel = StorageLevel$.MODULE$.MEMORY_ONLY();
                MatrixFactorizationModel model = new ALS().setRank(5).setIterations(1).setLambda(1.0).setBlocks(2).setSeed(1L).setFinalRDDStorageLevel(storageLevel).run(ratings);
                StorageLevel $org_scalatest_assert_macro_left = model.productFeatures().getStorageLevel();
                StorageLevel $org_scalatest_assert_macro_right = storageLevel;
                StorageLevel storageLevel2 = $org_scalatest_assert_macro_left;
                StorageLevel storageLevel3 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(storageLevel2 != null ? !storageLevel2.equals(storageLevel3) : storageLevel3 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                StorageLevel $org_scalatest_assert_macro_left2 = model.userFeatures().getStorageLevel();
                StorageLevel $org_scalatest_assert_macro_right2 = storageLevel;
                StorageLevel storageLevel4 = $org_scalatest_assert_macro_left2;
                StorageLevel storageLevel5 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(storageLevel4 != null ? !storageLevel4.equals(storageLevel5) : storageLevel5 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                storageLevel = StorageLevel$.MODULE$.DISK_ONLY();
                model = new ALS().setRank(5).setIterations(1).setLambda(1.0).setBlocks(2).setSeed(1L).setFinalRDDStorageLevel(storageLevel).run(ratings);
                StorageLevel $org_scalatest_assert_macro_left3 = model.productFeatures().getStorageLevel();
                StorageLevel $org_scalatest_assert_macro_right3 = storageLevel;
                StorageLevel storageLevel6 = $org_scalatest_assert_macro_left3;
                StorageLevel storageLevel7 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(storageLevel6 != null ? !storageLevel6.equals(storageLevel7) : storageLevel7 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                StorageLevel $org_scalatest_assert_macro_left4 = model.userFeatures().getStorageLevel();
                StorageLevel $org_scalatest_assert_macro_right4 = storageLevel;
                StorageLevel storageLevel8 = $org_scalatest_assert_macro_left4;
                StorageLevel storageLevel9 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(storageLevel8 != null ? !storageLevel8.equals(storageLevel9) : storageLevel9 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("negative ids", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple3<Seq<Rating>, DoubleMatrix, DoubleMatrix> data = ALSSuite$.MODULE$.generateRatings(50, 50, 2, 0.7, false, false, ALSSuite$.MODULE$.generateRatings$default$7());
                SparkContext qual$1 = this.$outer.sc();
                Seq x$21 = (Seq)((TraversableLike)data._1()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Rating apply(Rating x0$1) {
                        Rating rating = x0$1;
                        if (rating != null) {
                            int u = rating.user();
                            int p = rating.product();
                            double r = rating.rating();
                            Rating rating2 = new Rating(u - 25, p - 25, r);
                            return rating2;
                        }
                        throw new MatchError((Object)rating);
                    }
                }, Seq$.MODULE$.canBuildFrom());
                int x$22 = qual$1.parallelize$default$2();
                RDD ratings = qual$1.parallelize(x$21, x$22, ClassTag$.MODULE$.apply(Rating.class));
                DoubleMatrix correct = (DoubleMatrix)data._2();
                MatrixFactorizationModel model = ALS$.MODULE$.train(ratings, 5, 15);
                Tuple2[] pairs = (Tuple2[])Predef$.MODULE$.refArrayOps(Array$.MODULE$.tabulate(50, 50, (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(int u, int p) {
                        return new Tuple2.mcII.sp(u - 25, p - 25);
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class))).flatten((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final WrappedArray<Tuple2<Object, Object>> apply(Tuple2<Object, Object>[] xs) {
                        return Predef$.MODULE$.wrapRefArray((Object[])xs);
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class));
                SparkContext qual$2 = this.$outer.sc();
                WrappedArray x$23 = Predef$.MODULE$.wrapRefArray((Object[])pairs);
                int x$24 = qual$2.parallelize$default$2();
                Rating[] ans = (Rating[])model.predict(qual$2.parallelize((Seq)x$23, x$24, ClassTag$.MODULE$.apply(Tuple2.class))).collect();
                Predef$.MODULE$.refArrayOps((Object[])ans).foreach((Function1)new Serializable(this, correct){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$15 $outer;
                    private final DoubleMatrix correct$1;

                    public final void apply(Rating r) {
                        int u = r.user() + 25;
                        int p = r.product() + 25;
                        double v = r.rating();
                        double error = v - this.correct$1.get(u, p);
                        double $org_scalatest_assert_macro_left = package$.MODULE$.abs(error);
                        double $org_scalatest_assert_macro_right = 0.4;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
                        this.$outer.org$apache$spark$mllib$recommendation$ALSSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.correct$1 = correct$1;
                    }
                });
            }

            public /* synthetic */ ALSSuite org$apache$spark$mllib$recommendation$ALSSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("NNALS, rank 2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ALSSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.testALS(100, 200, 2, 15, 0.7, 0.4, false, false, false, -1, -1, false);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

