/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat;

import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.Matrix;
import breeze.linalg.support.LiteralRow$;
import breeze.storage.Zero;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.stat.CorrelationSuite$;
import org.apache.spark.mllib.stat.CorrelationSuite$$anonfun$matrixApproxEqual$1$;
import org.apache.spark.mllib.stat.Statistics$;
import org.apache.spark.mllib.stat.correlation.Correlations$;
import org.apache.spark.mllib.stat.correlation.PearsonCorrelation$;
import org.apache.spark.mllib.stat.correlation.SpearmanCorrelation$;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SQLContext;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001E4A!\u0001\u0002\u0001\u001b\t\u00012i\u001c:sK2\fG/[8o'VLG/\u001a\u0006\u0003\u0007\u0011\tAa\u001d;bi*\u0011QAB\u0001\u0006[2d\u0017N\u0019\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u000f%a\u0001\"a\u0004\t\u000e\u0003\u0019I!!\u0005\u0004\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t\u0019b#D\u0001\u0015\u0015\t)B!\u0001\u0003vi&d\u0017BA\f\u0015\u0005UiE\n\\5c)\u0016\u001cHo\u00159be.\u001cuN\u001c;fqR\u0004\"aD\r\n\u0005i1!a\u0002'pO\u001eLgn\u001a\u0005\u00069\u0001!\t!H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003y\u0001\"a\b\u0001\u000e\u0003\tAq!\t\u0001C\u0002\u0013\u0005!%A\u0003y\t\u0006$\u0018-F\u0001$!\r!s%K\u0007\u0002K)\ta%A\u0003tG\u0006d\u0017-\u0003\u0002)K\t)\u0011I\u001d:bsB\u0011AEK\u0005\u0003W\u0015\u0012a\u0001R8vE2,\u0007BB\u0017\u0001A\u0003%1%\u0001\u0004y\t\u0006$\u0018\r\t\u0005\b_\u0001\u0011\r\u0011\"\u0001#\u0003\u0015IH)\u0019;b\u0011\u0019\t\u0004\u0001)A\u0005G\u00051\u0011\u0010R1uC\u0002Bqa\r\u0001C\u0002\u0013\u0005!%A\u0003{KJ|7\u000f\u0003\u00046\u0001\u0001\u0006IaI\u0001\u0007u\u0016\u0014xn\u001d\u0011\t\u000f]\u0002!\u0019!C\u0001q\u0005!A-\u0019;b+\u0005I\u0004c\u0001\u001e>\u007f5\t1H\u0003\u0002=K\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005yZ$aA*fcB\u0011\u0001iQ\u0007\u0002\u0003*\u0011!\tB\u0001\u0007Y&t\u0017\r\\4\n\u0005\u0011\u000b%A\u0002,fGR|'\u000f\u0003\u0004G\u0001\u0001\u0006I!O\u0001\u0006I\u0006$\u0018\r\t\u0005\u0006\u0011\u0002!\t!S\u0001\fCB\u0004(o\u001c=FcV\fG\u000e\u0006\u0003K\u001b>\u000b\u0006C\u0001\u0013L\u0013\taUEA\u0004C_>dW-\u00198\t\u000b9;\u0005\u0019A\u0015\u0002\u0005Y\f\u0004\"\u0002)H\u0001\u0004I\u0013A\u0001<3\u0011\u001d\u0011v\t%AA\u0002%\n\u0011\u0002\u001e5sKNDw\u000e\u001c3\t\u000bQ\u0003A\u0011A+\u0002#5\fGO]5y\u0003B\u0004(o\u001c=FcV\fG\u000e\u0006\u0003K-~\u000b\u0007\"B,T\u0001\u0004A\u0016!A!\u0011\u0007ek\u0016&D\u0001[\u0015\t\u00115LC\u0001]\u0003\u0019\u0011'/Z3{K&\u0011aL\u0017\u0002\u0007\u001b\u0006$(/\u001b=\t\u000b\u0001\u001c\u0006\u0019\u0001-\u0002\u0003\tCqAU*\u0011\u0002\u0003\u0007\u0011\u0006C\u0004d\u0001E\u0005I\u0011\u00013\u0002+\u0005\u0004\bO]8y\u000bF,\u0018\r\u001c\u0013eK\u001a\fW\u000f\u001c;%gU\tQM\u000b\u0002*M.\nq\r\u0005\u0002i[6\t\u0011N\u0003\u0002kW\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003Y\u0016\n!\"\u00198o_R\fG/[8o\u0013\tq\u0017NA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016Dq\u0001\u001d\u0001\u0012\u0002\u0013\u0005A-A\u000enCR\u0014\u0018\u000e_!qaJ|\u00070R9vC2$C-\u001a4bk2$He\r")
public class CorrelationSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private final double[] xData;
    private final double[] yData;
    private final double[] zeros;
    private final Seq<Vector> data;
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public double[] xData() {
        return this.xData;
    }

    public double[] yData() {
        return this.yData;
    }

    public double[] zeros() {
        return this.zeros;
    }

    public Seq<Vector> data() {
        return this.data;
    }

    public boolean approxEqual(double v1, double v2, double threshold) {
        return Predef$.MODULE$.double2Double(v1).isNaN() ? Predef$.MODULE$.double2Double(v2).isNaN() : package$.MODULE$.abs(v1 - v2) <= threshold;
    }

    public double approxEqual$default$3() {
        return 1.0E-6;
    }

    public boolean matrixApproxEqual(Matrix<Object> A, Matrix<Object> B, double threshold) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            boolean bl;
            Object object = new Object();
            try {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), A.rows()).foreach$mVc$sp((Function1)new Serializable(this, A, B, threshold, object){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ CorrelationSuite $outer;
                    public final Matrix A$1;
                    public final Matrix B$1;
                    public final double threshold$1;
                    public final Object nonLocalReturnKey1$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.A$1.cols()).foreach$mVc$sp((Function1)new Serializable(this, i){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$matrixApproxEqual$1 $outer;
                            public final int i$1;

                            public final void apply(int j) {
                                this.apply$mcVI$sp(j);
                            }

                            public void apply$mcVI$sp(int j) {
                                if (this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer().approxEqual(this.$outer.A$1.apply$mcD$sp(this.i$1, j), this.$outer.B$1.apply$mcD$sp(this.i$1, j), this.$outer.threshold$1)) {
                                    return;
                                }
                                this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer().logInfo((Function0)new Serializable(this, j){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$matrixApproxEqual$1$$anonfun$apply$mcVI$sp$1 $outer;
                                    private final int j$1;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)"i, j = ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.i$1)).append((Object)", ").append((Object)BoxesRunTime.boxToInteger((int)this.j$1)).append((Object)" actual: ").append((Object)BoxesRunTime.boxToDouble((double)this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$anonfun$$$outer().A$1.apply$mcD$sp(this.$outer.i$1, this.j$1))).append((Object)" expected:").append((Object)BoxesRunTime.boxToDouble((double)this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$anonfun$$$outer().B$1.apply$mcD$sp(this.$outer.i$1, this.j$1))).toString();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.j$1 = j$1;
                                    }
                                });
                                throw new NonLocalReturnControl.mcZ.sp(this.$outer.nonLocalReturnKey1$1, false);
                            }

                            public /* synthetic */ $anonfun$matrixApproxEqual$1 org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.i$1 = i$1;
                            }
                        });
                    }

                    public /* synthetic */ CorrelationSuite org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.A$1 = A$1;
                        this.B$1 = B$1;
                        this.threshold$1 = threshold$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                bl = true;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    public double matrixApproxEqual$default$3() {
        return 1.0E-6;
    }

    public CorrelationSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        this.xData = new double[]{1.0, 0.0, -2.0};
        this.yData = new double[]{4.0, 5.0, 3.0};
        this.zeros = new double[3];
        this.data = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Vector[]{Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, -2.0})), Vectors$.MODULE$.dense(4.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{5.0, 0.0, 3.0})), Vectors$.MODULE$.dense(6.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{7.0, 0.0, 8.0})), Vectors$.MODULE$.dense(9.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 1.0}))}));
        this.test("corr(x, y) pearson, 1 value in data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CorrelationSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkContext qual$1 = this.$outer.sc();
                WrappedArray x$1 = Predef$.MODULE$.wrapDoubleArray(new double[]{1.0});
                int x$2 = qual$1.parallelize$default$2();
                RDD x = qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.Double());
                SparkContext qual$2 = this.$outer.sc();
                WrappedArray x$3 = Predef$.MODULE$.wrapDoubleArray(new double[]{4.0});
                int x$4 = qual$2.parallelize$default$2();
                RDD y = qual$2.parallelize((Seq)x$3, x$4, ClassTag$.MODULE$.Double());
                this.$outer.intercept((Function0)new Serializable(this, x, y){
                    public static final long serialVersionUID = 0L;
                    private final RDD x$21;
                    private final RDD y$1;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return Statistics$.MODULE$.corr(this.x$21, this.y$1, "pearson");
                    }
                    {
                        this.x$21 = x$21;
                        this.y$1 = y$1;
                    }
                }, ManifestFactory$.MODULE$.classType(RuntimeException.class));
                this.$outer.intercept((Function0)new Serializable(this, x, y){
                    public static final long serialVersionUID = 0L;
                    private final RDD x$21;
                    private final RDD y$1;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return Statistics$.MODULE$.corr(this.x$21, this.y$1, "spearman");
                    }
                    {
                        this.x$21 = x$21;
                        this.y$1 = y$1;
                    }
                }, ManifestFactory$.MODULE$.classType(RuntimeException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("corr(x, y) default, pearson", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CorrelationSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkContext qual$3 = this.$outer.sc();
                WrappedArray x$5 = Predef$.MODULE$.wrapDoubleArray(this.$outer.xData());
                int x$6 = qual$3.parallelize$default$2();
                RDD x = qual$3.parallelize((Seq)x$5, x$6, ClassTag$.MODULE$.Double());
                SparkContext qual$4 = this.$outer.sc();
                WrappedArray x$7 = Predef$.MODULE$.wrapDoubleArray(this.$outer.yData());
                int x$8 = qual$4.parallelize$default$2();
                RDD y = qual$4.parallelize((Seq)x$7, x$8, ClassTag$.MODULE$.Double());
                double expected = 0.6546537;
                double d = Statistics$.MODULE$.corr(x, y);
                double p1 = Statistics$.MODULE$.corr(x, y, "pearson");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.approxEqual(expected, d, this.$outer.approxEqual$default$3()), "CorrelationSuite.this.approxEqual(expected, default, CorrelationSuite.this.approxEqual$default$3)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.$outer.approxEqual(expected, p1, this.$outer.approxEqual$default$3()), "CorrelationSuite.this.approxEqual(expected, p1, CorrelationSuite.this.approxEqual$default$3)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{Predef$.MODULE$.doubleArrayOps(this.$outer.xData()).size(), Predef$.MODULE$.doubleArrayOps(this.$outer.xData()).size() * 2})).foreach((Function1)new Serializable(this, expected){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;
                    private final double expected$1;

                    public final void apply(int numParts) {
                        this.apply$mcVI$sp(numParts);
                    }

                    public void apply$mcVI$sp(int numParts) {
                        RDD x1 = this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer().sc().parallelize((Seq)Predef$.MODULE$.wrapDoubleArray(this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer().xData()), numParts, ClassTag$.MODULE$.Double());
                        RDD y1 = this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer().sc().parallelize((Seq)Predef$.MODULE$.wrapDoubleArray(this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer().yData()), numParts, ClassTag$.MODULE$.Double());
                        double p2 = Statistics$.MODULE$.corr(x1, y1);
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer().approxEqual(this.expected$1, p2, this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer().approxEqual$default$3()), "CorrelationSuite.this.approxEqual(expected, p2, CorrelationSuite.this.approxEqual$default$3)");
                        this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.expected$1 = expected$1;
                    }
                });
                SparkContext qual$5 = this.$outer.sc();
                WrappedArray x$9 = Predef$.MODULE$.wrapDoubleArray(this.$outer.zeros());
                int x$10 = qual$5.parallelize$default$2();
                RDD z = qual$5.parallelize((Seq)x$9, x$10, ClassTag$.MODULE$.Double());
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.double2Double(Statistics$.MODULE$.corr(x, z)).isNaN(), "scala.this.Predef.double2Double(Statistics.corr(x, z)).isNaN()");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }

            public /* synthetic */ CorrelationSuite org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("corr(x, y) spearman", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CorrelationSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkContext qual$6 = this.$outer.sc();
                WrappedArray x$11 = Predef$.MODULE$.wrapDoubleArray(this.$outer.xData());
                int x$12 = qual$6.parallelize$default$2();
                RDD x = qual$6.parallelize((Seq)x$11, x$12, ClassTag$.MODULE$.Double());
                SparkContext qual$7 = this.$outer.sc();
                WrappedArray x$13 = Predef$.MODULE$.wrapDoubleArray(this.$outer.yData());
                int x$14 = qual$7.parallelize$default$2();
                RDD y = qual$7.parallelize((Seq)x$13, x$14, ClassTag$.MODULE$.Double());
                double expected = 0.5;
                double s1 = Statistics$.MODULE$.corr(x, y, "spearman");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.approxEqual(expected, s1, this.$outer.approxEqual$default$3()), "CorrelationSuite.this.approxEqual(expected, s1, CorrelationSuite.this.approxEqual$default$3)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{Predef$.MODULE$.doubleArrayOps(this.$outer.xData()).size(), Predef$.MODULE$.doubleArrayOps(this.$outer.xData()).size() * 2})).foreach((Function1)new Serializable(this, expected){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    private final double expected$2;

                    public final void apply(int numParts) {
                        this.apply$mcVI$sp(numParts);
                    }

                    public void apply$mcVI$sp(int numParts) {
                        RDD x1 = this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer().sc().parallelize((Seq)Predef$.MODULE$.wrapDoubleArray(this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer().xData()), numParts, ClassTag$.MODULE$.Double());
                        RDD y1 = this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer().sc().parallelize((Seq)Predef$.MODULE$.wrapDoubleArray(this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer().yData()), numParts, ClassTag$.MODULE$.Double());
                        double s2 = Statistics$.MODULE$.corr(x1, y1, "spearman");
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer().approxEqual(this.expected$2, s2, this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer().approxEqual$default$3()), "CorrelationSuite.this.approxEqual(expected, s2, CorrelationSuite.this.approxEqual$default$3)");
                        this.$outer.org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.expected$2 = expected$2;
                    }
                });
                SparkContext qual$8 = this.$outer.sc();
                WrappedArray x$15 = Predef$.MODULE$.wrapDoubleArray(this.$outer.zeros());
                int x$16 = qual$8.parallelize$default$2();
                RDD z = qual$8.parallelize((Seq)x$15, x$16, ClassTag$.MODULE$.Double());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.double2Double(Statistics$.MODULE$.corr(x, z, "spearman")).isNaN(), "scala.this.Predef.double2Double(Statistics.corr(x, z, \"spearman\")).isNaN()");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }

            public /* synthetic */ CorrelationSuite org$apache$spark$mllib$stat$CorrelationSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("corr(X) default, pearson", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CorrelationSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkContext qual$9 = this.$outer.sc();
                Seq<Vector> x$17 = this.$outer.data();
                int x$18 = qual$9.parallelize$default$2();
                RDD X = qual$9.parallelize(x$17, x$18, ClassTag$.MODULE$.apply(Vector.class));
                org.apache.spark.mllib.linalg.Matrix defaultMat = Statistics$.MODULE$.corr(X);
                org.apache.spark.mllib.linalg.Matrix pearsonMat = Statistics$.MODULE$.corr(X, "pearson");
                DenseMatrix expected = (DenseMatrix)DenseMatrix$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)0.05564149), (Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)0.4004714)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.05564149), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)0.9135959)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)Double.NaN)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.40047142), (Object)BoxesRunTime.boxToDouble((double)0.91359586), (Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)1.0))}), LiteralRow$.MODULE$.tuple4(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.matrixApproxEqual((Matrix<Object>)defaultMat.toBreeze(), (Matrix<Object>)expected, this.$outer.matrixApproxEqual$default$3()), "CorrelationSuite.this.matrixApproxEqual(defaultMat.toBreeze, expected, CorrelationSuite.this.matrixApproxEqual$default$3)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.$outer.matrixApproxEqual((Matrix<Object>)pearsonMat.toBreeze(), (Matrix<Object>)expected, this.$outer.matrixApproxEqual$default$3()), "CorrelationSuite.this.matrixApproxEqual(pearsonMat.toBreeze, expected, CorrelationSuite.this.matrixApproxEqual$default$3)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("corr(X) spearman", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CorrelationSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SparkContext qual$10 = this.$outer.sc();
                Seq<Vector> x$19 = this.$outer.data();
                int x$20 = qual$10.parallelize$default$2();
                RDD X = qual$10.parallelize(x$19, x$20, ClassTag$.MODULE$.apply(Vector.class));
                org.apache.spark.mllib.linalg.Matrix spearmanMat = Statistics$.MODULE$.corr(X, "spearman");
                DenseMatrix expected = (DenseMatrix)DenseMatrix$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple4[]{new Tuple4((Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)0.1054093), (Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)0.4)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.1054093), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)0.9486833)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)1.0), (Object)BoxesRunTime.boxToDouble((double)Double.NaN)), new Tuple4((Object)BoxesRunTime.boxToDouble((double)0.4), (Object)BoxesRunTime.boxToDouble((double)0.9486833), (Object)BoxesRunTime.boxToDouble((double)Double.NaN), (Object)BoxesRunTime.boxToDouble((double)1.0))}), LiteralRow$.MODULE$.tuple4(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.matrixApproxEqual((Matrix<Object>)spearmanMat.toBreeze(), (Matrix<Object>)expected, this.$outer.matrixApproxEqual$default$3()), "CorrelationSuite.this.matrixApproxEqual(spearmanMat.toBreeze, expected, CorrelationSuite.this.matrixApproxEqual$default$3)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("method identification", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CorrelationSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PearsonCorrelation$ pearson = PearsonCorrelation$.MODULE$;
                SpearmanCorrelation$ spearman = SpearmanCorrelation$.MODULE$;
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(Correlations$.MODULE$.getCorrelationFromName("pearson"));
                PearsonCorrelation$ $org_scalatest_assert_macro_right = pearson;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(Correlations$.MODULE$.getCorrelationFromName("spearman"));
                SpearmanCorrelation$ $org_scalatest_assert_macro_right2 = spearman;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                try {
                    Correlations$.MODULE$.getCorrelationFromName("kendall");
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(false, "");
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

