/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import java.util.List;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.configuration.FeatureType$;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.InformationGainStats;
import org.apache.spark.mllib.tree.model.Node;
import org.apache.spark.mllib.tree.model.Node$;
import org.apache.spark.mllib.tree.model.Predict;
import org.apache.spark.mllib.tree.model.Split;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class DecisionTreeSuite$
extends SparkFunSuite {
    public static final DecisionTreeSuite$ MODULE$;
    private final int[] org$apache$spark$mllib$tree$DecisionTreeSuite$$createdModelNodeIds;

    static {
        new DecisionTreeSuite$();
    }

    public void validateClassifier(DecisionTreeModel model, Seq<LabeledPoint> input, double requiredAccuracy) {
        double accuracy;
        Seq predictions = (Seq)input.map((Function1)new Serializable(model){
            public static final long serialVersionUID = 0L;
            private final DecisionTreeModel model$2;

            public final double apply(LabeledPoint x) {
                return this.model$2.predict(x.features());
            }
            {
                this.model$2 = model$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        int numOffPredictions = ((TraversableOnce)predictions.zip(input, Seq$.MODULE$.canBuildFrom())).count((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, LabeledPoint> x0$1) {
                Tuple2<Object, LabeledPoint> tuple2 = x0$1;
                if (tuple2 != null) {
                    LabeledPoint expected;
                    double prediction = tuple2._1$mcD$sp();
                    boolean bl = prediction != (expected = (LabeledPoint)tuple2._2()).label();
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
        double $org_scalatest_assert_macro_left = accuracy = (double)(input.length() - numOffPredictions) / (double)input.length();
        double $org_scalatest_assert_macro_right = requiredAccuracy;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left >= $org_scalatest_assert_macro_right);
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"validateClassifier calculated accuracy ", " but required ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)accuracy), BoxesRunTime.boxToDouble((double)requiredAccuracy)})));
    }

    public void validateRegressor(DecisionTreeModel model, Seq<LabeledPoint> input, double requiredMSE) {
        double mse;
        Seq predictions = (Seq)input.map((Function1)new Serializable(model){
            public static final long serialVersionUID = 0L;
            private final DecisionTreeModel model$1;

            public final double apply(LabeledPoint x) {
                return this.model$1.predict(x.features());
            }
            {
                this.model$1 = model$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        double squaredError = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)predictions.zip(input, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, LabeledPoint> x0$2) {
                Tuple2<Object, LabeledPoint> tuple2 = x0$2;
                if (tuple2 != null) {
                    double prediction = tuple2._1$mcD$sp();
                    LabeledPoint expected = (LabeledPoint)tuple2._2();
                    double err = prediction - expected.label();
                    double d = err * err;
                    return d;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        double $org_scalatest_assert_macro_left = mse = squaredError / (double)input.length();
        double $org_scalatest_assert_macro_right = requiredMSE;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left <= $org_scalatest_assert_macro_right);
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"validateRegressor calculated MSE ", " but required ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)mse), BoxesRunTime.boxToDouble((double)requiredMSE)})));
    }

    /*
     * WARNING - void declaration
     */
    public LabeledPoint[] generateOrderedLabeledPointsWithLabel0() {
        void var1_1;
        LabeledPoint[] arr = new LabeledPoint[1000];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1000).foreach$mVc$sp((Function1)new Serializable(arr){
            public static final long serialVersionUID = 0L;
            private final LabeledPoint[] arr$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                LabeledPoint lp;
                this.arr$1[i] = lp = new LabeledPoint(0.0, Vectors$.MODULE$.dense((double)i, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1000.0 - (double)i})));
            }
            {
                this.arr$1 = arr$1;
            }
        });
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LabeledPoint[] generateOrderedLabeledPointsWithLabel1() {
        void var1_1;
        LabeledPoint[] arr = new LabeledPoint[1000];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1000).foreach$mVc$sp((Function1)new Serializable(arr){
            public static final long serialVersionUID = 0L;
            private final LabeledPoint[] arr$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                LabeledPoint lp;
                this.arr$2[i] = lp = new LabeledPoint(1.0, Vectors$.MODULE$.dense((double)i, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{999.0 - (double)i})));
            }
            {
                this.arr$2 = arr$2;
            }
        });
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LabeledPoint[] generateOrderedLabeledPoints() {
        void var1_1;
        LabeledPoint[] arr = new LabeledPoint[1000];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1000).foreach$mVc$sp((Function1)new Serializable(arr){
            public static final long serialVersionUID = 0L;
            private final LabeledPoint[] arr$3;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                double label = i < 100 ? 0.0 : (i < 500 ? 1.0 : (i < 900 ? 0.0 : 1.0));
                this.arr$3[i] = new LabeledPoint(label, Vectors$.MODULE$.dense((double)i, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1000.0 - (double)i})));
            }
            {
                this.arr$3 = arr$3;
            }
        });
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LabeledPoint[] generateCategoricalDataPoints() {
        void var1_1;
        LabeledPoint[] arr = new LabeledPoint[1000];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1000).foreach$mVc$sp((Function1)new Serializable(arr){
            public static final long serialVersionUID = 0L;
            private final LabeledPoint[] arr$4;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.arr$4[i] = i < 600 ? new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))) : new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0})));
            }
            {
                this.arr$4 = arr$4;
            }
        });
        return var1_1;
    }

    public List<LabeledPoint> generateCategoricalDataPointsAsJavaList() {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.refArrayOps((Object[])this.generateCategoricalDataPoints()).toList()).asJava();
    }

    /*
     * WARNING - void declaration
     */
    public LabeledPoint[] generateCategoricalDataPointsForMulticlass() {
        void var1_1;
        LabeledPoint[] arr = new LabeledPoint[3000];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3000).foreach$mVc$sp((Function1)new Serializable(arr){
            public static final long serialVersionUID = 0L;
            private final LabeledPoint[] arr$5;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.arr$5[i] = i < 1000 ? new LabeledPoint(2.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))) : (i < 2000 ? new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))) : new LabeledPoint(2.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))));
            }
            {
                this.arr$5 = arr$5;
            }
        });
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LabeledPoint[] generateContinuousDataPointsForMulticlass() {
        void var1_1;
        LabeledPoint[] arr = new LabeledPoint[3000];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3000).foreach$mVc$sp((Function1)new Serializable(arr){
            public static final long serialVersionUID = 0L;
            private final LabeledPoint[] arr$6;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.arr$6[i] = i < 2000 ? new LabeledPoint(2.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{i}))) : new LabeledPoint(1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{i})));
            }
            {
                this.arr$6 = arr$6;
            }
        });
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public LabeledPoint[] generateCategoricalDataPointsForMulticlassForOrderedFeatures() {
        void var1_1;
        LabeledPoint[] arr = new LabeledPoint[3000];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3000).foreach$mVc$sp((Function1)new Serializable(arr){
            public static final long serialVersionUID = 0L;
            private final LabeledPoint[] arr$7;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.arr$7[i] = i < 1000 ? new LabeledPoint(2.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))) : (i < 2000 ? new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))) : new LabeledPoint(1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0}))));
            }
            {
                this.arr$7 = arr$7;
            }
        });
        return var1_1;
    }

    private Node createLeafNode(int id) {
        return Node$.MODULE$.apply(id, new Predict(0.0, 1.0), 0.5, true);
    }

    /*
     * WARNING - void declaration
     */
    private Node createInternalNode(int id, Enumeration.Value featureType) {
        Enumeration.Value value;
        block4: {
            void var3_3;
            Node node;
            block3: {
                block2: {
                    node = Node$.MODULE$.apply(id, new Predict(0.0, 1.0), 0.5, false);
                    value = featureType;
                    Enumeration.Value value2 = FeatureType$.MODULE$.Continuous();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                    node.split_$eq((Option)new Some((Object)new Split(0, 0.5, FeatureType$.MODULE$.Continuous(), List$.MODULE$.empty())));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                Enumeration.Value value4 = FeatureType$.MODULE$.Categorical();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                node.split_$eq((Option)new Some((Object)new Split(1, 0.0, FeatureType$.MODULE$.Categorical(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.0})))));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            node.stats_$eq((Option)new Some((Object)new InformationGainStats(0.1, 0.2, 0.3, 0.4, new Predict(1.0, 0.4), new Predict(0.0, 0.6))));
            return var3_3;
        }
        throw new MatchError((Object)value);
    }

    public DecisionTreeModel createModel(Enumeration.Value algo) {
        Node topNode = this.createInternalNode(1, FeatureType$.MODULE$.Continuous());
        Tuple2 tuple2 = new Tuple2((Object)this.createLeafNode(2), (Object)this.createInternalNode(3, FeatureType$.MODULE$.Categorical()));
        if (tuple2 != null) {
            Tuple2 tuple22;
            Node node2 = (Node)tuple2._1();
            Node node3 = (Node)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)node2, (Object)node3);
            Node node22 = (Node)tuple23._1();
            Node node32 = (Node)tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)this.createLeafNode(6), (Object)this.createLeafNode(7));
            if (tuple24 != null) {
                Tuple2 tuple25;
                Node node6 = (Node)tuple24._1();
                Node node7 = (Node)tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)node6, (Object)node7);
                Node node62 = (Node)tuple26._1();
                Node node72 = (Node)tuple26._2();
                topNode.leftNode_$eq((Option)new Some((Object)node22));
                topNode.rightNode_$eq((Option)new Some((Object)node32));
                node32.leftNode_$eq((Option)new Some((Object)node62));
                node32.rightNode_$eq((Option)new Some((Object)node72));
                return new DecisionTreeModel(topNode, algo);
            }
            throw new MatchError((Object)tuple24);
        }
        throw new MatchError((Object)tuple2);
    }

    public int[] org$apache$spark$mllib$tree$DecisionTreeSuite$$createdModelNodeIds() {
        return this.org$apache$spark$mllib$tree$DecisionTreeSuite$$createdModelNodeIds;
    }

    public void checkEqual(DecisionTreeModel a, DecisionTreeModel b) {
        try {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(a.algo());
            Enumeration.Value $org_scalatest_assert_macro_right = b.algo();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            this.checkEqual(a.topNode(), b.topNode());
            return;
        }
        catch (Exception exception) {
            throw new AssertionError(new StringBuilder().append((Object)"checkEqual failed since the two trees were not identical.\nTREE A:\n").append((Object)a.toDebugString()).append((Object)"\n").append((Object)"TREE B:\n").append((Object)b.toDebugString()).append((Object)"\n").toString(), exception);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void checkEqual(Node a, Node b) {
        block8: {
            block9: {
                while (true) {
                    $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)a.id()));
                    $org_scalatest_assert_macro_right = b.id();
                    $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                    this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    $org_scalatest_assert_macro_left = this.convertToEqualizer(a.predict());
                    $org_scalatest_assert_macro_right = b.predict();
                    $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                    this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)a.impurity()));
                    $org_scalatest_assert_macro_right = b.impurity();
                    $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                    this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)a.isLeaf()));
                    $org_scalatest_assert_macro_right = b.isLeaf();
                    $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                    this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    $org_scalatest_assert_macro_left = this.convertToEqualizer(a.split());
                    $org_scalatest_assert_macro_right = b.split();
                    $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                    this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    var20_18 = new Tuple2((Object)a.stats(), (Object)b.stats());
                    if (var20_18 == null) ** GOTO lbl-1000
                    var21_19 = (Option)var20_18._1();
                    var22_20 = (Option)var20_18._2();
                    if (!(var21_19 instanceof Some)) ** GOTO lbl-1000
                    var23_21 = (Some)var21_19;
                    aStats = (InformationGainStats)var23_21.x();
                    if (var22_20 instanceof Some) {
                        var25_23 = (Some)var22_20;
                        bStats = (InformationGainStats)var25_23.x();
                        $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)aStats.gain()));
                        $org_scalatest_assert_macro_right = bStats.gain();
                        $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        var27_25 = BoxedUnit.UNIT;
                    } else lbl-1000:
                    // 3 sources

                    {
                        if (var20_18 == null) break block8;
                        var32_29 = (Option)var20_18._1();
                        var33_30 = (Option)var20_18._2();
                        v0 = None$.MODULE$;
                        var34_31 = var32_29;
                        if (v0 != null ? v0.equals(var34_31) == false : var34_31 != null) break block8;
                        v1 = None$.MODULE$;
                        var35_32 = var33_30;
                        if (v1 != null ? v1.equals(var35_32) == false : var35_32 != null) break block8;
                        var27_25 = BoxedUnit.UNIT;
                    }
                    var36_33 = new Tuple2((Object)a.leftNode(), (Object)b.leftNode());
                    if (var36_33 == null) ** GOTO lbl-1000
                    var37_34 = (Option)var36_33._1();
                    var38_35 = (Option)var36_33._2();
                    if (!(var37_34 instanceof Some)) ** GOTO lbl-1000
                    var39_36 = (Some)var37_34;
                    aNode = (Node)var39_36.x();
                    if (var38_35 instanceof Some) {
                        var41_38 = (Some)var38_35;
                        bNode = (Node)var41_38.x();
                        this.checkEqual(aNode, bNode);
                        var43_40 = BoxedUnit.UNIT;
                    } else lbl-1000:
                    // 3 sources

                    {
                        if (var36_33 == null) break block9;
                        var44_41 = (Option)var36_33._1();
                        var45_42 = (Option)var36_33._2();
                        v2 = None$.MODULE$;
                        var46_43 = var44_41;
                        if (v2 != null ? v2.equals(var46_43) == false : var46_43 != null) break block9;
                        v3 = None$.MODULE$;
                        var47_44 = var45_42;
                        if (v3 != null ? v3.equals(var47_44) == false : var47_44 != null) break block9;
                        var43_40 = BoxedUnit.UNIT;
                    }
                    var48_45 = new Tuple2((Object)a.rightNode(), (Object)b.rightNode());
                    if (var48_45 == null) break;
                    var49_46 = (Option)var48_45._1();
                    var50_47 = (Option)var48_45._2();
                    if (!(var49_46 instanceof Some) || (aNode = (Node)(var51_48 = (Some)var49_46).x()) == null) break;
                    var53_50 = aNode;
                    if (!(var50_47 instanceof Some) || (bNode = (Node)(var54_51 = (Some)var50_47).x()) == null) break;
                    b = var56_53 = bNode;
                    a = var53_50;
                }
                if (var48_45 != null) {
                    var58_54 = (Option)var48_45._1();
                    var59_55 = (Option)var48_45._2();
                    v4 = None$.MODULE$;
                    var60_56 = var58_54;
                    if (!(v4 != null ? v4.equals(var60_56) == false : var60_56 != null)) {
                        v5 = None$.MODULE$;
                        var61_57 = var59_55;
                        if (!(v5 != null ? v5.equals(var61_57) == false : var61_57 != null)) {
                            var57_58 = BoxedUnit.UNIT;
                            return;
                        }
                    }
                }
                throw new AssertionError((Object)new StringBuilder().append((Object)"Only one instance has rightNode defined. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(a.rightNode: ", ", b.rightNode: ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{a.rightNode(), b.rightNode()}))).toString());
            }
            throw new AssertionError((Object)new StringBuilder().append((Object)"Only one instance has leftNode defined. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(a.leftNode: ", ", b.leftNode: ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{a.leftNode(), b.leftNode()}))).toString());
        }
        throw new AssertionError((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only one instance has stats defined. (a.stats: ", ", b.stats: ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{a.stats(), b.stats()})));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DecisionTreeSuite$() {
        MODULE$ = this;
        this.org$apache$spark$mllib$tree$DecisionTreeSuite$$createdModelNodeIds = new int[]{1, 2, 3, 6, 7};
    }
}

