/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.DecisionTree$;
import org.apache.spark.mllib.tree.DecisionTreeSuite$;
import org.apache.spark.mllib.tree.RandomForest;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.FeatureType$;
import org.apache.spark.mllib.tree.configuration.QuantileStrategy$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.configuration.Strategy$;
import org.apache.spark.mllib.tree.impl.BaggedPoint$;
import org.apache.spark.mllib.tree.impl.DecisionTreeMetadata;
import org.apache.spark.mllib.tree.impl.DecisionTreeMetadata$;
import org.apache.spark.mllib.tree.impl.TreePoint$;
import org.apache.spark.mllib.tree.impurity.Entropy$;
import org.apache.spark.mllib.tree.impurity.Gini$;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.impurity.Variance$;
import org.apache.spark.mllib.tree.model.Bin;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.DecisionTreeModel$;
import org.apache.spark.mllib.tree.model.InformationGainStats;
import org.apache.spark.mllib.tree.model.InformationGainStats$;
import org.apache.spark.mllib.tree.model.Node;
import org.apache.spark.mllib.tree.model.Node$;
import org.apache.spark.mllib.tree.model.Split;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Array$;
import scala.Double$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Queue;
import scala.collection.mutable.WrappedArray;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001B\u0001\u0003\u00015\u0011\u0011\u0003R3dSNLwN\u001c+sK\u0016\u001cV/\u001b;f\u0015\t\u0019A!\u0001\u0003ue\u0016,'BA\u0003\u0007\u0003\u0015iG\u000e\\5c\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019\u0011\u0002CA\b\u0011\u001b\u00051\u0011BA\t\u0007\u00055\u0019\u0006/\u0019:l\rVt7+^5uKB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0005kRLG.\u0003\u0002\u0018)\t)R\n\u00147jER+7\u000f^*qCJ\\7i\u001c8uKb$\b\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0003\u000f\u0015q\"\u0001#\u0001 \u0003E!UmY5tS>tGK]3f'VLG/\u001a\t\u00039\u00012Q!\u0001\u0002\t\u0002\u0005\u001a\"\u0001\t\b\t\u000be\u0001C\u0011A\u0012\u0015\u0003}AQ!\n\u0011\u0005\u0002\u0019\n!C^1mS\u0012\fG/Z\"mCN\u001c\u0018NZ5feR!q%\f\u001bI!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0011)f.\u001b;\t\u000b9\"\u0003\u0019A\u0018\u0002\u000b5|G-\u001a7\u0011\u0005A\u0012T\"A\u0019\u000b\u00059\u0012\u0011BA\u001a2\u0005E!UmY5tS>tGK]3f\u001b>$W\r\u001c\u0005\u0006k\u0011\u0002\rAN\u0001\u0006S:\u0004X\u000f\u001e\t\u0004o}\u0012eB\u0001\u001d>\u001d\tID(D\u0001;\u0015\tYD\"\u0001\u0004=e>|GOP\u0005\u0002U%\u0011a(K\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0001\u0015IA\u0002TKFT!AP\u0015\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015#\u0011A\u0003:fOJ,7o]5p]&\u0011q\t\u0012\u0002\r\u0019\u0006\u0014W\r\\3e!>Lg\u000e\u001e\u0005\u0006\u0013\u0012\u0002\rAS\u0001\u0011e\u0016\fX/\u001b:fI\u0006\u001b7-\u001e:bGf\u0004\"\u0001K&\n\u00051K#A\u0002#pk\ndW\rC\u0003OA\u0011\u0005q*A\twC2LG-\u0019;f%\u0016<'/Z:t_J$Ba\n)R%\")a&\u0014a\u0001_!)Q'\u0014a\u0001m!)1+\u0014a\u0001\u0015\u0006Y!/Z9vSJ,G-T*F\u0011\u0015)\u0006\u0005\"\u0001W\u0003\u0019:WM\\3sCR,wJ\u001d3fe\u0016$G*\u00192fY\u0016$\u0007k\\5oiN<\u0016\u000e\u001e5MC\n,G\u000e\r\u000b\u0002/B\u0019\u0001\u0006\u0017\"\n\u0005eK#!B!se\u0006L\b\"B.!\t\u00031\u0016AJ4f]\u0016\u0014\u0018\r^3Pe\u0012,'/\u001a3MC\n,G.\u001a3Q_&tGo],ji\"d\u0015MY3mc!)Q\f\tC\u0001-\u0006ar-\u001a8fe\u0006$Xm\u0014:eKJ,G\rT1cK2,G\rU8j]R\u001c\b\"B0!\t\u00031\u0016!H4f]\u0016\u0014\u0018\r^3DCR,wm\u001c:jG\u0006dG)\u0019;b!>Lg\u000e^:\t\u000b\u0005\u0004C\u0011\u00012\u0002O\u001d,g.\u001a:bi\u0016\u001c\u0015\r^3h_JL7-\u00197ECR\f\u0007k\\5oiN\f5OS1wC2K7\u000f\u001e\u000b\u0002GB\u0019A\r\u001b\"\u000e\u0003\u0015T!!\u00064\u000b\u0003\u001d\fAA[1wC&\u0011\u0011.\u001a\u0002\u0005\u0019&\u001cH\u000fC\u0003lA\u0011\u0005a+\u0001\u0016hK:,'/\u0019;f\u0007\u0006$XmZ8sS\u000e\fG\u000eR1uCB{\u0017N\u001c;t\r>\u0014X*\u001e7uS\u000ed\u0017m]:\t\u000b5\u0004C\u0011\u0001,\u0002S\u001d,g.\u001a:bi\u0016\u001cuN\u001c;j]V|Wo\u001d#bi\u0006\u0004v.\u001b8ug\u001a{'/T;mi&\u001cG.Y:t\u0011\u0015y\u0007\u0005\"\u0001W\u0003q:WM\\3sCR,7)\u0019;fO>\u0014\u0018nY1m\t\u0006$\u0018\rU8j]R\u001chi\u001c:Nk2$\u0018n\u00197bgN4uN](sI\u0016\u0014X\r\u001a$fCR,(/Z:\t\u000bE\u0004C\u0011\u0002:\u0002\u001d\r\u0014X-\u0019;f\u0019\u0016\fgMT8eKR\u00111O\u001e\t\u0003aQL!!^\u0019\u0003\t9{G-\u001a\u0005\u0006oB\u0004\r\u0001_\u0001\u0003S\u0012\u0004\"\u0001K=\n\u0005iL#aA%oi\")A\u0010\tC\u0005{\u0006\u00112M]3bi\u0016Le\u000e^3s]\u0006dgj\u001c3f)\r\u0019hp \u0005\u0006on\u0004\r\u0001\u001f\u0005\b\u0003\u0003Y\b\u0019AA\u0002\u0003-1W-\u0019;ve\u0016$\u0016\u0010]3\u0011\t\u0005\u0015\u0011q\u0005\b\u0005\u0003\u000f\t\tC\u0004\u0003\u0002\n\u0005ua\u0002BA\u0006\u00037qA!!\u0004\u0002\u001a9!\u0011qBA\f\u001d\u0011\t\t\"!\u0006\u000f\u0007e\n\u0019\"C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003\u0007\u0011I1!a\b\u0003\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&!\u00111EA\u0013\u0003-1U-\u0019;ve\u0016$\u0016\u0010]3\u000b\u0007\u0005}!!\u0003\u0003\u0002*\u0005-\"a\u0003$fCR,(/\u001a+za\u0016TA!a\t\u0002&!A\u0011q\u0006\u0011\u0005\u0002\u0019\t\t$A\u0006de\u0016\fG/Z'pI\u0016dGcA\u0018\u00024!A\u0011QGA\u0017\u0001\u0004\t9$\u0001\u0003bY\u001e|\u0007\u0003BA\u001d\u0003\u007fqA!a\u0002\u0002<%!\u0011QHA\u0013\u0003\u0011\tEnZ8\n\t\u0005\u0005\u00131\t\u0002\u0005\u00032<wN\u0003\u0003\u0002>\u0005\u0015\u0002\"CA$A\t\u0007I\u0011BA%\u0003M\u0019'/Z1uK\u0012lu\u000eZ3m\u001d>$W-\u00133t+\t\tY\u0005E\u0002)1bD\u0001\"a\u0014!A\u0003%\u00111J\u0001\u0015GJ,\u0017\r^3e\u001b>$W\r\u001c(pI\u0016LEm\u001d\u0011\t\u0011\u0005M\u0003\u0005\"\u0001\u0005\u0003+\n!b\u00195fG.,\u0015/^1m)\u00159\u0013qKA.\u0011\u001d\tI&!\u0015A\u0002=\n\u0011!\u0019\u0005\b\u0003;\n\t\u00061\u00010\u0003\u0005\u0011\u0007bBA*A\u0011%\u0011\u0011\r\u000b\u0006O\u0005\r\u0014Q\r\u0005\b\u00033\ny\u00061\u0001t\u0011\u001d\ti&a\u0018A\u0002MD\u0011\"!\u001b!\u0003\u0003%I!a\u001b\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003[\u0002B!a\u001c\u0002v5\u0011\u0011\u0011\u000f\u0006\u0004\u0003g2\u0017\u0001\u00027b]\u001eLA!a\u001e\u0002r\t1qJ\u00196fGR\u0004")
public class DecisionTreeSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public static LabeledPoint[] generateCategoricalDataPointsForMulticlassForOrderedFeatures() {
        return DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsForMulticlassForOrderedFeatures();
    }

    public static LabeledPoint[] generateContinuousDataPointsForMulticlass() {
        return DecisionTreeSuite$.MODULE$.generateContinuousDataPointsForMulticlass();
    }

    public static LabeledPoint[] generateCategoricalDataPointsForMulticlass() {
        return DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsForMulticlass();
    }

    public static java.util.List<LabeledPoint> generateCategoricalDataPointsAsJavaList() {
        return DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsAsJavaList();
    }

    public static LabeledPoint[] generateCategoricalDataPoints() {
        return DecisionTreeSuite$.MODULE$.generateCategoricalDataPoints();
    }

    public static LabeledPoint[] generateOrderedLabeledPoints() {
        return DecisionTreeSuite$.MODULE$.generateOrderedLabeledPoints();
    }

    public static LabeledPoint[] generateOrderedLabeledPointsWithLabel1() {
        return DecisionTreeSuite$.MODULE$.generateOrderedLabeledPointsWithLabel1();
    }

    public static LabeledPoint[] generateOrderedLabeledPointsWithLabel0() {
        return DecisionTreeSuite$.MODULE$.generateOrderedLabeledPointsWithLabel0();
    }

    public static void validateRegressor(DecisionTreeModel decisionTreeModel, Seq<LabeledPoint> seq, double d) {
        DecisionTreeSuite$.MODULE$.validateRegressor(decisionTreeModel, seq, d);
    }

    public static void validateClassifier(DecisionTreeModel decisionTreeModel, Seq<LabeledPoint> seq, double d) {
        DecisionTreeSuite$.MODULE$.validateClassifier(decisionTreeModel, seq, d);
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public DecisionTreeSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("Binary classification with continuous features: split and bin calculation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateOrderedLabeledPointsWithLabel1();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
                int $org_scalatest_assert_macro_right = 1000;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                SparkContext qual$1 = this.$outer.sc();
                WrappedArray x$20 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$21 = qual$1.parallelize$default$2();
                RDD rdd = qual$1.parallelize((Seq)x$20, x$21, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Gini$.MODULE$, 3, 2, 100, Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Tuple2 tuple2 = DecisionTree$.MODULE$.findSplitsBins(rdd, metadata);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    Split[][] splits = (Split[][])tuple2._1();
                    Bin[][] bins = (Bin[][])tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)splits, (Object)bins);
                    Split[][] splits2 = (Split[][])tuple23._1();
                    Bin[][] bins2 = (Bin[][])tuple23._2();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2.length));
                    int $org_scalatest_assert_macro_right2 = 2;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bins2.length));
                    int $org_scalatest_assert_macro_right3 = 2;
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2[0].length));
                    int $org_scalatest_assert_macro_right4 = 99;
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bins2[0].length));
                    int $org_scalatest_assert_macro_right5 = 100;
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                    return;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Binary classification with binary (ordered) categorical features: split and bin calculation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateCategoricalDataPoints();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
                int $org_scalatest_assert_macro_right = 1000;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                SparkContext qual$2 = this.$outer.sc();
                WrappedArray x$22 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$23 = qual$2.parallelize$default$2();
                RDD rdd = qual$2.parallelize((Seq)x$22, x$23, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$24 = Algo$.MODULE$.Classification();
                Gini$ x$25 = Gini$.MODULE$;
                int x$26 = 2;
                int x$27 = 2;
                int x$28 = 100;
                Map x$29 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2))}));
                Enumeration.Value x$30 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$31 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$32 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$33 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$34 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$35 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$36 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$24, (Impurity)x$25, x$26, x$27, x$28, x$30, x$29, x$31, x$32, x$33, x$34, x$35, x$36);
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy);
                Tuple2 tuple2 = DecisionTree$.MODULE$.findSplitsBins(rdd, metadata);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    Split[][] splits = (Split[][])tuple2._1();
                    Bin[][] bins = (Bin[][])tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)splits, (Object)bins);
                    Split[][] splits2 = (Split[][])tuple23._1();
                    Bin[][] bins2 = (Bin[][])tuple23._2();
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)"));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)"));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2.length));
                    int $org_scalatest_assert_macro_right2 = 2;
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bins2.length));
                    int $org_scalatest_assert_macro_right3 = 2;
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2[0].length));
                    int $org_scalatest_assert_macro_right4 = 0;
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bins2[0].length));
                    int $org_scalatest_assert_macro_right5 = 0;
                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                    return;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Binary classification with 3-ary (ordered) categorical features, with no samples for one category", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateCategoricalDataPoints();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
                int $org_scalatest_assert_macro_right = 1000;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                SparkContext qual$3 = this.$outer.sc();
                WrappedArray x$37 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$38 = qual$3.parallelize$default$2();
                RDD rdd = qual$3.parallelize((Seq)x$37, x$38, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$39 = Algo$.MODULE$.Classification();
                Gini$ x$40 = Gini$.MODULE$;
                int x$41 = 2;
                int x$42 = 2;
                int x$43 = 100;
                Map x$44 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)3))}));
                Enumeration.Value x$45 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$46 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$47 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$48 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$49 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$50 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$51 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$39, (Impurity)x$40, x$41, x$42, x$43, x$45, x$44, x$46, x$47, x$48, x$49, x$50, x$51);
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Tuple2 tuple2 = DecisionTree$.MODULE$.findSplitsBins(rdd, metadata);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    Split[][] splits = (Split[][])tuple2._1();
                    Bin[][] bins = (Bin[][])tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)splits, (Object)bins);
                    Split[][] splits2 = (Split[][])tuple23._1();
                    Bin[][] bins2 = (Bin[][])tuple23._2();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2.length));
                    int $org_scalatest_assert_macro_right2 = 2;
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bins2.length));
                    int $org_scalatest_assert_macro_right3 = 2;
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2[0].length));
                    int $org_scalatest_assert_macro_right4 = 0;
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bins2[0].length));
                    int $org_scalatest_assert_macro_right5 = 0;
                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                    return;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("extract categories from a number for multiclass classification", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                List l = DecisionTree$.MODULE$.extractMultiClassCategories(13, 10);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)l.length()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0, 2.0, 0.0})).toSeq());
                scala.collection.immutable.Seq $org_scalatest_assert_macro_right2 = l.toSeq();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("find splits for a continuous feature", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DecisionTreeMetadata fakeMetadata = new DecisionTreeMetadata(1, 0L, 0, 0, (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), new int[]{6}, (Impurity)Gini$.MODULE$, QuantileStrategy$.MODULE$.Sort(), 0, 0, 0.0, 0, 0);
                double[] featureSamples = (double[])Array$.MODULE$.fill(200000, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return package$.MODULE$.random();
                    }
                }, ClassTag$.MODULE$.Double());
                double[] splits = DecisionTree$.MODULE$.findSplitsForContinuousFeature(featureSamples, fakeMetadata, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits.length));
                int $org_scalatest_assert_macro_right = 5;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)fakeMetadata.numSplits(0)));
                int $org_scalatest_assert_macro_right2 = 5;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)fakeMetadata.numBins()[0]));
                int $org_scalatest_assert_macro_right3 = 6;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((double[])Predef$.MODULE$.doubleArrayOps(splits).distinct()).length));
                int $org_scalatest_assert_macro_right4 = splits.length;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                DecisionTreeMetadata fakeMetadata2 = new DecisionTreeMetadata(1, 0L, 0, 0, (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), new int[]{5}, (Impurity)Gini$.MODULE$, QuantileStrategy$.MODULE$.Sort(), 0, 0, 0.0, 0, 0);
                double[] featureSamples2 = (double[])Predef$.MODULE$.intArrayOps(new int[]{1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 3}).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(int x$4) {
                        return this.apply$mcDI$sp(x$4);
                    }

                    public double apply$mcDI$sp(int x$4) {
                        return x$4;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                double[] splits2 = DecisionTree$.MODULE$.findSplitsForContinuousFeature(featureSamples2, fakeMetadata2, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2.length));
                int $org_scalatest_assert_macro_right5 = 3;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((double[])Predef$.MODULE$.doubleArrayOps(splits2).distinct()).length));
                int $org_scalatest_assert_macro_right6 = splits2.length;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                DecisionTreeMetadata fakeMetadata3 = new DecisionTreeMetadata(1, 0L, 0, 0, (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), new int[]{3}, (Impurity)Gini$.MODULE$, QuantileStrategy$.MODULE$.Sort(), 0, 0, 0.0, 0, 0);
                double[] featureSamples3 = (double[])Predef$.MODULE$.intArrayOps(new int[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 4, 5}).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(int x$5) {
                        return this.apply$mcDI$sp(x$5);
                    }

                    public double apply$mcDI$sp(int x$5) {
                        return x$5;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                double[] splits3 = DecisionTree$.MODULE$.findSplitsForContinuousFeature(featureSamples3, fakeMetadata3, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits3.length));
                int $org_scalatest_assert_macro_right7 = 2;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)splits3[0]));
                double $org_scalatest_assert_macro_right8 = 2.0;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)splits3[1]));
                double $org_scalatest_assert_macro_right9 = 3.0;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                DecisionTreeMetadata fakeMetadata4 = new DecisionTreeMetadata(1, 0L, 0, 0, (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), new int[]{3}, (Impurity)Gini$.MODULE$, QuantileStrategy$.MODULE$.Sort(), 0, 0, 0.0, 0, 0);
                double[] featureSamples4 = (double[])Predef$.MODULE$.intArrayOps(new int[]{0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2}).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(int x$6) {
                        return this.apply$mcDI$sp(x$6);
                    }

                    public double apply$mcDI$sp(int x$6) {
                        return x$6;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                double[] splits4 = DecisionTree$.MODULE$.findSplitsForContinuousFeature(featureSamples4, fakeMetadata4, 0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits4.length));
                int $org_scalatest_assert_macro_right10 = 1;
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)splits4[0]));
                double $org_scalatest_assert_macro_right11 = 1.0;
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Multiclass classification with unordered categorical features: split and bin calculations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateCategoricalDataPoints();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
                int $org_scalatest_assert_macro_right = 1000;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                SparkContext qual$4 = this.$outer.sc();
                WrappedArray x$52 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$53 = qual$4.parallelize$default$2();
                RDD rdd = qual$4.parallelize((Seq)x$52, x$53, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$54 = Algo$.MODULE$.Classification();
                Gini$ x$55 = Gini$.MODULE$;
                int x$56 = 2;
                int x$57 = 100;
                int x$58 = 100;
                Map x$59 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)3))}));
                Enumeration.Value x$60 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$61 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$62 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$63 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$64 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$65 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$66 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$54, (Impurity)x$55, x$56, x$57, x$58, x$60, x$59, x$61, x$62, x$63, x$64, x$65, x$66);
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Tuple2 tuple2 = DecisionTree$.MODULE$.findSplitsBins(rdd, metadata);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    Split[][] splits = (Split[][])tuple2._1();
                    Bin[][] bins = (Bin[][])tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)splits, (Object)bins);
                    Split[][] splits2 = (Split[][])tuple23._1();
                    Bin[][] bins2 = (Bin[][])tuple23._2();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2.length));
                    int $org_scalatest_assert_macro_right2 = 2;
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bins2.length));
                    int $org_scalatest_assert_macro_right3 = 2;
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2[0].length));
                    int $org_scalatest_assert_macro_right4 = 3;
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bins2[0].length));
                    int $org_scalatest_assert_macro_right5 = 0;
                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2[0][0].feature()));
                    int $org_scalatest_assert_macro_right6 = 0;
                    Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)splits2[0][0].threshold()));
                    double $org_scalatest_assert_macro_right7 = Double$.MODULE$.MinValue();
                    Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(splits2[0][0].featureType());
                    Enumeration.Value $org_scalatest_assert_macro_right8 = FeatureType$.MODULE$.Categorical();
                    Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2[0][0].categories().length()));
                    int $org_scalatest_assert_macro_right9 = 1;
                    Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                    List $org_scalatest_assert_macro_left10 = splits2[0][0].categories();
                    double $org_scalatest_assert_macro_right10 = 0.0;
                    Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "contains", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.contains((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right10)));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2[1][0].feature()));
                    int $org_scalatest_assert_macro_right11 = 1;
                    Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)splits2[1][0].threshold()));
                    double $org_scalatest_assert_macro_right12 = Double$.MODULE$.MinValue();
                    Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right12), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.$outer.convertToEqualizer(splits2[1][0].featureType());
                    Enumeration.Value $org_scalatest_assert_macro_right13 = FeatureType$.MODULE$.Categorical();
                    Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)$org_scalatest_assert_macro_right13, $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)$org_scalatest_assert_macro_right13, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left14 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2[1][0].categories().length()));
                    int $org_scalatest_assert_macro_right14 = 1;
                    Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right14), $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right14), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"");
                    List $org_scalatest_assert_macro_left15 = splits2[1][0].categories();
                    double $org_scalatest_assert_macro_right15 = 0.0;
                    Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "contains", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right15), $org_scalatest_assert_macro_left15.contains((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right15)));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left16 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2[0][1].feature()));
                    int $org_scalatest_assert_macro_right16 = 0;
                    Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right16), $org_scalatest_assert_macro_left16.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right16), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left17 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)splits2[0][1].threshold()));
                    double $org_scalatest_assert_macro_right17 = Double$.MODULE$.MinValue();
                    Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left17, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right17), $org_scalatest_assert_macro_left17.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right17), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left18 = this.$outer.convertToEqualizer(splits2[0][1].featureType());
                    Enumeration.Value $org_scalatest_assert_macro_right18 = FeatureType$.MODULE$.Categorical();
                    Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left18, "===", (Object)$org_scalatest_assert_macro_right18, $org_scalatest_assert_macro_left18.$eq$eq$eq((Object)$org_scalatest_assert_macro_right18, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left19 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2[0][1].categories().length()));
                    int $org_scalatest_assert_macro_right19 = 1;
                    Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left19, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right19), $org_scalatest_assert_macro_left19.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right19), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"");
                    List $org_scalatest_assert_macro_left20 = splits2[0][1].categories();
                    double $org_scalatest_assert_macro_right20 = 1.0;
                    Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left20, "contains", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right20), $org_scalatest_assert_macro_left20.contains((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right20)));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left21 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2[1][1].feature()));
                    int $org_scalatest_assert_macro_right21 = 1;
                    Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left21, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right21), $org_scalatest_assert_macro_left21.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right21), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left22 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)splits2[1][1].threshold()));
                    double $org_scalatest_assert_macro_right22 = Double$.MODULE$.MinValue();
                    Bool $org_scalatest_assert_macro_expr24 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left22, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right22), $org_scalatest_assert_macro_left22.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right22), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr24, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left23 = this.$outer.convertToEqualizer(splits2[1][1].featureType());
                    Enumeration.Value $org_scalatest_assert_macro_right23 = FeatureType$.MODULE$.Categorical();
                    Bool $org_scalatest_assert_macro_expr25 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left23, "===", (Object)$org_scalatest_assert_macro_right23, $org_scalatest_assert_macro_left23.$eq$eq$eq((Object)$org_scalatest_assert_macro_right23, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr25, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left24 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2[1][1].categories().length()));
                    int $org_scalatest_assert_macro_right24 = 1;
                    Bool $org_scalatest_assert_macro_expr26 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left24, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right24), $org_scalatest_assert_macro_left24.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right24), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr26, (Object)"");
                    List $org_scalatest_assert_macro_left25 = splits2[1][1].categories();
                    double $org_scalatest_assert_macro_right25 = 1.0;
                    Bool $org_scalatest_assert_macro_expr27 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left25, "contains", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right25), $org_scalatest_assert_macro_left25.contains((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right25)));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr27, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left26 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2[0][2].feature()));
                    int $org_scalatest_assert_macro_right26 = 0;
                    Bool $org_scalatest_assert_macro_expr28 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left26, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right26), $org_scalatest_assert_macro_left26.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right26), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr28, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left27 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)splits2[0][2].threshold()));
                    double $org_scalatest_assert_macro_right27 = Double$.MODULE$.MinValue();
                    Bool $org_scalatest_assert_macro_expr29 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left27, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right27), $org_scalatest_assert_macro_left27.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right27), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr29, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left28 = this.$outer.convertToEqualizer(splits2[0][2].featureType());
                    Enumeration.Value $org_scalatest_assert_macro_right28 = FeatureType$.MODULE$.Categorical();
                    Bool $org_scalatest_assert_macro_expr30 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left28, "===", (Object)$org_scalatest_assert_macro_right28, $org_scalatest_assert_macro_left28.$eq$eq$eq((Object)$org_scalatest_assert_macro_right28, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr30, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left29 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2[0][2].categories().length()));
                    int $org_scalatest_assert_macro_right29 = 2;
                    Bool $org_scalatest_assert_macro_expr31 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left29, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right29), $org_scalatest_assert_macro_left29.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right29), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr31, (Object)"");
                    List $org_scalatest_assert_macro_left30 = splits2[0][2].categories();
                    double $org_scalatest_assert_macro_right30 = 0.0;
                    Bool $org_scalatest_assert_macro_expr32 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left30, "contains", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right30), $org_scalatest_assert_macro_left30.contains((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right30)));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr32, (Object)"");
                    List $org_scalatest_assert_macro_left31 = splits2[0][2].categories();
                    double $org_scalatest_assert_macro_right31 = 1.0;
                    Bool $org_scalatest_assert_macro_expr33 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left31, "contains", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right31), $org_scalatest_assert_macro_left31.contains((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right31)));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr33, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left32 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2[1][2].feature()));
                    int $org_scalatest_assert_macro_right32 = 1;
                    Bool $org_scalatest_assert_macro_expr34 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left32, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right32), $org_scalatest_assert_macro_left32.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right32), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr34, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left33 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)splits2[1][2].threshold()));
                    double $org_scalatest_assert_macro_right33 = Double$.MODULE$.MinValue();
                    Bool $org_scalatest_assert_macro_expr35 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left33, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right33), $org_scalatest_assert_macro_left33.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right33), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr35, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left34 = this.$outer.convertToEqualizer(splits2[1][2].featureType());
                    Enumeration.Value $org_scalatest_assert_macro_right34 = FeatureType$.MODULE$.Categorical();
                    Bool $org_scalatest_assert_macro_expr36 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left34, "===", (Object)$org_scalatest_assert_macro_right34, $org_scalatest_assert_macro_left34.$eq$eq$eq((Object)$org_scalatest_assert_macro_right34, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr36, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left35 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2[1][2].categories().length()));
                    int $org_scalatest_assert_macro_right35 = 2;
                    Bool $org_scalatest_assert_macro_expr37 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left35, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right35), $org_scalatest_assert_macro_left35.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right35), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr37, (Object)"");
                    List $org_scalatest_assert_macro_left36 = splits2[1][2].categories();
                    double $org_scalatest_assert_macro_right36 = 0.0;
                    Bool $org_scalatest_assert_macro_expr38 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left36, "contains", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right36), $org_scalatest_assert_macro_left36.contains((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right36)));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr38, (Object)"");
                    List $org_scalatest_assert_macro_left37 = splits2[1][2].categories();
                    double $org_scalatest_assert_macro_right37 = 1.0;
                    Bool $org_scalatest_assert_macro_expr39 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left37, "contains", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right37), $org_scalatest_assert_macro_left37.contains((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right37)));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr39, (Object)"");
                    return;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Multiclass classification with ordered categorical features: split and bin calculations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsForMulticlassForOrderedFeatures();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
                int $org_scalatest_assert_macro_right = 3000;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                SparkContext qual$5 = this.$outer.sc();
                WrappedArray x$67 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$68 = qual$5.parallelize$default$2();
                RDD rdd = qual$5.parallelize((Seq)x$67, x$68, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$69 = Algo$.MODULE$.Classification();
                Gini$ x$70 = Gini$.MODULE$;
                int x$71 = 2;
                int x$72 = 100;
                int x$73 = 100;
                Map x$74 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)10))}));
                Enumeration.Value x$75 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$76 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$77 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$78 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$79 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$80 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$81 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$69, (Impurity)x$70, x$71, x$72, x$73, x$75, x$74, x$76, x$77, x$78, x$79, x$80, x$81);
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Tuple2 tuple2 = DecisionTree$.MODULE$.findSplitsBins(rdd, metadata);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    Split[][] splits = (Split[][])tuple2._1();
                    Bin[][] bins = (Bin[][])tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)splits, (Object)bins);
                    Split[][] splits2 = (Split[][])tuple23._1();
                    Bin[][] bins2 = (Bin[][])tuple23._2();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2.length));
                    int $org_scalatest_assert_macro_right2 = 2;
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bins2.length));
                    int $org_scalatest_assert_macro_right3 = 2;
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2[0].length));
                    int $org_scalatest_assert_macro_right4 = 0;
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bins2[0].length));
                    int $org_scalatest_assert_macro_right5 = 0;
                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                    return;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Avoid aggregation on the last level", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int x$96;
                boolean x$95;
                double x$94;
                int x$93;
                double x$92;
                int x$91;
                Enumeration.Value x$90;
                LabeledPoint[] arr = (LabeledPoint[])((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0}))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 1.0})))});
                SparkContext qual$6 = this.$outer.sc();
                WrappedArray x$82 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$83 = qual$6.parallelize$default$2();
                RDD input = qual$6.parallelize((Seq)x$82, x$83, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$84 = Algo$.MODULE$.Classification();
                Gini$ x$85 = Gini$.MODULE$;
                int x$86 = 1;
                int x$87 = 2;
                Map x$88 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3))}));
                int x$89 = Strategy$.MODULE$.$lessinit$greater$default$5();
                Strategy strategy = new Strategy(x$84, (Impurity)x$85, x$86, x$87, x$89, x$90 = Strategy$.MODULE$.$lessinit$greater$default$6(), x$88, x$91 = Strategy$.MODULE$.$lessinit$greater$default$8(), x$92 = Strategy$.MODULE$.$lessinit$greater$default$9(), x$93 = Strategy$.MODULE$.$lessinit$greater$default$10(), x$94 = Strategy$.MODULE$.$lessinit$greater$default$11(), x$95 = Strategy$.MODULE$.$lessinit$greater$default$12(), x$96 = Strategy$.MODULE$.$lessinit$greater$default$13());
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(input, strategy);
                Tuple2 tuple2 = DecisionTree$.MODULE$.findSplitsBins(input, metadata);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    Split[][] splits = (Split[][])tuple2._1();
                    Bin[][] bins = (Bin[][])tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)splits, (Object)bins);
                    Split[][] splits2 = (Split[][])tuple23._1();
                    Bin[][] bins2 = (Bin[][])tuple23._2();
                    RDD treeInput = TreePoint$.MODULE$.convertToTreeRDD(input, bins2, metadata);
                    RDD baggedInput = BaggedPoint$.MODULE$.convertToBaggedRDD(treeInput, 1.0, 1, false, BaggedPoint$.MODULE$.convertToBaggedRDD$default$5());
                    Node topNode = Node$.MODULE$.emptyNode(1);
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)topNode.predict().predict()));
                    double $org_scalatest_assert_macro_right = Double$.MODULE$.MinValue();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)topNode.impurity()));
                    double $org_scalatest_assert_macro_right2 = -1.0;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)topNode.isLeaf()));
                    boolean $org_scalatest_assert_macro_right3 = false;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                    Map nodesForGroup = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)new Node[]{topNode})}));
                    Map treeToNodeToIndexInfo = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)topNode.id()), (Object)new RandomForest.NodeIndexInfo(0, (Option)None$.MODULE$))})))}));
                    Queue nodeQueue = new Queue();
                    DecisionTree$.MODULE$.findBestSplits(baggedInput, metadata, (Node[])((Object[])new Node[]{topNode}), nodesForGroup, treeToNodeToIndexInfo, splits2, bins2, nodeQueue, DecisionTree$.MODULE$.findBestSplits$default$9(), DecisionTree$.MODULE$.findBestSplits$default$10());
                    Queue $org_scalatest_assert_macro_left4 = nodeQueue;
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)topNode.predict().predict()));
                    double $org_scalatest_assert_macro_right4 = Double$.MODULE$.MinValue();
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "!==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left5.$bang$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)topNode.impurity()));
                    double $org_scalatest_assert_macro_right5 = -1.0;
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "!==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left6.$bang$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)((Node)topNode.leftNode().get()).predict().predict()));
                    double $org_scalatest_assert_macro_right6 = 0.0;
                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)((Node)topNode.rightNode().get()).predict().predict()));
                    double $org_scalatest_assert_macro_right7 = 1.0;
                    Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)((Node)topNode.leftNode().get()).impurity()));
                    double $org_scalatest_assert_macro_right8 = 0.0;
                    Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)((Node)topNode.rightNode().get()).impurity()));
                    double $org_scalatest_assert_macro_right9 = 0.0;
                    Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                    return;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Avoid aggregation if impurity is 0.0", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int x$111;
                boolean x$110;
                double x$109;
                int x$108;
                double x$107;
                int x$106;
                Enumeration.Value x$105;
                LabeledPoint[] arr = (LabeledPoint[])((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 1.0}))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0, 1.0})))});
                SparkContext qual$7 = this.$outer.sc();
                WrappedArray x$97 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$98 = qual$7.parallelize$default$2();
                RDD input = qual$7.parallelize((Seq)x$97, x$98, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$99 = Algo$.MODULE$.Classification();
                Gini$ x$100 = Gini$.MODULE$;
                int x$101 = 5;
                int x$102 = 2;
                Map x$103 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3))}));
                int x$104 = Strategy$.MODULE$.$lessinit$greater$default$5();
                Strategy strategy = new Strategy(x$99, (Impurity)x$100, x$101, x$102, x$104, x$105 = Strategy$.MODULE$.$lessinit$greater$default$6(), x$103, x$106 = Strategy$.MODULE$.$lessinit$greater$default$8(), x$107 = Strategy$.MODULE$.$lessinit$greater$default$9(), x$108 = Strategy$.MODULE$.$lessinit$greater$default$10(), x$109 = Strategy$.MODULE$.$lessinit$greater$default$11(), x$110 = Strategy$.MODULE$.$lessinit$greater$default$12(), x$111 = Strategy$.MODULE$.$lessinit$greater$default$13());
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(input, strategy);
                Tuple2 tuple2 = DecisionTree$.MODULE$.findSplitsBins(input, metadata);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    Split[][] splits = (Split[][])tuple2._1();
                    Bin[][] bins = (Bin[][])tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)splits, (Object)bins);
                    Split[][] splits2 = (Split[][])tuple23._1();
                    Bin[][] bins2 = (Bin[][])tuple23._2();
                    RDD treeInput = TreePoint$.MODULE$.convertToTreeRDD(input, bins2, metadata);
                    RDD baggedInput = BaggedPoint$.MODULE$.convertToBaggedRDD(treeInput, 1.0, 1, false, BaggedPoint$.MODULE$.convertToBaggedRDD$default$5());
                    Node topNode = Node$.MODULE$.emptyNode(1);
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)topNode.predict().predict()));
                    double $org_scalatest_assert_macro_right = Double$.MODULE$.MinValue();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)topNode.impurity()));
                    double $org_scalatest_assert_macro_right2 = -1.0;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)topNode.isLeaf()));
                    boolean $org_scalatest_assert_macro_right3 = false;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                    Map nodesForGroup = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)new Node[]{topNode})}));
                    Map treeToNodeToIndexInfo = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)topNode.id()), (Object)new RandomForest.NodeIndexInfo(0, (Option)None$.MODULE$))})))}));
                    Queue nodeQueue = new Queue();
                    DecisionTree$.MODULE$.findBestSplits(baggedInput, metadata, (Node[])((Object[])new Node[]{topNode}), nodesForGroup, treeToNodeToIndexInfo, splits2, bins2, nodeQueue, DecisionTree$.MODULE$.findBestSplits$default$9(), DecisionTree$.MODULE$.findBestSplits$default$10());
                    Queue $org_scalatest_assert_macro_left4 = nodeQueue;
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)topNode.predict().predict()));
                    double $org_scalatest_assert_macro_right4 = Double$.MODULE$.MinValue();
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "!==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left5.$bang$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)topNode.impurity()));
                    double $org_scalatest_assert_macro_right5 = -1.0;
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "!==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left6.$bang$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)((Node)topNode.leftNode().get()).predict().predict()));
                    double $org_scalatest_assert_macro_right6 = 0.0;
                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)((Node)topNode.rightNode().get()).predict().predict()));
                    double $org_scalatest_assert_macro_right7 = 1.0;
                    Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)((Node)topNode.leftNode().get()).impurity()));
                    double $org_scalatest_assert_macro_right8 = 0.0;
                    Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)((Node)topNode.rightNode().get()).impurity()));
                    double $org_scalatest_assert_macro_right9 = 0.0;
                    Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                    return;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Second level node building with vs. without groups", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateOrderedLabeledPoints();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
                int $org_scalatest_assert_macro_right = 1000;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                SparkContext qual$8 = this.$outer.sc();
                WrappedArray x$112 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$113 = qual$8.parallelize$default$2();
                RDD rdd = qual$8.parallelize((Seq)x$112, x$113, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Entropy$.MODULE$, 3, 2, 100, Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy);
                Tuple2 tuple2 = DecisionTree$.MODULE$.findSplitsBins(rdd, metadata);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    Split[][] splits = (Split[][])tuple2._1();
                    Bin[][] bins = (Bin[][])tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)splits, (Object)bins);
                    Split[][] splits2 = (Split[][])tuple23._1();
                    Bin[][] bins2 = (Bin[][])tuple23._2();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2.length));
                    int $org_scalatest_assert_macro_right2 = 2;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2[0].length));
                    int $org_scalatest_assert_macro_right3 = 99;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bins2.length));
                    int $org_scalatest_assert_macro_right4 = 2;
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bins2[0].length));
                    int $org_scalatest_assert_macro_right5 = 100;
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                    Strategy strategyOneNode = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Entropy$.MODULE$, 1, 2, 100, Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
                    DecisionTreeModel modelOneNode = DecisionTree$.MODULE$.train(rdd, strategyOneNode);
                    Node rootNode1 = modelOneNode.topNode().deepCopy();
                    Node rootNode2 = modelOneNode.topNode().deepCopy();
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(rootNode1.leftNode().nonEmpty(), "rootNode1.leftNode.nonEmpty");
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(rootNode1.rightNode().nonEmpty(), "rootNode1.rightNode.nonEmpty");
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                    RDD treeInput = TreePoint$.MODULE$.convertToTreeRDD(rdd, bins2, metadata);
                    RDD baggedInput = BaggedPoint$.MODULE$.convertToBaggedRDD(treeInput, 1.0, 1, false, BaggedPoint$.MODULE$.convertToBaggedRDD$default$5());
                    Map nodesForGroup = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)new Node[]{(Node)rootNode1.leftNode().get(), (Node)rootNode1.rightNode().get()})}));
                    Map treeToNodeToIndexInfo = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)((Node)rootNode1.leftNode().get()).id()), (Object)new RandomForest.NodeIndexInfo(0, (Option)None$.MODULE$)), new Tuple2((Object)BoxesRunTime.boxToInteger((int)((Node)rootNode1.rightNode().get()).id()), (Object)new RandomForest.NodeIndexInfo(1, (Option)None$.MODULE$))})))}));
                    Queue nodeQueue = new Queue();
                    DecisionTree$.MODULE$.findBestSplits(baggedInput, metadata, (Node[])((Object[])new Node[]{rootNode1}), nodesForGroup, treeToNodeToIndexInfo, splits2, bins2, nodeQueue, DecisionTree$.MODULE$.findBestSplits$default$9(), DecisionTree$.MODULE$.findBestSplits$default$10());
                    Node[] children1 = new Node[]{(Node)rootNode1.leftNode().get(), (Node)rootNode1.rightNode().get()};
                    Map nodesForGroupA = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)new Node[]{(Node)rootNode2.leftNode().get()})}));
                    Map treeToNodeToIndexInfoA = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)((Node)rootNode2.leftNode().get()).id()), (Object)new RandomForest.NodeIndexInfo(0, (Option)None$.MODULE$))})))}));
                    nodeQueue.clear();
                    DecisionTree$.MODULE$.findBestSplits(baggedInput, metadata, (Node[])((Object[])new Node[]{rootNode2}), nodesForGroupA, treeToNodeToIndexInfoA, splits2, bins2, nodeQueue, DecisionTree$.MODULE$.findBestSplits$default$9(), DecisionTree$.MODULE$.findBestSplits$default$10());
                    Map nodesForGroupB = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)new Node[]{(Node)rootNode2.rightNode().get()})}));
                    Map treeToNodeToIndexInfoB = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)((Node)rootNode2.rightNode().get()).id()), (Object)new RandomForest.NodeIndexInfo(0, (Option)None$.MODULE$))})))}));
                    nodeQueue.clear();
                    DecisionTree$.MODULE$.findBestSplits(baggedInput, metadata, (Node[])((Object[])new Node[]{rootNode2}), nodesForGroupB, treeToNodeToIndexInfoB, splits2, bins2, nodeQueue, DecisionTree$.MODULE$.findBestSplits$default$9(), DecisionTree$.MODULE$.findBestSplits$default$10());
                    Node[] children2 = new Node[]{(Node)rootNode2.leftNode().get(), (Node)rootNode2.rightNode().get()};
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)new Serializable(this, children1, children2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$14 $outer;
                        private final Node[] children1$1;
                        private final Node[] children2$1;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            Bool bool;
                            Bool bool2;
                            Bool $org_scalatest_assert_macro_left = Bool$.MODULE$.simpleMacroBool(this.children1$1[i].stats().nonEmpty(), "children1.apply(i).stats.nonEmpty");
                            if ($org_scalatest_assert_macro_left.value()) {
                                double $org_scalatest_assert_macro_left2 = ((InformationGainStats)this.children1$1[i].stats().get()).gain();
                                int $org_scalatest_assert_macro_right = 0;
                                bool2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left2 > (double)$org_scalatest_assert_macro_right);
                            } else {
                                bool2 = Bool$.MODULE$.simpleMacroBool(false, "");
                            }
                            Bool $org_scalatest_assert_macro_right = bool2;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "&&", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$amp$amp($org_scalatest_assert_macro_right));
                            this.$outer.org$apache$spark$mllib$tree$DecisionTreeSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            Bool $org_scalatest_assert_macro_left3 = Bool$.MODULE$.simpleMacroBool(this.children2$1[i].stats().nonEmpty(), "children2.apply(i).stats.nonEmpty");
                            if ($org_scalatest_assert_macro_left3.value()) {
                                double $org_scalatest_assert_macro_left4 = ((InformationGainStats)this.children2$1[i].stats().get()).gain();
                                int $org_scalatest_assert_macro_right2 = 0;
                                bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left4 > (double)$org_scalatest_assert_macro_right2);
                            } else {
                                bool = Bool$.MODULE$.simpleMacroBool(false, "");
                            }
                            Bool $org_scalatest_assert_macro_right3 = bool;
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$amp$amp($org_scalatest_assert_macro_right3));
                            this.$outer.org$apache$spark$mllib$tree$DecisionTreeSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.org$apache$spark$mllib$tree$DecisionTreeSuite$$anonfun$$$outer().convertToEqualizer(this.children1$1[i].split());
                            Option $org_scalatest_assert_macro_right4 = this.children2$1[i].split();
                            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$mllib$tree$DecisionTreeSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                            Bool $org_scalatest_assert_macro_left6 = Bool$.MODULE$.simpleMacroBool(this.children1$1[i].stats().nonEmpty(), "children1.apply(i).stats.nonEmpty");
                            Bool $org_scalatest_assert_macro_right5 = $org_scalatest_assert_macro_left6.value() ? Bool$.MODULE$.simpleMacroBool(this.children2$1[i].stats().nonEmpty(), "children2.apply(i).stats.nonEmpty") : Bool$.MODULE$.simpleMacroBool(false, "");
                            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "&&", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left6.$amp$amp($org_scalatest_assert_macro_right5));
                            this.$outer.org$apache$spark$mllib$tree$DecisionTreeSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                            InformationGainStats stats1 = (InformationGainStats)this.children1$1[i].stats().get();
                            InformationGainStats stats2 = (InformationGainStats)this.children2$1[i].stats().get();
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.org$apache$spark$mllib$tree$DecisionTreeSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)stats1.gain()));
                            double $org_scalatest_assert_macro_right6 = stats2.gain();
                            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$mllib$tree$DecisionTreeSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.org$apache$spark$mllib$tree$DecisionTreeSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)stats1.impurity()));
                            double $org_scalatest_assert_macro_right7 = stats2.impurity();
                            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$mllib$tree$DecisionTreeSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.org$apache$spark$mllib$tree$DecisionTreeSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)stats1.leftImpurity()));
                            double $org_scalatest_assert_macro_right8 = stats2.leftImpurity();
                            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$mllib$tree$DecisionTreeSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.org$apache$spark$mllib$tree$DecisionTreeSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)stats1.rightImpurity()));
                            double $org_scalatest_assert_macro_right9 = stats2.rightImpurity();
                            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$mllib$tree$DecisionTreeSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.$outer.org$apache$spark$mllib$tree$DecisionTreeSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)this.children1$1[i].predict().predict()));
                            double $org_scalatest_assert_macro_right10 = this.children2$1[i].predict().predict();
                            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$mllib$tree$DecisionTreeSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.children1$1 = children1$1;
                            this.children2$1 = children2$1;
                        }
                    });
                    return;
                }
                throw new MatchError((Object)tuple2);
            }

            public /* synthetic */ DecisionTreeSuite org$apache$spark$mllib$tree$DecisionTreeSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Binary classification stump with ordered categorical features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateCategoricalDataPoints();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
                int $org_scalatest_assert_macro_right = 1000;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                SparkContext qual$9 = this.$outer.sc();
                WrappedArray x$114 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$115 = qual$9.parallelize$default$2();
                RDD rdd = qual$9.parallelize((Seq)x$114, x$115, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$116 = Algo$.MODULE$.Classification();
                Gini$ x$117 = Gini$.MODULE$;
                int x$118 = 2;
                int x$119 = 2;
                int x$120 = 100;
                Map x$121 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)3))}));
                Enumeration.Value x$122 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$123 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$124 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$125 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$126 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$127 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$128 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$116, (Impurity)x$117, x$119, x$118, x$120, x$122, x$121, x$123, x$124, x$125, x$126, x$127, x$128);
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Tuple2 tuple2 = DecisionTree$.MODULE$.findSplitsBins(rdd, metadata);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    Split[][] splits = (Split[][])tuple2._1();
                    Bin[][] bins = (Bin[][])tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)splits, (Object)bins);
                    Split[][] splits2 = (Split[][])tuple23._1();
                    Bin[][] bins2 = (Bin[][])tuple23._2();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2.length));
                    int $org_scalatest_assert_macro_right2 = 2;
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bins2.length));
                    int $org_scalatest_assert_macro_right3 = 2;
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2[0].length));
                    int $org_scalatest_assert_macro_right4 = 0;
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bins2[0].length));
                    int $org_scalatest_assert_macro_right5 = 0;
                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                    Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
                    Split split = (Split)rootNode.split().get();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(split.categories());
                    List $org_scalatest_assert_macro_right6 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}));
                    Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(split.featureType());
                    Enumeration.Value $org_scalatest_assert_macro_right7 = FeatureType$.MODULE$.Categorical();
                    Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)split.threshold()));
                    double $org_scalatest_assert_macro_right8 = Double$.MODULE$.MinValue();
                    Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                    InformationGainStats stats = (InformationGainStats)rootNode.stats().get();
                    double $org_scalatest_assert_macro_left9 = stats.gain();
                    int $org_scalatest_assert_macro_right9 = 0;
                    Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left9), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9 > (double)$org_scalatest_assert_macro_right9);
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.predict().predict()));
                    int $org_scalatest_assert_macro_right10 = 1;
                    Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
                    double $org_scalatest_assert_macro_left11 = stats.impurity();
                    double $org_scalatest_assert_macro_right11 = 0.2;
                    Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left11), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11 > $org_scalatest_assert_macro_right11);
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"");
                    return;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Regression stump with 3-ary (ordered) categorical features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateCategoricalDataPoints();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
                int $org_scalatest_assert_macro_right = 1000;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                SparkContext qual$10 = this.$outer.sc();
                WrappedArray x$129 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$130 = qual$10.parallelize$default$2();
                RDD rdd = qual$10.parallelize((Seq)x$129, x$130, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$131 = Algo$.MODULE$.Regression();
                Variance$ x$132 = Variance$.MODULE$;
                int x$133 = 2;
                int x$134 = 100;
                Map x$135 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)3))}));
                int x$136 = Strategy$.MODULE$.$lessinit$greater$default$4();
                Enumeration.Value x$137 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$138 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$139 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$140 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$141 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$142 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$143 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$131, (Impurity)x$132, x$133, x$136, x$134, x$137, x$135, x$138, x$139, x$140, x$141, x$142, x$143);
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
                Split split = (Split)rootNode.split().get();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.categories().length()));
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                List $org_scalatest_assert_macro_left3 = split.categories();
                double $org_scalatest_assert_macro_right3 = 1.0;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.contains((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(split.featureType());
                Enumeration.Value $org_scalatest_assert_macro_right4 = FeatureType$.MODULE$.Categorical();
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)split.threshold()));
                double $org_scalatest_assert_macro_right5 = Double$.MODULE$.MinValue();
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                InformationGainStats stats = (InformationGainStats)rootNode.stats().get();
                double $org_scalatest_assert_macro_left6 = stats.gain();
                int $org_scalatest_assert_macro_right6 = 0;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left6), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 > (double)$org_scalatest_assert_macro_right6);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.predict().predict()));
                double $org_scalatest_assert_macro_right7 = 0.6;
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                double $org_scalatest_assert_macro_left8 = stats.impurity();
                double $org_scalatest_assert_macro_right8 = 0.2;
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left8), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8 > $org_scalatest_assert_macro_right8);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Regression stump with binary (ordered) categorical features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateCategoricalDataPoints();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
                int $org_scalatest_assert_macro_right = 1000;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                SparkContext qual$11 = this.$outer.sc();
                WrappedArray x$144 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$145 = qual$11.parallelize$default$2();
                RDD rdd = qual$11.parallelize((Seq)x$144, x$145, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$146 = Algo$.MODULE$.Regression();
                Variance$ x$147 = Variance$.MODULE$;
                int x$148 = 2;
                int x$149 = 100;
                Map x$150 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2))}));
                int x$151 = Strategy$.MODULE$.$lessinit$greater$default$4();
                Enumeration.Value x$152 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$153 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$154 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$155 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$156 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$157 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$158 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$146, (Impurity)x$147, x$148, x$151, x$149, x$152, x$150, x$153, x$154, x$155, x$156, x$157, x$158);
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                DecisionTreeModel model = DecisionTree$.MODULE$.train(rdd, strategy);
                DecisionTreeSuite$.MODULE$.validateRegressor(model, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 0.0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.numNodes()));
                int $org_scalatest_assert_macro_right2 = 3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.depth()));
                int $org_scalatest_assert_macro_right3 = 1;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Binary classification stump with fixed label 0 for Gini", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateOrderedLabeledPointsWithLabel0();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
                int $org_scalatest_assert_macro_right = 1000;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                SparkContext qual$12 = this.$outer.sc();
                WrappedArray x$159 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$160 = qual$12.parallelize$default$2();
                RDD rdd = qual$12.parallelize((Seq)x$159, x$160, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Gini$.MODULE$, 3, 2, 100, Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Tuple2 tuple2 = DecisionTree$.MODULE$.findSplitsBins(rdd, metadata);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    Split[][] splits = (Split[][])tuple2._1();
                    Bin[][] bins = (Bin[][])tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)splits, (Object)bins);
                    Split[][] splits2 = (Split[][])tuple23._1();
                    Bin[][] bins2 = (Bin[][])tuple23._2();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2.length));
                    int $org_scalatest_assert_macro_right2 = 2;
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2[0].length));
                    int $org_scalatest_assert_macro_right3 = 99;
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bins2.length));
                    int $org_scalatest_assert_macro_right4 = 2;
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bins2[0].length));
                    int $org_scalatest_assert_macro_right5 = 100;
                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                    Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
                    InformationGainStats stats = (InformationGainStats)rootNode.stats().get();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)stats.gain()));
                    int $org_scalatest_assert_macro_right6 = 0;
                    Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)stats.leftImpurity()));
                    int $org_scalatest_assert_macro_right7 = 0;
                    Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)stats.rightImpurity()));
                    int $org_scalatest_assert_macro_right8 = 0;
                    Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                    return;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Binary classification stump with fixed label 1 for Gini", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateOrderedLabeledPointsWithLabel1();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
                int $org_scalatest_assert_macro_right = 1000;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                SparkContext qual$13 = this.$outer.sc();
                WrappedArray x$161 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$162 = qual$13.parallelize$default$2();
                RDD rdd = qual$13.parallelize((Seq)x$161, x$162, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Gini$.MODULE$, 3, 2, 100, Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Tuple2 tuple2 = DecisionTree$.MODULE$.findSplitsBins(rdd, metadata);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    Split[][] splits = (Split[][])tuple2._1();
                    Bin[][] bins = (Bin[][])tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)splits, (Object)bins);
                    Split[][] splits2 = (Split[][])tuple23._1();
                    Bin[][] bins2 = (Bin[][])tuple23._2();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2.length));
                    int $org_scalatest_assert_macro_right2 = 2;
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2[0].length));
                    int $org_scalatest_assert_macro_right3 = 99;
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bins2.length));
                    int $org_scalatest_assert_macro_right4 = 2;
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bins2[0].length));
                    int $org_scalatest_assert_macro_right5 = 100;
                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                    Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
                    InformationGainStats stats = (InformationGainStats)rootNode.stats().get();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)stats.gain()));
                    int $org_scalatest_assert_macro_right6 = 0;
                    Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)stats.leftImpurity()));
                    int $org_scalatest_assert_macro_right7 = 0;
                    Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)stats.rightImpurity()));
                    int $org_scalatest_assert_macro_right8 = 0;
                    Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.predict().predict()));
                    int $org_scalatest_assert_macro_right9 = 1;
                    Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                    return;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Binary classification stump with fixed label 0 for Entropy", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateOrderedLabeledPointsWithLabel0();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
                int $org_scalatest_assert_macro_right = 1000;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                SparkContext qual$14 = this.$outer.sc();
                WrappedArray x$163 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$164 = qual$14.parallelize$default$2();
                RDD rdd = qual$14.parallelize((Seq)x$163, x$164, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Entropy$.MODULE$, 3, 2, 100, Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Tuple2 tuple2 = DecisionTree$.MODULE$.findSplitsBins(rdd, metadata);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    Split[][] splits = (Split[][])tuple2._1();
                    Bin[][] bins = (Bin[][])tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)splits, (Object)bins);
                    Split[][] splits2 = (Split[][])tuple23._1();
                    Bin[][] bins2 = (Bin[][])tuple23._2();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2.length));
                    int $org_scalatest_assert_macro_right2 = 2;
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2[0].length));
                    int $org_scalatest_assert_macro_right3 = 99;
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bins2.length));
                    int $org_scalatest_assert_macro_right4 = 2;
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bins2[0].length));
                    int $org_scalatest_assert_macro_right5 = 100;
                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                    Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
                    InformationGainStats stats = (InformationGainStats)rootNode.stats().get();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)stats.gain()));
                    int $org_scalatest_assert_macro_right6 = 0;
                    Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)stats.leftImpurity()));
                    int $org_scalatest_assert_macro_right7 = 0;
                    Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)stats.rightImpurity()));
                    int $org_scalatest_assert_macro_right8 = 0;
                    Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.predict().predict()));
                    int $org_scalatest_assert_macro_right9 = 0;
                    Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                    return;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Binary classification stump with fixed label 1 for Entropy", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateOrderedLabeledPointsWithLabel1();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)arr.length));
                int $org_scalatest_assert_macro_right = 1000;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                SparkContext qual$15 = this.$outer.sc();
                WrappedArray x$165 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$166 = qual$15.parallelize$default$2();
                RDD rdd = qual$15.parallelize((Seq)x$165, x$166, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Entropy$.MODULE$, 3, 2, 100, Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Tuple2 tuple2 = DecisionTree$.MODULE$.findSplitsBins(rdd, metadata);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    Split[][] splits = (Split[][])tuple2._1();
                    Bin[][] bins = (Bin[][])tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)splits, (Object)bins);
                    Split[][] splits2 = (Split[][])tuple23._1();
                    Bin[][] bins2 = (Bin[][])tuple23._2();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2.length));
                    int $org_scalatest_assert_macro_right2 = 2;
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)splits2[0].length));
                    int $org_scalatest_assert_macro_right3 = 99;
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bins2.length));
                    int $org_scalatest_assert_macro_right4 = 2;
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)bins2[0].length));
                    int $org_scalatest_assert_macro_right5 = 100;
                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                    Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
                    InformationGainStats stats = (InformationGainStats)rootNode.stats().get();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)stats.gain()));
                    int $org_scalatest_assert_macro_right6 = 0;
                    Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)stats.leftImpurity()));
                    int $org_scalatest_assert_macro_right7 = 0;
                    Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)stats.rightImpurity()));
                    int $org_scalatest_assert_macro_right8 = 0;
                    Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)rootNode.predict().predict()));
                    int $org_scalatest_assert_macro_right9 = 1;
                    Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                    return;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Multiclass classification stump with 3-ary (unordered) categorical features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsForMulticlass();
                SparkContext qual$16 = this.$outer.sc();
                WrappedArray x$167 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$168 = qual$16.parallelize$default$2();
                RDD rdd = qual$16.parallelize((Seq)x$167, x$168, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$169 = Algo$.MODULE$.Classification();
                Gini$ x$170 = Gini$.MODULE$;
                int x$171 = 4;
                int x$172 = 3;
                Map x$173 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)3))}));
                int x$174 = Strategy$.MODULE$.$lessinit$greater$default$5();
                Enumeration.Value x$175 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$176 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$177 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$178 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$179 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$180 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$181 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$169, (Impurity)x$170, x$171, x$172, x$174, x$175, x$173, x$176, x$177, x$178, x$179, x$180, x$181);
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(strategy.isMulticlassClassification(), "strategy.isMulticlassClassification");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
                Split split = (Split)rootNode.split().get();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.feature()));
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.categories().length()));
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                List $org_scalatest_assert_macro_left3 = split.categories();
                int $org_scalatest_assert_macro_right3 = 1;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(split.featureType());
                Enumeration.Value $org_scalatest_assert_macro_right4 = FeatureType$.MODULE$.Categorical();
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Binary classification stump with 1 continuous feature, to check off-by-1 error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = (LabeledPoint[])((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(3.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])))});
                SparkContext qual$17 = this.$outer.sc();
                WrappedArray x$182 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$183 = qual$17.parallelize$default$2();
                RDD rdd = qual$17.parallelize((Seq)x$182, x$183, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Gini$.MODULE$, 4, 2, Strategy$.MODULE$.$lessinit$greater$default$5(), Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
                DecisionTreeModel model = DecisionTree$.MODULE$.train(rdd, strategy);
                DecisionTreeSuite$.MODULE$.validateClassifier(model, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 1.0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.numNodes()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.depth()));
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Binary classification stump with 2 continuous features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = (LabeledPoint[])((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 0.0)})))), new LabeledPoint(1.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 1.0)})))), new LabeledPoint(0.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 0.0)})))), new LabeledPoint(1.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 2.0)}))))});
                SparkContext qual$18 = this.$outer.sc();
                WrappedArray x$184 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$185 = qual$18.parallelize$default$2();
                RDD rdd = qual$18.parallelize((Seq)x$184, x$185, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Gini$.MODULE$, 4, 2, Strategy$.MODULE$.$lessinit$greater$default$5(), Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
                DecisionTreeModel model = DecisionTree$.MODULE$.train(rdd, strategy);
                DecisionTreeSuite$.MODULE$.validateClassifier(model, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 1.0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.numNodes()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.depth()));
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Split)model.topNode().split().get()).feature()));
                int $org_scalatest_assert_macro_right3 = 1;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Multiclass classification stump with unordered categorical features, with just enough bins", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int maxBins = 2 * ((int)package$.MODULE$.pow(2.0, 2.0) - 1);
                LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsForMulticlass();
                SparkContext qual$19 = this.$outer.sc();
                WrappedArray x$186 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$187 = qual$19.parallelize$default$2();
                RDD rdd = qual$19.parallelize((Seq)x$186, x$187, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$188 = Algo$.MODULE$.Classification();
                Gini$ x$189 = Gini$.MODULE$;
                int x$190 = 4;
                int x$191 = 3;
                int x$192 = maxBins;
                Map x$193 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)3))}));
                Enumeration.Value x$194 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$195 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$196 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$197 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$198 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$199 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$200 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$188, (Impurity)x$189, x$190, x$191, x$192, x$194, x$193, x$195, x$196, x$197, x$198, x$199, x$200);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(strategy.isMulticlassClassification(), "strategy.isMulticlassClassification");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                DecisionTreeModel model = DecisionTree$.MODULE$.train(rdd, strategy);
                DecisionTreeSuite$.MODULE$.validateClassifier(model, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 1.0);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.numNodes()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)model.depth()));
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Node rootNode = model.topNode();
                Split split = (Split)rootNode.split().get();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.feature()));
                int $org_scalatest_assert_macro_right3 = 0;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.categories().length()));
                int $org_scalatest_assert_macro_right4 = 1;
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                List $org_scalatest_assert_macro_left5 = split.categories();
                int $org_scalatest_assert_macro_right5 = 1;
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(split.featureType());
                Enumeration.Value $org_scalatest_assert_macro_right6 = FeatureType$.MODULE$.Categorical();
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                InformationGainStats gain = (InformationGainStats)rootNode.stats().get();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)gain.leftImpurity()));
                int $org_scalatest_assert_macro_right7 = 0;
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(BoxesRunTime.boxToDouble((double)gain.rightImpurity()));
                int $org_scalatest_assert_macro_right8 = 0;
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Multiclass classification stump with continuous features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateContinuousDataPointsForMulticlass();
                SparkContext qual$20 = this.$outer.sc();
                WrappedArray x$201 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$202 = qual$20.parallelize$default$2();
                RDD rdd = qual$20.parallelize((Seq)x$201, x$202, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), (Impurity)Gini$.MODULE$, 4, 3, 100, Strategy$.MODULE$.$lessinit$greater$default$6(), Strategy$.MODULE$.$lessinit$greater$default$7(), Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(strategy.isMulticlassClassification(), "strategy.isMulticlassClassification");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy);
                DecisionTreeModel model = DecisionTree$.MODULE$.train(rdd, strategy);
                DecisionTreeSuite$.MODULE$.validateClassifier(model, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 0.9);
                Node rootNode = model.topNode();
                Split split = (Split)rootNode.split().get();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.feature()));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(split.featureType());
                Enumeration.Value $org_scalatest_assert_macro_right2 = FeatureType$.MODULE$.Continuous();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                double $org_scalatest_assert_macro_left3 = split.threshold();
                int $org_scalatest_assert_macro_right3 = 1980;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 > (double)$org_scalatest_assert_macro_right3);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                double $org_scalatest_assert_macro_left4 = split.threshold();
                int $org_scalatest_assert_macro_right4 = 2020;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 < (double)$org_scalatest_assert_macro_right4);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Multiclass classification stump with continuous + unordered categorical features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateContinuousDataPointsForMulticlass();
                SparkContext qual$21 = this.$outer.sc();
                WrappedArray x$203 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$204 = qual$21.parallelize$default$2();
                RDD rdd = qual$21.parallelize((Seq)x$203, x$204, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$205 = Algo$.MODULE$.Classification();
                Gini$ x$206 = Gini$.MODULE$;
                int x$207 = 4;
                int x$208 = 3;
                int x$209 = 100;
                Map x$210 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)3))}));
                Enumeration.Value x$211 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$212 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$213 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$214 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$215 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$216 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$217 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$205, (Impurity)x$206, x$207, x$208, x$209, x$211, x$210, x$212, x$213, x$214, x$215, x$216, x$217);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(strategy.isMulticlassClassification(), "strategy.isMulticlassClassification");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                DecisionTreeModel model = DecisionTree$.MODULE$.train(rdd, strategy);
                DecisionTreeSuite$.MODULE$.validateClassifier(model, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 0.9);
                Node rootNode = model.topNode();
                Split split = (Split)rootNode.split().get();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.feature()));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(split.featureType());
                Enumeration.Value $org_scalatest_assert_macro_right2 = FeatureType$.MODULE$.Continuous();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                double $org_scalatest_assert_macro_left3 = split.threshold();
                int $org_scalatest_assert_macro_right3 = 1980;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 > (double)$org_scalatest_assert_macro_right3);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                double $org_scalatest_assert_macro_left4 = split.threshold();
                int $org_scalatest_assert_macro_right4 = 2020;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "<", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 < (double)$org_scalatest_assert_macro_right4);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Multiclass classification stump with 10-ary (ordered) categorical features", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsForMulticlassForOrderedFeatures();
                SparkContext qual$22 = this.$outer.sc();
                WrappedArray x$218 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$219 = qual$22.parallelize$default$2();
                RDD rdd = qual$22.parallelize((Seq)x$218, x$219, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$220 = Algo$.MODULE$.Classification();
                Gini$ x$221 = Gini$.MODULE$;
                int x$222 = 4;
                int x$223 = 3;
                int x$224 = 100;
                Map x$225 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)10))}));
                Enumeration.Value x$226 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$227 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$228 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$229 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$230 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$231 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$232 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$220, (Impurity)x$221, x$222, x$223, x$224, x$226, x$225, x$227, x$228, x$229, x$230, x$231, x$232);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(strategy.isMulticlassClassification(), "strategy.isMulticlassClassification");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata(rdd, strategy);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(0), "metadata.isUnordered(0)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(metadata.isUnordered(1), "metadata.isUnordered(1)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
                Split split = (Split)rootNode.split().get();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.feature()));
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)split.categories().length()));
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                List $org_scalatest_assert_macro_left3 = split.categories();
                double $org_scalatest_assert_macro_right3 = 1.0;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.contains((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(split.featureType());
                Enumeration.Value $org_scalatest_assert_macro_right4 = FeatureType$.MODULE$.Categorical();
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Multiclass classification tree with 10-ary (ordered) categorical features, with just enough bins", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = DecisionTreeSuite$.MODULE$.generateCategoricalDataPointsForMulticlassForOrderedFeatures();
                SparkContext qual$23 = this.$outer.sc();
                WrappedArray x$233 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$234 = qual$23.parallelize$default$2();
                RDD rdd = qual$23.parallelize((Seq)x$233, x$234, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$235 = Algo$.MODULE$.Classification();
                Gini$ x$236 = Gini$.MODULE$;
                int x$237 = 4;
                int x$238 = 3;
                int x$239 = 10;
                Map x$240 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)10))}));
                Enumeration.Value x$241 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$242 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$243 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$244 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$245 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$246 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$247 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$235, (Impurity)x$236, x$237, x$238, x$239, x$241, x$240, x$242, x$243, x$244, x$245, x$246, x$247);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(strategy.isMulticlassClassification(), "strategy.isMulticlassClassification");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                DecisionTreeModel model = DecisionTree$.MODULE$.train(rdd, strategy);
                DecisionTreeSuite$.MODULE$.validateClassifier(model, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])arr), 0.6);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("split must satisfy min instances per node requirements", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InformationGainStats gain;
                LabeledPoint[] arr = (LabeledPoint[])((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 0.0)})))), new LabeledPoint(1.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 1.0)})))), new LabeledPoint(0.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0)}))))});
                SparkContext qual$24 = this.$outer.sc();
                WrappedArray x$248 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$249 = qual$24.parallelize$default$2();
                RDD rdd = qual$24.parallelize((Seq)x$248, x$249, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$250 = Algo$.MODULE$.Classification();
                Gini$ x$251 = Gini$.MODULE$;
                int x$252 = 2;
                int x$253 = 2;
                int x$254 = 2;
                int x$255 = Strategy$.MODULE$.$lessinit$greater$default$5();
                Enumeration.Value x$256 = Strategy$.MODULE$.$lessinit$greater$default$6();
                Map x$257 = Strategy$.MODULE$.$lessinit$greater$default$7();
                double x$258 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$259 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$260 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$261 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$262 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$250, (Impurity)x$251, x$252, x$253, x$255, x$256, x$257, x$254, x$258, x$259, x$260, x$261, x$262);
                DecisionTreeModel model = DecisionTree$.MODULE$.train(rdd, strategy);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(model.topNode().isLeaf(), "model.topNode.isLeaf");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                double $org_scalatest_assert_macro_left = model.topNode().predict().predict();
                double $org_scalatest_assert_macro_right = 0.0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                double[] predicts = (double[])rdd.map((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final DecisionTreeModel model$3;

                    public final double apply(LabeledPoint p) {
                        return this.model$3.predict(p.features());
                    }
                    {
                        this.model$3 = model$3;
                    }
                }, ClassTag$.MODULE$.Double()).collect();
                Predef$.MODULE$.doubleArrayOps(predicts).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$30 $outer;

                    public final void apply(double predict) {
                        this.apply$mcVD$sp(predict);
                    }

                    public void apply$mcVD$sp(double predict) {
                        double $org_scalatest_assert_macro_left = predict;
                        double $org_scalatest_assert_macro_right = 0.0;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right);
                        this.$outer.org$apache$spark$mllib$tree$DecisionTreeSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Node rootNode = model.topNode();
                InformationGainStats $org_scalatest_assert_macro_left2 = gain = (InformationGainStats)rootNode.stats().get();
                InformationGainStats $org_scalatest_assert_macro_right2 = InformationGainStats$.MODULE$.invalidInformationGainStats();
                InformationGainStats informationGainStats = $org_scalatest_assert_macro_left2;
                InformationGainStats informationGainStats2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(informationGainStats != null ? !informationGainStats.equals(informationGainStats2) : informationGainStats2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }

            public /* synthetic */ DecisionTreeSuite org$apache$spark$mllib$tree$DecisionTreeSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("do not choose split that does not satisfy min instance per node requirements", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LabeledPoint[] arr = (LabeledPoint[])((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new LabeledPoint(1.0, Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}))), new LabeledPoint(0.0, Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0})))});
                SparkContext qual$25 = this.$outer.sc();
                WrappedArray x$263 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$264 = qual$25.parallelize$default$2();
                RDD rdd = qual$25.parallelize((Seq)x$263, x$264, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$265 = Algo$.MODULE$.Classification();
                Gini$ x$266 = Gini$.MODULE$;
                int x$267 = 2;
                int x$268 = 2;
                Map x$269 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2))}));
                int x$270 = 2;
                int x$271 = 2;
                Enumeration.Value x$272 = Strategy$.MODULE$.$lessinit$greater$default$6();
                double x$273 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$274 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$275 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$276 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$277 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$265, (Impurity)x$266, x$268, x$270, x$267, x$272, x$269, x$271, x$273, x$274, x$275, x$276, x$277);
                Node rootNode = DecisionTree$.MODULE$.train(rdd, strategy).topNode();
                Split split = (Split)rootNode.split().get();
                InformationGainStats gain = (InformationGainStats)rootNode.stats().get();
                int $org_scalatest_assert_macro_left = split.feature();
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                InformationGainStats $org_scalatest_assert_macro_left2 = gain;
                InformationGainStats $org_scalatest_assert_macro_right2 = InformationGainStats$.MODULE$.invalidInformationGainStats();
                InformationGainStats informationGainStats = $org_scalatest_assert_macro_left2;
                InformationGainStats informationGainStats2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "!=", (Object)$org_scalatest_assert_macro_right2, informationGainStats != null ? !informationGainStats.equals(informationGainStats2) : informationGainStats2 != null);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("split must satisfy min info gain requirements", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InformationGainStats gain;
                LabeledPoint[] arr = (LabeledPoint[])((Object[])new LabeledPoint[]{new LabeledPoint(0.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 0.0)})))), new LabeledPoint(1.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 1.0)})))), new LabeledPoint(0.0, Vectors$.MODULE$.sparse(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(0, 1.0)}))))});
                SparkContext qual$26 = this.$outer.sc();
                WrappedArray x$278 = Predef$.MODULE$.wrapRefArray((Object[])arr);
                int x$279 = qual$26.parallelize$default$2();
                RDD input = qual$26.parallelize((Seq)x$278, x$279, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$280 = Algo$.MODULE$.Classification();
                Gini$ x$281 = Gini$.MODULE$;
                int x$282 = 2;
                int x$283 = 2;
                double x$284 = 1.0;
                int x$285 = Strategy$.MODULE$.$lessinit$greater$default$5();
                Enumeration.Value x$286 = Strategy$.MODULE$.$lessinit$greater$default$6();
                Map x$287 = Strategy$.MODULE$.$lessinit$greater$default$7();
                int x$288 = Strategy$.MODULE$.$lessinit$greater$default$8();
                int x$289 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$290 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$291 = Strategy$.MODULE$.$lessinit$greater$default$12();
                int x$292 = Strategy$.MODULE$.$lessinit$greater$default$13();
                Strategy strategy = new Strategy(x$280, (Impurity)x$281, x$282, x$283, x$285, x$286, x$287, x$288, x$284, x$289, x$290, x$291, x$292);
                DecisionTreeModel model = DecisionTree$.MODULE$.train(input, strategy);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(model.topNode().isLeaf(), "model.topNode.isLeaf");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                double $org_scalatest_assert_macro_left = model.topNode().predict().predict();
                double $org_scalatest_assert_macro_right = 0.0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                double[] predicts = (double[])input.map((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final DecisionTreeModel model$4;

                    public final double apply(LabeledPoint p) {
                        return this.model$4.predict(p.features());
                    }
                    {
                        this.model$4 = model$4;
                    }
                }, ClassTag$.MODULE$.Double()).collect();
                Predef$.MODULE$.doubleArrayOps(predicts).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$32 $outer;

                    public final void apply(double predict) {
                        this.apply$mcVD$sp(predict);
                    }

                    public void apply$mcVD$sp(double predict) {
                        double $org_scalatest_assert_macro_left = predict;
                        double $org_scalatest_assert_macro_right = 0.0;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right);
                        this.$outer.org$apache$spark$mllib$tree$DecisionTreeSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Node rootNode = model.topNode();
                InformationGainStats $org_scalatest_assert_macro_left2 = gain = (InformationGainStats)rootNode.stats().get();
                InformationGainStats $org_scalatest_assert_macro_right2 = InformationGainStats$.MODULE$.invalidInformationGainStats();
                InformationGainStats informationGainStats = $org_scalatest_assert_macro_left2;
                InformationGainStats informationGainStats2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(informationGainStats != null ? !informationGainStats.equals(informationGainStats2) : informationGainStats2 != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }

            public /* synthetic */ DecisionTreeSuite org$apache$spark$mllib$tree$DecisionTreeSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Node.subtreeIterator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DecisionTreeModel model = DecisionTreeSuite$.MODULE$.createModel(Algo$.MODULE$.Classification());
                int[] nodeIds = (int[])Predef$.MODULE$.intArrayOps((int[])model.topNode().subtreeIterator().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Node x$17) {
                        return x$17.id();
                    }
                }).toArray(ClassTag$.MODULE$.Int())).sorted((Ordering)Ordering.Int$.MODULE$);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(nodeIds);
                int[] $org_scalatest_assert_macro_right = DecisionTreeSuite$.MODULE$.org$apache$spark$mllib$tree$DecisionTreeSuite$$createdModelNodeIds();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("model save/load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DecisionTreeSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                String path = tempDir.toURI().toString();
                Predef$.MODULE$.refArrayOps((Object[])new Enumeration.Value[]{Algo$.MODULE$.Classification(), Algo$.MODULE$.Regression()}).foreach((Function1)new Serializable(this, tempDir, path){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$34 $outer;
                    private final File tempDir$1;
                    private final String path$1;

                    public final void apply(Enumeration.Value algo) {
                        DecisionTreeModel model = DecisionTreeSuite$.MODULE$.createModel(algo);
                        try {
                            model.save(this.$outer.org$apache$spark$mllib$tree$DecisionTreeSuite$$anonfun$$$outer().sc(), this.path$1);
                            DecisionTreeModel sameModel = DecisionTreeModel$.MODULE$.load(this.$outer.org$apache$spark$mllib$tree$DecisionTreeSuite$$anonfun$$$outer().sc(), this.path$1);
                            DecisionTreeSuite$.MODULE$.checkEqual(model, sameModel);
                            return;
                        }
                        finally {
                            Utils$.MODULE$.deleteRecursively(this.tempDir$1);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.tempDir$1 = tempDir$1;
                        this.path$1 = path$1;
                    }
                });
            }

            public /* synthetic */ DecisionTreeSuite org$apache$spark$mllib$tree$DecisionTreeSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

