/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import java.io.File;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.DecisionTree$;
import org.apache.spark.mllib.tree.DecisionTreeSuite$;
import org.apache.spark.mllib.tree.EnsembleTestHelper$;
import org.apache.spark.mllib.tree.GradientBoostedTrees;
import org.apache.spark.mllib.tree.GradientBoostedTrees$;
import org.apache.spark.mllib.tree.GradientBoostedTreesSuite$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.configuration.Strategy$;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.impurity.Variance$;
import org.apache.spark.mllib.tree.loss.AbsoluteError$;
import org.apache.spark.mllib.tree.loss.LogLoss$;
import org.apache.spark.mllib.tree.loss.Loss;
import org.apache.spark.mllib.tree.loss.SquaredError$;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel$;
import org.apache.spark.mllib.tree.model.TreeEnsembleModel;
import org.apache.spark.mllib.util.MLlibTestSparkContext;
import org.apache.spark.mllib.util.MLlibTestSparkContext$class;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0001\u0002\u0001\u001b\tIrI]1eS\u0016tGOQ8pgR,G\r\u0016:fKN\u001cV/\u001b;f\u0015\t\u0019A!\u0001\u0003ue\u0016,'BA\u0003\u0007\u0003\u0015iG\u000e\\5c\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0005\u00019\u0011\u0002\u0004\u0005\u0002\u0010!5\ta!\u0003\u0002\u0012\r\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\tU$\u0018\u000e\\\u0005\u0003/Q\u0011Q#\u0014'mS\n$Vm\u001d;Ta\u0006\u00148nQ8oi\u0016DH\u000f\u0005\u0002\u00103%\u0011!D\u0002\u0002\b\u0019><w-\u001b8h\u0011\u0015a\u0002\u0001\"\u0001\u001e\u0003\u0019a\u0014N\\5u}Q\ta\u0004\u0005\u0002 \u00015\t!aB\u0003\"\u0005!%!%A\rHe\u0006$\u0017.\u001a8u\u0005>|7\u000f^3e)J,Wm]*vSR,\u0007CA\u0010$\r\u0015\t!\u0001#\u0003%'\r\u0019Se\u000b\t\u0003M%j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!f\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0019b\u0013BA\u0017(\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u0015a2\u0005\"\u00010)\u0005\u0011\u0003bB\u0019$\u0005\u0004%\tAM\u0001\u0011i\u0016\u001cHoQ8nE&t\u0017\r^5p]N,\u0012a\r\t\u0004MQ2\u0014BA\u001b(\u0005\u0015\t%O]1z!\u00151s'\u000f\u001f=\u0013\tAtE\u0001\u0004UkBdWm\r\t\u0003MiJ!aO\u0014\u0003\u0007%sG\u000f\u0005\u0002'{%\u0011ah\n\u0002\u0007\t>,(\r\\3\t\r\u0001\u001b\u0003\u0015!\u00034\u0003E!Xm\u001d;D_6\u0014\u0017N\\1uS>t7\u000f\t\u0005\b\u0005\u000e\u0012\r\u0011\"\u0001D\u0003\u0011!\u0017\r^1\u0016\u0003\u0011\u00032A\n\u001bF!\t1\u0015*D\u0001H\u0015\tAE!\u0001\u0006sK\u001e\u0014Xm]:j_:L!AS$\u0003\u00191\u000b'-\u001a7fIB{\u0017N\u001c;\t\r1\u001b\u0003\u0015!\u0003E\u0003\u0015!\u0017\r^1!\u0011\u001dq5E1A\u0005\u0002\r\u000b\u0011\u0002\u001e:bS:$\u0015\r^1\t\rA\u001b\u0003\u0015!\u0003E\u0003)!(/Y5o\t\u0006$\u0018\r\t\u0005\b%\u000e\u0012\r\u0011\"\u0001D\u000311\u0018\r\\5eCR,G)\u0019;b\u0011\u0019!6\u0005)A\u0005\t\u0006ia/\u00197jI\u0006$X\rR1uC\u0002BqAV\u0012\u0002\u0002\u0013%q+A\u0006sK\u0006$'+Z:pYZ,G#\u0001-\u0011\u0005esV\"\u0001.\u000b\u0005mc\u0016\u0001\u00027b]\u001eT\u0011!X\u0001\u0005U\u00064\u0018-\u0003\u0002`5\n1qJ\u00196fGR\u0004")
public class GradientBoostedTreesSuite
extends SparkFunSuite
implements MLlibTestSparkContext {
    private transient SparkContext sc;
    private transient SQLContext sqlContext;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public static LabeledPoint[] validateData() {
        return GradientBoostedTreesSuite$.MODULE$.validateData();
    }

    public static LabeledPoint[] trainData() {
        return GradientBoostedTreesSuite$.MODULE$.trainData();
    }

    public static LabeledPoint[] data() {
        return GradientBoostedTreesSuite$.MODULE$.data();
    }

    public static Tuple3<Object, Object, Object>[] testCombinations() {
        return GradientBoostedTreesSuite$.MODULE$.testCombinations();
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void sqlContext_$eq(SQLContext x$1) {
        this.sqlContext = x$1;
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$beforeAll() {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this);
    }

    @Override
    public void org$apache$spark$mllib$util$MLlibTestSparkContext$$super$afterAll() {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this);
    }

    @Override
    public void beforeAll() {
        MLlibTestSparkContext$class.beforeAll(this);
    }

    @Override
    public void afterAll() {
        MLlibTestSparkContext$class.afterAll(this);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public GradientBoostedTreesSuite() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        MLlibTestSparkContext$class.$init$(this);
        this.test("Regression with continuous features: SquaredError", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GradientBoostedTreesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predef$.MODULE$.refArrayOps((Object[])GradientBoostedTreesSuite$.MODULE$.testCombinations()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final void apply(Tuple3<Object, Object, Object> x0$1) {
                        Tuple3<Object, Object, Object> tuple3 = x0$1;
                        if (tuple3 == null) throw new MatchError(tuple3);
                        int numIterations = BoxesRunTime.unboxToInt((Object)tuple3._1());
                        double learningRate = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                        double subsamplingRate = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                        RDD rdd = this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])GradientBoostedTreesSuite$.MODULE$.data()), 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                        Enumeration.Value x$3 = Algo$.MODULE$.Regression();
                        Variance$ x$4 = Variance$.MODULE$;
                        int x$5 = 2;
                        Map x$6 = Predef$.MODULE$.Map().empty();
                        double x$7 = subsamplingRate;
                        int x$8 = Strategy$.MODULE$.$lessinit$greater$default$4();
                        int x$9 = Strategy$.MODULE$.$lessinit$greater$default$5();
                        Enumeration.Value x$10 = Strategy$.MODULE$.$lessinit$greater$default$6();
                        int x$11 = Strategy$.MODULE$.$lessinit$greater$default$8();
                        double x$12 = Strategy$.MODULE$.$lessinit$greater$default$9();
                        int x$13 = Strategy$.MODULE$.$lessinit$greater$default$10();
                        boolean x$14 = Strategy$.MODULE$.$lessinit$greater$default$12();
                        int x$15 = Strategy$.MODULE$.$lessinit$greater$default$13();
                        Strategy treeStrategy = new Strategy(x$3, (Impurity)x$4, x$5, x$8, x$9, x$10, x$6, x$11, x$12, x$13, x$7, x$14, x$15);
                        BoostingStrategy boostingStrategy = new BoostingStrategy(treeStrategy, (Loss)SquaredError$.MODULE$, numIterations, learningRate, BoostingStrategy$.MODULE$.$lessinit$greater$default$5());
                        GradientBoostedTreesModel gbt = GradientBoostedTrees$.MODULE$.train(rdd, boostingStrategy);
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])gbt.trees()).size()));
                        int $org_scalatest_assert_macro_right = numIterations;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        try {
                            EnsembleTestHelper$.MODULE$.validateRegressor((TreeEnsembleModel)gbt, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])GradientBoostedTreesSuite$.MODULE$.data()), 0.06, EnsembleTestHelper$.MODULE$.validateRegressor$default$4());
                        }
                        catch (AssertionError assertionError) {
                            this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().logError((Function0)new Serializable(this, numIterations, learningRate, subsamplingRate){
                                public static final long serialVersionUID = 0L;
                                private final int numIterations$1;
                                private final double learningRate$1;
                                private final double subsamplingRate$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FAILED for numIterations=", ", learningRate=", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numIterations$1), BoxesRunTime.boxToDouble((double)this.learningRate$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" subsamplingRate=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.subsamplingRate$1)}))).toString();
                                }
                                {
                                    this.numIterations$1 = numIterations$1;
                                    this.learningRate$1 = learningRate$1;
                                    this.subsamplingRate$1 = subsamplingRate$1;
                                }
                            });
                            throw assertionError;
                        }
                        RDD remappedInput = rdd.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final LabeledPoint apply(LabeledPoint x) {
                                return new LabeledPoint(x.label() * (double)2 - 1.0, x.features());
                            }
                        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
                        DecisionTreeModel dt = DecisionTree$.MODULE$.train(remappedInput, treeStrategy);
                        String $org_scalatest_assert_macro_left2 = ((DecisionTreeModel)Predef$.MODULE$.refArrayOps((Object[])gbt.trees()).head()).toString();
                        String $org_scalatest_assert_macro_right2 = dt.toString();
                        String string = $org_scalatest_assert_macro_left2;
                        String string2 = $org_scalatest_assert_macro_right2;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null));
                        this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ GradientBoostedTreesSuite org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Regression with continuous features: Absolute Error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GradientBoostedTreesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predef$.MODULE$.refArrayOps((Object[])GradientBoostedTreesSuite$.MODULE$.testCombinations()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final void apply(Tuple3<Object, Object, Object> x0$2) {
                        Tuple3<Object, Object, Object> tuple3 = x0$2;
                        if (tuple3 == null) throw new MatchError(tuple3);
                        int numIterations = BoxesRunTime.unboxToInt((Object)tuple3._1());
                        double learningRate = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                        double subsamplingRate = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                        RDD rdd = this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])GradientBoostedTreesSuite$.MODULE$.data()), 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                        Enumeration.Value x$16 = Algo$.MODULE$.Regression();
                        Variance$ x$17 = Variance$.MODULE$;
                        int x$18 = 2;
                        Map x$19 = Predef$.MODULE$.Map().empty();
                        double x$20 = subsamplingRate;
                        int x$21 = Strategy$.MODULE$.$lessinit$greater$default$4();
                        int x$22 = Strategy$.MODULE$.$lessinit$greater$default$5();
                        Enumeration.Value x$23 = Strategy$.MODULE$.$lessinit$greater$default$6();
                        int x$24 = Strategy$.MODULE$.$lessinit$greater$default$8();
                        double x$25 = Strategy$.MODULE$.$lessinit$greater$default$9();
                        int x$26 = Strategy$.MODULE$.$lessinit$greater$default$10();
                        boolean x$27 = Strategy$.MODULE$.$lessinit$greater$default$12();
                        int x$28 = Strategy$.MODULE$.$lessinit$greater$default$13();
                        Strategy treeStrategy = new Strategy(x$16, (Impurity)x$17, x$18, x$21, x$22, x$23, x$19, x$24, x$25, x$26, x$20, x$27, x$28);
                        BoostingStrategy boostingStrategy = new BoostingStrategy(treeStrategy, (Loss)AbsoluteError$.MODULE$, numIterations, learningRate, BoostingStrategy$.MODULE$.$lessinit$greater$default$5());
                        GradientBoostedTreesModel gbt = GradientBoostedTrees$.MODULE$.train(rdd, boostingStrategy);
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])gbt.trees()).size()));
                        int $org_scalatest_assert_macro_right = numIterations;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        try {
                            EnsembleTestHelper$.MODULE$.validateRegressor((TreeEnsembleModel)gbt, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])GradientBoostedTreesSuite$.MODULE$.data()), 0.85, "mae");
                        }
                        catch (AssertionError assertionError) {
                            this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().logError((Function0)new Serializable(this, numIterations, learningRate, subsamplingRate){
                                public static final long serialVersionUID = 0L;
                                private final int numIterations$2;
                                private final double learningRate$2;
                                private final double subsamplingRate$2;

                                public final String apply() {
                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FAILED for numIterations=", ", learningRate=", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numIterations$2), BoxesRunTime.boxToDouble((double)this.learningRate$2)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" subsamplingRate=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.subsamplingRate$2)}))).toString();
                                }
                                {
                                    this.numIterations$2 = numIterations$2;
                                    this.learningRate$2 = learningRate$2;
                                    this.subsamplingRate$2 = subsamplingRate$2;
                                }
                            });
                            throw assertionError;
                        }
                        RDD remappedInput = rdd.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final LabeledPoint apply(LabeledPoint x) {
                                return new LabeledPoint(x.label() * (double)2 - 1.0, x.features());
                            }
                        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
                        DecisionTreeModel dt = DecisionTree$.MODULE$.train(remappedInput, treeStrategy);
                        String $org_scalatest_assert_macro_left2 = ((DecisionTreeModel)Predef$.MODULE$.refArrayOps((Object[])gbt.trees()).head()).toString();
                        String $org_scalatest_assert_macro_right2 = dt.toString();
                        String string = $org_scalatest_assert_macro_left2;
                        String string2 = $org_scalatest_assert_macro_right2;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null));
                        this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ GradientBoostedTreesSuite org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Binary classification with continuous features: Log Loss", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GradientBoostedTreesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predef$.MODULE$.refArrayOps((Object[])GradientBoostedTreesSuite$.MODULE$.testCombinations()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final void apply(Tuple3<Object, Object, Object> x0$3) {
                        Tuple3<Object, Object, Object> tuple3 = x0$3;
                        if (tuple3 == null) throw new MatchError(tuple3);
                        int numIterations = BoxesRunTime.unboxToInt((Object)tuple3._1());
                        double learningRate = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                        double subsamplingRate = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                        RDD rdd = this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])GradientBoostedTreesSuite$.MODULE$.data()), 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                        Enumeration.Value x$29 = Algo$.MODULE$.Classification();
                        Variance$ x$30 = Variance$.MODULE$;
                        int x$31 = 2;
                        int x$32 = 2;
                        Map x$33 = Predef$.MODULE$.Map().empty();
                        double x$34 = subsamplingRate;
                        int x$35 = Strategy$.MODULE$.$lessinit$greater$default$5();
                        Enumeration.Value x$36 = Strategy$.MODULE$.$lessinit$greater$default$6();
                        int x$37 = Strategy$.MODULE$.$lessinit$greater$default$8();
                        double x$38 = Strategy$.MODULE$.$lessinit$greater$default$9();
                        int x$39 = Strategy$.MODULE$.$lessinit$greater$default$10();
                        boolean x$40 = Strategy$.MODULE$.$lessinit$greater$default$12();
                        int x$41 = Strategy$.MODULE$.$lessinit$greater$default$13();
                        Strategy treeStrategy = new Strategy(x$29, (Impurity)x$30, x$31, x$32, x$35, x$36, x$33, x$37, x$38, x$39, x$34, x$40, x$41);
                        BoostingStrategy boostingStrategy = new BoostingStrategy(treeStrategy, (Loss)LogLoss$.MODULE$, numIterations, learningRate, BoostingStrategy$.MODULE$.$lessinit$greater$default$5());
                        GradientBoostedTreesModel gbt = GradientBoostedTrees$.MODULE$.train(rdd, boostingStrategy);
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])gbt.trees()).size()));
                        int $org_scalatest_assert_macro_right = numIterations;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        try {
                            EnsembleTestHelper$.MODULE$.validateClassifier((TreeEnsembleModel)gbt, (Seq<LabeledPoint>)Predef$.MODULE$.wrapRefArray((Object[])GradientBoostedTreesSuite$.MODULE$.data()), 0.9);
                        }
                        catch (AssertionError assertionError) {
                            this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().logError((Function0)new Serializable(this, numIterations, learningRate, subsamplingRate){
                                public static final long serialVersionUID = 0L;
                                private final int numIterations$3;
                                private final double learningRate$3;
                                private final double subsamplingRate$3;

                                public final String apply() {
                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FAILED for numIterations=", ", learningRate=", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numIterations$3), BoxesRunTime.boxToDouble((double)this.learningRate$3)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" subsamplingRate=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.subsamplingRate$3)}))).toString();
                                }
                                {
                                    this.numIterations$3 = numIterations$3;
                                    this.learningRate$3 = learningRate$3;
                                    this.subsamplingRate$3 = subsamplingRate$3;
                                }
                            });
                            throw assertionError;
                        }
                        RDD remappedInput = rdd.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final LabeledPoint apply(LabeledPoint x) {
                                return new LabeledPoint(x.label() * (double)2 - 1.0, x.features());
                            }
                        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
                        Strategy ensembleStrategy = treeStrategy.copy();
                        ensembleStrategy.algo_$eq(Algo$.MODULE$.Regression());
                        ensembleStrategy.impurity_$eq((Impurity)Variance$.MODULE$);
                        DecisionTreeModel dt = DecisionTree$.MODULE$.train(remappedInput, ensembleStrategy);
                        String $org_scalatest_assert_macro_left2 = ((DecisionTreeModel)Predef$.MODULE$.refArrayOps((Object[])gbt.trees()).head()).toString();
                        String $org_scalatest_assert_macro_right2 = dt.toString();
                        String string = $org_scalatest_assert_macro_left2;
                        String string2 = $org_scalatest_assert_macro_right2;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null));
                        this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ GradientBoostedTreesSuite org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SPARK-5496: BoostingStrategy.defaultParams should recognize Classification", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"classification", "Classification", "regression", "Regression"}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final BoostingStrategy apply(String algo) {
                        return BoostingStrategy$.MODULE$.defaultParams(algo);
                    }
                });
            }
        });
        this.test("model save/load", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GradientBoostedTreesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                String path = tempDir.toURI().toString();
                DecisionTreeModel[] trees = (DecisionTreeModel[])((TraversableOnce)package$.MODULE$.Range().apply(0, 3).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final DecisionTreeModel apply(int x$1) {
                        return DecisionTreeSuite$.MODULE$.createModel(Algo$.MODULE$.Regression());
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(DecisionTreeModel.class));
                double[] treeWeights = new double[]{0.1, 0.3, 1.1};
                Predef$.MODULE$.refArrayOps((Object[])new Enumeration.Value[]{Algo$.MODULE$.Classification(), Algo$.MODULE$.Regression()}).foreach((Function1)new Serializable(this, tempDir, path, trees, treeWeights){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;
                    private final File tempDir$1;
                    private final String path$1;
                    private final DecisionTreeModel[] trees$1;
                    private final double[] treeWeights$1;

                    public final void apply(Enumeration.Value algo) {
                        GradientBoostedTreesModel model = new GradientBoostedTreesModel(algo, this.trees$1, this.treeWeights$1);
                        try {
                            model.save(this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().sc(), this.path$1);
                            GradientBoostedTreesModel sameModel = GradientBoostedTreesModel$.MODULE$.load(this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().sc(), this.path$1);
                            Enumeration.Value $org_scalatest_assert_macro_left = model.algo();
                            Enumeration.Value $org_scalatest_assert_macro_right = sameModel.algo();
                            Enumeration.Value value = $org_scalatest_assert_macro_left;
                            Enumeration.Value value2 = $org_scalatest_assert_macro_right;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(value != null ? !value.equals(value2) : value2 != null));
                            this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])model.trees()).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])sameModel.trees()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final void apply(Tuple2<DecisionTreeModel, DecisionTreeModel> x0$4) {
                                    Tuple2<DecisionTreeModel, DecisionTreeModel> tuple2 = x0$4;
                                    if (tuple2 != null) {
                                        DecisionTreeModel treeA = (DecisionTreeModel)tuple2._1();
                                        DecisionTreeModel treeB = (DecisionTreeModel)tuple2._2();
                                        DecisionTreeSuite$.MODULE$.checkEqual(treeA, treeB);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        return;
                                    }
                                    throw new MatchError(tuple2);
                                }
                            });
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().convertToEqualizer(model.treeWeights());
                            double[] $org_scalatest_assert_macro_right2 = sameModel.treeWeights();
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                            return;
                        }
                        finally {
                            Utils$.MODULE$.deleteRecursively(this.tempDir$1);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.tempDir$1 = tempDir$1;
                        this.path$1 = path$1;
                        this.trees$1 = trees$1;
                        this.treeWeights$1 = treeWeights$1;
                    }
                });
            }

            public /* synthetic */ GradientBoostedTreesSuite org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("runWithValidation stops early and performs better on a validation dataset", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GradientBoostedTreesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int numIterations = 20;
                RDD trainRdd = this.$outer.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])GradientBoostedTreesSuite$.MODULE$.trainData()), 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                RDD validateRdd = this.$outer.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])GradientBoostedTreesSuite$.MODULE$.validateData()), 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value[] algos = (Enumeration.Value[])((Object[])new Enumeration.Value[]{Algo$.MODULE$.Regression(), Algo$.MODULE$.Regression(), Algo$.MODULE$.Classification()});
                Loss[] losses = (Loss[])((Object[])new Loss[]{SquaredError$.MODULE$, AbsoluteError$.MODULE$, LogLoss$.MODULE$});
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])algos).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])losses), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this, numIterations, trainRdd, validateRdd){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;
                    private final int numIterations$4;
                    private final RDD trainRdd$1;
                    private final RDD validateRdd$1;

                    public final void apply(Tuple2<Enumeration.Value, Loss> x0$5) {
                        Tuple2<Enumeration.Value, Loss> tuple2 = x0$5;
                        if (tuple2 != null) {
                            Tuple2.mcDD.sp sp2;
                            Tuple2.mcDD.sp sp3;
                            Strategy treeStrategy;
                            Enumeration.Value algo = (Enumeration.Value)tuple2._1();
                            Loss loss = (Loss)tuple2._2();
                            Enumeration.Value x$42 = algo;
                            Variance$ x$43 = Variance$.MODULE$;
                            int x$44 = 2;
                            Map x$45 = Predef$.MODULE$.Map().empty();
                            int x$46 = Strategy$.MODULE$.$lessinit$greater$default$4();
                            int x$47 = Strategy$.MODULE$.$lessinit$greater$default$5();
                            Enumeration.Value x$48 = Strategy$.MODULE$.$lessinit$greater$default$6();
                            int x$49 = Strategy$.MODULE$.$lessinit$greater$default$8();
                            double x$50 = Strategy$.MODULE$.$lessinit$greater$default$9();
                            int x$51 = Strategy$.MODULE$.$lessinit$greater$default$10();
                            double x$52 = Strategy$.MODULE$.$lessinit$greater$default$11();
                            boolean x$53 = Strategy$.MODULE$.$lessinit$greater$default$12();
                            int x$54 = Strategy$.MODULE$.$lessinit$greater$default$13();
                            Strategy x$55 = treeStrategy = new Strategy(x$42, (Impurity)x$43, x$44, x$46, x$47, x$48, x$45, x$49, x$50, x$51, x$52, x$53, x$54);
                            Loss x$56 = loss;
                            int x$57 = this.numIterations$4;
                            double x$58 = 0.0;
                            double x$59 = BoostingStrategy$.MODULE$.$lessinit$greater$default$4();
                            BoostingStrategy boostingStrategy = new BoostingStrategy(x$55, x$56, x$57, x$59, x$58);
                            GradientBoostedTreesModel gbtValidate = new GradientBoostedTrees(boostingStrategy).runWithValidation(this.trainRdd$1, this.validateRdd$1);
                            int numTrees = gbtValidate.numTrees();
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)numTrees));
                            int $org_scalatest_assert_macro_right = this.numIterations$4;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$bang$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                            this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            GradientBoostedTreesModel gbt = new GradientBoostedTrees(boostingStrategy).run(this.trainRdd$1);
                            Enumeration.Value value = algo;
                            Enumeration.Value value2 = Algo$.MODULE$.Classification();
                            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                                RDD remappedRdd = this.validateRdd$1.map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final LabeledPoint apply(LabeledPoint x) {
                                        return new LabeledPoint((double)2 * x.label() - 1.0, x.features());
                                    }
                                }, ClassTag$.MODULE$.apply(LabeledPoint.class));
                                sp3 = new Tuple2.mcDD.sp(loss.computeError((TreeEnsembleModel)gbt, remappedRdd), loss.computeError((TreeEnsembleModel)gbtValidate, remappedRdd));
                            } else {
                                sp3 = sp2 = new Tuple2.mcDD.sp(loss.computeError((TreeEnsembleModel)gbt, this.validateRdd$1), loss.computeError((TreeEnsembleModel)gbtValidate, this.validateRdd$1));
                            }
                            if (sp2 != null) {
                                double errorWithValidation;
                                Tuple2.mcDD.sp sp4;
                                double errorWithoutValidation = sp2._1$mcD$sp();
                                double errorWithValidation2 = sp2._2$mcD$sp();
                                Tuple2.mcDD.sp sp5 = sp4 = new Tuple2.mcDD.sp(errorWithoutValidation, errorWithValidation2);
                                double errorWithoutValidation2 = sp5._1$mcD$sp();
                                double $org_scalatest_assert_macro_left2 = errorWithValidation = sp5._2$mcD$sp();
                                double $org_scalatest_assert_macro_right2 = errorWithoutValidation2;
                                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 <= $org_scalatest_assert_macro_right2);
                                this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                                double[] evaluationArray = gbt.evaluateEachIteration(this.validateRdd$1, loss);
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToInteger((int)evaluationArray.length));
                                int $org_scalatest_assert_macro_right3 = this.numIterations$4;
                                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()));
                                this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                                double $org_scalatest_assert_macro_left4 = evaluationArray[numTrees];
                                double $org_scalatest_assert_macro_right4 = evaluationArray[numTrees - 1];
                                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), ">", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 > $org_scalatest_assert_macro_right4);
                                this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                                for (int i = 1; i < numTrees; ++i) {
                                    double $org_scalatest_assert_macro_left5 = evaluationArray[i];
                                    double $org_scalatest_assert_macro_right5 = evaluationArray[i - 1];
                                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left5), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 <= $org_scalatest_assert_macro_right5);
                                    this.$outer.org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                                }
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError((Object)sp2);
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.numIterations$4 = numIterations$4;
                        this.trainRdd$1 = trainRdd$1;
                        this.validateRdd$1 = validateRdd$1;
                    }
                });
            }

            public /* synthetic */ GradientBoostedTreesSuite org$apache$spark$mllib$tree$GradientBoostedTreesSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Checkpointing", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GradientBoostedTreesSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                String path = tempDir.toURI().toString();
                this.$outer.sc().setCheckpointDir(path);
                RDD rdd = this.$outer.sc().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])GradientBoostedTreesSuite$.MODULE$.data()), 2, ClassTag$.MODULE$.apply(LabeledPoint.class));
                Enumeration.Value x$60 = Algo$.MODULE$.Regression();
                Variance$ x$61 = Variance$.MODULE$;
                int x$62 = 2;
                Map x$63 = Predef$.MODULE$.Map().empty();
                int x$64 = 2;
                int x$65 = Strategy$.MODULE$.$lessinit$greater$default$4();
                int x$66 = Strategy$.MODULE$.$lessinit$greater$default$5();
                Enumeration.Value x$67 = Strategy$.MODULE$.$lessinit$greater$default$6();
                int x$68 = Strategy$.MODULE$.$lessinit$greater$default$8();
                double x$69 = Strategy$.MODULE$.$lessinit$greater$default$9();
                int x$70 = Strategy$.MODULE$.$lessinit$greater$default$10();
                double x$71 = Strategy$.MODULE$.$lessinit$greater$default$11();
                boolean x$72 = Strategy$.MODULE$.$lessinit$greater$default$12();
                Strategy treeStrategy = new Strategy(x$60, (Impurity)x$61, x$62, x$65, x$66, x$67, x$63, x$68, x$69, x$70, x$71, x$72, x$64);
                BoostingStrategy boostingStrategy = new BoostingStrategy(treeStrategy, (Loss)SquaredError$.MODULE$, 5, 0.1, BoostingStrategy$.MODULE$.$lessinit$greater$default$5());
                GradientBoostedTreesModel gbt = GradientBoostedTrees$.MODULE$.train(rdd, boostingStrategy);
                this.$outer.sc().checkpointDir_$eq((Option)None$.MODULE$);
                Utils$.MODULE$.deleteRecursively(tempDir);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

