/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.classification.BinaryLogisticRegressionSummary;
import org.apache.spark.ml.classification.LogisticRegressionModel$;
import org.apache.spark.ml.classification.LogisticRegressionModel$LogisticRegressionModelWriter$;
import org.apache.spark.ml.classification.LogisticRegressionModel$LogisticRegressionModelWriter$Data$;
import org.apache.spark.ml.classification.LogisticRegressionParams;
import org.apache.spark.ml.classification.LogisticRegressionParams$class;
import org.apache.spark.ml.classification.LogisticRegressionSummary;
import org.apache.spark.ml.classification.LogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasElasticNetParam$class;
import org.apache.spark.ml.param.shared.HasFitIntercept$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasRegParam$class;
import org.apache.spark.ml.param.shared.HasStandardization$class;
import org.apache.spark.ml.param.shared.HasThreshold$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.param.shared.HasWeightCol$class;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\r-d\u0001B\u0001\u0003\u00015\u0011q\u0003T8hSN$\u0018n\u0019*fOJ,7o]5p]6{G-\u001a7\u000b\u0005\r!\u0011AD2mCN\u001c\u0018NZ5dCRLwN\u001c\u0006\u0003\u000b\u0019\t!!\u001c7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001dmq\u0002\u0003B\b\u0011%ii\u0011AA\u0005\u0003#\t\u0011\u0001\u0005\u0015:pE\u0006\u0014\u0017\u000e\\5ti&\u001c7\t\\1tg&4\u0017nY1uS>tWj\u001c3fYB\u00111\u0003G\u0007\u0002))\u0011QCF\u0001\u0007Y&t\u0017\r\\4\u000b\u0005]1\u0011!B7mY&\u0014\u0017BA\r\u0015\u0005\u00191Vm\u0019;peB\u0011q\u0002\u0001\t\u0003\u001fqI!!\b\u0002\u000311{w-[:uS\u000e\u0014Vm\u001a:fgNLwN\u001c)be\u0006l7\u000f\u0005\u0002 E5\t\u0001E\u0003\u0002\"\t\u0005!Q\u000f^5m\u0013\t\u0019\u0003E\u0001\u0006N\u0019^\u0013\u0018\u000e^1cY\u0016D\u0001\"\n\u0001\u0003\u0006\u0004%\tEJ\u0001\u0004k&$W#A\u0014\u0011\u0005!rcBA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R\u0013A\u0002)sK\u0012,g-\u0003\u00020a\t11\u000b\u001e:j]\u001eT!!\f\u0016)\u0007\u0011\u0012\u0004\b\u0005\u00024m5\tAG\u0003\u00026\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005]\"$!B*j]\u000e,\u0017%A\u001d\u0002\u000bErCG\f\u0019\t\u0011m\u0002!\u0011!Q\u0001\n\u001d\nA!^5eA!\u001a!H\r\u001d\t\u0011y\u0002!Q1A\u0005\u0002}\nAbY8fM\u001aL7-[3oiN,\u0012A\u0005\u0015\u0004{I\n\u0015%\u0001\"\u0002\u000bErcG\f\u0019\t\u0011\u0011\u0003!\u0011!Q\u0001\nI\tQbY8fM\u001aL7-[3oiN\u0004\u0003fA\"3\u0003\"Aq\t\u0001BC\u0002\u0013\u0005\u0001*A\u0005j]R,'oY3qiV\t\u0011\n\u0005\u0002*\u0015&\u00111J\u000b\u0002\u0007\t>,(\r\\3)\u0007\u0019\u0013T*I\u0001O\u0003\u0015\tdf\r\u00181\u0011!\u0001\u0006A!A!\u0002\u0013I\u0015AC5oi\u0016\u00148-\u001a9uA!\u001aqJM'\t\rM\u0003A\u0011\u0001\u0003U\u0003\u0019a\u0014N\\5u}Q!!$V,Z\u0011\u0015)#\u000b1\u0001(Q\r)&\u0007\u000f\u0005\u0006}I\u0003\rA\u0005\u0015\u0004/J\n\u0005\"B$S\u0001\u0004I\u0005fA-3\u001b\")A\f\u0001C\u0001\u007f\u00059q/Z5hQR\u001c\b\u0006B._C\u0006\u0003\"!K0\n\u0005\u0001T#A\u00033faJ,7-\u0019;fI\u0006\n!-A\rVg\u0016\u00043m\\3gM&\u001c\u0017.\u001a8ug\u0002Jgn\u001d;fC\u0012t\u0003\"\u00023\u0001\t\u0003*\u0017\u0001D:fiRC'/Z:i_2$GC\u00014h\u001b\u0005\u0001\u0001\"\u00025d\u0001\u0004I\u0015!\u0002<bYV,\u0007fA23U\u0006\n1.A\u00032]Ur\u0003\u0007C\u0003n\u0001\u0011\u0005\u0003*\u0001\u0007hKR$\u0006N]3tQ>dG\rK\u0002me)DQ\u0001\u001d\u0001\u0005BE\fQb]3u)\"\u0014Xm\u001d5pY\u0012\u001cHC\u00014s\u0011\u0015Aw\u000e1\u0001t!\rIC/S\u0005\u0003k*\u0012Q!\u0011:sCfD3a\u001c\u001ak\u0011\u0015A\b\u0001\"\u0011z\u000359W\r\u001e+ie\u0016\u001c\bn\u001c7egV\t1\u000fK\u0002xe)Dq\u0001 \u0001C\u0002\u0013%Q0\u0001\u0004nCJ<\u0017N\\\u000b\u0002}B!\u0011f \nJ\u0013\r\t\tA\u000b\u0002\n\rVt7\r^5p]FBq!!\u0002\u0001A\u0003%a0A\u0004nCJ<\u0017N\u001c\u0011\t\u0011\u0005%\u0001A1A\u0005\nu\fQa]2pe\u0016Dq!!\u0004\u0001A\u0003%a0\u0001\u0004tG>\u0014X\r\t\u0005\n\u0003#\u0001!\u0019!C!\u0003'\t1B\\;n\r\u0016\fG/\u001e:fgV\u0011\u0011Q\u0003\t\u0004S\u0005]\u0011bAA\rU\t\u0019\u0011J\u001c;)\t\u0005=!'\u0011\u0005\t\u0003?\u0001\u0001\u0015!\u0003\u0002\u0016\u0005aa.^7GK\u0006$XO]3tA!\"\u0011Q\u0004\u001aB\u0011%\t)\u0003\u0001b\u0001\n\u0003\n\u0019\"\u0001\u0006ok6\u001cE.Y:tKNDC!a\t3\u001b\"A\u00111\u0006\u0001!\u0002\u0013\t)\"A\u0006ok6\u001cE.Y:tKN\u0004\u0003\u0006BA\u0015e5C\u0011\"!\r\u0001\u0001\u0004%I!a\r\u0002\u001fQ\u0014\u0018-\u001b8j]\u001e\u001cV/\\7bef,\"!!\u000e\u0011\u000b%\n9$a\u000f\n\u0007\u0005e\"F\u0001\u0004PaRLwN\u001c\t\u0004\u001f\u0005u\u0012bAA \u0005\t\tCj\\4jgRL7MU3he\u0016\u001c8/[8o)J\f\u0017N\\5oON+X.\\1ss\"I\u00111\t\u0001A\u0002\u0013%\u0011QI\u0001\u0014iJ\f\u0017N\\5oON+X.\\1ss~#S-\u001d\u000b\u0005\u0003\u000f\ni\u0005E\u0002*\u0003\u0013J1!a\u0013+\u0005\u0011)f.\u001b;\t\u0015\u0005=\u0013\u0011IA\u0001\u0002\u0004\t)$A\u0002yIEB\u0001\"a\u0015\u0001A\u0003&\u0011QG\u0001\u0011iJ\f\u0017N\\5oON+X.\\1ss\u0002Bq!a\u0016\u0001\t\u0003\tI&A\u0004tk6l\u0017M]=\u0016\u0005\u0005m\u0002\u0006BA+e)D\u0001\"a\u0018\u0001\t\u0003\u0011\u0011\u0011M\u0001\u000bg\u0016$8+^7nCJLHc\u00014\u0002d!A\u0011qKA/\u0001\u0004\tY\u0004C\u0004\u0002h\u0001!\t!!\u001b\u0002\u0015!\f7oU;n[\u0006\u0014\u00180\u0006\u0002\u0002lA\u0019\u0011&!\u001c\n\u0007\u0005=$FA\u0004C_>dW-\u00198)\t\u0005\u0015$G\u001b\u0005\t\u0003k\u0002A\u0011\u0001\u0002\u0002x\u0005AQM^1mk\u0006$X\r\u0006\u0003\u0002z\u0005}\u0004cA\b\u0002|%\u0019\u0011Q\u0010\u0002\u000331{w-[:uS\u000e\u0014Vm\u001a:fgNLwN\\*v[6\f'/\u001f\u0005\t\u0003\u0003\u000b\u0019\b1\u0001\u0002\u0004\u00069A-\u0019;bg\u0016$\b\u0003BAC\u0003\u0017k!!a\"\u000b\u0007\u0005%e!A\u0002tc2LA!!$\u0002\b\nIA)\u0019;b\rJ\fW.\u001a\u0005\b\u0003#\u0003A\u0011KAJ\u0003\u001d\u0001(/\u001a3jGR$2!SAK\u0011\u001d\t9*a$A\u0002I\t\u0001BZ3biV\u0014Xm\u001d\u0005\b\u00037\u0003A\u0011KAO\u0003Y\u0011\u0018m\u001e\u001aqe>\u0014\u0017MY5mSRL\u0018J\u001c)mC\u000e,Gc\u0001\n\u0002 \"9\u0011\u0011UAM\u0001\u0004\u0011\u0012!\u0004:boB\u0013X\rZ5di&|g\u000eC\u0004\u0002&\u0002!\t&a*\u0002\u0015A\u0014X\rZ5diJ\u000bw\u000fF\u0002\u0013\u0003SCq!a&\u0002$\u0002\u0007!\u0003C\u0004\u0002.\u0002!\t%a,\u0002\t\r|\u0007/\u001f\u000b\u00045\u0005E\u0006\u0002CAZ\u0003W\u0003\r!!.\u0002\u000b\u0015DHO]1\u0011\t\u0005]\u0016QX\u0007\u0003\u0003sS1!a/\u0005\u0003\u0015\u0001\u0018M]1n\u0013\u0011\ty,!/\u0003\u0011A\u000b'/Y7NCBDC!a+3q!9\u0011Q\u0019\u0001\u0005R\u0005\u001d\u0017A\u0004:boJ\u0002(/\u001a3jGRLwN\u001c\u000b\u0004\u0013\u0006%\u0007bBAQ\u0003\u0007\u0004\rA\u0005\u0005\b\u0003\u001b\u0004A\u0011KAh\u0003Y\u0001(o\u001c2bE&d\u0017\u000e^=3aJ,G-[2uS>tGcA%\u0002R\"9\u00111[Af\u0001\u0004\u0011\u0012a\u00039s_\n\f'-\u001b7jifDq!a6\u0001\t\u0003\nI.A\u0003xe&$X-\u0006\u0002\u0002\\B\u0019q$!8\n\u0007\u0005}\u0007E\u0001\u0005N\u0019^\u0013\u0018\u000e^3sQ\u0011\t)NM!)\u0007\u0001\t)\u000fE\u00024\u0003OL1!!;5\u00051)\u0005\u0010]3sS6,g\u000e^1mQ\r\u0001!\u0007O\u0004\b\u0003_\u0014\u0001\u0012AAy\u0003]aunZ5ti&\u001c'+Z4sKN\u001c\u0018n\u001c8N_\u0012,G\u000eE\u0002\u0010\u0003g4a!\u0001\u0002\t\u0002\u0005U8\u0003CAz\u0003o\fiPa\u0001\u0011\u0007%\nI0C\u0002\u0002|*\u0012a!\u00118z%\u00164\u0007\u0003B\u0010\u0002\u0000jI1A!\u0001!\u0005)iEJU3bI\u0006\u0014G.\u001a\t\u0004S\t\u0015\u0011b\u0001B\u0004U\ta1+\u001a:jC2L'0\u00192mK\"91+a=\u0005\u0002\t-ACAAy\u0011!\u0011y!a=\u0005B\tE\u0011\u0001\u0002:fC\u0012,\"Aa\u0005\u0011\t}\u0011)BG\u0005\u0004\u0005/\u0001#\u0001C'M%\u0016\fG-\u001a:)\t\t5!'\u0011\u0005\t\u0005;\t\u0019\u0010\"\u0011\u0003 \u0005!An\\1e)\rQ\"\u0011\u0005\u0005\b\u0005G\u0011Y\u00021\u0001(\u0003\u0011\u0001\u0018\r\u001e5)\t\tm!'\u0011\u0004\n\u0005S\t\u0019\u0010AAz\u0005W\u0011Q\u0004T8hSN$\u0018n\u0019*fOJ,7o]5p]6{G-\u001a7Xe&$XM]\n\u0007\u0005O\tYN!\f\u0011\t\t=\"\u0011G\u0007\u0002\r%\u0019!1\u0007\u0004\u0003\u000f1{wmZ5oO\"Q!q\u0007B\u0014\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\u0011%t7\u000f^1oG\u0016Dqa\u0015B\u0014\t\u0003\u0011Y\u0004\u0006\u0003\u0003>\t\u0005\u0003\u0003\u0002B \u0005Oi!!a=\t\u000f\t]\"\u0011\ba\u00015\u00199!Q\tB\u0014\t\n\u001d#\u0001\u0002#bi\u0006\u001c\u0002Ba\u0011\u0002x\n%#1\u0001\t\u0004S\t-\u0013b\u0001B'U\t9\u0001K]8ek\u000e$\bbCA\u0013\u0005\u0007\u0012)\u001a!C\u0001\u0003'A1\"a\u000b\u0003D\tE\t\u0015!\u0003\u0002\u0016!Y\u0011\u0011\u0003B\"\u0005+\u0007I\u0011AA\n\u0011-\tyBa\u0011\u0003\u0012\u0003\u0006I!!\u0006\t\u0013\u001d\u0013\u0019E!f\u0001\n\u0003A\u0005\"\u0003)\u0003D\tE\t\u0015!\u0003J\u0011%q$1\tBK\u0002\u0013\u0005q\bC\u0005E\u0005\u0007\u0012\t\u0012)A\u0005%!91Ka\u0011\u0005\u0002\t\u0005DC\u0003B2\u0005O\u0012IGa\u001b\u0003nA!!Q\rB\"\u001b\t\u00119\u0003\u0003\u0005\u0002&\t}\u0003\u0019AA\u000b\u0011!\t\tBa\u0018A\u0002\u0005U\u0001BB$\u0003`\u0001\u0007\u0011\n\u0003\u0004?\u0005?\u0002\rA\u0005\u0005\u000b\u0003[\u0013\u0019%!A\u0005\u0002\tEDC\u0003B2\u0005g\u0012)Ha\u001e\u0003z!Q\u0011Q\u0005B8!\u0003\u0005\r!!\u0006\t\u0015\u0005E!q\u000eI\u0001\u0002\u0004\t)\u0002\u0003\u0005H\u0005_\u0002\n\u00111\u0001J\u0011!q$q\u000eI\u0001\u0002\u0004\u0011\u0002B\u0003B?\u0005\u0007\n\n\u0011\"\u0001\u0003\u0000\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001BAU\u0011\t)Ba!,\u0005\t\u0015\u0005\u0003\u0002BD\u0005\u001fk!A!#\u000b\t\t-%QR\u0001\nk:\u001c\u0007.Z2lK\u0012T!!\u000e\u0016\n\t\tE%\u0011\u0012\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007B\u0003BK\u0005\u0007\n\n\u0011\"\u0001\u0003\u0000\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0004B\u0003BM\u0005\u0007\n\n\u0011\"\u0001\u0003\u001c\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTC\u0001BOU\rI%1\u0011\u0005\u000b\u0005C\u0013\u0019%%A\u0005\u0002\t\r\u0016AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005KS3A\u0005BB\u0011)\u0011IKa\u0011\u0002\u0002\u0013\u0005#1V\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t5\u0006\u0003\u0002BX\u0005sk!A!-\u000b\t\tM&QW\u0001\u0005Y\u0006twM\u0003\u0002\u00038\u0006!!.\u0019<b\u0013\ry#\u0011\u0017\u0005\u000b\u0005{\u0013\u0019%!A\u0005\u0002\u0005M\u0011\u0001\u00049s_\u0012,8\r^!sSRL\bB\u0003Ba\u0005\u0007\n\t\u0011\"\u0001\u0003D\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002Bc\u0005\u0017\u00042!\u000bBd\u0013\r\u0011IM\u000b\u0002\u0004\u0003:L\bBCA(\u0005\u007f\u000b\t\u00111\u0001\u0002\u0016!Q!q\u001aB\"\u0003\u0003%\tE!5\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa5\u0011\r\tU'1\u001cBc\u001b\t\u00119NC\u0002\u0003Z*\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011iNa6\u0003\u0011%#XM]1u_JD!B!9\u0003D\u0005\u0005I\u0011\u0001Br\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA6\u0005KD!\"a\u0014\u0003`\u0006\u0005\t\u0019\u0001Bc\u0011)\u0011IOa\u0011\u0002\u0002\u0013\u0005#1^\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011Q\u0003\u0005\u000b\u0005_\u0014\u0019%!A\u0005B\tE\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t5\u0006B\u0003B{\u0005\u0007\n\t\u0011\"\u0011\u0003x\u00061Q-];bYN$B!a\u001b\u0003z\"Q\u0011q\nBz\u0003\u0003\u0005\rA!2\b\u0015\tu(qEA\u0001\u0012\u0013\u0011y0\u0001\u0003ECR\f\u0007\u0003\u0002B3\u0007\u00031!B!\u0012\u0003(\u0005\u0005\t\u0012BB\u0002'\u0019\u0019\ta!\u0002\u0003\u0004Aa1qAB\u0007\u0003+\t)\"\u0013\n\u0003d5\u00111\u0011\u0002\u0006\u0004\u0007\u0017Q\u0013a\u0002:v]RLW.Z\u0005\u0005\u0007\u001f\u0019IAA\tBEN$(/Y2u\rVt7\r^5p]RBqaUB\u0001\t\u0003\u0019\u0019\u0002\u0006\u0002\u0003\u0000\"Q!q^B\u0001\u0003\u0003%)E!=\t\u0015\re1\u0011AA\u0001\n\u0003\u001bY\"A\u0003baBd\u0017\u0010\u0006\u0006\u0003d\ru1qDB\u0011\u0007GA\u0001\"!\n\u0004\u0018\u0001\u0007\u0011Q\u0003\u0005\t\u0003#\u00199\u00021\u0001\u0002\u0016!1qia\u0006A\u0002%CaAPB\f\u0001\u0004\u0011\u0002BCB\u0014\u0007\u0003\t\t\u0011\"!\u0004*\u00059QO\\1qa2LH\u0003BB\u0016\u0007g\u0001R!KA\u001c\u0007[\u0001\u0012\"KB\u0018\u0003+\t)\"\u0013\n\n\u0007\rE\"F\u0001\u0004UkBdW\r\u000e\u0005\u000b\u0007k\u0019)#!AA\u0002\t\r\u0014a\u0001=%a!Q1\u0011HB\u0001\u0003\u0003%Iaa\u000f\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0007{\u0001BAa,\u0004@%!1\u0011\tBY\u0005\u0019y%M[3di\"A1Q\tB\u0014\t#\u001a9%\u0001\u0005tCZ,\u0017*\u001c9m)\u0011\t9e!\u0013\t\u000f\t\r21\ta\u0001O\u001991QJAz\t\r=#!\b'pO&\u001cH/[2SK\u001e\u0014Xm]:j_:lu\u000eZ3m%\u0016\fG-\u001a:\u0014\t\r-#1\u0003\u0005\b'\u000e-C\u0011AB*)\t\u0019)\u0006\u0005\u0003\u0003@\r-\u0003BCB-\u0007\u0017\u0012\r\u0011\"\u0003\u0003,\u0006I1\r\\1tg:\u000bW.\u001a\u0005\n\u0007;\u001aY\u0005)A\u0005\u0005[\u000b!b\u00197bgNt\u0015-\\3!\u0011!\u0011iba\u0013\u0005B\r\u0005Dc\u0001\u000e\u0004d!9!1EB0\u0001\u00049\u0003BCB\u001d\u0003g\f\t\u0011\"\u0003\u0004<!\"\u00111\u001f\u001aBQ\u0011\tiOM!")
public class LogisticRegressionModel
extends ProbabilisticClassificationModel<Vector, LogisticRegressionModel>
implements LogisticRegressionParams,
MLWritable {
    private final String uid;
    private final Vector coefficients;
    private final double intercept;
    private final Function1<Vector, Object> org$apache$spark$ml$classification$LogisticRegressionModel$$margin;
    private final Function1<Vector, Object> score;
    private final int numFeatures;
    private final int numClasses;
    private Option<LogisticRegressionTrainingSummary> trainingSummary;
    private final DoubleParam threshold;
    private final Param<String> weightCol;
    private final BooleanParam standardization;
    private final DoubleParam tol;
    private final BooleanParam fitIntercept;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;

    public static LogisticRegressionModel load(String string) {
        return LogisticRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<LogisticRegressionModel> read() {
        return LogisticRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public void checkThresholdConsistency() {
        LogisticRegressionParams$class.checkThresholdConsistency(this);
    }

    @Override
    public void validateParams() {
        LogisticRegressionParams$class.validateParams(this);
    }

    @Override
    public final DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol$class.getWeightCol(this);
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization$class.getStandardization(this);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept$class.getFitIntercept(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam$class.getElasticNetParam(this);
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final double getRegParam() {
        return HasRegParam$class.getRegParam(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector coefficients() {
        return this.coefficients;
    }

    public double intercept() {
        return this.intercept;
    }

    public Vector weights() {
        return this.coefficients();
    }

    @Override
    public LogisticRegressionModel setThreshold(double value) {
        return (LogisticRegressionModel)LogisticRegressionParams$class.setThreshold(this, value);
    }

    @Override
    public double getThreshold() {
        return LogisticRegressionParams$class.getThreshold(this);
    }

    @Override
    public LogisticRegressionModel setThresholds(double[] value) {
        return (LogisticRegressionModel)LogisticRegressionParams$class.setThresholds(this, value);
    }

    @Override
    public double[] getThresholds() {
        return LogisticRegressionParams$class.getThresholds(this);
    }

    public Function1<Vector, Object> org$apache$spark$ml$classification$LogisticRegressionModel$$margin() {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$margin;
    }

    private Function1<Vector, Object> score() {
        return this.score;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    private Option<LogisticRegressionTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    private void trainingSummary_$eq(Option<LogisticRegressionTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    public LogisticRegressionTrainingSummary summary() {
        Option<LogisticRegressionTrainingSummary> option = this.trainingSummary();
        if (option instanceof Some) {
            LogisticRegressionTrainingSummary summ;
            Some some = (Some)option;
            LogisticRegressionTrainingSummary logisticRegressionTrainingSummary = summ = (LogisticRegressionTrainingSummary)some.x();
            return logisticRegressionTrainingSummary;
        }
        None$ none$ = None$.MODULE$;
        Option<LogisticRegressionTrainingSummary> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new SparkException("No training summary available for this LogisticRegressionModel", (Throwable)new NullPointerException());
        }
        throw new MatchError(option);
    }

    public LogisticRegressionModel setSummary(LogisticRegressionTrainingSummary summary) {
        this.trainingSummary_$eq((Option<LogisticRegressionTrainingSummary>)new Some((Object)summary));
        return this;
    }

    public boolean hasSummary() {
        return this.trainingSummary().isDefined();
    }

    public LogisticRegressionSummary evaluate(DataFrame dataset) {
        return new BinaryLogisticRegressionSummary(this.transform(dataset), this.$(this.probabilityCol()), this.$(this.labelCol()), this.$(this.featuresCol()));
    }

    @Override
    public double predict(Vector features) {
        return BoxesRunTime.unboxToDouble((Object)this.score().apply((Object)features)) > this.getThreshold() ? 1.0 : 0.0;
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            int size = denseVector.size();
            for (int i = 0; i < size; ++i) {
                denseVector.values()[i] = 1.0 / (1.0 + scala.math.package$.MODULE$.exp(-denseVector.values()[i]));
            }
            DenseVector denseVector2 = denseVector;
            return denseVector2;
        }
        if (vector instanceof SparseVector) {
            throw new RuntimeException("Unexpected error in LogisticRegressionModel: raw2probabilitiesInPlace encountered SparseVector");
        }
        throw new MatchError((Object)vector);
    }

    @Override
    public Vector predictRaw(Vector features) {
        double m = BoxesRunTime.unboxToDouble((Object)this.org$apache$spark$ml$classification$LogisticRegressionModel$$margin().apply((Object)features));
        return Vectors$.MODULE$.dense(-m, (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(new double[]{m}));
    }

    @Override
    public LogisticRegressionModel copy(ParamMap extra) {
        LogisticRegressionModel newModel = this.copyValues(new LogisticRegressionModel(this.uid(), this.coefficients(), this.intercept()), extra);
        Object object = this.trainingSummary().isDefined() ? newModel.setSummary((LogisticRegressionTrainingSummary)this.trainingSummary().get()) : BoxedUnit.UNIT;
        return (LogisticRegressionModel)newModel.setParent(this.parent());
    }

    @Override
    public double raw2prediction(Vector rawPrediction) {
        double t = this.getThreshold();
        double rawThreshold = t == 0.0 ? Double.NEGATIVE_INFINITY : (t == 1.0 ? Double.POSITIVE_INFINITY : scala.math.package$.MODULE$.log(t / (1.0 - t)));
        return rawPrediction.apply(1) > rawThreshold ? 1.0 : 0.0;
    }

    @Override
    public double probability2prediction(Vector probability) {
        return probability.apply(1) > this.getThreshold() ? 1.0 : 0.0;
    }

    @Override
    public MLWriter write() {
        return new LogisticRegressionModelWriter(this);
    }

    public LogisticRegressionModel(String uid, Vector coefficients, double intercept) {
        this.uid = uid;
        this.coefficients = coefficients;
        this.intercept = intercept;
        HasRegParam$class.$init$(this);
        HasElasticNetParam$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasFitIntercept$class.$init$(this);
        HasTol$class.$init$(this);
        HasStandardization$class.$init$(this);
        HasWeightCol$class.$init$(this);
        HasThreshold$class.$init$(this);
        LogisticRegressionParams$class.$init$(this);
        MLWritable$class.$init$(this);
        this.org$apache$spark$ml$classification$LogisticRegressionModel$$margin = new $anonfun$8(this);
        this.score = new $anonfun$9(this);
        this.numFeatures = coefficients.size();
        this.numClasses = 2;
        this.trainingSummary = None$.MODULE$;
    }

    public static class LogisticRegressionModelWriter
    extends MLWriter {
        private final LogisticRegressionModel instance;
        private volatile LogisticRegressionModel$LogisticRegressionModelWriter$Data$ Data$module;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private LogisticRegressionModel$LogisticRegressionModelWriter$Data$ org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$$Data$lzycompute() {
            LogisticRegressionModelWriter logisticRegressionModelWriter = this;
            synchronized (logisticRegressionModelWriter) {
                if (this.Data$module != null) return this.Data$module;
                this.Data$module = new LogisticRegressionModel$LogisticRegressionModelWriter$Data$(this);
                return this.Data$module;
            }
        }

        public LogisticRegressionModel$LogisticRegressionModelWriter$Data$ org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$$Data() {
            return this.Data$module == null ? this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$$Data$lzycompute() : this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Data data = new Data(this, this.instance.numClasses(), this.instance.numFeatures(), this.instance.intercept(), this.instance.coefficients());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LogisticRegressionModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.TypeRef().apply($u.ThisType().apply($m.staticClass("org.apache.spark.ml.classification.LogisticRegressionModel.LogisticRegressionModelWriter")), $u.build().selectType($m.staticClass("org.apache.spark.ml.classification.LogisticRegressionModel.LogisticRegressionModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1(LogisticRegressionModelWriter $outer) {
                }
            }
            this.sqlContext().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Data[]{data})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1(this))).repartition(1).write().parquet(dataPath);
        }

        public LogisticRegressionModelWriter(LogisticRegressionModel instance) {
            this.instance = instance;
        }

        public class Data
        implements Product,
        Serializable {
            private final int numClasses;
            private final int numFeatures;
            private final double intercept;
            private final Vector coefficients;
            public final /* synthetic */ LogisticRegressionModelWriter $outer;

            public int numClasses() {
                return this.numClasses;
            }

            public int numFeatures() {
                return this.numFeatures;
            }

            public double intercept() {
                return this.intercept;
            }

            public Vector coefficients() {
                return this.coefficients;
            }

            public Data copy(int numClasses, int numFeatures, double intercept, Vector coefficients) {
                return new Data(this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer(), numClasses, numFeatures, intercept, coefficients);
            }

            public int copy$default$1() {
                return this.numClasses();
            }

            public int copy$default$2() {
                return this.numFeatures();
            }

            public double copy$default$3() {
                return this.intercept();
            }

            public Vector copy$default$4() {
                return this.coefficients();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 4;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                    case 3: {
                        object = this.coefficients();
                        break;
                    }
                    case 2: {
                        object = BoxesRunTime.boxToDouble((double)this.intercept());
                        break;
                    }
                    case 1: {
                        object = BoxesRunTime.boxToInteger((int)this.numFeatures());
                        break;
                    }
                    case 0: {
                        object = BoxesRunTime.boxToInteger((int)this.numClasses());
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.numClasses());
                n = Statics.mix((int)n, (int)this.numFeatures());
                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.intercept()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficients()));
                return Statics.finalizeHash((int)n, (int)4);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                if (this.numClasses() != data.numClasses()) return false;
                if (this.numFeatures() != data.numFeatures()) return false;
                if (this.intercept() != data.intercept()) return false;
                Vector vector = this.coefficients();
                Vector vector2 = data.coefficients();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!((Object)vector).equals(vector2)) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ LogisticRegressionModelWriter org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(LogisticRegressionModelWriter $outer, int numClasses, int numFeatures, double intercept, Vector coefficients) {
                this.numClasses = numClasses;
                this.numFeatures = numFeatures;
                this.intercept = intercept;
                this.coefficients = coefficients;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                Product.class.$init$((Product)this);
            }
        }
    }

    public static class LogisticRegressionModelReader
    extends MLReader<LogisticRegressionModel> {
        private final String className = LogisticRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public LogisticRegressionModel load(String path) {
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
            String dataPath = new Path(path, "data").toString();
            Row data = this.sqlContext().read().format("parquet").load(dataPath).select("numClasses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numFeatures", "intercept", "coefficients"})).head();
            double intercept = data.getDouble(2);
            Vector coefficients = (Vector)data.getAs(3);
            LogisticRegressionModel model = new LogisticRegressionModel(metadata.uid(), coefficients, intercept);
            DefaultParamsReader$.MODULE$.getAndSetParams(model, metadata);
            return model;
        }
    }
}

