/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.math.Field;
import breeze.math.MutableEnumeratedCoordinateField;
import breeze.math.MutableInnerProductModule;
import breeze.optimize.CachedDiffFunction;
import breeze.optimize.DiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.LBFGS;
import breeze.optimize.OWLQN;
import breeze.optimize.StochasticDiffFunction;
import java.io.IOException;
import org.apache.spark.SparkException;
import org.apache.spark.ml.classification.BinaryLogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.LogisticCostFun;
import org.apache.spark.ml.classification.LogisticRegression$;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.classification.LogisticRegressionParams;
import org.apache.spark.ml.classification.LogisticRegressionParams$class;
import org.apache.spark.ml.classification.MultiClassSummarizer;
import org.apache.spark.ml.classification.ProbabilisticClassifier;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasElasticNetParam$class;
import org.apache.spark.ml.param.shared.HasFitIntercept$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasRegParam$class;
import org.apache.spark.ml.param.shared.HasStandardization$class;
import org.apache.spark.ml.param.shared.HasThreshold$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.param.shared.HasWeightCol$class;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.DefaultParamsWritable$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.linalg.VectorImplicits$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005eh\u0001B\u0001\u0003\u00015\u0011!\u0003T8hSN$\u0018n\u0019*fOJ,7o]5p]*\u00111\u0001B\u0001\u000fG2\f7o]5gS\u000e\fG/[8o\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001qAdH\u0013\u0011\u000b=\u0001\"\u0003G\r\u000e\u0003\tI!!\u0005\u0002\u0003/A\u0013xNY1cS2L7\u000f^5d\u00072\f7o]5gS\u0016\u0014\bCA\n\u0017\u001b\u0005!\"BA\u000b\u0005\u0003\u0019a\u0017N\\1mO&\u0011q\u0003\u0006\u0002\u0007-\u0016\u001cGo\u001c:\u0011\u0005=\u0001\u0001CA\b\u001b\u0013\tY\"AA\fM_\u001eL7\u000f^5d%\u0016<'/Z:tS>tWj\u001c3fYB\u0011q\"H\u0005\u0003=\t\u0011\u0001\u0004T8hSN$\u0018n\u0019*fOJ,7o]5p]B\u000b'/Y7t!\t\u00013%D\u0001\"\u0015\t\u0011C!\u0001\u0003vi&d\u0017B\u0001\u0013\"\u0005U!UMZ1vYR\u0004\u0016M]1ng^\u0013\u0018\u000e^1cY\u0016\u0004\"AJ\u0015\u000e\u0003\u001dR!\u0001\u000b\u0004\u0002\u0011%tG/\u001a:oC2L!AK\u0014\u0003\u000f1{wmZ5oO\"AA\u0006\u0001BC\u0002\u0013\u0005S&A\u0002vS\u0012,\u0012A\f\t\u0003_Ur!\u0001M\u001a\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\na\u0001\u0015:fI\u00164\u0017B\u0001\u001c8\u0005\u0019\u0019FO]5oO*\u0011A'\r\u0015\u0004Wez\u0004C\u0001\u001e>\u001b\u0005Y$B\u0001\u001f\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0003}m\u0012QaU5oG\u0016\f\u0013\u0001Q\u0001\u0006c9\"d\u0006\r\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005]\u0005!Q/\u001b3!Q\r\t\u0015h\u0010\u0005\u0006\u000b\u0002!\tAR\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005a9\u0005\"\u0002\u0017E\u0001\u0004q\u0003fA$:\u007f!\u001aA)\u000f&\"\u0003-\u000bQ!\r\u00183]ABQ!\u0012\u0001\u0005\u00025#\u0012\u0001\u0007\u0015\u0004\u0019fz\u0004\"\u0002)\u0001\t\u0003\t\u0016aC:fiJ+w\rU1sC6$\"AU*\u000e\u0003\u0001AQ\u0001V(A\u0002U\u000bQA^1mk\u0016\u0004\"\u0001\r,\n\u0005]\u000b$A\u0002#pk\ndW\rK\u0002Ps)CQA\u0017\u0001\u0005\u0002m\u000b!c]3u\u000b2\f7\u000f^5d\u001d\u0016$\b+\u0019:b[R\u0011!\u000b\u0018\u0005\u0006)f\u0003\r!\u0016\u0015\u00043fz\u0004\"B0\u0001\t\u0003\u0001\u0017AC:fi6\u000b\u00070\u0013;feR\u0011!+\u0019\u0005\u0006)z\u0003\rA\u0019\t\u0003a\rL!\u0001Z\u0019\u0003\u0007%sG\u000fK\u0002_s)CQa\u001a\u0001\u0005\u0002!\faa]3u)>dGC\u0001*j\u0011\u0015!f\r1\u0001VQ\r1\u0017h\u0010\u0005\u0006Y\u0002!\t!\\\u0001\u0010g\u0016$h)\u001b;J]R,'oY3qiR\u0011!K\u001c\u0005\u0006).\u0004\ra\u001c\t\u0003aAL!!]\u0019\u0003\u000f\t{w\u000e\\3b]\"\u001a1.O \t\u000bQ\u0004A\u0011A;\u0002%M,Go\u0015;b]\u0012\f'\u000fZ5{CRLwN\u001c\u000b\u0003%ZDQ\u0001V:A\u0002=D3a]\u001dyC\u0005I\u0018!B\u0019/k9\u0002\u0004\"B>\u0001\t\u0003b\u0018\u0001D:fiRC'/Z:i_2$GC\u0001*~\u0011\u0015!&\u00101\u0001VQ\rQ\u0018\b\u001f\u0005\b\u0003\u0003\u0001A\u0011IA\u0002\u000319W\r\u001e+ie\u0016\u001c\bn\u001c7e+\u0005)\u0006fA@:q\"9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0011\u0001D:fi^+\u0017n\u001a5u\u0007>dGc\u0001*\u0002\u000e!1A+a\u0002A\u00029BS!a\u0002:\u0003#\t#!a\u0005\u0002\u000bErcG\f\u0019\t\u000f\u0005]\u0001\u0001\"\u0011\u0002\u001a\u0005i1/\u001a;UQJ,7\u000f[8mIN$2AUA\u000e\u0011\u001d!\u0016Q\u0003a\u0001\u0003;\u0001B\u0001MA\u0010+&\u0019\u0011\u0011E\u0019\u0003\u000b\u0005\u0013(/Y=)\t\u0005U\u0011\b\u001f\u0005\b\u0003O\u0001A\u0011IA\u0015\u000359W\r\u001e+ie\u0016\u001c\bn\u001c7egV\u0011\u0011Q\u0004\u0015\u0005\u0003KI\u0004\u0010C\u0005\u00020\u0001\u0001\r\u0011\"\u0003\u00022\u0005yq\u000e\u001d;J]&$\u0018.\u00197N_\u0012,G.\u0006\u0002\u00024A!\u0001'!\u000e\u001a\u0013\r\t9$\r\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\u0005m\u0002\u00011A\u0005\n\u0005u\u0012aE8qi&s\u0017\u000e^5bY6{G-\u001a7`I\u0015\fH\u0003BA \u0003\u000b\u00022\u0001MA!\u0013\r\t\u0019%\r\u0002\u0005+:LG\u000f\u0003\u0006\u0002H\u0005e\u0012\u0011!a\u0001\u0003g\t1\u0001\u001f\u00132\u0011!\tY\u0005\u0001Q!\n\u0005M\u0012\u0001E8qi&s\u0017\u000e^5bY6{G-\u001a7!\u0011!\ty\u0005\u0001C\u0001\r\u0005E\u0013aD:fi&s\u0017\u000e^5bY6{G-\u001a7\u0015\u0007I\u000b\u0019\u0006C\u0004\u0002V\u00055\u0003\u0019A\r\u0002\u000b5|G-\u001a7\t\u0011\u0005e\u0003\u0001\"\u0015\u0007\u00037\nQ\u0001\u001e:bS:$2!GA/\u0011!\ty&a\u0016A\u0002\u0005\u0005\u0014a\u00023bi\u0006\u001cX\r\u001e\u0019\u0005\u0003G\n\u0019\b\u0005\u0004\u0002f\u0005-\u0014qN\u0007\u0003\u0003OR1!!\u001b\u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003[\n9GA\u0004ECR\f7/\u001a;\u0011\t\u0005E\u00141\u000f\u0007\u0001\t1\t)(!\u0018\u0002\u0002\u0003\u0005)\u0011AA<\u0005\ryF%M\t\u0005\u0003s\ny\bE\u00021\u0003wJ1!! 2\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001MAA\u0013\r\t\u0019)\r\u0002\u0004\u0003:L\b\u0002CA-\u0001\u0011Ea!a\"\u0015\u000be\tI)!&\t\u0011\u0005}\u0013Q\u0011a\u0001\u0003\u0017\u0003D!!$\u0002\u0012B1\u0011QMA6\u0003\u001f\u0003B!!\u001d\u0002\u0012\u0012a\u00111SAE\u0003\u0003\u0005\tQ!\u0001\u0002x\t\u0019q\f\n\u001a\t\u000f\u0005]\u0015Q\u0011a\u0001_\u0006\t\u0002.\u00198eY\u0016\u0004VM]:jgR,gnY3\t\u000f\u0005m\u0005\u0001\"\u0011\u0002\u001e\u0006!1m\u001c9z)\rA\u0012q\u0014\u0005\t\u0003C\u000bI\n1\u0001\u0002$\u0006)Q\r\u001f;sCB!\u0011QUAV\u001b\t\t9KC\u0002\u0002*\u0012\tQ\u0001]1sC6LA!!,\u0002(\nA\u0001+\u0019:b[6\u000b\u0007\u000f\u000b\u0003\u0002\u001afz\u0004f\u0001\u0001:\u0015\u001e9\u0011Q\u0017\u0002\t\u0002\u0005]\u0016A\u0005'pO&\u001cH/[2SK\u001e\u0014Xm]:j_:\u00042aDA]\r\u0019\t!\u0001#\u0001\u0002<NA\u0011\u0011XA_\u0003\u0007\fI\rE\u00021\u0003\u007fK1!!12\u0005\u0019\te.\u001f*fMB!\u0001%!2\u0019\u0013\r\t9-\t\u0002\u0016\t\u00164\u0017-\u001e7u!\u0006\u0014\u0018-\\:SK\u0006$\u0017M\u00197f!\r\u0001\u00141Z\u0005\u0004\u0003\u001b\f$\u0001D*fe&\fG.\u001b>bE2,\u0007bB#\u0002:\u0012\u0005\u0011\u0011\u001b\u000b\u0003\u0003oC\u0001\"!6\u0002:\u0012\u0005\u0013q[\u0001\u0005Y>\fG\rF\u0002\u0019\u00033Dq!a7\u0002T\u0002\u0007a&\u0001\u0003qCRD\u0007&BAjs\u0005E\u0001BCAq\u0003s\u000b\t\u0011\"\u0003\u0002d\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t)\u000f\u0005\u0003\u0002h\u0006EXBAAu\u0015\u0011\tY/!<\u0002\t1\fgn\u001a\u0006\u0003\u0003_\fAA[1wC&!\u00111_Au\u0005\u0019y%M[3di\"*\u0011\u0011X\u001d\u0002\u0012!*\u00111W\u001d\u0002\u0012\u0001")
public class LogisticRegression
extends ProbabilisticClassifier<Vector, LogisticRegression, LogisticRegressionModel>
implements LogisticRegressionParams,
DefaultParamsWritable {
    private final String uid;
    private Option<LogisticRegressionModel> optInitialModel;
    private final DoubleParam threshold;
    private final Param<String> weightCol;
    private final BooleanParam standardization;
    private final DoubleParam tol;
    private final BooleanParam fitIntercept;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;

    public static MLReader<LogisticRegression> read() {
        return LogisticRegression$.MODULE$.read();
    }

    public static LogisticRegression load(String string) {
        return LogisticRegression$.MODULE$.load(string);
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable$class.write(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public void checkThresholdConsistency() {
        LogisticRegressionParams$class.checkThresholdConsistency(this);
    }

    @Override
    public void validateParams() {
        LogisticRegressionParams$class.validateParams(this);
    }

    @Override
    public final DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol$class.getWeightCol(this);
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization$class.getStandardization(this);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept$class.getFitIntercept(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam$class.getElasticNetParam(this);
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final double getRegParam() {
        return HasRegParam$class.getRegParam(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public LogisticRegression setRegParam(double value) {
        return (LogisticRegression)this.set(this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setElasticNetParam(double value) {
        return (LogisticRegression)this.set(this.elasticNetParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setMaxIter(int value) {
        return (LogisticRegression)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public LogisticRegression setTol(double value) {
        return (LogisticRegression)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setFitIntercept(boolean value) {
        return (LogisticRegression)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LogisticRegression setStandardization(boolean value) {
        return (LogisticRegression)this.set(this.standardization(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    @Override
    public LogisticRegression setThreshold(double value) {
        return (LogisticRegression)LogisticRegressionParams$class.setThreshold(this, value);
    }

    @Override
    public double getThreshold() {
        return LogisticRegressionParams$class.getThreshold(this);
    }

    public LogisticRegression setWeightCol(String value) {
        return (LogisticRegression)this.set(this.weightCol(), value);
    }

    @Override
    public LogisticRegression setThresholds(double[] value) {
        return (LogisticRegression)LogisticRegressionParams$class.setThresholds(this, value);
    }

    @Override
    public double[] getThresholds() {
        return LogisticRegressionParams$class.getThresholds(this);
    }

    private Option<LogisticRegressionModel> optInitialModel() {
        return this.optInitialModel;
    }

    private void optInitialModel_$eq(Option<LogisticRegressionModel> x$1) {
        this.optInitialModel = x$1;
    }

    public LogisticRegression setInitialModel(LogisticRegressionModel model) {
        this.optInitialModel_$eq((Option<LogisticRegressionModel>)new Some((Object)model));
        return this;
    }

    @Override
    public LogisticRegressionModel train(Dataset<?> dataset) {
        StorageLevel storageLevel = dataset.rdd().getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
        return this.train(dataset, handlePersistence);
    }

    public LogisticRegressionModel train(Dataset<?> dataset, boolean handlePersistence) {
        Column w2 = this.isDefined(this.weightCol()) && !this.$(this.weightCol()).isEmpty() ? functions$.MODULE$.col(this.$(this.weightCol())) : functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0));
        RDD instances = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.labelCol())).cast((DataType)DoubleType$.MODULE$), w2, functions$.MODULE$.col(this.$(this.featuresCol()))})).rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Instance apply(Row x0$1) {
                Row row = x0$1;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                    Object label = ((SeqLike)some.get()).apply(0);
                    Object weight = ((SeqLike)some.get()).apply(1);
                    Object features = ((SeqLike)some.get()).apply(2);
                    if (label instanceof Double) {
                        double d = BoxesRunTime.unboxToDouble((Object)label);
                        if (weight instanceof Double) {
                            double d2 = BoxesRunTime.unboxToDouble((Object)weight);
                            if (features instanceof Vector) {
                                Vector vector = (Vector)features;
                                Instance instance = new Instance(d, d2, vector);
                                return instance;
                            }
                        }
                    }
                }
                throw new MatchError((Object)row);
            }
        }, ClassTag$.MODULE$.apply(Instance.class));
        Object object = handlePersistence ? instances.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
        Instrumentation<LogisticRegression> instr = Instrumentation$.MODULE$.create(this, instances);
        instr.logParams((Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.regParam(), this.elasticNetParam(), this.standardization(), this.threshold(), this.maxIter(), this.tol(), this.fitIntercept()}));
        Serializable seqOp = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> apply(Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> c, Instance instance) {
                return new Tuple2((Object)((MultivariateOnlineSummarizer)c._1()).add(VectorImplicits$.MODULE$.mlVectorToMLlibVector(instance.features()), instance.weight()), (Object)((MultiClassSummarizer)c._2()).add(instance.label(), instance.weight()));
            }
        };
        Serializable combOp = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> apply(Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> c1, Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> c2) {
                return new Tuple2((Object)((MultivariateOnlineSummarizer)c1._1()).merge((MultivariateOnlineSummarizer)c2._1()), (Object)((MultiClassSummarizer)c1._2()).merge((MultiClassSummarizer)c2._2()));
            }
        };
        Tuple2 x$9 = new Tuple2((Object)new MultivariateOnlineSummarizer(), (Object)new MultiClassSummarizer());
        Serializable x$10 = seqOp;
        Serializable x$11 = combOp;
        int x$12 = instances.treeAggregate$default$4((Object)x$9);
        Tuple2 tuple2 = (Tuple2)instances.treeAggregate((Object)x$9, (Function2)x$10, (Function2)x$11, x$12, ClassTag$.MODULE$.apply(Tuple2.class));
        if (tuple2 != null) {
            Tuple3 tuple3;
            Tuple3 tuple32;
            Tuple2 tuple22;
            MultivariateOnlineSummarizer summarizer = (MultivariateOnlineSummarizer)tuple2._1();
            MultiClassSummarizer labelSummarizer = (MultiClassSummarizer)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)summarizer, (Object)labelSummarizer);
            MultivariateOnlineSummarizer summarizer2 = (MultivariateOnlineSummarizer)tuple23._1();
            MultiClassSummarizer labelSummarizer2 = (MultiClassSummarizer)tuple23._2();
            double[] histogram2 = labelSummarizer2.histogram();
            long numInvalid = labelSummarizer2.countInvalid();
            int numClasses = histogram2.length;
            int numFeatures = summarizer2.mean().size();
            if (this.isDefined(this.thresholds())) {
                Predef$.MODULE$.require(this.$(this.thresholds()).length == numClasses, (Function0)new Serializable(this, numClasses){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ LogisticRegression $outer;
                    private final int numClasses$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)this.$outer.getClass().getSimpleName()).append((Object)".train() called with non-matching numClasses and thresholds.length.").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" numClasses=", ", but thresholds has length ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numClasses$1), BoxesRunTime.boxToInteger((int)this.$outer.$(this.$outer.thresholds()).length)}))).toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.numClasses$1 = numClasses$1;
                    }
                });
            }
            instr.logNumClasses(numClasses);
            instr.logNumFeatures(numFeatures);
            if (numInvalid != 0L) {
                String msg = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Classification labels should be in {0 to ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(numClasses - 1))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " invalid labels."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)numInvalid)}))).toString();
                this.logError((Function0<String>)new Serializable(this, msg){
                    public static final long serialVersionUID = 0L;
                    private final String msg$1;

                    public final String apply() {
                        return this.msg$1;
                    }
                    {
                        this.msg$1 = msg$1;
                    }
                });
                throw new SparkException(msg);
            }
            if (numClasses > 2) {
                String msg = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Currently, LogisticRegression with ElasticNet in ML package only supports "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"binary classification. Found ", " in the input dataset."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numClasses)}))).toString();
                this.logError((Function0<String>)new Serializable(this, msg){
                    public static final long serialVersionUID = 0L;
                    private final String msg$2;

                    public final String apply() {
                        return this.msg$2;
                    }
                    {
                        this.msg$2 = msg$2;
                    }
                });
                throw new SparkException(msg);
            }
            if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && numClasses == 2 && histogram2[0] == 0.0) {
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"All labels are one and fitIntercept=true, so the coefficients will be "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zeros and the intercept will be positive infinity; as a result, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"training is not needed."})).s((Seq)Nil$.MODULE$)).toString();
                    }
                });
                tuple32 = new Tuple3((Object)Vectors$.MODULE$.sparse(numFeatures, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), (Object)BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY), Array$.MODULE$.empty(ClassTag$.MODULE$.Double()));
            } else if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && numClasses == 1) {
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"All labels are zero and fitIntercept=true, so the coefficients will be "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zeros and the intercept will be negative infinity; as a result, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"training is not needed."})).s((Seq)Nil$.MODULE$)).toString();
                    }
                });
                tuple32 = new Tuple3((Object)Vectors$.MODULE$.sparse(numFeatures, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), (Object)BoxesRunTime.boxToDouble((double)Double.NEGATIVE_INFINITY), Array$.MODULE$.empty(ClassTag$.MODULE$.Double()));
            } else {
                Object object2;
                LBFGS lBFGS;
                if (!BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && numClasses == 2 && histogram2[0] == 0.0) {
                    this.logWarning((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"All labels are one and fitIntercept=false. It's a dangerous ground, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"so the algorithm may not converge."})).s((Seq)Nil$.MODULE$)).toString();
                        }
                    });
                } else if (!BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && numClasses == 1) {
                    this.logWarning((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"All labels are zero and fitIntercept=false. It's a dangerous ground, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"so the algorithm may not converge."})).s((Seq)Nil$.MODULE$)).toString();
                        }
                    });
                }
                double[] featuresMean = summarizer2.mean().toArray();
                double[] featuresStd = (double[])Predef$.MODULE$.doubleArrayOps(summarizer2.variance().toArray()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x) {
                        return this.apply$mcDD$sp(x);
                    }

                    public double apply$mcDD$sp(double x) {
                        return package$.MODULE$.sqrt(x);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                if (!BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numFeatures).exists((Function1)new Serializable(this, featuresMean, featuresStd){
                    public static final long serialVersionUID = 0L;
                    private final double[] featuresMean$1;
                    private final double[] featuresStd$1;

                    public final boolean apply(int i) {
                        return this.apply$mcZI$sp(i);
                    }

                    public boolean apply$mcZI$sp(int i) {
                        return this.featuresStd$1[i] == 0.0 && this.featuresMean$1[i] != 0.0;
                    }
                    {
                        this.featuresMean$1 = featuresMean$1;
                        this.featuresStd$1 = featuresStd$1;
                    }
                })) {
                    this.logWarning((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Fitting LogisticRegressionModel without intercept on dataset with constant nonzero column, Spark MLlib outputs zero coefficients for constant nonzero columns. This behavior is the same as R glmnet but different from LIBSVM.";
                        }
                    });
                }
                double regParamL1 = BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) * BoxesRunTime.unboxToDouble((Object)this.$(this.regParam()));
                double regParamL2 = (1.0 - BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam()))) * BoxesRunTime.unboxToDouble((Object)this.$(this.regParam()));
                LogisticCostFun costFun = new LogisticCostFun((RDD<Instance>)instances, numClasses, BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization())), featuresStd, featuresMean, regParamL2);
                if (BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) == 0.0 || BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())) == 0.0) {
                    lBFGS = new LBFGS(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableInnerProductModule)DenseVector$.MODULE$.space((Field)Field.fieldDouble$.MODULE$, ClassTag$.MODULE$.Double()));
                } else {
                    boolean standardizationParam = BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization()));
                    lBFGS = new OWLQN(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, this.regParamL1Fun$1(numFeatures, featuresStd, regParamL1, standardizationParam), BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableEnumeratedCoordinateField)DenseVector$.MODULE$.space((Field)Field.fieldDouble$.MODULE$, ClassTag$.MODULE$.Double()));
                }
                LBFGS optimizer = lBFGS;
                Vector initialCoefficientsWithIntercept = Vectors$.MODULE$.zeros(BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) ? numFeatures + 1 : numFeatures);
                if (this.optInitialModel().isDefined() && ((LogisticRegressionModel)this.optInitialModel().get()).coefficients().size() != numFeatures) {
                    int vecSize = ((LogisticRegressionModel)this.optInitialModel().get()).coefficients().size();
                    this.logWarning((Function0<String>)new Serializable(this, numFeatures, vecSize){
                        public static final long serialVersionUID = 0L;
                        private final int numFeatures$1;
                        private final int vecSize$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initial coefficients will be ignored!! As its size ", " did not match the "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.vecSize$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expected size ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numFeatures$1)}))).toString();
                        }
                        {
                            this.numFeatures$1 = numFeatures$1;
                            this.vecSize$1 = vecSize$1;
                        }
                    });
                }
                if (this.optInitialModel().isDefined() && ((LogisticRegressionModel)this.optInitialModel().get()).coefficients().size() == numFeatures) {
                    double[] initialCoefficientsWithInterceptArray = initialCoefficientsWithIntercept.toArray();
                    ((LogisticRegressionModel)this.optInitialModel().get()).coefficients().foreachActive((Function2)new Serializable(this, initialCoefficientsWithInterceptArray){
                        public static final long serialVersionUID = 0L;
                        private final double[] initialCoefficientsWithInterceptArray$1;

                        public final void apply(int x0$2, double x1$1) {
                            this.apply$mcVID$sp(x0$2, x1$1);
                        }

                        public void apply$mcVID$sp(int x0$2, double x1$1) {
                            Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(x0$2, x1$1);
                            if (sp2 != null) {
                                double value;
                                int index2 = sp2._1$mcI$sp();
                                this.initialCoefficientsWithInterceptArray$1[index2] = value = sp2._2$mcD$sp();
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError((Object)sp2);
                        }
                        {
                            this.initialCoefficientsWithInterceptArray$1 = initialCoefficientsWithInterceptArray$1;
                        }
                    });
                    object2 = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) ? BoxesRunTime.boxToBoolean((initialCoefficientsWithInterceptArray[numFeatures] == ((LogisticRegressionModel)this.optInitialModel().get()).intercept() ? 1 : 0) != 0) : BoxedUnit.UNIT;
                } else {
                    if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()))) {
                        initialCoefficientsWithIntercept.toArray()[numFeatures] = package$.MODULE$.log(histogram2[1] / histogram2[0]);
                    }
                    object2 = BoxedUnit.UNIT;
                }
                Iterator states = optimizer.iterations((StochasticDiffFunction)new CachedDiffFunction((DiffFunction)costFun, DenseVector$.MODULE$.canCopyDenseVector(ClassTag$.MODULE$.Double())), (Object)initialCoefficientsWithIntercept.asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()));
                ArrayBuilder arrayBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
                ObjectRef state = ObjectRef.create(null);
                while (states.hasNext()) {
                    state.elem = (FirstOrderMinimizer.State)states.next();
                    arrayBuilder.$plus$eq((Object)BoxesRunTime.boxToDouble((double)((FirstOrderMinimizer.State)state.elem).adjustedValue()));
                }
                if ((FirstOrderMinimizer.State)state.elem == null) {
                    String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " failed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{optimizer.getClass().getName()}));
                    this.logError((Function0<String>)new Serializable(this, msg){
                        public static final long serialVersionUID = 0L;
                        private final String msg$3;

                        public final String apply() {
                            return this.msg$3;
                        }
                        {
                            this.msg$3 = msg$3;
                        }
                    });
                    throw new SparkException(msg);
                }
                if (!((FirstOrderMinimizer.State)state.elem).actuallyConverged()) {
                    this.logWarning((Function0<String>)new Serializable(this, state){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef state$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"LogisticRegression training finished but the result ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is not converged because: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((FirstOrderMinimizer.ConvergenceReason)((FirstOrderMinimizer.State)this.state$1.elem).convergedReason().get()).reason()}))).toString();
                        }
                        {
                            this.state$1 = state$1;
                        }
                    });
                }
                double[] rawCoefficients = (double[])((DenseVector)((FirstOrderMinimizer.State)state.elem).x()).toArray$mcD$sp(ClassTag$.MODULE$.Double()).clone();
                for (int i = 0; i < numFeatures; ++i) {
                    int n = i;
                    rawCoefficients[n] = rawCoefficients[n] * (featuresStd[i] != 0.0 ? 1.0 / featuresStd[i] : 0.0);
                }
                tuple32 = tuple3 = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) ? new Tuple3((Object)Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(rawCoefficients).dropRight(1)).compressed(), Predef$.MODULE$.doubleArrayOps(rawCoefficients).last(), arrayBuilder.result()) : new Tuple3((Object)Vectors$.MODULE$.dense(rawCoefficients).compressed(), (Object)BoxesRunTime.boxToDouble((double)0.0), arrayBuilder.result());
            }
            if (tuple3 != null) {
                Tuple3 tuple33;
                Vector coefficients2 = (Vector)tuple3._1();
                double intercept = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                double[] objectiveHistory = (double[])tuple3._3();
                Tuple3 tuple34 = tuple33 = new Tuple3((Object)coefficients2, (Object)BoxesRunTime.boxToDouble((double)intercept), (Object)objectiveHistory);
                Vector coefficients3 = (Vector)tuple34._1();
                double intercept2 = BoxesRunTime.unboxToDouble((Object)tuple34._2());
                double[] objectiveHistory2 = (double[])tuple34._3();
                Object object3 = handlePersistence ? instances.unpersist(instances.unpersist$default$1()) : BoxedUnit.UNIT;
                LogisticRegressionModel model = this.copyValues(new LogisticRegressionModel(this.uid(), coefficients3, intercept2), this.copyValues$default$2());
                Tuple2<LogisticRegressionModel, String> tuple24 = model.findSummaryModelAndProbabilityCol();
                if (tuple24 != null) {
                    Tuple2 tuple25;
                    LogisticRegressionModel summaryModel = (LogisticRegressionModel)tuple24._1();
                    String probabilityColName = (String)tuple24._2();
                    Tuple2 tuple26 = tuple25 = new Tuple2((Object)summaryModel, (Object)probabilityColName);
                    LogisticRegressionModel summaryModel2 = (LogisticRegressionModel)tuple26._1();
                    String probabilityColName2 = (String)tuple26._2();
                    BinaryLogisticRegressionTrainingSummary logRegSummary = new BinaryLogisticRegressionTrainingSummary(summaryModel2.transform(dataset), probabilityColName2, this.$(this.labelCol()), this.$(this.featuresCol()), objectiveHistory2);
                    LogisticRegressionModel m = model.setSummary(logRegSummary);
                    instr.logSuccess(m);
                    return m;
                }
                throw new MatchError(tuple24);
            }
            throw new MatchError((Object)tuple3);
        }
        throw new MatchError((Object)tuple2);
    }

    @Override
    public LogisticRegression copy(ParamMap extra) {
        return (LogisticRegression)this.defaultCopy(extra);
    }

    private final Function1 regParamL1Fun$1(int numFeatures$1, double[] featuresStd$1, double regParamL1$1, boolean standardizationParam$1) {
        return new Serializable(this, numFeatures$1, featuresStd$1, regParamL1$1, standardizationParam$1){
            public static final long serialVersionUID = 0L;
            private final int numFeatures$1;
            private final double[] featuresStd$1;
            private final double regParamL1$1;
            private final boolean standardizationParam$1;

            public final double apply(int index2) {
                return this.apply$mcDI$sp(index2);
            }

            public double apply$mcDI$sp(int index2) {
                return index2 == this.numFeatures$1 ? 0.0 : (this.standardizationParam$1 ? this.regParamL1$1 : (this.featuresStd$1[index2] != 0.0 ? this.regParamL1$1 / this.featuresStd$1[index2] : 0.0));
            }
            {
                this.numFeatures$1 = numFeatures$1;
                this.featuresStd$1 = featuresStd$1;
                this.regParamL1$1 = regParamL1$1;
                this.standardizationParam$1 = standardizationParam$1;
            }
        };
    }

    public LogisticRegression(String uid) {
        this.uid = uid;
        HasRegParam$class.$init$(this);
        HasElasticNetParam$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasFitIntercept$class.$init$(this);
        HasTol$class.$init$(this);
        HasStandardization$class.$init$(this);
        HasWeightCol$class.$init$(this);
        HasThreshold$class.$init$(this);
        LogisticRegressionParams$class.$init$(this);
        MLWritable$class.$init$(this);
        DefaultParamsWritable$class.$init$(this);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.regParam().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.elasticNetParam().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.maxIter().$minus$greater(BoxesRunTime.boxToInteger((int)100))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.tol().$minus$greater(BoxesRunTime.boxToDouble((double)1.0E-6))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.fitIntercept().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.standardization().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.optInitialModel = None$.MODULE$;
    }

    public LogisticRegression() {
        this(Identifiable$.MODULE$.randomUID("logreg"));
    }
}

