/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.math.Field;
import breeze.math.MutableEnumeratedCoordinateField;
import breeze.math.MutableInnerProductModule;
import breeze.optimize.CachedDiffFunction;
import breeze.optimize.DiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.LBFGS;
import breeze.optimize.OWLQN;
import breeze.optimize.StochasticDiffFunction;
import java.io.IOException;
import org.apache.spark.SparkException;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.WeightedLeastSquares;
import org.apache.spark.ml.optim.WeightedLeastSquares$;
import org.apache.spark.ml.optim.WeightedLeastSquaresModel;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasElasticNetParam$class;
import org.apache.spark.ml.param.shared.HasFitIntercept$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasRegParam$class;
import org.apache.spark.ml.param.shared.HasSolver$class;
import org.apache.spark.ml.param.shared.HasStandardization$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.param.shared.HasWeightCol$class;
import org.apache.spark.ml.regression.LeastSquaresCostFun;
import org.apache.spark.ml.regression.LinearRegression$;
import org.apache.spark.ml.regression.LinearRegressionModel;
import org.apache.spark.ml.regression.LinearRegressionParams;
import org.apache.spark.ml.regression.LinearRegressionTrainingSummary;
import org.apache.spark.ml.regression.Regressor;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.DefaultParamsWritable$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.linalg.VectorImplicits$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005me\u0001B\u0001\u0003\u00015\u0011\u0001\u0003T5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8\u000b\u0005\r!\u0011A\u0003:fOJ,7o]5p]*\u0011QAB\u0001\u0003[2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0015\u0001a\u0002H\u0010&!\u0015y\u0001C\u0005\r\u001a\u001b\u0005\u0011\u0011BA\t\u0003\u0005%\u0011Vm\u001a:fgN|'\u000f\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u00051A.\u001b8bY\u001eL!a\u0006\u000b\u0003\rY+7\r^8s!\ty\u0001\u0001\u0005\u0002\u00105%\u00111D\u0001\u0002\u0016\u0019&tW-\u0019:SK\u001e\u0014Xm]:j_:lu\u000eZ3m!\tyQ$\u0003\u0002\u001f\u0005\t1B*\u001b8fCJ\u0014Vm\u001a:fgNLwN\u001c)be\u0006l7\u000f\u0005\u0002!G5\t\u0011E\u0003\u0002#\t\u0005!Q\u000f^5m\u0013\t!\u0013EA\u000bEK\u001a\fW\u000f\u001c;QCJ\fWn],sSR\f'\r\\3\u0011\u0005\u0019JS\"A\u0014\u000b\u0005!2\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005):#a\u0002'pO\u001eLgn\u001a\u0005\tY\u0001\u0011)\u0019!C![\u0005\u0019Q/\u001b3\u0016\u00039\u0002\"aL\u001b\u000f\u0005A\u001aT\"A\u0019\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0002\rA\u0013X\rZ3g\u0013\t1tG\u0001\u0004TiJLgn\u001a\u0006\u0003iEB3aK\u001d@!\tQT(D\u0001<\u0015\tad!\u0001\u0006b]:|G/\u0019;j_:L!AP\u001e\u0003\u000bMKgnY3\"\u0003\u0001\u000bQ!\r\u00184]AB\u0001B\u0011\u0001\u0003\u0002\u0003\u0006IAL\u0001\u0005k&$\u0007\u0005K\u0002Bs}BQ!\u0012\u0001\u0005\u0002\u0019\u000ba\u0001P5oSRtDC\u0001\rH\u0011\u0015aC\t1\u0001/Q\r9\u0015h\u0010\u0015\u0004\tfz\u0004\"B#\u0001\t\u0003YE#\u0001\r)\u0007)KT*I\u0001O\u0003\u0015\td\u0006\u000e\u00181\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0003-\u0019X\r\u001e*fOB\u000b'/Y7\u0015\u0005I\u001bV\"\u0001\u0001\t\u000bQ{\u0005\u0019A+\u0002\u000bY\fG.^3\u0011\u0005A2\u0016BA,2\u0005\u0019!u.\u001e2mK\"\u001aq*O \t\u000bi\u0003A\u0011A.\u0002\u001fM,GOR5u\u0013:$XM]2faR$\"A\u0015/\t\u000bQK\u0006\u0019A/\u0011\u0005Ar\u0016BA02\u0005\u001d\u0011un\u001c7fC:D3!W\u001dbC\u0005\u0011\u0017!B\u0019/k9\u0002\u0004\"\u00023\u0001\t\u0003)\u0017AE:fiN#\u0018M\u001c3be\u0012L'0\u0019;j_:$\"A\u00154\t\u000bQ\u001b\u0007\u0019A/)\u0007\rL\u0014\rC\u0003j\u0001\u0011\u0005!.\u0001\ntKR,E.Y:uS\u000etU\r\u001e)be\u0006lGC\u0001*l\u0011\u0015!\u0006\u000e1\u0001VQ\rA\u0017(\u0014\u0005\u0006]\u0002!\ta\\\u0001\u000bg\u0016$X*\u0019=Ji\u0016\u0014HC\u0001*q\u0011\u0015!V\u000e1\u0001r!\t\u0001$/\u0003\u0002tc\t\u0019\u0011J\u001c;)\u00075Lt\bC\u0003w\u0001\u0011\u0005q/\u0001\u0004tKR$v\u000e\u001c\u000b\u0003%bDQ\u0001V;A\u0002UC3!^\u001dN\u0011\u0015Y\b\u0001\"\u0001}\u00031\u0019X\r^,fS\u001eDGoQ8m)\t\u0011V\u0010C\u0003Uu\u0002\u0007a\u0006K\u0002{s}\f#!!\u0001\u0002\u000bErcG\f\u0019\t\u000f\u0005\u0015\u0001\u0001\"\u0001\u0002\b\u0005I1/\u001a;T_24XM\u001d\u000b\u0004%\u0006%\u0001B\u0002+\u0002\u0004\u0001\u0007a\u0006\u000b\u0003\u0002\u0004ez\bbBA\b\u0001\u0011E\u0013\u0011C\u0001\u0006iJ\f\u0017N\u001c\u000b\u00043\u0005M\u0001\u0002CA\u000b\u0003\u001b\u0001\r!a\u0006\u0002\u000f\u0011\fG/Y:fiB\"\u0011\u0011DA\u0015!\u0019\tY\"!\t\u0002&5\u0011\u0011Q\u0004\u0006\u0004\u0003?1\u0011aA:rY&!\u00111EA\u000f\u0005\u001d!\u0015\r^1tKR\u0004B!a\n\u0002*1\u0001A\u0001DA\u0016\u0003'\t\t\u0011!A\u0003\u0002\u00055\"aA0%cE!\u0011qFA\u001b!\r\u0001\u0014\u0011G\u0005\u0004\u0003g\t$a\u0002(pi\"Lgn\u001a\t\u0004a\u0005]\u0012bAA\u001dc\t\u0019\u0011I\\=\t\u000f\u0005u\u0002\u0001\"\u0011\u0002@\u0005!1m\u001c9z)\rA\u0012\u0011\t\u0005\t\u0003\u0007\nY\u00041\u0001\u0002F\u0005)Q\r\u001f;sCB!\u0011qIA'\u001b\t\tIEC\u0002\u0002L\u0011\tQ\u0001]1sC6LA!a\u0014\u0002J\tA\u0001+\u0019:b[6\u000b\u0007\u000f\u000b\u0003\u0002<ej\u0005f\u0001\u0001:\u007f\u001d9\u0011q\u000b\u0002\t\u0002\u0005e\u0013\u0001\u0005'j]\u0016\f'OU3he\u0016\u001c8/[8o!\ry\u00111\f\u0004\u0007\u0003\tA\t!!\u0018\u0014\u0011\u0005m\u0013qLA3\u0003W\u00022\u0001MA1\u0013\r\t\u0019'\r\u0002\u0007\u0003:L(+\u001a4\u0011\t\u0001\n9\u0007G\u0005\u0004\u0003S\n#!\u0006#fM\u0006,H\u000e\u001e)be\u0006l7OU3bI\u0006\u0014G.\u001a\t\u0004a\u00055\u0014bAA8c\ta1+\u001a:jC2L'0\u00192mK\"9Q)a\u0017\u0005\u0002\u0005MDCAA-\u0011!\t9(a\u0017\u0005B\u0005e\u0014\u0001\u00027pC\u0012$2\u0001GA>\u0011\u001d\ti(!\u001eA\u00029\nA\u0001]1uQ\"\"\u0011QO\u001d\u0000\u0011)\t\u0019)a\u0017\u0002\u0002\u0013%\u0011QQ\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\bB!\u0011\u0011RAJ\u001b\t\tYI\u0003\u0003\u0002\u000e\u0006=\u0015\u0001\u00027b]\u001eT!!!%\u0002\t)\fg/Y\u0005\u0005\u0003+\u000bYI\u0001\u0004PE*,7\r\u001e\u0015\u0005\u00037Jt\u0010\u000b\u0003\u0002Vez\b")
public class LinearRegression
extends Regressor<Vector, LinearRegression, LinearRegressionModel>
implements LinearRegressionParams,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> solver;
    private final Param<String> weightCol;
    private final BooleanParam standardization;
    private final BooleanParam fitIntercept;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;

    public static MLReader<LinearRegression> read() {
        return LinearRegression$.MODULE$.read();
    }

    public static LinearRegression load(String string) {
        return LinearRegression$.MODULE$.load(string);
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable$class.write(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param x$1) {
        this.solver = x$1;
    }

    @Override
    public final String getSolver() {
        return HasSolver$class.getSolver(this);
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol$class.getWeightCol(this);
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization$class.getStandardization(this);
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept$class.getFitIntercept(this);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam$class.getElasticNetParam(this);
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final double getRegParam() {
        return HasRegParam$class.getRegParam(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public LinearRegression setRegParam(double value) {
        return (LinearRegression)this.set(this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearRegression setFitIntercept(boolean value) {
        return (LinearRegression)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LinearRegression setStandardization(boolean value) {
        return (LinearRegression)this.set(this.standardization(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LinearRegression setElasticNetParam(double value) {
        return (LinearRegression)this.set(this.elasticNetParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearRegression setMaxIter(int value) {
        return (LinearRegression)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public LinearRegression setTol(double value) {
        return (LinearRegression)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearRegression setWeightCol(String value) {
        return (LinearRegression)this.set(this.weightCol(), value);
    }

    public LinearRegression setSolver(String value) {
        return (LinearRegression)this.set(this.solver(), value);
    }

    @Override
    public LinearRegressionModel train(Dataset<?> dataset) {
        Column w2;
        int numFeatures;
        block21: {
            block20: {
                block19: {
                    numFeatures = ((Vector)((Row)dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})).first()).getAs(0)).size();
                    w2 = this.isDefined(this.weightCol()) && !this.$(this.weightCol()).isEmpty() ? functions$.MODULE$.col(this.$(this.weightCol())) : functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0));
                    String string = this.$(this.solver());
                    String string2 = "auto";
                    if (string != null ? !string.equals(string2) : string2 != null) break block19;
                    if (BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) == 0.0 && numFeatures <= WeightedLeastSquares$.MODULE$.MAX_NUM_FEATURES()) break block20;
                }
                String string = this.$(this.solver());
                String string3 = "normal";
                if (string != null ? !string.equals(string3) : string3 != null) break block21;
            }
            Predef$.MODULE$.require(BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) == 0.0, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Only L2 regularization can be used when normal solver is used.'";
                }
            });
            RDD instances = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.labelCol())).cast((DataType)DoubleType$.MODULE$), w2, functions$.MODULE$.col(this.$(this.featuresCol()))})).rdd().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Instance apply(Row x0$1) {
                    Row row = x0$1;
                    Some some = Row$.MODULE$.unapplySeq(row);
                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                        Object label = ((SeqLike)some.get()).apply(0);
                        Object weight = ((SeqLike)some.get()).apply(1);
                        Object features = ((SeqLike)some.get()).apply(2);
                        if (label instanceof Double) {
                            double d = BoxesRunTime.unboxToDouble((Object)label);
                            if (weight instanceof Double) {
                                double d2 = BoxesRunTime.unboxToDouble((Object)weight);
                                if (features instanceof Vector) {
                                    Vector vector = (Vector)features;
                                    Instance instance = new Instance(d, d2, vector);
                                    return instance;
                                }
                            }
                        }
                    }
                    throw new MatchError((Object)row);
                }
            }, ClassTag$.MODULE$.apply(Instance.class));
            WeightedLeastSquares optimizer = new WeightedLeastSquares(BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())), BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization())), true);
            WeightedLeastSquaresModel model = optimizer.fit((RDD<Instance>)instances);
            LinearRegressionModel lrModel = this.copyValues(new LinearRegressionModel(this.uid(), (Vector)model.coefficients(), model.intercept()), this.copyValues$default$2());
            Tuple2<LinearRegressionModel, String> tuple2 = lrModel.findSummaryModelAndPredictionCol();
            if (tuple2 != null) {
                Tuple2 tuple22;
                LinearRegressionModel summaryModel = (LinearRegressionModel)tuple2._1();
                String predictionColName = (String)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)summaryModel, (Object)predictionColName);
                LinearRegressionModel summaryModel2 = (LinearRegressionModel)tuple23._1();
                String predictionColName2 = (String)tuple23._2();
                LinearRegressionTrainingSummary trainingSummary = new LinearRegressionTrainingSummary(summaryModel2.transform(dataset), predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()), summaryModel2, model.diagInvAtWA().toArray(), new double[]{0.0});
                return lrModel.setSummary(trainingSummary);
            }
            throw new MatchError(tuple2);
        }
        RDD instances = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.labelCol())), w2, functions$.MODULE$.col(this.$(this.featuresCol()))})).rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Instance apply(Row x0$2) {
                Row row = x0$2;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                    Object label = ((SeqLike)some.get()).apply(0);
                    Object weight = ((SeqLike)some.get()).apply(1);
                    Object features = ((SeqLike)some.get()).apply(2);
                    if (label instanceof Double) {
                        double d = BoxesRunTime.unboxToDouble((Object)label);
                        if (weight instanceof Double) {
                            double d2 = BoxesRunTime.unboxToDouble((Object)weight);
                            if (features instanceof Vector) {
                                Vector vector = (Vector)features;
                                Instance instance = new Instance(d, d2, vector);
                                return instance;
                            }
                        }
                    }
                }
                throw new MatchError((Object)row);
            }
        }, ClassTag$.MODULE$.apply(Instance.class));
        StorageLevel storageLevel = dataset.rdd().getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
        Object object = handlePersistence ? instances.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
        Tuple2 x$10 = new Tuple2((Object)new MultivariateOnlineSummarizer(), (Object)new MultivariateOnlineSummarizer());
        Serializable seqOp = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<MultivariateOnlineSummarizer, MultivariateOnlineSummarizer> apply(Tuple2<MultivariateOnlineSummarizer, MultivariateOnlineSummarizer> c, Instance instance) {
                return new Tuple2((Object)((MultivariateOnlineSummarizer)c._1()).add(VectorImplicits$.MODULE$.mlVectorToMLlibVector(instance.features()), instance.weight()), (Object)((MultivariateOnlineSummarizer)c._2()).add(VectorImplicits$.MODULE$.mlVectorToMLlibVector(Vectors$.MODULE$.dense(instance.label(), (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]))), instance.weight()));
            }
        };
        Serializable x$11 = seqOp;
        Serializable combOp = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<MultivariateOnlineSummarizer, MultivariateOnlineSummarizer> apply(Tuple2<MultivariateOnlineSummarizer, MultivariateOnlineSummarizer> c1, Tuple2<MultivariateOnlineSummarizer, MultivariateOnlineSummarizer> c2) {
                return new Tuple2((Object)((MultivariateOnlineSummarizer)c1._1()).merge((MultivariateOnlineSummarizer)c2._1()), (Object)((MultivariateOnlineSummarizer)c1._2()).merge((MultivariateOnlineSummarizer)c2._2()));
            }
        };
        Serializable x$12 = combOp;
        int x$13 = instances.treeAggregate$default$4((Object)x$10);
        Tuple2 tuple2 = (Tuple2)instances.treeAggregate((Object)x$10, (Function2)x$11, (Function2)x$12, x$13, ClassTag$.MODULE$.apply(Tuple2.class));
        if (tuple2 != null) {
            LBFGS lBFGS;
            Tuple2 tuple24;
            MultivariateOnlineSummarizer featuresSummarizer = (MultivariateOnlineSummarizer)tuple2._1();
            MultivariateOnlineSummarizer ySummarizer = (MultivariateOnlineSummarizer)tuple2._2();
            Tuple2 tuple25 = tuple24 = new Tuple2((Object)featuresSummarizer, (Object)ySummarizer);
            MultivariateOnlineSummarizer featuresSummarizer2 = (MultivariateOnlineSummarizer)tuple25._1();
            MultivariateOnlineSummarizer ySummarizer2 = (MultivariateOnlineSummarizer)tuple25._2();
            double yMean = ySummarizer2.mean().apply(0);
            double rawYStd = package$.MODULE$.sqrt(ySummarizer2.variance().apply(0));
            if (rawYStd == 0.0) {
                if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) || yMean == 0.0) {
                    if (yMean == 0.0) {
                        this.logWarning((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Mean and standard deviation of the label are zero, so the coefficients "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"and the intercept will all be zero; as a result, training is not needed."})).s((Seq)Nil$.MODULE$)).toString();
                            }
                        });
                    } else {
                        this.logWarning((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The standard deviation of the label is zero, so the coefficients will be "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zeros and the intercept will be the mean of the label; as a result, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"training is not needed."})).s((Seq)Nil$.MODULE$)).toString();
                            }
                        });
                    }
                    Object object2 = handlePersistence ? instances.unpersist(instances.unpersist$default$1()) : BoxedUnit.UNIT;
                    Vector coefficients2 = Vectors$.MODULE$.sparse(numFeatures, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                    double intercept = yMean;
                    LinearRegressionModel model = this.copyValues(new LinearRegressionModel(this.uid(), coefficients2, intercept), this.copyValues$default$2());
                    Tuple2<LinearRegressionModel, String> tuple26 = model.findSummaryModelAndPredictionCol();
                    if (tuple26 != null) {
                        Tuple2 tuple27;
                        LinearRegressionModel summaryModel = (LinearRegressionModel)tuple26._1();
                        String predictionColName = (String)tuple26._2();
                        Tuple2 tuple28 = tuple27 = new Tuple2((Object)summaryModel, (Object)predictionColName);
                        LinearRegressionModel summaryModel3 = (LinearRegressionModel)tuple28._1();
                        String predictionColName3 = (String)tuple28._2();
                        LinearRegressionTrainingSummary trainingSummary = new LinearRegressionTrainingSummary(summaryModel3.transform(dataset), predictionColName3, this.$(this.labelCol()), this.$(this.featuresCol()), model, new double[]{0.0}, new double[]{0.0});
                        return model.setSummary(trainingSummary);
                    }
                    throw new MatchError(tuple26);
                }
                Predef$.MODULE$.require(BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())) == 0.0, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "The standard deviation of the label is zero. Model cannot be regularized.";
                    }
                });
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The standard deviation of the label is zero. "})).s((Seq)Nil$.MODULE$)).append((Object)"Consider setting fitIntercept=true.").toString();
                    }
                });
            }
            double yStd = rawYStd > 0.0 ? rawYStd : package$.MODULE$.abs(yMean);
            double[] featuresMean = featuresSummarizer2.mean().toArray();
            double[] featuresStd = (double[])Predef$.MODULE$.doubleArrayOps(featuresSummarizer2.variance().toArray()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(double x) {
                    return this.apply$mcDD$sp(x);
                }

                public double apply$mcDD$sp(double x) {
                    return package$.MODULE$.sqrt(x);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            if (!BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numFeatures).exists((Function1)new Serializable(this, featuresMean, featuresStd){
                public static final long serialVersionUID = 0L;
                private final double[] featuresMean$1;
                private final double[] featuresStd$1;

                public final boolean apply(int i) {
                    return this.apply$mcZI$sp(i);
                }

                public boolean apply$mcZI$sp(int i) {
                    return this.featuresStd$1[i] == 0.0 && this.featuresMean$1[i] != 0.0;
                }
                {
                    this.featuresMean$1 = featuresMean$1;
                    this.featuresStd$1 = featuresStd$1;
                }
            })) {
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Fitting LinearRegressionModel without intercept on dataset with constant nonzero column, Spark MLlib outputs zero coefficients for constant nonzero columns. This behavior is the same as R glmnet but different from LIBSVM.";
                    }
                });
            }
            double effectiveRegParam = BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())) / yStd;
            double effectiveL1RegParam = BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) * effectiveRegParam;
            double effectiveL2RegParam = (1.0 - BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam()))) * effectiveRegParam;
            LeastSquaresCostFun costFun = new LeastSquaresCostFun((RDD<Instance>)instances, yStd, yMean, BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization())), featuresStd, featuresMean, effectiveL2RegParam);
            if (BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) == 0.0 || effectiveRegParam == 0.0) {
                lBFGS = new LBFGS(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableInnerProductModule)DenseVector$.MODULE$.space((Field)Field.fieldDouble$.MODULE$, ClassTag$.MODULE$.Double()));
            } else {
                boolean standardizationParam = BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization()));
                lBFGS = new OWLQN(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, this.effectiveL1RegFun$1(featuresStd, effectiveL1RegParam, standardizationParam), BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableEnumeratedCoordinateField)DenseVector$.MODULE$.space((Field)Field.fieldDouble$.MODULE$, ClassTag$.MODULE$.Double()));
            }
            LBFGS optimizer = lBFGS;
            Vector initialCoefficients = Vectors$.MODULE$.zeros(numFeatures);
            Iterator states = optimizer.iterations((StochasticDiffFunction)new CachedDiffFunction((DiffFunction)costFun, DenseVector$.MODULE$.canCopyDenseVector(ClassTag$.MODULE$.Double())), (Object)initialCoefficients.asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()));
            ArrayBuilder arrayBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
            ObjectRef state = ObjectRef.create(null);
            while (states.hasNext()) {
                state.elem = (FirstOrderMinimizer.State)states.next();
                arrayBuilder.$plus$eq((Object)BoxesRunTime.boxToDouble((double)((FirstOrderMinimizer.State)state.elem).adjustedValue()));
            }
            if ((FirstOrderMinimizer.State)state.elem == null) {
                String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " failed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{optimizer.getClass().getName()}));
                this.logError((Function0<String>)new Serializable(this, msg){
                    public static final long serialVersionUID = 0L;
                    private final String msg$1;

                    public final String apply() {
                        return this.msg$1;
                    }
                    {
                        this.msg$1 = msg$1;
                    }
                });
                throw new SparkException(msg);
            }
            if (!((FirstOrderMinimizer.State)state.elem).actuallyConverged()) {
                this.logWarning((Function0<String>)new Serializable(this, state){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef state$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"LinearRegression training finished but the result ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is not converged because: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((FirstOrderMinimizer.ConvergenceReason)((FirstOrderMinimizer.State)this.state$1.elem).convergedReason().get()).reason()}))).toString();
                    }
                    {
                        this.state$1 = state$1;
                    }
                });
            }
            double[] rawCoefficients = (double[])((DenseVector)((FirstOrderMinimizer.State)state.elem).x()).toArray$mcD$sp(ClassTag$.MODULE$.Double()).clone();
            int len = rawCoefficients.length;
            for (int i = 0; i < len; ++i) {
                int n = i;
                rawCoefficients[n] = rawCoefficients[n] * (featuresStd[i] != 0.0 ? yStd / featuresStd[i] : 0.0);
            }
            Tuple2 tuple29 = new Tuple2((Object)Vectors$.MODULE$.dense(rawCoefficients).compressed(), arrayBuilder.result());
            if (tuple29 != null) {
                Tuple2 tuple210;
                Vector coefficients3 = (Vector)tuple29._1();
                double[] objectiveHistory = (double[])tuple29._2();
                Tuple2 tuple211 = tuple210 = new Tuple2((Object)coefficients3, (Object)objectiveHistory);
                Vector coefficients4 = (Vector)tuple211._1();
                double[] objectiveHistory2 = (double[])tuple211._2();
                double intercept = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) ? yMean - BLAS$.MODULE$.dot(coefficients4, Vectors$.MODULE$.dense(featuresMean)) : 0.0;
                Object object3 = handlePersistence ? instances.unpersist(instances.unpersist$default$1()) : BoxedUnit.UNIT;
                LinearRegressionModel model = this.copyValues(new LinearRegressionModel(this.uid(), coefficients4, intercept), this.copyValues$default$2());
                Tuple2<LinearRegressionModel, String> tuple212 = model.findSummaryModelAndPredictionCol();
                if (tuple212 != null) {
                    Tuple2 tuple213;
                    LinearRegressionModel summaryModel = (LinearRegressionModel)tuple212._1();
                    String predictionColName = (String)tuple212._2();
                    Tuple2 tuple214 = tuple213 = new Tuple2((Object)summaryModel, (Object)predictionColName);
                    LinearRegressionModel summaryModel4 = (LinearRegressionModel)tuple214._1();
                    String predictionColName4 = (String)tuple214._2();
                    LinearRegressionTrainingSummary trainingSummary = new LinearRegressionTrainingSummary(summaryModel4.transform(dataset), predictionColName4, this.$(this.labelCol()), this.$(this.featuresCol()), model, new double[]{0.0}, objectiveHistory2);
                    return model.setSummary(trainingSummary);
                }
                throw new MatchError(tuple212);
            }
            throw new MatchError((Object)tuple29);
        }
        throw new MatchError((Object)tuple2);
    }

    @Override
    public LinearRegression copy(ParamMap extra) {
        return (LinearRegression)this.defaultCopy(extra);
    }

    private final Function1 effectiveL1RegFun$1(double[] featuresStd$1, double effectiveL1RegParam$1, boolean standardizationParam$1) {
        return new Serializable(this, featuresStd$1, effectiveL1RegParam$1, standardizationParam$1){
            public static final long serialVersionUID = 0L;
            private final double[] featuresStd$1;
            private final double effectiveL1RegParam$1;
            private final boolean standardizationParam$1;

            public final double apply(int index2) {
                return this.apply$mcDI$sp(index2);
            }

            public double apply$mcDI$sp(int index2) {
                return this.standardizationParam$1 ? this.effectiveL1RegParam$1 : (this.featuresStd$1[index2] != 0.0 ? this.effectiveL1RegParam$1 / this.featuresStd$1[index2] : 0.0);
            }
            {
                this.featuresStd$1 = featuresStd$1;
                this.effectiveL1RegParam$1 = effectiveL1RegParam$1;
                this.standardizationParam$1 = standardizationParam$1;
            }
        };
    }

    public LinearRegression(String uid) {
        this.uid = uid;
        HasRegParam$class.$init$(this);
        HasElasticNetParam$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasTol$class.$init$(this);
        HasFitIntercept$class.$init$(this);
        HasStandardization$class.$init$(this);
        HasWeightCol$class.$init$(this);
        HasSolver$class.$init$(this);
        MLWritable$class.$init$(this);
        DefaultParamsWritable$class.$init$(this);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.regParam().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.fitIntercept().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.standardization().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.elasticNetParam().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.maxIter().$minus$greater(BoxesRunTime.boxToInteger((int)100))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.tol().$minus$greater(BoxesRunTime.boxToDouble((double)1.0E-6))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.solver().$minus$greater("auto")}));
    }

    public LinearRegression() {
        this(Identifiable$.MODULE$.randomUID("linReg"));
    }
}

