/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.fpm;

import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.fpm.LocalPrefixSpan;
import org.apache.spark.mllib.fpm.PrefixSpan;
import org.apache.spark.mllib.fpm.PrefixSpan$Postfix$;
import org.apache.spark.mllib.fpm.PrefixSpan$Prefix$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class PrefixSpan$
implements Logging,
Serializable {
    public static final PrefixSpan$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new PrefixSpan$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public RDD<Tuple2<int[], Object>> genFreqPatterns(RDD<int[]> data, long minCount, int maxPatternLength, long maxLocalProjDBSize) {
        SparkContext sc = data.sparkContext();
        StorageLevel storageLevel = data.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
            this.logWarning((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Input data is not cached.";
                }
            });
        }
        RDD postfixes = data.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final PrefixSpan.Postfix apply(int[] items) {
                return new PrefixSpan.Postfix(items, PrefixSpan$Postfix$.MODULE$.$lessinit$greater$default$2(), PrefixSpan$Postfix$.MODULE$.$lessinit$greater$default$3());
            }
        }, ClassTag$.MODULE$.apply(PrefixSpan.Postfix.class));
        ArrayBuffer localFreqPatterns = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        Map smallPrefixes = Map$.MODULE$.empty();
        PrefixSpan.Prefix emptyPrefix = PrefixSpan$Prefix$.MODULE$.empty();
        ObjectRef largePrefixes = ObjectRef.create((Object)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)emptyPrefix.id())), (Object)emptyPrefix)}))));
        while (((Map)largePrefixes.elem).nonEmpty()) {
            int numLocalFreqPatterns = localFreqPatterns.length();
            this.logInfo((Function0<String>)new Serializable(numLocalFreqPatterns){
                public static final long serialVersionUID = 0L;
                private final int numLocalFreqPatterns$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"number of local frequent patterns: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numLocalFreqPatterns$1)}));
                }
                {
                    this.numLocalFreqPatterns$1 = numLocalFreqPatterns$1;
                }
            });
            if (numLocalFreqPatterns > 1000000) {
                this.logWarning((Function0<String>)new Serializable(numLocalFreqPatterns){
                    public static final long serialVersionUID = 0L;
                    private final int numLocalFreqPatterns$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             | Collected ", " local frequent patterns. You may want to consider:\n             |   1. increase minSupport,\n             |   2. decrease maxPatternLength,\n             |   3. increase maxLocalProjDBSize.\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numLocalFreqPatterns$1)})))).stripMargin();
                    }
                    {
                        this.numLocalFreqPatterns$1 = numLocalFreqPatterns$1;
                    }
                });
            }
            this.logInfo((Function0<String>)new Serializable(smallPrefixes){
                public static final long serialVersionUID = 0L;
                private final Map smallPrefixes$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"number of small prefixes: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.smallPrefixes$1.size())}));
                }
                {
                    this.smallPrefixes$1 = smallPrefixes$1;
                }
            });
            this.logInfo((Function0<String>)new Serializable(largePrefixes){
                public static final long serialVersionUID = 0L;
                private final ObjectRef largePrefixes$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"number of large prefixes: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((Map)this.largePrefixes$1.elem).size())}));
                }
                {
                    this.largePrefixes$1 = largePrefixes$1;
                }
            });
            PrefixSpan.Prefix[] largePrefixArray = (PrefixSpan.Prefix[])((Map)largePrefixes.elem).values().toArray(ClassTag$.MODULE$.apply(PrefixSpan.Prefix.class));
            Tuple2[] freqPrefixes = (Tuple2[])RDD$.MODULE$.rddToPairRDDFunctions(postfixes.flatMap((Function1)new Serializable(largePrefixArray){
                public static final long serialVersionUID = 0L;
                private final PrefixSpan.Prefix[] largePrefixArray$1;

                public final ArrayOps<Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>>> apply(PrefixSpan.Postfix postfix) {
                    return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.largePrefixArray$1).flatMap((Function1)new Serializable(this, postfix){
                        public static final long serialVersionUID = 0L;
                        private final PrefixSpan.Postfix postfix$1;

                        public final Iterator<Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>>> apply(PrefixSpan.Prefix prefix) {
                            return this.postfix$1.project(prefix).genPrefixItems().map((Function1)new Serializable(this, prefix){
                                public static final long serialVersionUID = 0L;
                                private final PrefixSpan.Prefix prefix$2;

                                public final Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>> apply(Tuple2<Object, Object> x0$3) {
                                    Tuple2<Object, Object> tuple2 = x0$3;
                                    if (tuple2 != null) {
                                        int item = tuple2._1$mcI$sp();
                                        long postfixSize = tuple2._2$mcJ$sp();
                                        Tuple2 tuple22 = new Tuple2((Object)new Tuple2.mcII.sp(this.prefix$2.id(), item), (Object)new Tuple2.mcJJ.sp(1L, postfixSize));
                                        return tuple22;
                                    }
                                    throw new MatchError(tuple2);
                                }
                                {
                                    this.prefix$2 = prefix$2;
                                }
                            });
                        }
                        {
                            this.postfix$1 = postfix$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))));
                }
                {
                    this.largePrefixArray$1 = largePrefixArray$1;
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Tuple2.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).reduceByKey((Function2)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x0$4, Tuple2<Object, Object> x1$1) {
                    Tuple2 tuple2 = new Tuple2(x0$4, x1$1);
                    if (tuple2 != null) {
                        Tuple2 tuple22 = (Tuple2)tuple2._1();
                        Tuple2 tuple23 = (Tuple2)tuple2._2();
                        if (tuple22 != null) {
                            long c0 = tuple22._1$mcJ$sp();
                            long s0 = tuple22._2$mcJ$sp();
                            if (tuple23 != null) {
                                long c1 = tuple23._1$mcJ$sp();
                                long s1 = tuple23._2$mcJ$sp();
                                Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(c0 + c1, s0 + s1);
                                return sp2;
                            }
                        }
                    }
                    throw new MatchError((Object)tuple2);
                }
            }).filter((Function1)new Serializable(minCount){
                public static final long serialVersionUID = 0L;
                private final long minCount$2;

                public final boolean apply(Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>> x0$5) {
                    Tuple2 tuple2;
                    Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>> tuple22 = x0$5;
                    if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                        long c = tuple2._1$mcJ$sp();
                        boolean bl = c >= this.minCount$2;
                        return bl;
                    }
                    throw new MatchError(tuple22);
                }
                {
                    this.minCount$2 = minCount$2;
                }
            }).collect();
            Map newLargePrefixes = Map$.MODULE$.empty();
            Predef$.MODULE$.refArrayOps((Object[])freqPrefixes).foreach((Function1)new Serializable(maxPatternLength, maxLocalProjDBSize, localFreqPatterns, smallPrefixes, largePrefixes, newLargePrefixes){
                public static final long serialVersionUID = 0L;
                private final int maxPatternLength$2;
                private final long maxLocalProjDBSize$2;
                private final ArrayBuffer localFreqPatterns$1;
                private final Map smallPrefixes$1;
                private final ObjectRef largePrefixes$1;
                private final Map newLargePrefixes$1;

                public final Object apply(Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>> x0$6) {
                    Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>> tuple2 = x0$6;
                    if (tuple2 != null) {
                        Tuple2 tuple22 = (Tuple2)tuple2._1();
                        Tuple2 tuple23 = (Tuple2)tuple2._2();
                        if (tuple22 != null) {
                            int id = tuple22._1$mcI$sp();
                            int item = tuple22._2$mcI$sp();
                            if (tuple23 != null) {
                                long count = tuple23._1$mcJ$sp();
                                long projDBSize = tuple23._2$mcJ$sp();
                                PrefixSpan.Prefix newPrefix = ((PrefixSpan.Prefix)((Map)this.largePrefixes$1.elem).apply((Object)BoxesRunTime.boxToInteger((int)id))).$colon$plus(item);
                                this.localFreqPatterns$1.$plus$eq((Object)new Tuple2(Predef$.MODULE$.intArrayOps(newPrefix.items()).$colon$plus((Object)BoxesRunTime.boxToInteger((int)0), ClassTag$.MODULE$.Int()), (Object)BoxesRunTime.boxToLong((long)count)));
                                BoxedUnit boxedUnit = newPrefix.length() < this.maxPatternLength$2 ? (projDBSize > this.maxLocalProjDBSize$2 ? this.newLargePrefixes$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)newPrefix.id())), (Object)newPrefix)) : this.smallPrefixes$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)newPrefix.id())), (Object)newPrefix))) : BoxedUnit.UNIT;
                                return boxedUnit;
                            }
                        }
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.maxPatternLength$2 = maxPatternLength$2;
                    this.maxLocalProjDBSize$2 = maxLocalProjDBSize$2;
                    this.localFreqPatterns$1 = localFreqPatterns$1;
                    this.smallPrefixes$1 = smallPrefixes$1;
                    this.largePrefixes$1 = largePrefixes$1;
                    this.newLargePrefixes$1 = newLargePrefixes$1;
                }
            });
            largePrefixes.elem = newLargePrefixes;
        }
        RDD freqPatterns = sc.parallelize((Seq)localFreqPatterns, 1, ClassTag$.MODULE$.apply(Tuple2.class));
        int numSmallPrefixes = smallPrefixes.size();
        this.logInfo((Function0<String>)new Serializable(numSmallPrefixes){
            public static final long serialVersionUID = 0L;
            private final int numSmallPrefixes$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"number of small prefixes for local processing: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numSmallPrefixes$1)}));
            }
            {
                this.numSmallPrefixes$1 = numSmallPrefixes$1;
            }
        });
        if (numSmallPrefixes > 0) {
            Broadcast bcSmallPrefixes = sc.broadcast((Object)smallPrefixes, ClassTag$.MODULE$.apply(Map.class));
            RDD distributedFreqPattern = RDD$.MODULE$.rddToPairRDDFunctions(postfixes.flatMap((Function1)new Serializable(bcSmallPrefixes){
                public static final long serialVersionUID = 0L;
                private final Broadcast bcSmallPrefixes$1;

                public final Iterable<Tuple2<Object, PrefixSpan.Postfix>> apply(PrefixSpan.Postfix postfix) {
                    return (Iterable)((TraversableLike)((MapLike)this.bcSmallPrefixes$1.value()).values().map((Function1)new Serializable(this, postfix){
                        public static final long serialVersionUID = 0L;
                        private final PrefixSpan.Postfix postfix$2;

                        public final Tuple2<Object, PrefixSpan.Postfix> apply(PrefixSpan.Prefix prefix) {
                            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)prefix.id()), (Object)this.postfix$2.project(prefix).compressed());
                        }
                        {
                            this.postfix$2 = postfix$2;
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<Object, PrefixSpan.Postfix> x$9) {
                            return ((PrefixSpan.Postfix)x$9._2()).nonEmpty();
                        }
                    });
                }
                {
                    this.bcSmallPrefixes$1 = bcSmallPrefixes$1;
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(PrefixSpan.Postfix.class), (Ordering)Ordering.Int$.MODULE$).groupByKey().flatMap((Function1)new Serializable(minCount, maxPatternLength, bcSmallPrefixes){
                public static final long serialVersionUID = 0L;
                private final long minCount$2;
                private final int maxPatternLength$2;
                private final Broadcast bcSmallPrefixes$1;

                public final Iterator<Tuple2<int[], Object>> apply(Tuple2<Object, Iterable<PrefixSpan.Postfix>> x0$7) {
                    Tuple2<Object, Iterable<PrefixSpan.Postfix>> tuple2 = x0$7;
                    if (tuple2 != null) {
                        int id = tuple2._1$mcI$sp();
                        Iterable projPostfixes = (Iterable)tuple2._2();
                        PrefixSpan.Prefix prefix = (PrefixSpan.Prefix)((MapLike)this.bcSmallPrefixes$1.value()).apply((Object)BoxesRunTime.boxToInteger((int)id));
                        LocalPrefixSpan localPrefixSpan = new LocalPrefixSpan(this.minCount$2, this.maxPatternLength$2 - prefix.length());
                        Iterator iterator = localPrefixSpan.run((PrefixSpan.Postfix[])projPostfixes.toArray(ClassTag$.MODULE$.apply(PrefixSpan.Postfix.class))).map((Function1)new Serializable(this, prefix){
                            public static final long serialVersionUID = 0L;
                            private final PrefixSpan.Prefix prefix$1;

                            public final Tuple2<int[], Object> apply(Tuple2<int[], Object> x0$8) {
                                Tuple2<int[], Object> tuple2 = x0$8;
                                if (tuple2 != null) {
                                    int[] pattern = (int[])tuple2._1();
                                    long count = tuple2._2$mcJ$sp();
                                    Tuple2 tuple22 = new Tuple2(Predef$.MODULE$.intArrayOps(this.prefix$1.items()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.intArrayOps(pattern), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), (Object)BoxesRunTime.boxToLong((long)count));
                                    return tuple22;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.prefix$1 = prefix$1;
                            }
                        });
                        return iterator;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.minCount$2 = minCount$2;
                    this.maxPatternLength$2 = maxPatternLength$2;
                    this.bcSmallPrefixes$1 = bcSmallPrefixes$1;
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            freqPatterns = freqPatterns.$plus$plus(distributedFreqPattern);
        }
        return freqPatterns;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private PrefixSpan$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

