/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.repl;

import java.io.File;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.repl.Signaling$;
import org.apache.spark.repl.SparkILoop;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.runtime.BoxedUnit;
import scala.tools.nsc.GenericRunnerSettings;
import scala.tools.nsc.Settings;

public final class Main$
implements Logging {
    public static final Main$ MODULE$;
    private final SparkConf conf;
    private final String rootDir;
    private final File outputDir;
    private SparkContext sparkContext;
    private SparkSession sparkSession;
    private SparkILoop interp;
    private boolean hasErrors;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new Main$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public SparkConf conf() {
        return this.conf;
    }

    public String rootDir() {
        return this.rootDir;
    }

    public File outputDir() {
        return this.outputDir;
    }

    public SparkContext sparkContext() {
        return this.sparkContext;
    }

    public void sparkContext_$eq(SparkContext x$1) {
        this.sparkContext = x$1;
    }

    public SparkSession sparkSession() {
        return this.sparkSession;
    }

    public void sparkSession_$eq(SparkSession x$1) {
        this.sparkSession = x$1;
    }

    public SparkILoop interp() {
        return this.interp;
    }

    public void interp_$eq(SparkILoop x$1) {
        this.interp = x$1;
    }

    private boolean hasErrors() {
        return this.hasErrors;
    }

    private void hasErrors_$eq(boolean x$1) {
        this.hasErrors = x$1;
    }

    public void org$apache$spark$repl$Main$$scalaOptionError(String msg) {
        this.hasErrors_$eq(true);
        Console$.MODULE$.err().println(msg);
    }

    public void main(String[] args) {
        this.doMain(args, new SparkILoop());
    }

    public void doMain(String[] args, SparkILoop _interp) {
        this.interp_$eq(_interp);
        String jars = Utils$.MODULE$.getUserJars(this.conf(), true).mkString(File.pathSeparator);
        List interpArguments = (List)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-Yrepl-class-based", "-Yrepl-outdir", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.outputDir().getAbsolutePath()})), "-classpath", jars})).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])args).toList(), List$.MODULE$.canBuildFrom());
        GenericRunnerSettings settings = new GenericRunnerSettings((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(String msg) {
                Main$.MODULE$.org$apache$spark$repl$Main$$scalaOptionError(msg);
            }
        });
        settings.processArguments(interpArguments, true);
        if (!this.hasErrors()) {
            this.interp().process((Settings)settings);
            Option$.MODULE$.apply((Object)this.sparkContext()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(SparkContext x$1) {
                    x$1.stop();
                }
            });
        }
    }

    public SparkSession createSparkSession() {
        String execUri = System.getenv("SPARK_EXECUTOR_URI");
        this.conf().setIfMissing("spark.app.name", "Spark shell");
        this.conf().set("spark.repl.class.outputDir", this.outputDir().getAbsolutePath());
        Object object = execUri == null ? BoxedUnit.UNIT : this.conf().set("spark.executor.uri", execUri);
        Object object2 = System.getenv("SPARK_HOME") == null ? BoxedUnit.UNIT : this.conf().setSparkHome(System.getenv("SPARK_HOME"));
        SparkSession.Builder builder = SparkSession$.MODULE$.builder().config(this.conf());
        String string = this.conf().get(package$.MODULE$.CATALOG_IMPLEMENTATION().key(), "hive").toLowerCase();
        String string2 = "hive";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            if (SparkSession$.MODULE$.hiveClassesArePresent()) {
                this.sparkSession_$eq(builder.enableHiveSupport().getOrCreate());
                this.logInfo((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Created Spark session with Hive support";
                    }
                });
            } else {
                builder.config(package$.MODULE$.CATALOG_IMPLEMENTATION().key(), "in-memory");
                this.sparkSession_$eq(builder.getOrCreate());
                this.logInfo((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Created Spark session";
                    }
                });
            }
        } else {
            this.sparkSession_$eq(builder.getOrCreate());
            this.logInfo((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Created Spark session";
                }
            });
        }
        this.sparkContext_$eq(this.sparkSession().sparkContext());
        Signaling$.MODULE$.cancelOnInterrupt(this.sparkContext());
        return this.sparkSession();
    }

    private Main$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.initializeLogIfNecessary(true);
        this.conf = new SparkConf();
        this.rootDir = (String)this.conf().getOption("spark.repl.classdir").getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return Utils$.MODULE$.getLocalDir(Main$.MODULE$.conf());
            }
        });
        this.outputDir = Utils$.MODULE$.createTempDir(this.rootDir(), "repl");
        this.hasErrors = false;
    }
}

