/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.logging;

import java.util.logging.Level;

public interface SimplifiedLog {
    public static final SimplifiedLog EMPTY = new SimplifiedLog(){

        @Override
        public boolean isEnabledLevel(Level level) {
            return false;
        }

        @Override
        public void log(Level level, Object message, Throwable t) {
        }

        public String toString() {
            return "EMPTY";
        }
    };

    default public boolean isErrorEnabled() {
        return this.isEnabledLevel(Level.SEVERE);
    }

    default public void error(String msg) {
        this.error(msg, null);
    }

    default public void error(String msg, Throwable err) {
        this.log(Level.SEVERE, msg, err);
    }

    default public boolean isWarnEnabled() {
        return this.isEnabledLevel(Level.WARNING);
    }

    default public void warn(String msg) {
        this.warn(msg, null);
    }

    default public void warn(String msg, Throwable err) {
        this.log(Level.WARNING, msg, err);
    }

    default public boolean isInfoEnabled() {
        return this.isEnabledLevel(Level.INFO);
    }

    default public void info(String msg) {
        this.info(msg, null);
    }

    default public void info(String msg, Throwable err) {
        this.log(Level.INFO, msg, err);
    }

    default public boolean isDebugEnabled() {
        return this.isEnabledLevel(Level.FINE);
    }

    default public void debug(String msg) {
        this.debug(msg, null);
    }

    default public void debug(String msg, Throwable err) {
        this.log(Level.FINE, msg, err);
    }

    default public boolean isTraceEnabled() {
        return this.isEnabledLevel(Level.FINER);
    }

    default public void trace(String msg) {
        this.trace(msg, null);
    }

    default public void trace(String msg, Throwable err) {
        this.log(Level.FINER, msg, err);
    }

    public boolean isEnabledLevel(Level var1);

    default public void log(Level level, Object message) {
        this.log(level, message, null);
    }

    public void log(Level var1, Object var2, Throwable var3);

    public static boolean isErrorEnabled(Level level) {
        return SimplifiedLog.isLoggable(level, Level.SEVERE);
    }

    public static boolean isWarnEnabled(Level level) {
        return SimplifiedLog.isLoggable(level, Level.WARNING);
    }

    public static boolean isInfoEnabled(Level level) {
        return SimplifiedLog.isLoggable(level, Level.INFO);
    }

    public static boolean isDebugEnabled(Level level) {
        return SimplifiedLog.isLoggable(level, Level.FINE);
    }

    public static boolean isTraceEnabled(Level level) {
        return SimplifiedLog.isLoggable(level, Level.FINER);
    }

    public static boolean isLoggable(Level level, Level threshold) {
        if (level == null || threshold == null) {
            return false;
        }
        if (Level.OFF.equals(level) || Level.OFF.equals(threshold)) {
            return false;
        }
        if (Level.ALL.equals(threshold)) {
            return true;
        }
        return level.intValue() >= threshold.intValue();
    }
}

