/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.sftp.client.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Objects;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.io.output.OutputStreamWithChannel;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpClientHolder;
import org.apache.sshd.sftp.client.impl.AbstractSftpClient;
import org.apache.sshd.sftp.client.impl.SftpAckData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpOutputStreamAsync
extends OutputStreamWithChannel
implements SftpClientHolder {
    protected final Logger log;
    protected final byte[] bb = new byte[1];
    protected final int bufferSize;
    protected Buffer buffer;
    protected SftpClient.CloseableHandle handle;
    protected long offset;
    protected final Deque<SftpAckData> pendingWrites = new LinkedList<SftpAckData>();
    private final AbstractSftpClient clientInstance;
    private final String path;

    public SftpOutputStreamAsync(AbstractSftpClient client, int bufferSize, String path, Collection<SftpClient.OpenMode> mode) throws IOException {
        this.log = LoggerFactory.getLogger(this.getClass());
        this.clientInstance = Objects.requireNonNull(client, "No SFTP client instance");
        this.path = path;
        this.handle = client.open(path, mode);
        this.bufferSize = bufferSize;
    }

    public SftpOutputStreamAsync(AbstractSftpClient client, int bufferSize, String path, SftpClient.CloseableHandle handle) throws IOException {
        this.log = LoggerFactory.getLogger(this.getClass());
        this.clientInstance = Objects.requireNonNull(client, "No SFTP client instance");
        this.path = path;
        this.handle = handle;
        this.bufferSize = bufferSize;
    }

    @Override
    public final AbstractSftpClient getClient() {
        return this.clientInstance;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public final String getPath() {
        return this.path;
    }

    public boolean isOpen() {
        return this.handle != null && this.handle.isOpen();
    }

    public void write(int b) throws IOException {
        this.bb[0] = (byte)b;
        this.write(this.bb, 0, 1);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        byte[] id = this.handle.getIdentifier();
        AbstractSftpClient client = this.getClient();
        ClientSession session = client.getSession();
        boolean traceEnabled = this.log.isTraceEnabled();
        int writtenCount = 0;
        int totalLen = len;
        do {
            if (this.buffer == null) {
                if (traceEnabled) {
                    this.log.trace("write({}) allocate buffer size={} after {}/{} bytes", new Object[]{this, this.bufferSize, writtenCount, totalLen});
                }
                this.buffer = session.createBuffer((byte)94, this.bufferSize);
                int hdr = 33 + id.length + this.buffer.wpos();
                this.buffer.rpos(hdr);
                this.buffer.wpos(hdr);
            }
            int max = this.bufferSize - (25 + id.length + 72);
            int nb = Math.min(len, Math.max(0, max - this.buffer.available()));
            this.buffer.putRawBytes(b, off, nb);
            off += nb;
            len -= nb;
            writtenCount += nb;
            if (this.buffer.available() < max) continue;
            if (traceEnabled) {
                this.log.trace("write({}) flush after {}/{} bytes", new Object[]{this, writtenCount, totalLen});
            }
            this.flush();
        } while (len > 0);
    }

    public void flush() throws IOException {
        ByteArrayBuffer buf;
        if (!this.isOpen()) {
            throw new IOException("flush(" + this.getPath() + ") stream is closed");
        }
        boolean debugEnabled = this.log.isDebugEnabled();
        AbstractSftpClient client = this.getClient();
        int ackIndex = 0;
        while (true) {
            Buffer response;
            SftpAckData ack;
            if ((ack = this.pendingWrites.peek()) == null) {
                if (!debugEnabled) break;
                this.log.debug("flush({}) processed {} pending writes", (Object)this, (Object)ackIndex);
                break;
            }
            ++ackIndex;
            if (debugEnabled) {
                this.log.debug("flush({}) waiting for ack #{}: {}", new Object[]{this, ackIndex, ack});
            }
            if ((response = client.receive(ack.id, 0L)) == null) {
                if (!debugEnabled) break;
                this.log.debug("flush({}) no response for ack #{}: {}", new Object[]{this, ackIndex, ack});
                break;
            }
            if (debugEnabled) {
                this.log.debug("flush({}) processing ack #{}: {}", new Object[]{this, ackIndex, ack});
            }
            ack = this.pendingWrites.removeFirst();
            client.checkResponseStatus(6, response);
        }
        if (this.buffer == null) {
            if (debugEnabled) {
                this.log.debug("flush({}) no pending buffer to flush", (Object)this);
            }
            return;
        }
        byte[] id = this.handle.getIdentifier();
        int avail = this.buffer.available();
        if (this.buffer.rpos() >= 16 + id.length) {
            int wpos = this.buffer.wpos();
            this.buffer.rpos(this.buffer.rpos() - 16 - id.length);
            this.buffer.wpos(this.buffer.rpos());
            this.buffer.putBytes(id);
            this.buffer.putLong(this.offset);
            this.buffer.putUInt((long)avail);
            this.buffer.wpos(wpos);
            buf = this.buffer;
        } else {
            buf = new ByteArrayBuffer(id.length + avail + 64, false);
            buf.putBytes(id);
            buf.putLong(this.offset);
            buf.putBytes(this.buffer.array(), this.buffer.rpos(), avail);
        }
        int reqId = client.send(6, (Buffer)buf);
        SftpAckData ack = new SftpAckData(reqId, this.offset, avail);
        if (debugEnabled) {
            this.log.debug("flush({}) enqueue pending ack={}", (Object)this, (Object)ack);
        }
        this.pendingWrites.add(ack);
        this.offset += (long)avail;
        this.buffer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.isOpen()) {
            return;
        }
        try {
            boolean debugEnabled = this.log.isDebugEnabled();
            try {
                int pendingSize;
                int n = pendingSize = this.buffer == null ? 0 : this.buffer.available();
                if (pendingSize > 0) {
                    if (debugEnabled) {
                        this.log.debug("close({}) flushing {} pending bytes", (Object)this, (Object)pendingSize);
                    }
                    this.flush();
                }
                AbstractSftpClient client = this.getClient();
                int ackIndex = 1;
                while (!this.pendingWrites.isEmpty()) {
                    SftpAckData ack = this.pendingWrites.removeFirst();
                    if (debugEnabled) {
                        this.log.debug("close({}) processing ack #{}: {}", new Object[]{this, ackIndex, ack});
                    }
                    Buffer response = client.receive(ack.id);
                    if (debugEnabled) {
                        this.log.debug("close({}) processing ack #{} response for {}", new Object[]{this, ackIndex, ack});
                    }
                    client.checkResponseStatus(6, response);
                    ++ackIndex;
                }
            }
            finally {
                if (debugEnabled) {
                    this.log.debug("close({}) closing file handle", (Object)this);
                }
                this.handle.close();
            }
        }
        finally {
            this.handle = null;
        }
    }

    public String toString() {
        AbstractSftpClient client = this.getClient();
        return this.getClass().getSimpleName() + "[" + client.getSession() + "][" + this.getPath() + "]";
    }
}

