/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo;

import com.google.common.base.Objects;
import org.apache.tajo.QueryIdFactory;
import org.apache.tajo.TajoIdProtos;

public class QueryId
implements Comparable<QueryId> {
    public static final String SEPARATOR = "_";
    public static final String QUERY_ID_PREFIX = "q";
    private String id;
    private int seq;

    public QueryId(String id, int seq) {
        this.id = id;
        this.seq = seq;
    }

    public QueryId(TajoIdProtos.QueryIdProto queryId) {
        this(queryId.getId(), queryId.getSeq());
    }

    public String getId() {
        return this.id;
    }

    public int getSeq() {
        return this.seq;
    }

    public boolean isNull() {
        return this.equals(QueryIdFactory.NULL_QUERY_ID);
    }

    public String toString() {
        return "q_" + this.toStringNoPrefix();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QueryId)) {
            return false;
        }
        return this.compareTo((QueryId)obj) == 0;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.seq});
    }

    @Override
    public int compareTo(QueryId queryId) {
        int result = this.id.compareTo(queryId.id);
        if (result == 0) {
            return this.seq - queryId.seq;
        }
        return result;
    }

    public TajoIdProtos.QueryIdProto getProto() {
        return TajoIdProtos.QueryIdProto.newBuilder().setId(this.id).setSeq(this.seq).build();
    }

    public String toStringNoPrefix() {
        return this.id + SEPARATOR + QueryIdFactory.ID_FORMAT.format(this.seq);
    }
}

