/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.datum;

import com.google.common.primitives.Ints;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.DatumFactory;
import org.apache.tajo.datum.Int4Datum;
import org.apache.tajo.datum.IntervalDatum;
import org.apache.tajo.datum.NullDatum;
import org.apache.tajo.datum.TextDatum;
import org.apache.tajo.datum.TimestampDatum;
import org.apache.tajo.exception.InvalidOperationException;
import org.apache.tajo.exception.InvalidValueForCastException;
import org.apache.tajo.exception.TajoRuntimeException;
import org.apache.tajo.util.Bytes;
import org.apache.tajo.util.datetime.DateTimeConstants;
import org.apache.tajo.util.datetime.DateTimeFormat;
import org.apache.tajo.util.datetime.DateTimeUtil;
import org.apache.tajo.util.datetime.TimeMeta;

public class DateDatum
extends Datum {
    public static final int SIZE = 4;
    private int jdate;

    public DateDatum(int value) {
        super(TajoDataTypes.Type.DATE);
        this.jdate = value;
    }

    public DateDatum(TimeMeta tm) {
        super(TajoDataTypes.Type.DATE);
        this.jdate = DateTimeUtil.date2j(tm.years, tm.monthOfYear, tm.dayOfMonth);
    }

    @Override
    public TimeMeta asTimeMeta() {
        TimeMeta tm = new TimeMeta();
        DateTimeUtil.j2date(this.jdate, tm);
        return tm;
    }

    @Override
    public byte[] asTextBytes() {
        return this.asChars().getBytes(TextDatum.DEFAULT_CHARSET);
    }

    public int getCenturyOfEra() {
        return this.asTimeMeta().getCenturyOfEra();
    }

    public int getYear() {
        return this.asTimeMeta().years;
    }

    public int getWeekyear() {
        return this.asTimeMeta().getWeekyear();
    }

    public int getMonthOfYear() {
        return this.asTimeMeta().monthOfYear;
    }

    public int getDayOfYear() {
        return this.asTimeMeta().getDayOfYear();
    }

    public int getDayOfWeek() {
        return this.asTimeMeta().getDayOfWeek();
    }

    public int getISODayOfWeek() {
        return this.asTimeMeta().getISODayOfWeek();
    }

    public int getWeekOfYear() {
        return this.asTimeMeta().getWeekOfYear();
    }

    public int getDayOfMonth() {
        return this.asTimeMeta().dayOfMonth;
    }

    @Override
    public String toString() {
        return this.asChars();
    }

    @Override
    public Datum plus(Datum datum) {
        switch (datum.type()) {
            case INT2: 
            case INT4: 
            case INT8: 
            case FLOAT4: 
            case FLOAT8: {
                TimeMeta tm = this.asTimeMeta();
                tm.plusDays(datum.asInt4());
                return new DateDatum(tm);
            }
            case INTERVAL: {
                IntervalDatum interval = (IntervalDatum)datum;
                TimeMeta tm = this.asTimeMeta();
                tm.plusInterval(interval.months, interval.milliseconds);
                return new TimestampDatum(DateTimeUtil.toJulianTimestamp(tm));
            }
            case TIME: {
                TimeMeta tm1 = this.asTimeMeta();
                TimeMeta tm2 = datum.asTimeMeta();
                tm1.plusTime(DateTimeUtil.toTime(tm2));
                return new TimestampDatum(DateTimeUtil.toJulianTimestamp(tm1));
            }
        }
        throw new InvalidOperationException(datum.type());
    }

    @Override
    public Datum minus(Datum datum) {
        switch (datum.type()) {
            case INT2: 
            case INT4: 
            case INT8: 
            case FLOAT4: 
            case FLOAT8: {
                TimeMeta tm = this.asTimeMeta();
                tm.plusDays(0 - datum.asInt4());
                return new DateDatum(tm);
            }
            case INTERVAL: {
                IntervalDatum interval = (IntervalDatum)datum;
                TimeMeta tm = this.asTimeMeta();
                tm.plusInterval(-interval.months, -interval.milliseconds);
                return new TimestampDatum(DateTimeUtil.toJulianTimestamp(tm));
            }
            case TIME: {
                TimeMeta tm1 = this.asTimeMeta();
                TimeMeta tm2 = datum.asTimeMeta();
                tm1.plusTime(0L - DateTimeUtil.toTime(tm2));
                return new TimestampDatum(DateTimeUtil.toJulianTimestamp(tm1));
            }
            case DATE: {
                DateDatum d = (DateDatum)datum;
                return new Int4Datum(this.jdate - d.jdate);
            }
        }
        throw new InvalidOperationException(datum.type());
    }

    @Override
    public int asInt4() {
        return this.jdate;
    }

    @Override
    public long asInt8() {
        return this.jdate;
    }

    @Override
    public float asFloat4() {
        throw new TajoRuntimeException(new InvalidValueForCastException(TajoDataTypes.Type.DATE, TajoDataTypes.Type.FLOAT4));
    }

    @Override
    public double asFloat8() {
        throw new TajoRuntimeException(new InvalidValueForCastException(TajoDataTypes.Type.DATE, TajoDataTypes.Type.FLOAT8));
    }

    @Override
    public String asChars() {
        return DateTimeUtil.encodeDate(this.asTimeMeta(), DateTimeConstants.DateStyle.ISO_DATES);
    }

    public String toChars(String format) {
        return DateTimeFormat.to_char(this.asTimeMeta(), format);
    }

    @Override
    public int size() {
        return 4;
    }

    @Override
    public byte[] asByteArray() {
        return Bytes.toBytes(this.jdate);
    }

    @Override
    public Datum equalsTo(Datum datum) {
        if (datum.type() == TajoDataTypes.Type.DATE) {
            return DatumFactory.createBool(this.equals(datum));
        }
        if (datum.isNull()) {
            return datum;
        }
        throw new InvalidOperationException();
    }

    @Override
    public int compareTo(Datum datum) {
        if (datum.type() == TajoDataTypes.Type.DATE) {
            DateDatum another = (DateDatum)datum;
            return Ints.compare((int)this.jdate, (int)another.jdate);
        }
        if (datum.type() == TajoDataTypes.Type.TIMESTAMP) {
            TimestampDatum another = (TimestampDatum)datum;
            TimeMeta myMeta = this.asTimeMeta();
            TimeMeta otherMeta = another.asTimeMeta();
            return myMeta.compareTo(otherMeta);
        }
        if (datum instanceof NullDatum || datum.isNull()) {
            return -1;
        }
        throw new InvalidOperationException(datum.type());
    }

    public boolean equals(Object obj) {
        TimeMeta tm = this.asTimeMeta();
        if (obj instanceof DateDatum) {
            TimeMeta another = ((DateDatum)obj).asTimeMeta();
            return tm.years == another.years && tm.monthOfYear == another.monthOfYear && tm.dayOfMonth == another.dayOfMonth;
        }
        return false;
    }

    public int hashCode() {
        TimeMeta tm = this.asTimeMeta();
        int total = 157;
        total = 23 * total + tm.years;
        total = 23 * total + tm.monthOfYear;
        total = 23 * total + tm.dayOfMonth;
        return total;
    }
}

