/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.datum;

import com.google.common.primitives.Longs;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.DateDatum;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.DatumFactory;
import org.apache.tajo.datum.NullDatum;
import org.apache.tajo.datum.TimeDatum;
import org.apache.tajo.datum.TimestampDatum;
import org.apache.tajo.exception.InvalidOperationException;
import org.apache.tajo.util.datetime.DateTimeUtil;
import org.apache.tajo.util.datetime.TimeMeta;

public class IntervalDatum
extends Datum {
    public static final long MINUTE_MILLIS = 60000L;
    public static final long HOUR_MILLIS = 3600000L;
    public static final long DAY_MILLIS = 86400000L;
    public static final long MONTH_MILLIS = 2592000000L;
    static Map<String, DATE_UNIT> DATE_FORMAT_LITERAL;
    final int months;
    final long milliseconds;
    static DecimalFormat df;
    static DecimalFormat df2;

    public IntervalDatum(long milliseconds) {
        this(0, milliseconds);
    }

    public IntervalDatum(int months, long milliseconds) {
        super(TajoDataTypes.Type.INTERVAL);
        this.months = months;
        this.milliseconds = milliseconds;
    }

    public IntervalDatum(String intervalStr) {
        super(TajoDataTypes.Type.INTERVAL);
        intervalStr = intervalStr.trim();
        if (intervalStr.isEmpty()) {
            throw new InvalidOperationException("interval expression is empty");
        }
        try {
            int year = 0;
            int month = 0;
            int day = 0;
            int hour = 0;
            int minute = 0;
            int second = 0;
            int microsecond = 0;
            int millisecond = 0;
            long time = 0L;
            int length = intervalStr.getBytes().length;
            StringBuilder digitChars = new StringBuilder();
            StringBuilder unitChars = new StringBuilder();
            for (int i = 0; i < length; ++i) {
                char c = intervalStr.charAt(i);
                if (Character.isDigit(c) || c == ':' || c == '.' || c == '-') {
                    digitChars.append(c);
                    continue;
                }
                if (c == ' ') {
                    if (digitChars.length() <= 0) continue;
                    if (unitChars.length() > 0) {
                        String unitName = unitChars.toString();
                        DATE_UNIT foundUnit = DATE_FORMAT_LITERAL.get(unitName);
                        if (foundUnit == null) {
                            throw new InvalidOperationException("invalid input syntax for type interval: " + intervalStr);
                        }
                        int digit = Integer.parseInt(digitChars.toString());
                        switch (foundUnit) {
                            case YEAR: {
                                year = digit;
                                break;
                            }
                            case MONTH: {
                                month = digit;
                                break;
                            }
                            case DAY: {
                                day = digit;
                                break;
                            }
                            case HOUR: {
                                hour = digit;
                                break;
                            }
                            case MINUTE: {
                                minute = digit;
                                break;
                            }
                            case SECOND: {
                                second = digit;
                                break;
                            }
                            case MICROSEC: {
                                microsecond = digit;
                                break;
                            }
                            case MILLISEC: {
                                millisecond = digit;
                                break;
                            }
                            default: {
                                throw new InvalidOperationException("Unknown datetime unit: " + (Object)((Object)foundUnit));
                            }
                        }
                        digitChars.setLength(0);
                        unitChars.setLength(0);
                        continue;
                    }
                    if (digitChars.indexOf(":") < 0) continue;
                    time = IntervalDatum.parseTime(digitChars.toString());
                    digitChars.setLength(0);
                    continue;
                }
                unitChars.append(c);
            }
            if (digitChars.length() > 0) {
                if (unitChars.length() > 0) {
                    String unitName = unitChars.toString();
                    DATE_UNIT foundUnit = DATE_FORMAT_LITERAL.get(unitName);
                    if (foundUnit == null) {
                        throw new InvalidOperationException("invalid input syntax for type interval: " + intervalStr);
                    }
                    int digit = Integer.parseInt(digitChars.toString());
                    switch (foundUnit) {
                        case YEAR: {
                            year = digit;
                            break;
                        }
                        case MONTH: {
                            month = digit;
                            break;
                        }
                        case DAY: {
                            day = digit;
                            break;
                        }
                        case HOUR: {
                            hour = digit;
                            break;
                        }
                        case MINUTE: {
                            minute = digit;
                            break;
                        }
                        case SECOND: {
                            second = digit;
                            break;
                        }
                        case MICROSEC: {
                            microsecond = digit;
                            break;
                        }
                        case MILLISEC: {
                            millisecond = digit;
                            break;
                        }
                        default: {
                            throw new InvalidOperationException("Unknown datetime unit: " + (Object)((Object)foundUnit));
                        }
                    }
                } else if (digitChars.indexOf(":") >= 0) {
                    time = IntervalDatum.parseTime(digitChars.toString());
                    digitChars.setLength(0);
                }
            }
            if (time > 0L && (hour != 0 || minute != 0 || second != 0 || microsecond != 0 || millisecond != 0)) {
                throw new InvalidOperationException("invalid input syntax for type interval: " + intervalStr);
            }
            this.milliseconds = time + (long)day * 86400000L + (long)hour * 3600000L + (long)(minute * 60) * 1000L + (long)second * 1000L + (long)microsecond * 100L + (long)millisecond;
            this.months = year * 12 + month;
        }
        catch (InvalidOperationException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new InvalidOperationException(t.getMessage() + ": " + intervalStr);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long parseTime(String timeStr) {
        int hour = 0;
        int minute = 0;
        int second = 0;
        int millisecond = 0;
        String[] timeTokens = timeStr.split(":");
        if (timeTokens.length == 1) {
            String[] secondTokens = timeTokens[0].split("\\.");
            if (secondTokens.length == 1) {
                second = Integer.parseInt(secondTokens[0]);
                return (long)hour * 3600000L + (long)minute * 60000L + (long)(second * 1000) + (long)millisecond;
            } else {
                if (secondTokens.length != 2) throw new InvalidOperationException("invalid input syntax for type interval: " + timeStr);
                millisecond = Integer.parseInt(secondTokens[1]);
            }
            return (long)hour * 3600000L + (long)minute * 60000L + (long)(second * 1000) + (long)millisecond;
        } else {
            if (timeTokens.length > 3) {
                throw new InvalidOperationException("invalid input syntax for type interval: " + timeStr);
            }
            for (int i = 0; i < timeTokens.length - 1; ++i) {
                if (i == 0) {
                    hour = Integer.parseInt(timeTokens[i]);
                }
                if (i != 1) continue;
                minute = Integer.parseInt(timeTokens[i]);
            }
            if (timeTokens.length != 3) return (long)hour * 3600000L + (long)minute * 60000L + (long)(second * 1000) + (long)millisecond;
            String[] secondTokens = timeTokens[2].split("\\.");
            if (secondTokens.length == 1) {
                second = Integer.parseInt(secondTokens[0]);
                return (long)hour * 3600000L + (long)minute * 60000L + (long)(second * 1000) + (long)millisecond;
            } else {
                if (secondTokens.length != 2) throw new InvalidOperationException("invalid input syntax for type interval: " + timeStr);
                second = Integer.parseInt(secondTokens[0]);
                millisecond = Integer.parseInt(secondTokens[1]);
            }
        }
        return (long)hour * 3600000L + (long)minute * 60000L + (long)(second * 1000) + (long)millisecond;
    }

    public int getMonths() {
        return this.months;
    }

    public long getMilliSeconds() {
        return this.milliseconds;
    }

    @Override
    public Datum plus(Datum datum) {
        switch (datum.type()) {
            case INTERVAL: {
                IntervalDatum other = (IntervalDatum)datum;
                return new IntervalDatum(this.months + other.months, this.milliseconds + other.milliseconds);
            }
            case DATE: {
                DateDatum dateDatum = (DateDatum)datum;
                TimeMeta tm = dateDatum.asTimeMeta();
                tm.plusInterval(this.months, this.milliseconds);
                return new TimestampDatum(DateTimeUtil.toJulianTimestamp(tm));
            }
            case TIME: {
                TimeMeta tm = datum.asTimeMeta();
                tm.plusInterval(this.months, this.milliseconds);
                return new TimeDatum(DateTimeUtil.toTime(tm));
            }
            case TIMESTAMP: {
                TimeMeta tm = new TimeMeta();
                DateTimeUtil.toJulianTimeMeta(datum.asInt8(), tm);
                tm.plusInterval(this.months, this.milliseconds);
                return new TimestampDatum(DateTimeUtil.toJulianTimestamp(tm));
            }
        }
        throw new InvalidOperationException(datum.type());
    }

    @Override
    public Datum minus(Datum datum) {
        if (datum.type() == TajoDataTypes.Type.INTERVAL) {
            IntervalDatum other = (IntervalDatum)datum;
            return new IntervalDatum(this.months - other.months, this.milliseconds - other.milliseconds);
        }
        throw new InvalidOperationException(datum.type());
    }

    @Override
    public Datum multiply(Datum datum) {
        switch (datum.type()) {
            case INT2: 
            case INT4: 
            case INT8: {
                long int8Val = datum.asInt8();
                return this.createIntervalDatum((double)this.months * (double)int8Val, (double)this.milliseconds * (double)int8Val);
            }
            case FLOAT4: 
            case FLOAT8: {
                double float8Val = datum.asFloat8();
                return this.createIntervalDatum((double)this.months * float8Val, (double)this.milliseconds * float8Val);
            }
        }
        throw new InvalidOperationException(datum.type());
    }

    @Override
    public Datum divide(Datum datum) {
        switch (datum.type()) {
            case INT2: 
            case INT4: 
            case INT8: {
                long paramValueI8 = datum.asInt8();
                if (!this.validateDivideZero(paramValueI8)) {
                    return NullDatum.get();
                }
                return this.createIntervalDatum((double)this.months / (double)paramValueI8, (double)this.milliseconds / (double)paramValueI8);
            }
            case FLOAT4: 
            case FLOAT8: {
                double paramValueF8 = datum.asFloat8();
                if (!this.validateDivideZero(paramValueF8)) {
                    return NullDatum.get();
                }
                return this.createIntervalDatum((double)this.months / paramValueF8, (double)this.milliseconds / paramValueF8);
            }
        }
        throw new InvalidOperationException(datum.type());
    }

    private IntervalDatum createIntervalDatum(double monthValue, double millisValue) {
        int month = (int)monthValue;
        return new IntervalDatum(month, Math.round((monthValue - (double)month) * 2.592E9 + millisValue));
    }

    @Override
    public long asInt8() {
        return (long)(this.months * 30) * 86400000L + this.milliseconds;
    }

    @Override
    public String toString() {
        return this.asChars();
    }

    @Override
    public String asChars() {
        try {
            StringBuilder sb = new StringBuilder();
            String prefix = "";
            if (this.months != 0) {
                int positiveNum = Math.abs(this.months);
                int year = positiveNum / 12;
                int remainMonth = positiveNum - year * 12;
                if (year > 0) {
                    sb.append(this.months < 0 ? "-" : "");
                    sb.append(year).append(year == 1 ? " year" : " years");
                    prefix = " ";
                }
                sb.append(prefix).append(this.months < 0 ? "-" : "").append(remainMonth).append(this.months == 1 ? " month" : " months");
                prefix = " ";
            }
            IntervalDatum.formatMillis(sb, prefix, this.milliseconds);
            return sb.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String formatMillis(long millis) {
        StringBuilder sb = new StringBuilder();
        IntervalDatum.formatMillis(sb, "", millis);
        return sb.toString();
    }

    public static void formatMillis(StringBuilder sb, String prefix, long millis) {
        if (millis != 0L) {
            long positiveNum = Math.abs(millis);
            int days = (int)(positiveNum / 86400000L);
            long remainInterval = positiveNum - (long)days * 86400000L;
            if (days != 0) {
                sb.append(prefix).append(millis < 0L ? "-" : "").append(days).append(days == 1 ? " day" : " days");
                prefix = " ";
            }
            if (remainInterval != 0L) {
                int hour = (int)(remainInterval / 3600000L);
                int minutes = (int)(remainInterval - (long)hour * 3600000L) / 60000;
                long sec = (long)((int)(remainInterval - (long)hour * 3600000L - (long)minutes * 60000L)) / 1000L;
                long millisecond = (int)(remainInterval - (long)hour * 3600000L - (long)minutes * 60000L - sec * 1000L);
                sb.append(prefix).append(millis < 0L ? "-" : "").append(df.format(hour)).append(":").append(df.format(minutes)).append(":").append(df.format(sec));
                if (millisecond > 0L) {
                    sb.append(".").append(df2.format(millisecond));
                }
            }
        }
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public int compareTo(Datum datum) {
        if (datum.type() == TajoDataTypes.Type.INTERVAL) {
            return Longs.compare((long)this.asInt8(), (long)datum.asInt8());
        }
        if (datum instanceof NullDatum || datum.isNull()) {
            return -1;
        }
        throw new InvalidOperationException(datum.type());
    }

    @Override
    public Datum equalsTo(Datum datum) {
        if (datum.type() == TajoDataTypes.Type.INTERVAL) {
            return DatumFactory.createBool(this.asInt8() == datum.asInt8());
        }
        if (datum.isNull()) {
            return datum;
        }
        throw new InvalidOperationException();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IntervalDatum) {
            return this.asInt8() == ((IntervalDatum)obj).asInt8();
        }
        return false;
    }

    public int hashCode() {
        return Longs.hashCode((long)this.asInt8());
    }

    static {
        Object[][] dateFormatLiterals;
        DATE_FORMAT_LITERAL = new HashMap<String, DATE_UNIT>();
        for (Object[] eachLiteral : dateFormatLiterals = new Object[][]{{DATE_UNIT.CENTURY, "c,cent,centuries,century"}, {DATE_UNIT.DAY, "d,day,days"}, {DATE_UNIT.DECADE, "dec,decade,decades,decs"}, {DATE_UNIT.HOUR, "h,hour,hours,hr,hrs"}, {DATE_UNIT.MILLISEC, "millisecon,ms,msec,msecond,mseconds,msecs"}, {DATE_UNIT.MINUTE, "m,min,mins,minute,minutes"}, {DATE_UNIT.MONTH, "mon,mons,month,months"}, {DATE_UNIT.SECOND, "s,sec,second,seconds,secs"}, {DATE_UNIT.TIMEZONE, "timezone"}, {DATE_UNIT.MICROSEC, "microsecon,us,usec,microsecond,useconds,usecs"}, {DATE_UNIT.YEAR, "y,year,years,yr,yrs"}}) {
            String[] tokens = ((String)eachLiteral[1]).split(",");
            DATE_UNIT unit = (DATE_UNIT)((Object)eachLiteral[0]);
            for (String eachToken : tokens) {
                DATE_FORMAT_LITERAL.put(eachToken, unit);
            }
        }
        df = new DecimalFormat("00");
        df2 = new DecimalFormat("000");
    }

    static enum DATE_UNIT {
        CENTURY,
        DECADE,
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        SECOND,
        MICROSEC,
        MILLISEC,
        TIMEZONE;

    }
}

