/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.datum;

import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.BooleanDatum;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.exception.InvalidValueForCastException;
import org.apache.tajo.exception.TajoRuntimeException;

public class NullDatum
extends Datum {
    private static NullDatum instance;
    public static final String DEFAULT_TEXT = "";
    private static final byte[] EMPTY_BYTES;
    private static final TajoDataTypes.DataType NULL_DATA_TYPE;

    private NullDatum() {
        super(TajoDataTypes.Type.NULL_TYPE);
    }

    public static NullDatum get() {
        return instance;
    }

    public static TajoDataTypes.DataType getDataType() {
        return NULL_DATA_TYPE;
    }

    @Override
    public boolean isNull() {
        return true;
    }

    @Override
    public boolean isNotNull() {
        return false;
    }

    @Override
    public boolean asBool() {
        throw new TajoRuntimeException(new InvalidValueForCastException(TajoDataTypes.Type.NULL_TYPE, TajoDataTypes.Type.BOOLEAN));
    }

    @Override
    public byte asByte() {
        return 0;
    }

    @Override
    public short asInt2() {
        return 0;
    }

    @Override
    public int asInt4() {
        return 0;
    }

    @Override
    public long asInt8() {
        return 0L;
    }

    @Override
    public byte[] asByteArray() {
        return EMPTY_BYTES;
    }

    @Override
    public float asFloat4() {
        return 0.0f;
    }

    @Override
    public double asFloat8() {
        return 0.0;
    }

    @Override
    public String asChars() {
        return DEFAULT_TEXT;
    }

    @Override
    public byte[] asTextBytes() {
        return EMPTY_BYTES;
    }

    @Override
    public int size() {
        return 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof NullDatum;
    }

    @Override
    public int compareTo(Datum datum) {
        if (datum.type() == TajoDataTypes.Type.NULL_TYPE) {
            return 0;
        }
        return 1;
    }

    @Override
    public Datum and(Datum datum) {
        return BooleanDatum.AND_LOGIC[0][datum.asInt4()];
    }

    @Override
    public Datum or(Datum datum) {
        return BooleanDatum.OR_LOGIC[0][datum.asInt4()];
    }

    @Override
    public NullDatum plus(Datum datum) {
        return this;
    }

    @Override
    public NullDatum minus(Datum datum) {
        return this;
    }

    @Override
    public NullDatum multiply(Datum datum) {
        return this;
    }

    @Override
    public NullDatum divide(Datum datum) {
        return this;
    }

    @Override
    public NullDatum modular(Datum datum) {
        return this;
    }

    @Override
    public NullDatum equalsTo(Datum datum) {
        return this;
    }

    @Override
    public NullDatum lessThan(Datum datum) {
        return this;
    }

    @Override
    public NullDatum lessThanEqual(Datum datum) {
        return this;
    }

    @Override
    public NullDatum greaterThan(Datum datum) {
        return this;
    }

    @Override
    public NullDatum greaterThanEqual(Datum datum) {
        return this;
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public String toString() {
        return "NULL";
    }

    static {
        EMPTY_BYTES = new byte[0];
        instance = new NullDatum();
        NULL_DATA_TYPE = TajoDataTypes.DataType.newBuilder().setType(TajoDataTypes.Type.NULL_TYPE).build();
    }
}

