/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.datum;

import com.google.protobuf.Message;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;

public class ProtobufDatum
extends Datum {
    private final Message value;

    public ProtobufDatum(Message message) {
        super(TajoDataTypes.Type.PROTOBUF);
        this.value = message;
    }

    public Message get() {
        return this.value;
    }

    @Override
    public byte[] asByteArray() {
        return this.value.toByteArray();
    }

    @Override
    public int size() {
        return this.value.getSerializedSize();
    }

    @Override
    public int compareTo(Datum datum) {
        if (datum.type() == TajoDataTypes.Type.PROTOBUF) {
            return this.value.equals((Object)((ProtobufDatum)datum).get()) ? 0 : -1;
        }
        return -1;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof ProtobufDatum) {
            ProtobufDatum another = (ProtobufDatum)object;
            return this.value.equals((Object)another.value);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.value.toString();
    }
}

