/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.datum;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.ProtobufDatum;
import org.apache.tajo.datum.protobuf.ProtobufJsonFormat;

public class ProtobufDatumFactory {
    private static Map<String, ProtobufDatumFactory> factories = Maps.newHashMap();
    private static ProtobufJsonFormat protobufFormatter = ProtobufJsonFormat.getInstance();
    private Method getDefaultInstance;
    Class<? extends GeneratedMessage> messageClass;
    private Message defaultInstance;

    private ProtobufDatumFactory(String protobufClass) {
        try {
            String messageClassName = protobufClass;
            this.messageClass = Class.forName(messageClassName);
            this.getDefaultInstance = this.messageClass.getMethod("getDefaultInstance", new Class[0]);
            this.defaultInstance = (Message)this.getDefaultInstance.invoke(null, new Object[0]);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    public <T extends Message.Builder> T newBuilder() {
        Message.Builder builder;
        try {
            builder = this.defaultInstance.newBuilderForType();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
        return (T)builder;
    }

    public static ProtobufDatum createDatum(Message.Builder builder) {
        return ProtobufDatumFactory.createDatum(builder.build());
    }

    public static ProtobufDatum createDatum(Message message) {
        return new ProtobufDatum(message);
    }

    public static ProtobufDatum createDatum(String className, byte[] bytes, int offset, int length) throws InvalidProtocolBufferException {
        ProtobufDatumFactory factory = ProtobufDatumFactory.get(className);
        Object builder = factory.newBuilder();
        builder.mergeFrom(bytes, offset, length);
        return ProtobufDatumFactory.createDatum(builder);
    }

    public static Datum createDatum(TajoDataTypes.DataType type, byte[] bytes) throws InvalidProtocolBufferException {
        ProtobufDatumFactory factory = ProtobufDatumFactory.get(type);
        Object builder = factory.newBuilder();
        builder.mergeFrom(bytes);
        return ProtobufDatumFactory.createDatum(builder);
    }

    public static ProtobufDatumFactory get(TajoDataTypes.DataType dataType) {
        Preconditions.checkArgument((dataType.getType() == TajoDataTypes.Type.PROTOBUF ? 1 : 0) != 0, (Object)"ProtobufDatumFactory only can accepts Protocol Buffer Datum Type.");
        return ProtobufDatumFactory.get(dataType.getCode());
    }

    public static ProtobufDatumFactory get(String className) {
        ProtobufDatumFactory factory;
        if (factories.containsKey(className)) {
            factory = factories.get(className);
        } else {
            factory = new ProtobufDatumFactory(className);
            factories.put(className, factory);
        }
        return factory;
    }

    public static String toJson(Message message) {
        return protobufFormatter.printToString(message);
    }
}

