/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.datum;

import com.google.common.primitives.Longs;
import java.util.TimeZone;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.BooleanDatum;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.IntervalDatum;
import org.apache.tajo.datum.TextDatum;
import org.apache.tajo.exception.InvalidOperationException;
import org.apache.tajo.util.Bytes;
import org.apache.tajo.util.datetime.DateTimeConstants;
import org.apache.tajo.util.datetime.DateTimeFormat;
import org.apache.tajo.util.datetime.DateTimeUtil;
import org.apache.tajo.util.datetime.TimeMeta;

public class TimestampDatum
extends Datum {
    public static final int SIZE = 8;
    private long timestamp;

    public TimestampDatum(long timestamp) {
        super(TajoDataTypes.Type.TIMESTAMP);
        this.timestamp = timestamp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getEpoch() {
        return DateTimeUtil.julianTimeToEpoch(this.timestamp);
    }

    public long getJavaTimestamp() {
        return DateTimeUtil.julianTimeToJavaTime(this.timestamp);
    }

    public int getCenturyOfEra() {
        TimeMeta tm = this.asTimeMeta();
        return tm.getCenturyOfEra();
    }

    public int getYear() {
        TimeMeta tm = this.asTimeMeta();
        return tm.years;
    }

    public int getMonthOfYear() {
        TimeMeta tm = this.asTimeMeta();
        return tm.monthOfYear;
    }

    public int getDayOfYear() {
        TimeMeta tm = this.asTimeMeta();
        return tm.getDayOfYear();
    }

    public int getDayOfWeek() {
        TimeMeta tm = this.asTimeMeta();
        return tm.getDayOfYear();
    }

    public int getWeekOfYear() {
        TimeMeta tm = this.asTimeMeta();
        return tm.getWeekOfYear();
    }

    public int getDayOfMonth() {
        TimeMeta tm = this.asTimeMeta();
        return tm.dayOfMonth;
    }

    public int getHourOfDay() {
        TimeMeta tm = this.asTimeMeta();
        return tm.hours;
    }

    public int getMinuteOfHour() {
        TimeMeta tm = this.asTimeMeta();
        return tm.minutes;
    }

    public int getSecondOfMinute() {
        TimeMeta tm = this.asTimeMeta();
        return tm.secs;
    }

    public int getMillisOfSecond() {
        TimeMeta tm = this.asTimeMeta();
        return tm.fsecs / 1000;
    }

    public int getUnixTime() {
        return (int)(DateTimeUtil.julianTimeToJavaTime(this.timestamp) / 1000L);
    }

    @Override
    public String toString() {
        return this.asChars();
    }

    public static String asChars(TimeMeta tm, TimeZone timeZone, boolean includeTimeZone) {
        DateTimeUtil.toUserTimezone(tm, timeZone);
        if (includeTimeZone) {
            tm.timeZone = timeZone.getRawOffset() / 1000;
        }
        return DateTimeUtil.encodeDateTime(tm, DateTimeConstants.DateStyle.ISO_DATES);
    }

    public String toString(TimeZone timeZone, boolean includeTimeZone) {
        return TimestampDatum.asChars(this.asTimeMeta(), timeZone, includeTimeZone);
    }

    @Override
    public long asInt8() {
        return this.timestamp;
    }

    @Override
    public String asChars() {
        TimeMeta tm = this.asTimeMeta();
        return DateTimeUtil.encodeDateTime(tm, DateTimeConstants.DateStyle.ISO_DATES);
    }

    public String toChars(String format) {
        TimeMeta tm = this.asTimeMeta();
        return DateTimeFormat.to_char(tm, format);
    }

    @Override
    public int size() {
        return 8;
    }

    @Override
    public byte[] asByteArray() {
        return Bytes.toBytes(this.timestamp);
    }

    @Override
    public byte[] asTextBytes() {
        return this.asChars().getBytes(TextDatum.DEFAULT_CHARSET);
    }

    @Override
    public Datum equalsTo(Datum datum) {
        if (datum.type() == TajoDataTypes.Type.TIME) {
            return this.timestamp == datum.asInt8() ? BooleanDatum.TRUE : BooleanDatum.FALSE;
        }
        if (datum.isNull()) {
            return datum;
        }
        throw new InvalidOperationException(datum.type());
    }

    @Override
    public int compareTo(Datum datum) {
        if (datum.type() == TajoDataTypes.Type.TIMESTAMP) {
            TimestampDatum another = (TimestampDatum)datum;
            return Longs.compare((long)this.timestamp, (long)another.timestamp);
        }
        if (datum.type() == TajoDataTypes.Type.DATE) {
            TimeMeta myMeta = this.asTimeMeta();
            TimeMeta otherMeta = datum.asTimeMeta();
            return myMeta.compareTo(otherMeta);
        }
        if (datum.isNull()) {
            return -1;
        }
        throw new InvalidOperationException(datum.type());
    }

    public boolean equals(Object obj) {
        if (obj instanceof TimestampDatum) {
            TimestampDatum another = (TimestampDatum)obj;
            return this.timestamp == another.timestamp;
        }
        return false;
    }

    @Override
    public Datum plus(Datum datum) {
        if (datum.type() == TajoDataTypes.Type.INTERVAL) {
            IntervalDatum interval = (IntervalDatum)datum;
            TimeMeta tm = this.asTimeMeta();
            tm.plusInterval(interval.months, interval.milliseconds);
            return new TimestampDatum(DateTimeUtil.toJulianTimestamp(tm));
        }
        throw new InvalidOperationException(datum.type());
    }

    @Override
    public Datum minus(Datum datum) {
        switch (datum.type()) {
            case INTERVAL: {
                IntervalDatum interval = (IntervalDatum)datum;
                TimeMeta tm = this.asTimeMeta();
                tm.plusInterval(-interval.months, -interval.milliseconds);
                return new TimestampDatum(DateTimeUtil.toJulianTimestamp(tm));
            }
            case TIMESTAMP: {
                return new IntervalDatum((this.timestamp - ((TimestampDatum)datum).timestamp) / 1000L);
            }
        }
        throw new InvalidOperationException(datum.type());
    }

    public int hashCode() {
        return Longs.hashCode((long)this.timestamp);
    }

    @Override
    public TimeMeta asTimeMeta() {
        TimeMeta tm = new TimeMeta();
        DateTimeUtil.toJulianTimeMeta(this.timestamp, tm);
        return tm;
    }
}

