/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.exception;

import org.apache.tajo.error.Errors;
import org.apache.tajo.exception.DefaultTajoException;
import org.apache.tajo.exception.ErrorMessages;
import org.apache.tajo.exception.ExceptionUtil;
import org.apache.tajo.exception.TajoException;
import org.apache.tajo.rpc.protocolrecords.PrimitiveProtos;

public class TajoRuntimeException
extends RuntimeException
implements DefaultTajoException {
    private Errors.ResultCode code;

    public TajoRuntimeException(PrimitiveProtos.ReturnState state) {
        super(ExceptionUtil.toTajoException(state));
        this.code = state.getReturnCode();
    }

    public TajoRuntimeException(Errors.ResultCode code, String ... args) {
        super(ExceptionUtil.toTajoException(PrimitiveProtos.ReturnState.newBuilder().setReturnCode(code).setMessage(ErrorMessages.getMessage(code, args)).build()));
        this.code = code;
    }

    public TajoRuntimeException(TajoException e) {
        super(e);
        this.code = e.getErrorCode();
    }

    @Override
    public Errors.ResultCode getErrorCode() {
        return this.code;
    }
}

