/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.json.CommonGsonHelper;
import org.apache.tajo.json.GsonSerDerAdapter;

public class DataTypeAdapter
implements GsonSerDerAdapter<TajoDataTypes.DataType> {
    public TajoDataTypes.DataType deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonElement code;
        JsonObject obj = (JsonObject)json;
        TajoDataTypes.DataType.Builder builder = TajoDataTypes.DataType.newBuilder();
        TajoDataTypes.Type type = TajoDataTypes.Type.valueOf(CommonGsonHelper.getOrDie(obj, "type").getAsString());
        builder.setType(type);
        JsonElement len = obj.get("len");
        if (len != null) {
            builder.setLength(len.getAsInt());
        }
        if ((code = obj.get("code")) != null) {
            builder.setCode(code.getAsString());
        }
        return builder.build();
    }

    public JsonElement serialize(TajoDataTypes.DataType src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.addProperty("type", src.getType().name());
        if (src.hasLength()) {
            json.addProperty("len", (Number)src.getLength());
        }
        if (src.hasCode()) {
            json.addProperty("code", src.getCode());
        }
        return json;
    }
}

