/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.rule.base;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.IOUtils;
import org.apache.tajo.rule.EvaluationContext;
import org.apache.tajo.rule.EvaluationResult;
import org.apache.tajo.rule.SelfDiagnosisRule;
import org.apache.tajo.rule.SelfDiagnosisRuleDefinition;
import org.apache.tajo.rule.SelfDiagnosisRuleVisibility;
import org.apache.tajo.validation.Validators;

@SelfDiagnosisRuleDefinition(category="base", name="CheckHadoopRuntimeVersionRule", priority=0)
@SelfDiagnosisRuleVisibility.Public
public class CheckHadoopRuntimeVersionRule
implements SelfDiagnosisRule {
    private Log LOG = LogFactory.getLog(this.getClass());
    private final Properties versionInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CheckHadoopRuntimeVersionRule() {
        InputStream is = ClassLoader.getSystemResourceAsStream("common-version-info.properties");
        this.versionInfo = new Properties();
        try {
            this.versionInfo.load(is);
        }
        catch (IOException e) {
            this.LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeStream((Closeable)is);
        }
    }

    private int[] getVersion() {
        int[] version = new int[]{};
        String versionString = this.versionInfo.getProperty("version").split("-")[0];
        if (versionString != null && !versionString.isEmpty()) {
            Validators.patternMatch("\\d+\\.\\d+\\.\\d+.*").validate(versionString, true);
            String[] versionArray = versionString.split("\\.");
            version = new int[versionArray.length];
            for (int idx = 0; idx < versionArray.length; ++idx) {
                version[idx] = Integer.parseInt(versionArray[idx]);
            }
        }
        return version;
    }

    private int compareVersion(int[] left, int[] right) {
        int returnValue = 0;
        int minLength = Math.min(left.length, right.length);
        for (int idx = 0; idx < minLength && (returnValue = (int)Math.signum(left[idx] - right[idx])) == 0; ++idx) {
        }
        if (returnValue == 0) {
            returnValue = (int)Math.signum(left.length - right.length);
        }
        return returnValue;
    }

    @Override
    public EvaluationResult evaluate(EvaluationContext context) {
        EvaluationResult evalResult = new EvaluationResult();
        try {
            int compared = this.compareVersion(this.getVersion(), new int[]{2, 3, 0});
            if (compared >= 0) {
                evalResult.setReturnCode(EvaluationResult.EvaluationResultCode.OK);
                evalResult.setMessage("Version test for hadoop common has passed.");
            } else {
                evalResult.setReturnCode(EvaluationResult.EvaluationResultCode.ERROR);
                evalResult.setMessage("Checking the version of hadoop common component has failed.\nCurrent version : " + this.versionInfo.getProperty("version"));
            }
        }
        catch (Exception e) {
            evalResult.setReturnCode(EvaluationResult.EvaluationResultCode.ERROR);
            evalResult.setThrowable(e);
            evalResult.setMessage("Checking the version of hadoop common component has failed.");
        }
        return evalResult;
    }
}

