/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.tuple;

import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.storage.Tuple;
import org.apache.tajo.tuple.TupleBuilder;
import org.apache.tajo.tuple.memory.HeapTuple;
import org.apache.tajo.tuple.memory.MemoryBlock;
import org.apache.tajo.tuple.memory.OffHeapRowBlockUtils;
import org.apache.tajo.tuple.memory.OffHeapRowWriter;
import org.apache.tajo.tuple.memory.ResizableLimitSpec;
import org.apache.tajo.tuple.memory.ResizableMemoryBlock;
import org.apache.tajo.tuple.memory.UnSafeTuple;
import org.apache.tajo.util.Deallocatable;
import org.apache.tajo.util.TUtil;

public class BaseTupleBuilder
extends OffHeapRowWriter
implements TupleBuilder,
Deallocatable {
    private MemoryBlock memoryBlock = new ResizableMemoryBlock(new ResizableLimitSpec(65536L), true);

    public BaseTupleBuilder(TajoDataTypes.DataType[] schema) {
        super(schema);
    }

    @Override
    public long address() {
        return this.memoryBlock.address();
    }

    @Override
    public void ensureSize(int size) {
        this.memoryBlock.ensureSize(size);
    }

    @Override
    public int position() {
        return this.memoryBlock.writerPosition();
    }

    @Override
    public void forward(int length) {
        this.memoryBlock.writerPosition(this.memoryBlock.writerPosition() + length);
    }

    @Override
    public boolean startRow() {
        this.memoryBlock.writerPosition(0);
        return super.startRow();
    }

    @Override
    public void endRow() {
        super.endRow();
    }

    @Override
    public void addTuple(Tuple tuple) {
        if (tuple instanceof UnSafeTuple) {
            UnSafeTuple unSafeTuple = TUtil.checkTypeAndGet(tuple, UnSafeTuple.class);
            this.addTuple(unSafeTuple);
        } else {
            OffHeapRowBlockUtils.convert(tuple, this);
        }
    }

    @Override
    public Tuple build() {
        return this.buildToHeapTuple();
    }

    public HeapTuple buildToHeapTuple() {
        return this.buildToZeroCopyTuple().toHeapTuple();
    }

    public UnSafeTuple buildToZeroCopyTuple() {
        UnSafeTuple zcTuple = new UnSafeTuple();
        zcTuple.set(this.memoryBlock, this.memoryBlock.readerPosition(), this.memoryBlock.readableBytes(), this.dataTypes());
        return zcTuple;
    }

    @Override
    public void release() {
        this.memoryBlock.release();
    }
}

