/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.tuple.memory;

import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.tuple.RowBlockReader;
import org.apache.tajo.tuple.memory.HeapTuple;
import org.apache.tajo.tuple.memory.MemoryBlock;
import org.apache.tajo.tuple.memory.MemoryRowBlock;

public class HeapRowBlockReader
implements RowBlockReader<HeapTuple> {
    private final TajoDataTypes.DataType[] dataTypes;
    private final MemoryBlock memoryBlock;
    private final int rows;
    private int curRowIdxForRead;
    private int curPosForRead;

    public HeapRowBlockReader(MemoryRowBlock rowBlock) {
        this(rowBlock.getMemory(), rowBlock.getDataTypes(), rowBlock.rows());
    }

    public HeapRowBlockReader(MemoryBlock memoryBlock, TajoDataTypes.DataType[] dataTypes, int rows) {
        this.dataTypes = dataTypes;
        this.rows = rows;
        this.memoryBlock = memoryBlock.duplicate();
    }

    @Override
    public long remainForRead() {
        return this.memoryBlock.readableBytes();
    }

    @Override
    public boolean next(HeapTuple tuple) {
        if (this.curRowIdxForRead < this.rows) {
            int recordLen = this.memoryBlock.getInt(this.curPosForRead);
            tuple.set(this.memoryBlock, this.curPosForRead, recordLen, this.dataTypes);
            this.curPosForRead += recordLen;
            ++this.curRowIdxForRead;
            this.memoryBlock.readerPosition(this.curPosForRead);
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.curPosForRead = 0;
        this.curRowIdxForRead = 0;
        this.memoryBlock.readerPosition(this.curPosForRead);
    }
}

