/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.tuple.memory;

import com.google.protobuf.InvalidProtocolBufferException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteOrder;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.Datum;
import org.apache.tajo.datum.DatumFactory;
import org.apache.tajo.datum.IntervalDatum;
import org.apache.tajo.datum.NullDatum;
import org.apache.tajo.datum.ProtobufDatum;
import org.apache.tajo.datum.ProtobufDatumFactory;
import org.apache.tajo.datum.TextDatum;
import org.apache.tajo.exception.TajoRuntimeException;
import org.apache.tajo.exception.UnsupportedException;
import org.apache.tajo.storage.Tuple;
import org.apache.tajo.storage.VTuple;
import org.apache.tajo.tuple.memory.MemoryBlock;
import org.apache.tajo.tuple.memory.ZeroCopyTuple;
import org.apache.tajo.util.StringUtils;
import org.apache.tajo.util.datetime.TimeMeta;

public class HeapTuple
extends ZeroCopyTuple
implements Cloneable {
    private ByteBuf buffer;
    private TajoDataTypes.DataType[] types;

    @Override
    public void set(MemoryBlock memoryBlock, int relativePos, int length, TajoDataTypes.DataType[] types) {
        this.buffer = memoryBlock.getBuffer();
        this.types = types;
        super.set(relativePos, length);
    }

    protected void set(byte[] bytes, TajoDataTypes.DataType[] types) {
        this.buffer = Unpooled.wrappedBuffer((byte[])bytes).order(ByteOrder.LITTLE_ENDIAN);
        this.types = types;
        super.set(0, bytes.length);
    }

    @Override
    public int size() {
        return this.types.length;
    }

    @Override
    public TajoDataTypes.Type type(int fieldId) {
        return this.types[fieldId].getType();
    }

    @Override
    public int size(int fieldId) {
        return this.buffer.getInt(this.checkNullAndGetOffset(fieldId));
    }

    @Override
    public void clearOffset() {
    }

    private int getFieldOffset(int fieldId) {
        return this.buffer.getInt(this.getRelativePos() + 4 + fieldId * 4);
    }

    private int checkNullAndGetOffset(int fieldId) {
        int offset = this.getFieldOffset(fieldId);
        if (offset == -1) {
            throw new RuntimeException("Invalid Field Access: " + fieldId);
        }
        return offset + this.getRelativePos();
    }

    @Override
    public boolean contains(int fieldid) {
        return this.getFieldOffset(fieldid) > -1;
    }

    @Override
    public boolean isBlank(int fieldid) {
        return this.getFieldOffset(fieldid) == -1;
    }

    @Override
    public boolean isBlankOrNull(int fieldid) {
        return this.getFieldOffset(fieldid) == -1;
    }

    @Override
    public void put(int fieldId, Tuple tuple) {
        throw new TajoRuntimeException(new UnsupportedException());
    }

    @Override
    public void clear() {
    }

    @Override
    public void put(int fieldId, Datum value) {
        throw new TajoRuntimeException(new UnsupportedException());
    }

    @Override
    public void put(Datum[] values) {
        throw new TajoRuntimeException(new UnsupportedException());
    }

    @Override
    public Datum asDatum(int fieldId) {
        if (this.isBlankOrNull(fieldId)) {
            return NullDatum.get();
        }
        switch (this.types[fieldId].getType()) {
            case BOOLEAN: {
                return DatumFactory.createBool(this.getBool(fieldId));
            }
            case BIT: {
                return DatumFactory.createBit(this.getByte(fieldId));
            }
            case INT1: 
            case INT2: {
                return DatumFactory.createInt2(this.getInt2(fieldId));
            }
            case INT4: {
                return DatumFactory.createInt4(this.getInt4(fieldId));
            }
            case INT8: {
                return DatumFactory.createInt8(this.getInt8(fieldId));
            }
            case FLOAT4: {
                return DatumFactory.createFloat4(this.getFloat4(fieldId));
            }
            case FLOAT8: {
                return DatumFactory.createFloat8(this.getFloat8(fieldId));
            }
            case CHAR: {
                return DatumFactory.createChar(this.getBytes(fieldId));
            }
            case TEXT: {
                return DatumFactory.createText(this.getBytes(fieldId));
            }
            case BLOB: {
                return DatumFactory.createBlob(this.getBytes(fieldId));
            }
            case TIMESTAMP: {
                return DatumFactory.createTimestamp(this.getInt8(fieldId));
            }
            case DATE: {
                return DatumFactory.createDate(this.getInt4(fieldId));
            }
            case TIME: {
                return DatumFactory.createTime(this.getInt8(fieldId));
            }
            case INTERVAL: {
                return this.getInterval(fieldId);
            }
            case INET4: {
                return DatumFactory.createInet4(this.getInt4(fieldId));
            }
            case PROTOBUF: {
                return this.getProtobufDatum(fieldId);
            }
            case NULL_TYPE: {
                return NullDatum.get();
            }
        }
        throw new TajoRuntimeException(new UnsupportedException("data type '" + this.types[fieldId] + "'"));
    }

    @Override
    public void setOffset(long offset) {
    }

    @Override
    public long getOffset() {
        return 0L;
    }

    @Override
    public boolean getBool(int fieldId) {
        return this.buffer.getByte(this.checkNullAndGetOffset(fieldId)) == 1;
    }

    @Override
    public byte getByte(int fieldId) {
        return this.buffer.getByte(this.checkNullAndGetOffset(fieldId));
    }

    @Override
    public char getChar(int fieldId) {
        return this.buffer.getChar(this.checkNullAndGetOffset(fieldId));
    }

    @Override
    public byte[] getBytes(int fieldId) {
        int pos = this.checkNullAndGetOffset(fieldId);
        int len = this.buffer.getInt(pos);
        byte[] bytes = new byte[len];
        this.buffer.getBytes(pos + 4, bytes);
        return bytes;
    }

    @Override
    public byte[] getTextBytes(int fieldId) {
        return this.asDatum(fieldId).asTextBytes();
    }

    @Override
    public short getInt2(int fieldId) {
        return this.buffer.getShort(this.checkNullAndGetOffset(fieldId));
    }

    @Override
    public int getInt4(int fieldId) {
        return this.buffer.getInt(this.checkNullAndGetOffset(fieldId));
    }

    @Override
    public long getInt8(int fieldId) {
        return this.buffer.getLong(this.checkNullAndGetOffset(fieldId));
    }

    @Override
    public float getFloat4(int fieldId) {
        return this.buffer.getFloat(this.checkNullAndGetOffset(fieldId));
    }

    @Override
    public double getFloat8(int fieldId) {
        return this.buffer.getDouble(this.checkNullAndGetOffset(fieldId));
    }

    @Override
    public String getText(int fieldId) {
        return new String(this.getBytes(fieldId), TextDatum.DEFAULT_CHARSET);
    }

    @Override
    public TimeMeta getTimeDate(int fieldId) {
        return this.asDatum(fieldId).asTimeMeta();
    }

    @Override
    public IntervalDatum getInterval(int fieldId) {
        int pos = this.checkNullAndGetOffset(fieldId);
        int months = this.buffer.getInt(pos);
        long millisecs = this.buffer.getLong(pos + 4);
        return new IntervalDatum(months, millisecs);
    }

    @Override
    public Datum getProtobufDatum(int fieldId) {
        byte[] bytes = this.getBytes(fieldId);
        ProtobufDatumFactory factory = ProtobufDatumFactory.get(this.types[fieldId].getCode());
        Object builder = factory.newBuilder();
        try {
            builder.mergeFrom(bytes);
        }
        catch (InvalidProtocolBufferException e) {
            return NullDatum.get();
        }
        return new ProtobufDatum(builder.build());
    }

    @Override
    public char[] getUnicodeChars(int fieldId) {
        int pos = this.checkNullAndGetOffset(fieldId);
        int len = this.buffer.getInt(pos);
        byte[] bytes = new byte[len];
        this.buffer.getBytes(pos + 4, bytes);
        return StringUtils.convertBytesToChars(bytes, TextDatum.DEFAULT_CHARSET);
    }

    @Override
    public Datum[] getValues() {
        Datum[] datums = new Datum[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            datums[i] = this.contains(i) ? this.asDatum(i) : NullDatum.get();
        }
        return datums;
    }

    public String toString() {
        return VTuple.toDisplayString(this.getValues());
    }

    @Override
    public Tuple clone() throws CloneNotSupportedException {
        HeapTuple heapTuple = (HeapTuple)super.clone();
        heapTuple.buffer = this.buffer.copy(this.getRelativePos(), this.getLength());
        heapTuple.relativePos = 0;
        return heapTuple;
    }
}

