/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.tuple.memory;

import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.nio.channels.ScatteringByteChannel;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.exception.NotImplementedException;
import org.apache.tajo.exception.TajoInternalError;
import org.apache.tajo.tuple.RowBlockReader;
import org.apache.tajo.tuple.memory.HeapRowBlockReader;
import org.apache.tajo.tuple.memory.MemoryBlock;
import org.apache.tajo.tuple.memory.OffHeapRowBlockReader;
import org.apache.tajo.tuple.memory.OffHeapRowBlockWriter;
import org.apache.tajo.tuple.memory.ResizableLimitSpec;
import org.apache.tajo.tuple.memory.ResizableMemoryBlock;
import org.apache.tajo.tuple.memory.RowBlock;
import org.apache.tajo.tuple.memory.RowWriter;
import org.apache.tajo.util.Deallocatable;
import org.apache.tajo.util.TUtil;

public class MemoryRowBlock
implements RowBlock,
Deallocatable {
    public static final int NULL_FIELD_OFFSET = -1;
    private TajoDataTypes.DataType[] dataTypes;
    private int maxRowNum = Integer.MAX_VALUE;
    private int rowNum;
    private RowWriter builder;
    private MemoryBlock memory;

    public MemoryRowBlock(TajoDataTypes.DataType[] dataTypes, ResizableLimitSpec limitSpec, boolean isDirect) {
        this.memory = new ResizableMemoryBlock(limitSpec, isDirect);
        this.dataTypes = dataTypes;
    }

    public MemoryRowBlock(MemoryRowBlock rowBlock) {
        this.memory = TUtil.checkTypeAndGet(rowBlock.getMemory().duplicate(), ResizableMemoryBlock.class);
        this.rowNum = rowBlock.rowNum;
        this.dataTypes = rowBlock.dataTypes;
    }

    public MemoryRowBlock(MemoryBlock memory, TajoDataTypes.DataType[] dataTypes, int rowNum) {
        this.memory = memory;
        this.rowNum = rowNum;
        this.dataTypes = dataTypes;
    }

    public MemoryRowBlock(TajoDataTypes.DataType[] dataTypes) {
        this(dataTypes, new ResizableLimitSpec(65536L), true);
    }

    public MemoryRowBlock(TajoDataTypes.DataType[] dataTypes, int bytes) {
        this(dataTypes, new ResizableLimitSpec(bytes), true);
    }

    public MemoryRowBlock(TajoDataTypes.DataType[] dataTypes, int bytes, boolean isDirect) {
        this(dataTypes, new ResizableLimitSpec(bytes), isDirect);
    }

    @Override
    public void clear() {
        this.reset();
        this.memory.clear();
    }

    private void reset() {
        this.rowNum = 0;
        if (this.builder != null) {
            this.builder.clear();
        }
    }

    @Override
    public int capacity() {
        return this.memory.capacity();
    }

    public int maxRowNum() {
        return this.maxRowNum;
    }

    @Override
    public int rows() {
        return this.rowNum;
    }

    @Override
    public void setRows(int rowNum) {
        this.rowNum = rowNum;
    }

    @Override
    public TajoDataTypes.DataType[] getDataTypes() {
        return this.dataTypes;
    }

    @Override
    public boolean copyFromChannel(ScatteringByteChannel channel) throws IOException {
        this.reset();
        int readBytes = this.memory.writeBytes(channel);
        if (readBytes > 0) {
            while (this.memory.isReadable()) {
                if (this.memory.readableBytes() < 4) {
                    return true;
                }
                int recordSize = PlatformDependent.getInt((long)(this.memory.address() + (long)this.memory.readerPosition()));
                assert (recordSize > 0);
                if (this.memory.readableBytes() < recordSize) {
                    return true;
                }
                this.memory.readerPosition(this.memory.readerPosition() + recordSize);
                ++this.rowNum;
            }
            return true;
        }
        return false;
    }

    @Override
    public RowWriter getWriter() {
        if (this.builder == null) {
            if (!this.getMemory().hasAddress()) {
                throw new TajoInternalError(new NotImplementedException("Heap memory writer not implemented yet"));
            }
            this.builder = new OffHeapRowBlockWriter(this);
        }
        return this.builder;
    }

    @Override
    public MemoryBlock getMemory() {
        return this.memory;
    }

    @Override
    public void release() {
        this.memory.release();
    }

    @Override
    public RowBlockReader getReader() {
        if (!this.getMemory().hasAddress()) {
            return new HeapRowBlockReader(this);
        }
        return new OffHeapRowBlockReader(this);
    }
}

