/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.tuple.memory;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.tajo.datum.IntervalDatum;
import org.apache.tajo.datum.ProtobufDatum;
import org.apache.tajo.exception.TajoRuntimeException;
import org.apache.tajo.exception.UnsupportedException;
import org.apache.tajo.storage.Tuple;
import org.apache.tajo.tuple.RowBlockReader;
import org.apache.tajo.tuple.memory.HeapTuple;
import org.apache.tajo.tuple.memory.MemoryRowBlock;
import org.apache.tajo.tuple.memory.RowWriter;
import org.apache.tajo.tuple.memory.UnSafeTuple;
import org.apache.tajo.tuple.memory.ZeroCopyTuple;

public class OffHeapRowBlockUtils {
    public static List<Tuple> sort(MemoryRowBlock rowBlock, Comparator<Tuple> comparator) {
        ArrayList tupleList = Lists.newArrayList();
        ZeroCopyTuple zcTuple = rowBlock.getMemory().hasAddress() ? new UnSafeTuple() : new HeapTuple();
        RowBlockReader reader = rowBlock.getReader();
        while (reader.next(zcTuple)) {
            tupleList.add(zcTuple);
            if (rowBlock.getMemory().hasAddress()) {
                zcTuple = new UnSafeTuple();
                continue;
            }
            zcTuple = new HeapTuple();
        }
        Collections.sort(tupleList, comparator);
        return tupleList;
    }

    public static Tuple[] sortToArray(MemoryRowBlock rowBlock, Comparator<Tuple> comparator) {
        Tuple[] tuples = new Tuple[rowBlock.rows()];
        ZeroCopyTuple zcTuple = rowBlock.getMemory().hasAddress() ? new UnSafeTuple() : new HeapTuple();
        RowBlockReader reader = rowBlock.getReader();
        for (int i = 0; i < rowBlock.rows() && reader.next(zcTuple); ++i) {
            tuples[i] = zcTuple;
            zcTuple = rowBlock.getMemory().hasAddress() ? new UnSafeTuple() : new HeapTuple();
        }
        Arrays.sort(tuples, comparator);
        return tuples;
    }

    public static void convert(Tuple tuple, RowWriter writer) {
        writer.startRow();
        block14: for (int i = 0; i < writer.dataTypes().length; ++i) {
            if (tuple.isBlankOrNull(i)) {
                writer.skipField();
                continue;
            }
            switch (writer.dataTypes()[i].getType()) {
                case BOOLEAN: {
                    writer.putBool(tuple.getBool(i));
                    continue block14;
                }
                case BIT: {
                    writer.putByte(tuple.getByte(i));
                    continue block14;
                }
                case INT1: 
                case INT2: {
                    writer.putInt2(tuple.getInt2(i));
                    continue block14;
                }
                case INT4: 
                case DATE: 
                case INET4: {
                    writer.putInt4(tuple.getInt4(i));
                    continue block14;
                }
                case INT8: 
                case TIMESTAMP: 
                case TIME: {
                    writer.putInt8(tuple.getInt8(i));
                    continue block14;
                }
                case FLOAT4: {
                    writer.putFloat4(tuple.getFloat4(i));
                    continue block14;
                }
                case FLOAT8: {
                    writer.putFloat8(tuple.getFloat8(i));
                    continue block14;
                }
                case CHAR: 
                case TEXT: {
                    writer.putText(tuple.getBytes(i));
                    continue block14;
                }
                case BLOB: {
                    writer.putBlob(tuple.getBytes(i));
                    continue block14;
                }
                case INTERVAL: {
                    writer.putInterval((IntervalDatum)tuple.getInterval(i));
                    continue block14;
                }
                case PROTOBUF: {
                    writer.putProtoDatum((ProtobufDatum)tuple.getProtobufDatum(i));
                    continue block14;
                }
                case NULL_TYPE: {
                    writer.skipField();
                    continue block14;
                }
                default: {
                    throw new TajoRuntimeException(new UnsupportedException("unknown data type '" + writer.dataTypes()[i].getType().name() + "'"));
                }
            }
        }
        writer.endRow();
    }
}

