/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.tuple.memory;

import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.exception.TajoInternalError;
import org.apache.tajo.storage.Tuple;
import org.apache.tajo.tuple.memory.OffHeapRowBlockUtils;
import org.apache.tajo.tuple.memory.OffHeapRowWriter;
import org.apache.tajo.tuple.memory.RowBlock;
import org.apache.tajo.tuple.memory.UnSafeTuple;
import org.apache.tajo.util.TUtil;

public class OffHeapRowBlockWriter
extends OffHeapRowWriter {
    private RowBlock rowBlock;

    OffHeapRowBlockWriter(RowBlock rowBlock) {
        super(rowBlock.getDataTypes());
        this.rowBlock = rowBlock;
        if (!rowBlock.getMemory().hasAddress()) {
            throw new TajoInternalError(rowBlock.getMemory().getClass().getSimpleName() + " does not support to direct memory access");
        }
    }

    @Override
    public long address() {
        return this.rowBlock.getMemory().address();
    }

    @Override
    public int position() {
        return this.rowBlock.getMemory().writerPosition();
    }

    @Override
    public void forward(int length) {
        this.rowBlock.getMemory().writerPosition(this.rowBlock.getMemory().writerPosition() + length);
    }

    @Override
    public void ensureSize(int size) {
        this.rowBlock.getMemory().ensureSize(size);
    }

    @Override
    public void endRow() {
        super.endRow();
        this.rowBlock.setRows(this.rowBlock.rows() + 1);
    }

    @Override
    public TajoDataTypes.DataType[] dataTypes() {
        return this.rowBlock.getDataTypes();
    }

    @Override
    public void addTuple(Tuple tuple) {
        if (tuple instanceof UnSafeTuple) {
            UnSafeTuple unSafeTuple = TUtil.checkTypeAndGet(tuple, UnSafeTuple.class);
            this.addTuple(unSafeTuple);
            this.rowBlock.setRows(this.rowBlock.rows() + 1);
        } else {
            OffHeapRowBlockUtils.convert(tuple, this);
        }
    }
}

