/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.tuple.memory;

import io.netty.util.internal.PlatformDependent;
import org.apache.tajo.common.TajoDataTypes;
import org.apache.tajo.datum.IntervalDatum;
import org.apache.tajo.datum.ProtobufDatum;
import org.apache.tajo.datum.TextDatum;
import org.apache.tajo.tuple.memory.RowWriter;
import org.apache.tajo.tuple.memory.UnSafeTuple;

public abstract class OffHeapRowWriter
implements RowWriter {
    private final int headerSize;
    private final TajoDataTypes.DataType[] dataTypes;
    private int curFieldIdx;
    private int curFieldOffset;
    private int curOffset;

    public OffHeapRowWriter(TajoDataTypes.DataType[] dataTypes) {
        this.dataTypes = dataTypes;
        this.headerSize = 4 * (dataTypes.length + 1);
        this.curFieldOffset = 4;
    }

    public long recordStartAddr() {
        return this.currentAddr() - (long)this.curOffset;
    }

    private long currentAddr() {
        return this.address() + (long)this.position();
    }

    public abstract long address();

    public abstract void ensureSize(int var1);

    public int offset() {
        return this.position();
    }

    public abstract int position();

    public abstract void forward(int var1);

    @Override
    public void clear() {
        this.curOffset = 0;
        this.curFieldIdx = 0;
        this.curFieldOffset = 4;
    }

    @Override
    public TajoDataTypes.DataType[] dataTypes() {
        return this.dataTypes;
    }

    @Override
    public boolean startRow() {
        this.ensureSize(this.headerSize);
        this.curOffset = this.headerSize;
        this.curFieldOffset = 4;
        this.curFieldIdx = 0;
        this.forward(this.headerSize);
        return true;
    }

    @Override
    public void endRow() {
        long rowHeaderPos = this.recordStartAddr();
        PlatformDependent.putInt((long)rowHeaderPos, (int)this.curOffset);
        rowHeaderPos += (long)(4 + this.curFieldOffset);
        for (int i = this.curFieldIdx; i < this.dataTypes.length; ++i) {
            PlatformDependent.putInt((long)rowHeaderPos, (int)-1);
            rowHeaderPos += 4L;
        }
    }

    @Override
    public void skipField() {
        this.putFieldHeader(this.currentAddr(), -1);
    }

    private void forwardField(int fieldLength) {
        this.forward(fieldLength);
        this.curOffset += fieldLength;
    }

    private void putFieldHeader(long currentAddr, int length) {
        long currentHeaderAddr = currentAddr - (long)this.curOffset + (long)this.curFieldOffset;
        PlatformDependent.putInt((long)currentHeaderAddr, (int)length);
        this.curFieldOffset += 4;
        ++this.curFieldIdx;
    }

    @Override
    public void putByte(byte val) {
        this.ensureSize(1);
        long addr = this.currentAddr();
        PlatformDependent.putByte((long)addr, (byte)val);
        this.putFieldHeader(addr, this.curOffset);
        this.forwardField(1);
    }

    @Override
    public void putBool(boolean val) {
        this.ensureSize(1);
        long addr = this.currentAddr();
        PlatformDependent.putByte((long)addr, (byte)((byte)(val ? 1 : 0)));
        this.putFieldHeader(addr, this.curOffset);
        this.forwardField(1);
    }

    @Override
    public void putInt2(short val) {
        this.ensureSize(2);
        long addr = this.currentAddr();
        PlatformDependent.putShort((long)addr, (short)val);
        this.putFieldHeader(addr, this.curOffset);
        this.forwardField(2);
    }

    @Override
    public void putInt4(int val) {
        this.ensureSize(4);
        long addr = this.currentAddr();
        PlatformDependent.putInt((long)addr, (int)val);
        this.putFieldHeader(addr, this.curOffset);
        this.forwardField(4);
    }

    @Override
    public void putInt8(long val) {
        this.ensureSize(8);
        long addr = this.currentAddr();
        PlatformDependent.putLong((long)addr, (long)val);
        this.putFieldHeader(addr, this.curOffset);
        this.forwardField(8);
    }

    @Override
    public void putFloat4(float val) {
        this.ensureSize(4);
        long addr = this.currentAddr();
        PlatformDependent.putInt((long)addr, (int)Float.floatToRawIntBits(val));
        this.putFieldHeader(addr, this.curOffset);
        this.forwardField(4);
    }

    @Override
    public void putFloat8(double val) {
        this.ensureSize(8);
        long addr = this.currentAddr();
        PlatformDependent.putLong((long)addr, (long)Double.doubleToRawLongBits(val));
        this.putFieldHeader(addr, this.curOffset);
        this.forwardField(8);
    }

    @Override
    public void putText(String val) {
        byte[] bytes = val.getBytes(TextDatum.DEFAULT_CHARSET);
        this.putText(bytes);
    }

    @Override
    public void putText(byte[] val) {
        this.putBlob(val);
    }

    @Override
    public void putBlob(byte[] val) {
        int bytesLen = val.length;
        int fieldLen = 4 + bytesLen;
        this.ensureSize(fieldLen);
        long addr = this.currentAddr();
        PlatformDependent.putInt((long)addr, (int)bytesLen);
        PlatformDependent.copyMemory((byte[])val, (int)0, (long)(addr + 4L), (long)bytesLen);
        this.putFieldHeader(addr, this.curOffset);
        this.forwardField(fieldLen);
    }

    @Override
    public void putTimestamp(long val) {
        this.putInt8(val);
    }

    @Override
    public void putDate(int val) {
        this.putInt4(val);
    }

    @Override
    public void putTime(long val) {
        this.putInt8(val);
    }

    @Override
    public void putInterval(IntervalDatum val) {
        this.ensureSize(12);
        long addr = this.currentAddr();
        PlatformDependent.putInt((long)addr, (int)val.getMonths());
        PlatformDependent.putLong((long)(addr + 4L), (long)val.getMilliSeconds());
        this.putFieldHeader(addr, this.curOffset);
        this.forwardField(12);
    }

    @Override
    public void putInet4(int val) {
        this.putInt4(val);
    }

    @Override
    public void putProtoDatum(ProtobufDatum val) {
        this.putBlob(val.asByteArray());
    }

    protected void addTuple(UnSafeTuple tuple) {
        int length = tuple.getLength();
        this.ensureSize(length);
        PlatformDependent.copyMemory((long)tuple.address(), (long)(this.address() + (long)this.position()), (long)length);
        this.forward(length);
    }
}

