/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tajo.tuple.memory;

import com.google.common.base.Preconditions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tajo.util.FileUtil;

public class ResizableLimitSpec {
    private final Log LOG = LogFactory.getLog(ResizableLimitSpec.class);
    public static final int MAX_SIZE_BYTES = Integer.MAX_VALUE;
    public static final ResizableLimitSpec DEFAULT_LIMIT = new ResizableLimitSpec(Integer.MAX_VALUE);
    private final long initSize;
    private final long limitBytes;
    private final float incRatio;
    private final float allowedOVerflowRatio;
    private static final float DEFAULT_ALLOWED_OVERFLOW_RATIO = 0.1f;
    private static final float DEFAULT_INCREASE_RATIO = 1.0f;

    public ResizableLimitSpec(long initSize) {
        this(initSize, Integer.MAX_VALUE, 0.1f);
    }

    public ResizableLimitSpec(long initSize, long limitBytes) {
        this(initSize, limitBytes, 0.1f);
    }

    public ResizableLimitSpec(long initSize, long limitBytes, float allowedOverflow) {
        this(initSize, limitBytes, allowedOverflow, 1.0f);
    }

    public ResizableLimitSpec(long initSize, long limitBytes, float allowedOverflowRatio, float incRatio) {
        Preconditions.checkArgument((initSize > 0L ? 1 : 0) != 0, (Object)"initial size must be greater than 0 bytes.");
        Preconditions.checkArgument((initSize <= Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"The maximum initial size is 2GB.");
        Preconditions.checkArgument((limitBytes > 0L ? 1 : 0) != 0, (Object)"The limit size must be greater than 0 bytes.");
        Preconditions.checkArgument((limitBytes <= Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"The maximum limit size is 2GB.");
        Preconditions.checkArgument((incRatio > 0.0f ? 1 : 0) != 0, (Object)"Increase Ratio must be greater than 0.");
        if (initSize == limitBytes) {
            long overflowedSize = (long)((float)initSize + (float)initSize * allowedOverflowRatio);
            if (overflowedSize > Integer.MAX_VALUE) {
                overflowedSize = Integer.MAX_VALUE;
            }
            this.initSize = overflowedSize;
            this.limitBytes = overflowedSize;
        } else {
            this.initSize = initSize;
            this.limitBytes = (limitBytes = (long)((float)limitBytes + (float)limitBytes * allowedOverflowRatio)) > Integer.MAX_VALUE ? Integer.MAX_VALUE : limitBytes;
        }
        this.allowedOVerflowRatio = allowedOverflowRatio;
        this.incRatio = incRatio;
    }

    public long initialSize() {
        return this.initSize;
    }

    public long limit() {
        return this.limitBytes;
    }

    public float remainRatio(long currentSize) {
        Preconditions.checkArgument((currentSize > 0L ? 1 : 0) != 0, (Object)"Size must be greater than 0 bytes.");
        if (currentSize > Integer.MAX_VALUE) {
            currentSize = Integer.MAX_VALUE;
        }
        return (float)currentSize / (float)this.limitBytes;
    }

    public boolean canIncrease(long currentSize) {
        return this.remain(currentSize) > 0L;
    }

    public long remain(long currentSize) {
        Preconditions.checkArgument((currentSize > 0L ? 1 : 0) != 0, (Object)"Size must be greater than 0 bytes.");
        return this.limitBytes > Integer.MAX_VALUE ? Integer.MAX_VALUE - currentSize : this.limitBytes - currentSize;
    }

    public int increasedSize(int currentSize) {
        if ((long)currentSize < this.initSize) {
            return (int)this.initSize;
        }
        if (currentSize > Integer.MAX_VALUE) {
            this.LOG.warn((Object)"Current size already exceeds the maximum size (2147483647 bytes)");
            return Integer.MAX_VALUE;
        }
        long nextSize = (long)((float)currentSize + (float)currentSize * this.incRatio);
        if (nextSize > this.limitBytes) {
            this.LOG.info((Object)("Increasing reaches size limit (" + FileUtil.humanReadableByteCount(this.limitBytes, false) + ")"));
            nextSize = this.limitBytes;
        }
        if (nextSize > Integer.MAX_VALUE) {
            this.LOG.info((Object)("Increasing reaches maximum size (" + FileUtil.humanReadableByteCount(Integer.MAX_VALUE, false) + ")"));
            nextSize = Integer.MAX_VALUE;
        }
        return (int)nextSize;
    }

    public String toString() {
        return "init=" + FileUtil.humanReadableByteCount(this.initSize, false) + ",limit=" + FileUtil.humanReadableByteCount(this.limitBytes, false) + ",overflow_ratio=" + this.allowedOVerflowRatio + ",inc_ratio=" + this.incRatio;
    }
}

